/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.com.column.SJctrErrorColumn;
import sanproject.sn2.controller.com.column.SJctrMSGCellObject;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.inf.SJmoSearchTerm_IF;

public class SJctrErrorTableModel
extends SJctrTableDataModel {
    public static final String KEY_COL_ERROR = "COM_COL_ERROR";
    List<SJctrErrorColumnData> errDataList;
    Comparator comparator;
    List<Object> basicDataList = new ArrayList<Object>();
    private boolean embeddedMSG = false;

    public SJctrErrorTableModel() {
        super(false);
    }

    @Override
    protected List<SJmoSearchTerm_IF> createModelFilter(Class<? extends SJmoGetKind_IF> kindClass) {
        ArrayList<SJmoSearchTerm_IF> retList = new ArrayList<SJmoSearchTerm_IF>();
        return retList;
    }

    @Override
    protected SJmoGetRange_IF createModelRange(Class<? extends SJmoGetKind_IF> kindClass) {
        SJmoGetRange_IF ret = null;
        return ret;
    }

    @Override
    protected void initTable() {
    }

    public void initialize(SJctrTableDataModel table, List<SJctrErrorColumnData> list, Comparator comp) {
        this.errDataList = list;
        this.comparator = comp;
        this.basicDataList.addAll(table.getAllRowData());
        if (this.errDataList != null) {
            this.errDataList = new ArrayList<SJctrErrorColumnData>(this.errDataList);
            Collections.sort(this.errDataList, this.comparator);
            SJctrErrorColumn errColumnInfo = new SJctrErrorColumn(KEY_COL_ERROR);
            errColumnInfo.initGuidance(this.getDataController().getOwner().getComUtility());
            errColumnInfo.initialize(this.errDataList, this.comparator);
            if (this.isEmbeddedMSG()) {
                SJctrMSGCellObject cellObj = new SJctrMSGCellObject();
                errColumnInfo.setCellObj(cellObj);
            }
            this.addColumn(errColumnInfo);
        }
        this.addColumn(table);
        this.setItemInfo();
        this.getBasicDataMap().putAll(table.getBasicDataMap());
    }

    private void addColumn(SJctrTableDataModel originalTable) {
        Set<String> topKeySet = originalTable.getTopColumnKeySet(false);
        for (String key : topKeySet) {
            SJctrColumn cloneColumnInfo;
            SJctrColumn columnInfo = originalTable.getColumnInfo(key);
            try {
                cloneColumnInfo = (SJctrColumn)columnInfo.clone();
            }
            catch (CloneNotSupportedException e) {
                this.getLogUty().putlog("initialize", "Clone Fail:" + columnInfo, e, 30000);
                continue;
            }
            this.addColumn(cloneColumnInfo);
        }
    }

    private void setItemInfo() {
        Set<String> allKeySet = this.getAllColumnKeySet(false);
        for (String key : allKeySet) {
            if (KEY_COL_ERROR.equals(key)) continue;
            SJctrColumn columnInfo = this.getColumnInfo(key);
            columnInfo.setItemInfo(0);
        }
    }

    @Override
    protected void setModelData(Map<SJctrGetDirectWrapper, List<?>> models) {
    }

    @Override
    public List<?> getBasicDataList(Class<?> cls) {
        if (this.errDataList == null) {
            return this.basicDataList;
        }
        ArrayList<Object> result = new ArrayList<Object>(this.basicDataList.size());
        for (Object basicData : this.basicDataList) {
            int index = Collections.binarySearch(this.errDataList, basicData, this.comparator);
            if (index < 0) continue;
            result.add(basicData);
        }
        result.trimToSize();
        return result;
    }

    public void setEmbeddedMSG(boolean embedded) {
        this.embeddedMSG = embedded;
    }

    public boolean isEmbeddedMSG() {
        return this.embeddedMSG;
    }
}

