/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.WeakHashMap;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.guidance.inf.SJcGuidanceHandleInterface;
import sanproject.sn2.com.utility.message.inf.SJcMessageHandleInterface;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidIdDefinition;
import sanproject.sn2.controller.com.SJctrKeyValueErrorInfo;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrStringUtility;
import sanproject.sn2.controller.com.comparator.SJctrLdevIndexComparator;
import sanproject.sn2.controller.topwindow.arraygroup.com.SJctrArrayGroupUtility;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.cvs.com.SJctrAluErrorInfo;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSMacro;
import sanproject.sn2.controller.wizard.cvs.com.SJctrLDEVDetail;
import sanproject.sn2.controller.wizard.cvs.createldev.SJctrCreateLdevData;
import sanproject.sn2.controller.wizard.lunm.com.SJctrLdevDetailLUSEInfo;
import sanproject.sn2.model.SJmoDataChange;
import sanproject.sn2.model.SJmoGetAgent;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetThroughRmiData;
import sanproject.sn2.model.data.group.SJmoHDPRelationByPool;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.system.SJmoClprInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevJnlGroupInfo;
import sanproject.sn2.model.data.volume.SJmoLdevLuseInfo;
import sanproject.sn2.model.data.volume.SJmoLdevUuidInfo;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoPgIndex;

public class SJctrLdevUtility
extends SJctrStringUtility
implements SJctrGuidIdDefinition {
    private static WeakHashMap<String, WeakReference<String>> SIMPLE_NUMBER = new WeakHashMap();
    private static WeakHashMap<String, WeakReference<String>> LDEV_ID = new WeakHashMap(65280);
    private static WeakHashMap<String, WeakReference<String>> ARRAY_GROUP = new WeakHashMap(65280);
    private static WeakHashMap<String, WeakReference<String>> CAPACITY = new WeakHashMap(256);
    public static final int VolumeType_Normal = 0;
    public static final int VolumeType_External = 1;
    public static final int VolumeType_Vvol = 2;
    public static final int VolumeType_AOUvol = 3;
    public static final int VolumeType_External_MF = 4;
    public static final byte GUARD_EQUIPMENT = -128;
    public static final byte GUARD_RESERVE = 8;
    public static final byte GUARD_RESERVED_MASK = -120;
    public static final int MASK_HMDE_SEPARATOR = 1792;
    public static final int DKUEMU_HMDE_ATYPE = 768;
    public static final int DKUEMU_HMDE_BTYPE = 256;
    public static final int DKUEMU_HMDE_CTYPE = 1024;
    public static final int DKUEMU_OPENVOL = 512;
    public static final int DRIVETYPE_NORMAL = 0;
    public static final int DRIVETYPE_SATA = 1;
    public static final int DRIVETYPE_SSD = 5;
    public static final int DRIVETYPE_FMC = 9;
    public static final int VOLUMEFLG_MF = 1;
    public static final int VOLUMEFLG_MIDDLE = 2;
    public static final int VOLUMEFLG_OPEN = 3;
    public static final int VOLUMETYPE_NORMAL = 0;
    public static final int VOLUMETYPE_EXTERNAL = 1;
    public static final int VOLUMETYPE_QSVVOL = 2;
    public static final int VOLUMETYPE_AOUVVOL = 3;
    public static final int VOLUMETYPE_EXTERAL_MF = 4;
    public static final int VOLUMETYPE_ALU = 5;
    public static final String QUESTION_RAIDLEVEL = "?(?)";
    public static final String QUESTION_LDEVID = "?:?:?";
    public static final String QUESTION_CLPR = "?:?";
    public static final String NO_VALUEDISPLAY = "-";
    public static final int STS_NOMAL = 1;
    public static final int STS_FAILD = 2;
    public static final int STS_FORMAT = 3;
    public static final int STS_CORRECT = 4;
    public static final int STS_COPYING = 5;
    public static final int STS_UNKNOWN = 6;
    public static final int STS_READONLY = 7;
    public static final int STS_CORRECT2 = 8;
    public static final int STS_NQF = 9;
    public static final int STS_PQF = 10;
    public static final int STS_SHREDD = 101;
    public static final int STS_WARNING = 127;
    public static final int STS_NOHDEV = 0;
    public static final int COMPULSION_BLOCKED = 12;
    public static final int STS_VERIFY = 0;
    public static final String STRING_COLON = ":";
    public static final byte READ_WRITE = -128;
    public static final byte PROTECT = -127;
    public static final byte READ_ONLY = -126;
    public static final byte S_READ_WRITE = -64;
    public static final byte S_PROTECT = -63;
    public static final byte S_READ_ONLY = -62;
    public static final String EMUTYPE_CVS = " CVS";
    public static final int PGKIND_ALUVVOL = 97;
    public static final int PGKIND_RESVVOL_MIN = 98;
    public static final int PGKIND_RESVVOL_MAX = 100;

    public SJctrLdevUtility(SJmoDataChange dc, SJcGuidanceHandleInterface ghi, SJcMessageHandleInterface mhi) {
        super(dc, ghi, mhi);
    }

    public String toLdevDisplay(SJmoLdevIndex ldev) {
        if (ldev == null) {
            return QUESTION_LDEVID;
        }
        String ldevString = this.toLdevDisplay(ldev.getSLdkc(), ldev.getSCu(), ldev.getSLdev());
        return this.getCache(ldevString, LDEV_ID);
    }

    public String toLdevDisplay(SJctrCreateLdevData data) {
        String str = QUESTION_LDEVID;
        if (data != null) {
            str = this.toLdevDisplay(data.getNode(), data.getCu(), data.getLdev());
        }
        return this.getCache(str, LDEV_ID);
    }

    public String toLdevDisplay(SJmoPortLunDetail data) {
        String str = QUESTION_LDEVID;
        if (data != null) {
            str = this.toLdevDisplay(data.getSLDKC(), data.getSCU(), data.getSLDEV());
        }
        return this.getCache(str, LDEV_ID);
    }

    private String toLdevDisplay(int node, int cu, int ldev) {
        String SEPARATOR = STRING_COLON;
        StringBuilder buf = new StringBuilder();
        buf.append(SJctrComUtility.toHexString(node, 2, true));
        buf.append(STRING_COLON);
        buf.append(SJctrComUtility.toHexString(cu, 2, true));
        buf.append(STRING_COLON);
        buf.append(SJctrComUtility.toHexString(ldev, 2, true));
        return buf.toString();
    }

    public String toArrayGroupDisplay(SJmoLdevDetail ldev) {
        String str = "?";
        if (ldev != null) {
            str = this.toArrayGroupDisplay(ldev.getIFB4(), ldev.getIPG());
        }
        return this.getCache(str, ARRAY_GROUP);
    }

    public String toArrayGroupDisplay(SJctrCreateLdevData data) {
        String str = "?";
        if (data != null) {
            str = this.toArrayGroupDisplay(data.getFb4(), data.getPg());
        }
        return this.getCache(str, ARRAY_GROUP);
    }

    public String toArrayGroupDisplay(SJmoPgIndex pg) {
        String str = "?";
        if (pg != null) {
            str = this.toArrayGroupDisplay(pg.getFB4(), pg.getPG());
        }
        return this.getCache(str, ARRAY_GROUP);
    }

    public String toArrayGroupDisplay(int fb4, int pg) {
        StringBuilder buf = new StringBuilder();
        if (1 <= fb4 && fb4 <= 44) {
            buf.append(fb4).append(NO_VALUEDISPLAY).append(pg);
        } else if (45 <= fb4 && fb4 <= 64) {
            buf.append("?");
        } else if (65 <= fb4 && fb4 <= 96) {
            buf.append(NO_VALUEDISPLAY);
        } else if (97 == fb4) {
            buf.append(NO_VALUEDISPLAY);
        } else if (98 <= fb4 && fb4 <= 100) {
            buf.append("?");
        } else if (101 <= fb4 && fb4 <= 16484) {
            buf.append("E");
            buf.append(fb4 - 100).append(NO_VALUEDISPLAY).append(pg);
        } else if (16485 <= fb4 && fb4 <= 16516) {
            buf.append(NO_VALUEDISPLAY);
        } else if (16641 <= fb4 && fb4 <= 17152) {
            buf.append("M");
            buf.append(fb4 - 16640).append(NO_VALUEDISPLAY).append(pg);
        }
        return buf.toString();
    }

    public String toRaidLevelDisplay(SJmoLdevDetail ldev) {
        String ret = QUESTION_RAIDLEVEL;
        if (ldev != null) {
            if (ldev.getByVolumeType() == 1 || ldev.getByVolumeType() == 4) {
                ret = NO_VALUEDISPLAY;
            } else {
                ret = this.dataChange.getRAIDLevelName(ldev.getIRaidLevel());
                if (ret == null) {
                    ret = NO_VALUEDISPLAY;
                }
            }
        }
        return ret;
    }

    public String toRaidLevelDisplay(SJctrCreateLdevData data) {
        return this.getCache(data.getRaidLevel(), DEFAULT_CACHE);
    }

    public String toRaidLevelDisplay(SJmoPgDetail pg) {
        String ret = QUESTION_RAIDLEVEL;
        if (pg != null) {
            ret = this.dataChange.getRAIDLevelName(pg.getRaidLevel());
        }
        return ret;
    }

    public String toEmuDisplay(int emu) {
        String ret = "?";
        String strEmuType = this.dataChange.getEmulationTypeName(emu);
        if (!strEmuType.equals("N/A")) {
            ret = strEmuType;
        }
        return ret;
    }

    public String toEmuDisplay(int emu, short luseEmlCount) {
        String ret = "?";
        StringBuffer buf = new StringBuffer();
        String strEmuType = this.toEmuDisplay(emu);
        if (!strEmuType.equals("?")) {
            buf.append(strEmuType);
            if (luseEmlCount >= 2) {
                buf.append("*" + luseEmlCount);
            }
            ret = buf.toString();
        }
        return ret;
    }

    public String toEmuDisplay(SJmoLdevDetail ldev) {
        String ret = "?";
        if (ldev != null) {
            ret = this.toEmuDisplay(ldev.getIEmulationType(), ldev.getSLUSEEmlCount());
            boolean cvsvol = ldev.getbCvsVolume();
            if (cvsvol) {
                ret = ret.concat(EMUTYPE_CVS);
            }
        } else {
            SJcLogUty.info("ctr", "SJctrLdevUtility", "toEmuDisplay", "SJmoLdevDetail is Null.");
        }
        return ret;
    }

    public String toEmuDisplay(SJctrCreateLdevData data) {
        return this.getCache(data.getEmulationType(), DEFAULT_CACHE);
    }

    public String toCapacityDisplay(SJmoLdevDetail ldev) {
        String result = "";
        Long capa = ldev.getLLDEVSize();
        switch (ldev.getByVolumeFlag()) {
            case 1: 
            case 2: {
                result = capa.toString() + " " + "Cyl";
                break;
            }
            case 3: {
                break;
            }
        }
        return this.getCache(result, CAPACITY);
    }

    public String toCapacityDisplay(SJmoLdevDetail ldev, long unit) {
        long value = ldev.getLLDEVLBASize() / unit;
        String result = Long.toString(value);
        return this.getCache(result, CAPACITY);
    }

    public String toCapacityDisplay(SJctrCreateLdevData data) {
        StringBuilder buf = new StringBuilder();
        buf.append(data.getCapacity());
        buf.append(" GB");
        return this.getCache(buf.toString(), CAPACITY);
    }

    public String toCapacityDisplay(SJmoPgDetail pg) {
        long kb = pg.getPGLBASize() / 2L;
        StringBuilder buf = new StringBuilder();
        buf.append(" GB");
        return this.getCache(buf.toString(), CAPACITY);
    }

    public String toPathDisplay(SJmoLdevDetail ldev) {
        String str = "0";
        if (ldev != null) {
            str = String.valueOf(ldev.getILUPathNumber());
        }
        return this.getCache(str, SIMPLE_NUMBER);
    }

    public String toLdevName(SJctrCreateLdevData data) {
        return this.getCache(data.getName(), DEFAULT_CACHE);
    }

    public String toFormatType(SJctrCreateLdevData data) {
        return this.getCache(data.getFormatType(), DEFAULT_CACHE);
    }

    public String toSsid(SJctrCreateLdevData data) {
        String str = SJctrComUtility.toHexString(data.getSsid(), 4, true);
        return this.getCache(str, SIMPLE_NUMBER);
    }

    public String toSystemDisk(SJctrCreateLdevData data) {
        return this.getCache(data.getSystemDisk(), DEFAULT_CACHE);
    }

    public String toFreeSpaceDisplay(SJmoPgDetail pg) {
        return "0000";
    }

    public String toBaseEmulationDisplay(SJmoPgDetail pg) {
        String ret = this.dataChange.getEmulationTypeName(pg.getBaseEmulationType());
        if (ret == null) {
            ret = NO_VALUEDISPLAY;
        }
        return ret;
    }

    public String toDriveTypeDisplay(SJmoPgDetail pg) {
        return this.getCache(pg.getHDDType(), DEFAULT_CACHE);
    }

    public String toLdevAttributeDisplay(SJmoLdevDetail ldev) {
        String result = "?";
        if (ldev != null) {
            result = NO_VALUEDISPLAY;
            if (ldev.getbPoolVol()) {
                result = this.toLdevAttributeCommaDisplay(result, "PL_VOL");
            }
            if (ldev.getbLUPathCmdDev() && !ldev.getbRmtComDev()) {
                result = this.toLdevAttributeCommaDisplay(result, "CMD_DEV");
            }
            if (ldev.getbJNLVolume()) {
                result = this.toLdevAttributeCommaDisplay(result, "JNL_VOL");
            }
            if (ldev.getBLockVolume()) {
                result = this.toLdevAttributeCommaDisplay(result, "LOCK_VOL");
            }
            if (ldev.getbRmtComDev()) {
                result = this.toLdevAttributeCommaDisplay(result, "RCMD_DEV");
            }
            if (ldev.getbOdmVol()) {
                result = this.toLdevAttributeCommaDisplay(result, "ODM_VOL");
            }
            if (ldev.getBDM()) {
                result = this.toLdevAttributeCommaDisplay(result, "DATA_DIRECT_MAPPING");
            }
            if (ldev.getBFPTVol()) {
                result = this.toLdevAttributeCommaDisplay(result, "FPT");
            }
            if (ldev.getbTseVol()) {
                result = this.toLdevAttributeCommaDisplay(result, "TSE");
            }
            if (ldev.getBSystemLu()) {
                result = this.toLdevAttributeCommaDisplay(result, "HNAS_SYSTEM_LU");
            }
            if (ldev.getBUserLu()) {
                result = this.toLdevAttributeCommaDisplay(result, "HNAS_USER_LU");
            }
            if (ldev.getBAlu()) {
                result = this.toLdevAttributeCommaDisplay(result, "ALU");
            }
            if (ldev.getBSlu()) {
                result = this.toLdevAttributeCommaDisplay(result, "SLU");
            }
        }
        return result;
    }

    private String toLdevAttributeCommaDisplay(String str, String GuidanceKey) {
        String result = str;
        result = NO_VALUEDISPLAY.equals(result) ? this.guidanceHandle.getGuidance(GuidanceKey) : result + ", " + this.guidanceHandle.getGuidance(GuidanceKey);
        return result;
    }

    public boolean isLdevAttributeNone(String strLdevAttribute) {
        boolean result = false;
        if (strLdevAttribute.equals(NO_VALUEDISPLAY)) {
            result = true;
        }
        return result;
    }

    public String toDriveTypeDisplay(byte drivetype2) {
        String type = "?";
        switch (drivetype2) {
            case 0: {
                type = this.guidanceHandle.getGuidance("NORMAL");
                break;
            }
            case 1: {
                type = this.guidanceHandle.getGuidance("SATA");
                break;
            }
            case 5: {
                type = this.guidanceHandle.getGuidance("SATA");
                break;
            }
        }
        return type;
    }

    public String toUuidDisplay(SJmoLdevUuidInfo uuid) {
        String str = "?";
        if (uuid != null) {
            str = uuid.getStrUuid();
        }
        return str;
    }

    public String toDriveTypeDisplay(SJmoLdevDetail ldev) {
        String str = "?";
        if (ldev != null) {
            str = this.toDriveTypeDisplay(ldev.getByDriveType());
        }
        return str;
    }

    public String toClprDisplay(SJmoClprInfo clpr) {
        if (clpr == null) {
            return QUESTION_CLPR;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(SJctrComUtility.toDecString(clpr.getSClpr()));
        buf.append(STRING_COLON);
        buf.append(clpr.getStrClprName());
        return buf.toString();
    }

    public String toVolumeTypeDisplay(SJmoLdevDetail ldev) {
        String str = "?";
        if (ldev != null) {
            str = this.toVolumeTypeDisplay(ldev.getByVolumeType());
        }
        return str;
    }

    public String toVolumeTypeDisplay(byte volumetype) {
        String type = "?";
        switch (volumetype) {
            case 0: {
                type = this.guidanceHandle.getGuidance("BASIC_VOL");
                break;
            }
            case 1: {
                type = this.guidanceHandle.getGuidance("EXTERNAL_VOL");
                break;
            }
            case 2: {
                type = this.guidanceHandle.getGuidance("SS-VVOL");
                break;
            }
            case 3: {
                type = this.guidanceHandle.getGuidance("AOU-VVOL");
                break;
            }
            case 4: {
                type = this.guidanceHandle.getGuidance("EXTERNAL_MF_VOL");
                break;
            }
            case 5: {
                type = this.guidanceHandle.getGuidance("ALU");
                break;
            }
        }
        return type;
    }

    public static boolean isOpenVolume(SJmoLdevDetail ldevDetail) {
        return ldevDetail.getByVolumeFlag() == 3;
    }

    public static boolean isMFVolume(SJmoLdevDetail ldevDetail) {
        byte volumeFlag = ldevDetail.getByVolumeFlag();
        return volumeFlag == 1 || volumeFlag == 2;
    }

    public static boolean isATypeVolume(SJmoLdevDetail ldevDetail) {
        return (ldevDetail.getIEmulationType() & 0x700) == 768;
    }

    public static boolean isBTypeVolume(SJmoLdevDetail ldevDetail) {
        return (ldevDetail.getIEmulationType() & 0x700) == 256;
    }

    public static boolean isCTypeVolume(SJmoLdevDetail ldevDetail) {
        return (ldevDetail.getIEmulationType() & 0x700) == 1024;
    }

    public static boolean isHIHSMReserveVolume(SJmoLdevDetail ldevDetail) {
        return ldevDetail.getbHIHSMReserve();
    }

    public static boolean isAllocateVolume(SJmoLdevDetail ldevDetail) {
        return ldevDetail.getILUPathNumber() > 0;
    }

    public String toCommandDeviceDisplay(SJmoLdevDetail ldev) {
        String ret = "?";
        if (ldev != null) {
            ret = ldev.getbLUPathCmdDev() ? this.guidanceHandle.getGuidance("ENABLED") : this.guidanceHandle.getGuidance("DISABLED");
        }
        return ret;
    }

    public String toCommandDeviceSecurityDisplay(SJmoLdevDetail ldev) {
        String ret = "?";
        if (ldev != null) {
            ret = ldev.getbLUPathCmdDevSec() ? this.guidanceHandle.getGuidance("ENABLED") : this.guidanceHandle.getGuidance("DISABLED");
        }
        return ret;
    }

    public String toCommandDeviceAuthenticationDisplay(SJmoLdevDetail ldev) {
        String ret = "?";
        if (ldev != null) {
            ret = ldev.getbCmdDevAuth() ? this.guidanceHandle.getGuidance("ENABLED") : this.guidanceHandle.getGuidance("DISABLED");
        }
        return ret;
    }

    public String toDeviceGrpDifinitionDisplay(SJmoLdevDetail ldev) {
        String ret = "?";
        if (ldev != null) {
            ret = ldev.getbDevGrpDefine() ? this.guidanceHandle.getGuidance("ENABLED") : this.guidanceHandle.getGuidance("DISABLED");
        }
        return ret;
    }

    public static SJctrLdevDetailLUSEInfo getLdevDetailLUListSEInfo(SJmoLdevDetail targetLdevDtl, List<SJmoLdevDetail> allLdevDtlList, List<SJmoLdevLuseInfo> allLuseList) {
        SJctrLdevDetailLUSEInfo ldevDtl = new SJctrLdevDetailLUSEInfo(targetLdevDtl);
        long tortalSize = 0L;
        if (targetLdevDtl.getSLUSEEmlCount() > 1) {
            tortalSize += targetLdevDtl.getLLDEVLBASize();
            int luseIndex = Collections.binarySearch(allLuseList, targetLdevDtl);
            if (luseIndex >= 0) {
                SJmoLdevLuseInfo luseInfo = allLuseList.get(luseIndex);
                ArrayList luseLdevList = luseInfo.getAlLUSELdevIndex();
                for (SJmoLdevIndex luseLdev : luseLdevList) {
                    int ldevIndex = Collections.binarySearch(allLdevDtlList, luseLdev);
                    if (ldevIndex < 0) continue;
                    SJmoLdevDetail luseLdevDtl = allLdevDtlList.get(ldevIndex);
                    tortalSize += luseLdevDtl.getLLDEVLBASize();
                }
            }
        } else {
            tortalSize = targetLdevDtl.getLLDEVLBASize();
        }
        ldevDtl.setLTotalLBASize(tortalSize);
        return ldevDtl;
    }

    public static List<SJctrLdevDetailLUSEInfo> getLdevDetailLUListSEInfoList(List<SJmoLdevDetail> targetLdevList, List<SJmoLdevDetail> allLdevDtlList, List<SJmoLdevLuseInfo> allLuseList) {
        ArrayList<SJctrLdevDetailLUSEInfo> retList = new ArrayList<SJctrLdevDetailLUSEInfo>(targetLdevList.size());
        for (SJmoLdevDetail targetLdev : targetLdevList) {
            SJctrLdevDetailLUSEInfo ldevDtl = SJctrLdevUtility.getLdevDetailLUListSEInfo(targetLdev, allLdevDtlList, allLuseList);
            retList.add(ldevDtl);
        }
        return retList;
    }

    public boolean isOpenVMSBit(SJmoLdevUuidInfo ldevUuidInfo, SJmoHostGroupInfo hgInfo) {
        boolean result = true;
        if (hgInfo.getByHostMode() == 5) {
            if (!ldevUuidInfo.getBBinary()) {
                result = false;
            }
        } else if (ldevUuidInfo.getBBinary()) {
            result = false;
        }
        return result;
    }

    public String toSystemDiskDisplay(SJmoLdevDetail ldev) {
        String ret = "";
        ret = ldev.getbSystemDisk() ? this.guidanceHandle.getGuidance("YES") : this.guidanceHandle.getGuidance("NO");
        return ret;
    }

    public String toStatusDisplay(byte byStatus) {
        String rtn = "";
        switch (byStatus) {
            case 1: {
                rtn = this.guidanceHandle.getGuidance("NORMAL");
                break;
            }
            case 2: {
                rtn = this.guidanceHandle.getGuidance("BLOCKED");
                break;
            }
            case 3: {
                rtn = this.guidanceHandle.getGuidance("FORMATTING");
                break;
            }
            case 4: {
                rtn = this.guidanceHandle.getGuidance("CORRECT");
                break;
            }
            case 5: {
                rtn = this.guidanceHandle.getGuidance("COPYING");
                break;
            }
            case 6: {
                rtn = this.guidanceHandle.getGuidance("UNKNOWN");
                break;
            }
            case 7: {
                rtn = this.guidanceHandle.getGuidance("READ_ONLY");
                break;
            }
            case 8: {
                rtn = this.guidanceHandle.getGuidance("CORRECTION_ACCESS_WITH_RDDC");
                break;
            }
            case 101: {
                rtn = this.guidanceHandle.getGuidance("SHREDDING");
                break;
            }
            case 9: {
                rtn = this.guidanceHandle.getGuidance("QUICK_FORMATTING");
                break;
            }
            case 10: {
                rtn = this.guidanceHandle.getGuidance("PREPARING_QUICK_FORMAT");
                break;
            }
            case 127: {
                rtn = this.guidanceHandle.getGuidance("STS_WARNING");
                break;
            }
            default: {
                rtn = NO_VALUEDISPLAY;
            }
        }
        return rtn;
    }

    public int toStatusICON(byte byStatus) {
        int rtn = 0;
        switch (byStatus) {
            case 1: {
                rtn = 12289;
                break;
            }
            case 2: {
                rtn = 12292;
                break;
            }
            case 3: {
                rtn = 12292;
                break;
            }
            case 4: {
                rtn = 12291;
                break;
            }
            case 5: {
                rtn = 12291;
                break;
            }
            case 6: {
                rtn = 12292;
                break;
            }
            case 7: {
                rtn = 12292;
                break;
            }
            case 8: {
                rtn = 12291;
                break;
            }
            case 101: {
                rtn = 12292;
                break;
            }
            case 9: {
                rtn = 12291;
                break;
            }
            case 10: {
                rtn = 12292;
                break;
            }
            case 127: {
                rtn = 12291;
                break;
            }
            default: {
                rtn = 12289;
            }
        }
        return rtn;
    }

    public String toPinStatusDisplay(boolean bPinStatus) {
        return bPinStatus ? this.guidanceHandle.getGuidance("ERROR") : this.guidanceHandle.getGuidance("NORMAL");
    }

    public String getGuardAttrStr(byte byGuard, boolean bVMA, boolean bExt) {
        String strGuard = "";
        if (bVMA && bExt) {
            strGuard = this.guidanceHandle.getGuidance("LDEVGUARD_VMA");
            strGuard = strGuard.concat(STRING_COLON);
        } else if (bExt) {
            strGuard = this.guidanceHandle.getGuidance("LDEVGUARD_VMA");
            strGuard = strGuard.concat(this.guidanceHandle.getGuidance("LDEVGUARD_EXT"));
            strGuard = strGuard.concat(STRING_COLON);
        }
        switch ((byte)(byGuard & 0xC3)) {
            case -128: {
                strGuard = strGuard.concat(this.guidanceHandle.getGuidance("LDEVGUARD_RW"));
                break;
            }
            case -127: {
                strGuard = strGuard.concat(this.guidanceHandle.getGuidance("LDEVGUARD_PROTECT"));
                break;
            }
            case -126: {
                strGuard = strGuard.concat(this.guidanceHandle.getGuidance("LDEVGUARD_RO"));
                break;
            }
            case -64: {
                strGuard = strGuard.concat(this.guidanceHandle.getGuidance("LDEVGUARD_RW_S"));
                break;
            }
            case -63: {
                strGuard = strGuard.concat(this.guidanceHandle.getGuidance("LDEVGUARD_PROTECT_S"));
                break;
            }
            case -62: {
                strGuard = strGuard.concat(this.guidanceHandle.getGuidance("LDEVGUARD_RO_S"));
                break;
            }
            default: {
                strGuard = NO_VALUEDISPLAY;
            }
        }
        return strGuard;
    }

    public String getProtectionLevel(SJmoPgDetail pgDetail) {
        String rtn = "";
        byte drivType = pgDetail.getDriveType();
        String type = SJctrArrayGroupUtility.createFolderName((int)pgDetail.getFB4());
        rtn = drivType == 0 || drivType == 5 || type.equals("EXTERNAL") ? this.guidanceHandle.getGuidance("STANDARD") : (pgDetail.getProtectionLevel() == 0 ? this.guidanceHandle.getGuidance("STANDARD") : (pgDetail.getProtectionLevel() == 1 ? this.guidanceHandle.getGuidance("SATA_WV") : this.guidanceHandle.getGuidance("SATA_E")));
        return rtn;
    }

    public String toJournalGroupIdDisplay(SJmoLdevJnlGroupInfo jnlGroup) {
        String ret = "?";
        if (jnlGroup != null) {
            int jnlId = jnlGroup.getIJnlGroup();
            ret = -1 == jnlId ? NO_VALUEDISPLAY : SJctrComUtility.toHexString(jnlId, 3, true);
        }
        return ret;
    }

    public static boolean isFiconDm(SJmoLdevIndex ldev, List ldevList, SJctrDataController dc) {
        SJmoLdevDetail wkldev;
        int ldevIndex;
        boolean rtn = false;
        if (ldev != null && ldevList != null && (ldevIndex = Collections.binarySearch(ldevList, ldev)) >= 0 && (wkldev = (SJmoLdevDetail)ldevList.get(ldevIndex)).getbExternalMfVolume() && !dc.getOwner().getAuthorizeContainer().getSystemParamContainer().isLocalHost()) {
            rtn = true;
        }
        return rtn;
    }

    public static ArrayList<SJctrErrorColumnData> getAluIDList(SJctrDataController dc, ArrayList ldevList) {
        SJctrLogUty.info("SJctrLdevUtility", "getAluIDList", "START");
        ArrayList<SJctrLDEVDetail> aryLdevList = new ArrayList<SJctrLDEVDetail>();
        for (int i = 0; i < ldevList.size(); ++i) {
            SJctrLDEVDetail ldev = (SJctrLDEVDetail)ldevList.get(i);
            if (!ldev.getBAlu()) continue;
            aryLdevList.add(ldev);
        }
        SJctrLogUty.info("SJctrLdevUtility", "getAluIDList", "END");
        return SJctrLdevUtility.getAluSluData(dc, aryLdevList);
    }

    public static ArrayList<SJctrErrorColumnData> getDpSluIDList(SJctrDataController dc, ArrayList ldevList) {
        SJctrLogUty.info("SJctrLdevUtility", "getDpSluIDList", "START");
        ArrayList<SJctrLDEVDetail> aryLdevList = new ArrayList<SJctrLDEVDetail>();
        for (int i = 0; i < ldevList.size(); ++i) {
            SJctrLDEVDetail ldev = (SJctrLDEVDetail)ldevList.get(i);
            if (!ldev.isDPSluVol()) continue;
            aryLdevList.add(ldev);
        }
        SJctrLogUty.info("SJctrLdevUtility", "getDpSluIDList", "END");
        return SJctrLdevUtility.getAluSluData(dc, aryLdevList);
    }

    public static ArrayList<SJctrErrorColumnData> getAluSluData(SJctrDataController dc, ArrayList aryLdevList) {
        ArrayList<SJctrErrorColumnData> errList;
        block13: {
            errList = new ArrayList<SJctrErrorColumnData>();
            if (aryLdevList.size() <= 0) {
                SJctrLogUty.info("SJctrLdevUtility", "getAluSluData", "NO LDEV");
                return errList;
            }
            Collections.sort(aryLdevList);
            try {
                SanRequest request = dc.getOwner().getModelAgent().newRequest("VVOLreadConglomerateLuId");
                SanList repLdevList = request.newList("Ldevs");
                for (int i = 0; i < aryLdevList.size(); ++i) {
                    SanObject ldevParameter = repLdevList.addObj();
                    SJctrLDEVDetail ldev = (SJctrLDEVDetail)aryLdevList.get(i);
                    int[] id = new int[]{ldev.getSLdkc(), ldev.getSCu(), ldev.getSLdev()};
                    ldevParameter.putIntArray("Id", id);
                    SJctrLogUty.info("SJctrLdevUtility", "getAluSluData", "LDEV=" + ldev.getIndexKey());
                }
                SJmoGetThroughRmiData kind = new SJmoGetThroughRmiData(request);
                SJmoGetDirect direct = new SJmoGetDirect((SJmoGetKind_IF)kind, null, null);
                SJctrGetDirectWrapper wrapper = new SJctrGetDirectWrapper(direct, false);
                SanResponse responseData = (SanResponse)dc.getModelData(wrapper).get(0);
                SJctrKeyValueErrorInfo keyValueInf = new SJctrKeyValueErrorInfo(responseData.getObj("ErrorInfo"));
                if (keyValueInf.getErrorCode() == 0) {
                    SanList wkLdevList = responseData.getList("Ldevs");
                    for (int i = 0; i < wkLdevList.size(); ++i) {
                        SJctrErrorColumnData errColumn;
                        SJctrError error;
                        SanObject wkLdev = wkLdevList.getObj(i);
                        int[] wkLdevId = wkLdev.getIntArray("Id");
                        SJmoLdevIndex ldev = new SJmoLdevIndex();
                        ldev.setLdevIndex((short)wkLdevId[0], (short)wkLdevId[1], (short)wkLdevId[2]);
                        int found = Collections.binarySearch(aryLdevList, ldev);
                        if (found < 0) continue;
                        SJctrLDEVDetail ldevInfo = (SJctrLDEVDetail)aryLdevList.get(found);
                        if (ldevInfo.getBAlu()) {
                            SanObject wkAluId = wkLdev.getObj("Alu");
                            if (wkAluId != null && wkLdev.getMember("Alu") != null) {
                                byte[] byAluId = wkAluId.getByteArray("Id");
                                if (byAluId != null && wkAluId.getMember("Id") != null) {
                                    ldevInfo.setByAluID(byAluId);
                                    SJctrLogUty.info("SJctrLdevUtility", "getAluSluData", "LDEV=" + ldev.getIndexKey() + " ALUID=" + SJctrAluErrorInfo.chgByStr((byte[])byAluId));
                                } else {
                                    SJctrError error2 = new SJctrError(30, 22, 205155);
                                    SJctrErrorColumnData errColumn2 = new SJctrErrorColumnData((Comparable)ldev, error2);
                                    errList.add(errColumn2);
                                }
                            } else {
                                error = new SJctrError(30, 22, 205155);
                                errColumn = new SJctrErrorColumnData((Comparable)ldev, error);
                                errList.add(errColumn);
                            }
                        }
                        if (!ldevInfo.getBSlu()) continue;
                        SanObject wkSluId = wkLdev.getObj("Slu");
                        if (wkSluId != null && wkLdev.getMember("Slu") != null) {
                            byte[] bySluId = wkSluId.getByteArray("Id");
                            byte[] SecondaryId = wkSluId.getByteArray("SecondaryId");
                            if (bySluId != null && wkSluId.getMember("Id") != null) {
                                ldevInfo.setBySluID(bySluId);
                                ldevInfo.setBySlu2ndID(SecondaryId);
                                SJctrLogUty.info("SJctrLdevUtility", "getAluSluData", "LDEV=" + ldev.getIndexKey() + " SLUID=" + SJctrAluErrorInfo.chgByStr((byte[])bySluId) + " SNDID=" + SJctrAluErrorInfo.chgByStr((byte[])SecondaryId));
                                continue;
                            }
                            SJctrError error3 = new SJctrError(30, 22, 205156);
                            SJctrErrorColumnData errColumn3 = new SJctrErrorColumnData((Comparable)ldev, error3);
                            errList.add(errColumn3);
                            continue;
                        }
                        error = new SJctrError(30, 22, 205156);
                        errColumn = new SJctrErrorColumnData((Comparable)ldev, error);
                        errList.add(errColumn);
                    }
                    break block13;
                }
                SJctrError err = keyValueInf.createError();
                SJcException exp = err.createException();
                throw exp;
            }
            catch (SanDataException ex) {
                SJctrLogUty.error("[LDEV]", "getAluIDList()", "SanDataException");
                SJctrLdevUtility.SJctrErrorDialog(105171);
            }
        }
        return errList;
    }

    public static void SJctrErrorDialog(int iError) {
        SJctrError error = new SJctrError(30, 22, iError);
        SJcException exception = error.createException();
        throw exception;
    }

    public static List<SJmoLdevIndex> getPinErrorLDEVList(SJctrDataController dc, SanResponse responseData) {
        ArrayList<SJmoLdevIndex> pinErrorLDEVList = new ArrayList<SJmoLdevIndex>();
        try {
            SanObject errorInfo;
            int errorCode;
            if (responseData == null) {
                SJctrLogUty.info("SJctrLdevUtility", "getPinErrorLDEVList", "Before MNTgetPinInfoOfLdevs RMI is issued.");
                SJmoGetAgent agent = dc.getOwner().getModelAgent();
                SanRequest request = agent.newRequest("MNTgetPinInfoOfLdevs");
                SJmoGetThroughRmiData kind = new SJmoGetThroughRmiData(request);
                SJmoGetDirect direct = new SJmoGetDirect((SJmoGetKind_IF)kind, null, null);
                SJctrGetDirectWrapper wrapper = new SJctrGetDirectWrapper(direct, false);
                responseData = (SanResponse)dc.getModelData(wrapper).get(0);
            }
            if ((errorCode = (errorInfo = responseData.getObj("ErrorInfo")).getInt("ErrorCode")) == 0) {
                SanList ldevs = responseData.getList("Ldevs");
                if (ldevs != null) {
                    for (int i = 0; i < ldevs.size(); ++i) {
                        SanObject pinInfo = ldevs.getObj(i);
                        if (null != pinInfo) {
                            int[] id = pinInfo.getIntArray("Id");
                            SJmoLdevIndex ldev = new SJmoLdevIndex();
                            ldev.setLdevIndex((short)id[0], (short)id[1], (short)id[2]);
                            pinErrorLDEVList.add(ldev);
                            continue;
                        }
                        SJctrLogUty.error("SJctrLdevUtility", "getPinErrorLDEVList", "Ldevs[" + i + "] is null");
                    }
                }
                SJctrLogUty.info("SJctrLdevUtility", "getPinErrorLDEVList", "MNTgetPinInfoOfLdevs RMI ended successfully. ErrorCode = " + errorCode + ", Ldevs.size = " + (ldevs == null ? "0" : String.valueOf(ldevs.size())) + ", pinErrorLDEVList.size = " + String.valueOf(pinErrorLDEVList.size()));
            } else {
                int[] messageId = errorInfo.getIntArray("MessageId");
                String m_strLog = "MNTgetPinInfoOfLdevs RMI returned an error. ErrorCode=" + String.valueOf(errorCode) + ", MessageId=" + String.valueOf(messageId[0]) + " " + String.valueOf(messageId[1]);
                SJctrLogUty.error("SJctrLdevUtility", "getPinErrorLDEVList", m_strLog);
            }
        }
        catch (Exception e) {
            SJctrLogUty.error("SJctrLdevUtility", "getPinErrorLDEVList", "Exception caught.", e);
        }
        Collections.sort(pinErrorLDEVList, new SJctrLdevIndexComparator());
        return pinErrorLDEVList;
    }

    public String toEncryptionDisplay(SJmoLdevDetail ldevDetail) {
        String ret = "?";
        if (ldevDetail != null) {
            switch (ldevDetail.getByVolumeType()) {
                case 0: {
                    boolean isEncryptKey = ldevDetail.getbEncryptKey();
                    if (isEncryptKey) {
                        ret = this.guidanceHandle.getGuidance("ENABLED");
                        break;
                    }
                    ret = this.guidanceHandle.getGuidance("DISABLED");
                    break;
                }
                case 3: {
                    int dpEncript = ldevDetail.getIDpEncrypt();
                    ret = this.getEncryptionString(dpEncript);
                    break;
                }
                default: {
                    ret = NO_VALUEDISPLAY;
                }
            }
        }
        return ret;
    }

    public String toT10PIDisplay(SJmoLdevDetail ldev) {
        String rtn = "?";
        if (ldev != null) {
            rtn = NO_VALUEDISPLAY;
            if (this.isT10PITarget(ldev)) {
                rtn = ldev.getBT10pi() ? this.guidanceHandle.getGuidance("ENABLED") : this.guidanceHandle.getGuidance("DISABLED");
            }
        }
        return rtn;
    }

    public boolean isT10PITarget(SJmoLdevDetail ldev) {
        boolean rtn = false;
        byte byVolType = ldev.getByVolumeType();
        if (byVolType == 0 || byVolType == 2 || byVolType == 3) {
            rtn = true;
        }
        return rtn;
    }

    public String toT10PIDisplayEx(SJmoLdevDetail ldev) {
        String rtn = this.toT10PIDisplay(ldev);
        if (rtn.equals(this.guidanceHandle.getGuidance("ENABLED"))) {
            rtn = this.guidanceHandle.getGuidance("ENABLE");
        } else if (rtn.equals(this.guidanceHandle.getGuidance("DISABLED"))) {
            rtn = this.guidanceHandle.getGuidance("DISABLE");
        }
        return rtn;
    }

    public static SJmoLdevDetail getLdevDetailFromDdmLdev(SJmoLdevDetail ldev, List<SJmoLdevDetail> ldevDetailList) {
        SJmoLdevDetail retLdev = null;
        if (ldev.getBDM() || ldev.getbExternalVolume() || ldev.getbExternalMfVolume()) {
            if (ldev.getbVvol() && ldev.getbAouVvol()) {
                int ldevIndex = Collections.binarySearch(ldevDetailList, ldev.getCnctLDEVIndex());
                if (ldevIndex >= 0) {
                    retLdev = ldevDetailList.get(ldevIndex);
                }
            } else {
                retLdev = ldev;
            }
        }
        return retLdev;
    }

    public String getEncryptionString(int iEncrypt) {
        String ret = "?";
        ret = (iEncrypt & 8) == 8 ? NO_VALUEDISPLAY : (iEncrypt == 4 ? NO_VALUEDISPLAY : (iEncrypt == 2 ? this.guidanceHandle.getGuidance("ENABLED") : (iEncrypt == 1 ? this.guidanceHandle.getGuidance("DISABLED") : (iEncrypt == 0 ? NO_VALUEDISPLAY : this.guidanceHandle.getGuidance("MIXED")))));
        return ret;
    }

    public String toVirtModeDisplay(SJmoLdevDetail ldevDetail) {
        String rtn = NO_VALUEDISPLAY;
        if (ldevDetail != null && ldevDetail.getBVirtSupport()) {
            rtn = ldevDetail.getBVirtMode() ? this.guidanceHandle.getGuidance("ENABLED") : this.guidanceHandle.getGuidance("DISABLED");
        }
        return rtn;
    }

    public String toVirtSpaceUsedDisplay(SJmoLdevDetail ldevDetail) {
        String rtn = NO_VALUEDISPLAY;
        if (ldevDetail != null && ldevDetail.getBVirtSupport()) {
            rtn = ldevDetail.getBVirtSpaceUsed() ? this.guidanceHandle.getGuidance("YES") : this.guidanceHandle.getGuidance("NO");
        }
        return rtn;
    }

    public static int chkDataSavingAsyncDeletingStatusLdevList(SJctrDataController dc, ArrayList aryLdevList) {
        int rtn = 0;
        ArrayList<SJctrLDEVDetail> wkLdevList = new ArrayList<SJctrLDEVDetail>();
        boolean bFpt = false;
        boolean bHdp = false;
        for (int i = 0; i < aryLdevList.size(); ++i) {
            SJctrLDEVDetail ldev = (SJctrLDEVDetail)aryLdevList.get(i);
            if (ldev.getByVolumeType() != 3) continue;
            if (ldev.getBFPTVol()) {
                List HDPRelationbyPoolList = ((SJctrWizardDataController)dc).getCache(SJctrCVSMacro.KEY_CLASS_RELATION_BYPOOL);
                int relIndex = Collections.binarySearch(HDPRelationbyPoolList, ldev.getPoolIndex());
                if (relIndex < 0) continue;
                SJmoHDPRelationByPool relPool = (SJmoHDPRelationByPool)HDPRelationbyPoolList.get(relIndex);
                ArrayList dpVolInfoList = relPool.getAlDPVOLInfo();
                wkLdevList.addAll(dpVolInfoList);
                bFpt = true;
                break;
            }
            wkLdevList.add(ldev);
            bHdp = true;
        }
        if (SJctrLdevUtility.chkDataSavingAsyncDeletingStatus(dc, wkLdevList)) {
            if (bFpt) {
                rtn = 205230;
            } else if (bHdp) {
                rtn = 205229;
            }
        }
        return rtn;
    }

    private static boolean chkDataSavingAsyncDeletingStatus(SJctrDataController dc, ArrayList aryLdevList) {
        boolean rtn = false;
        if (aryLdevList.size() <= 0) {
            SJctrLogUty.info("SJctrLdevUtility", "chkDelDrdFlg", "NO LDEV");
            return rtn;
        }
        Collections.sort(aryLdevList);
        try {
            SanRequest request = dc.getOwner().getModelAgent().newRequest("VVOLreadDataSavingStatusOfThinProvisioningVolumes");
            SanList repLdevList = request.newList("ThinProvisioningVolumes");
            for (int i = 0; i < aryLdevList.size(); ++i) {
                SanObject ldevParameter = repLdevList.addObj();
                SJmoLdevIndex ldev = (SJmoLdevIndex)aryLdevList.get(i);
                int[] id = new int[]{ldev.getSLdkc(), ldev.getSCu(), ldev.getSLdev()};
                ldevParameter.putIntArray("Id", id);
            }
            SJmoGetThroughRmiData kind = new SJmoGetThroughRmiData(request);
            SJmoGetDirect direct = new SJmoGetDirect((SJmoGetKind_IF)kind, null, null);
            SJctrGetDirectWrapper wrapper = new SJctrGetDirectWrapper(direct, false);
            SanResponse responseData = (SanResponse)dc.getModelData(wrapper).get(0);
            SJctrKeyValueErrorInfo keyValueInf = new SJctrKeyValueErrorInfo(responseData);
            if (keyValueInf.hasLowerNodeError()) {
                rtn = SJctrLdevUtility.chkDataSavingAsyncDeletingStatus(responseData);
            } else if (!keyValueInf.isOverAll()) {
                rtn = SJctrLdevUtility.chkDataSavingAsyncDeletingStatus(responseData);
            }
        }
        catch (SanDataException ex) {
            SJctrLogUty.error("[LDEV]", "chkDelDrdFlg()", "SanDataException");
        }
        return rtn;
    }

    private static boolean chkDataSavingAsyncDeletingStatus(SanResponse responseData) {
        boolean rtn = false;
        try {
            SanList list = responseData.getList("ThinProvisioningVolumes");
            for (int i = 0; i < list.size(); ++i) {
                SanObject ldev = list.getObj(i);
                if (null == ldev.getMember("ErrorInfo")) {
                    SJctrLogUty.info("[LDEV]", "chkDelDrdFlg()", "DKCMAIN is older than SVOS7.1.");
                    rtn = false;
                } else {
                    SJctrKeyValueErrorInfo keyValueInf = new SJctrKeyValueErrorInfo(ldev.getObj("ErrorInfo"));
                    if (keyValueInf.getErrorCode() != 0 || !ldev.getBoolean("DataSavingAsyncDeletingStatus")) continue;
                    rtn = true;
                }
                break;
            }
        }
        catch (SanDataException ex) {
            SJctrLogUty.error("[LDEV]", "chkDelDrdFlg()", "SanDataException");
        }
        return rtn;
    }
}

