/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorTableModel;
import sanproject.sn2.controller.com.comparator.SJctrErrorColumnDataComparator;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;

public class SJctrMessageDataController
extends SJctrDialogDataController {
    public static final SJctrFooterDataModel.Button MD_CLOSE = SJctrFooterDataModel.Button.CLOSE;
    public static final SJctrFooterDataModel.Button MD_OK = SJctrFooterDataModel.Button.OK;
    public static final SJctrFooterDataModel.Button MD_CANCEL = SJctrFooterDataModel.Button.CANCEL;
    public static final SJctrFooterDataModel.Button MD_YES = SJctrFooterDataModel.Button.YES;
    public static final SJctrFooterDataModel.Button MD_NO = SJctrFooterDataModel.Button.NO;
    private static final Set<SJctrFooterDataModel.Button> MD_SET = Collections.unmodifiableSet(EnumSet.of(MD_CLOSE, MD_OK, MD_CANCEL, MD_YES, MD_NO));
    private static final String KEY_ERROR = "COM_ERROR";
    private static final String KEY_MSG = "COM_MSG";
    private static final int DISP_ID = 0x3000011;
    private final EnumMap<SJctrFooterDataModel.Button, SJctrItemSelectListener> useButton = new EnumMap(SJctrFooterDataModel.Button.class);
    public static final SJctrErrorColumnDataComparator DEFAULT_COMPARATOR = new SJctrErrorColumnDataComparator();
    public static final String KEY_TABLE = "COM_TABLE";
    public static final String KEY_TABLE_SETTING = "COM_TABLE_SETTING";
    public static final String KEY_TABLE_TITLE = "COM_TABLE_TITLE";
    public static final String KEY_TABLE_ALIGN_RIGHT_COLUMN = "COM_TABLE_ALIGN_RIGHT_COLUMN";

    public SJctrMessageDataController() throws SJcException {
        super(0x3000011);
        this.initModel();
    }

    public void addButton(SJctrFooterDataModel.Button btn) {
        this.addButton(btn, null);
    }

    public void addButton(SJctrFooterDataModel.Button btn, SJctrItemSelectListener listener) {
        if (MD_SET.contains(btn)) {
            this.useButton.put(btn, listener);
        }
    }

    public void makeDataModel() {
        SJctrItemSelectListener closeListener = new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrMessageDataController.this.doClose();
            }
        };
        this.addDefaultButton();
        SJctrFooterDataModel model = new SJctrFooterDataModel(this.useButton.keySet());
        this.addDataObjectModel("COM_FOOTER", (SJctrDataObjectModel)model);
        super.makeDataModel();
        for (Map.Entry<SJctrFooterDataModel.Button, SJctrItemSelectListener> entry : this.useButton.entrySet()) {
            SJctrFooterDataModel.Button buttonKey = entry.getKey();
            SJctrItemSelectListener listener = entry.getValue();
            SJctrButtonDataModel buttonModel = model.getFooterButtonObject(buttonKey);
            model.setRollBackCheck(buttonKey, false);
            this.addMessageEventListener(buttonKey.getMessage(), null);
            if (listener != null) {
                buttonModel.addItemSelectListener(listener);
            }
            buttonModel.addItemSelectListener(closeListener);
        }
    }

    public void addUpdateDispParent(SJctrRelatedDispDataObject related) {
        this.addUpdateDisp(related);
    }

    protected void setMessage(SJcMessage msg) {
        SJctrSimpleDataModel model = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_ERROR);
        Object dataObject = model.getManageData();
        ((SJctrDataObject)dataObject).setData(KEY_MSG, msg);
    }

    private void addDefaultButton() {
        if (this.useButton.size() == 0) {
            this.addButton(MD_OK);
        }
    }

    private void initModel() {
        SJctrSimpleDataModel model = new SJctrSimpleDataModel();
        this.addDataObjectModel(KEY_ERROR, model);
    }

    public void initCache() {
    }

    @Override
    public void rollback() {
    }

    public List<?> getCache(String key) {
        ArrayList ret = new ArrayList(0);
        return ret;
    }

    @Override
    public void putCache(String key, List<?> list) {
    }

    public void setErrColumnOnlyTableParam(Object ... args) {
        SJctrTableDataModel table = null;
        table = (SJctrTableDataModel)args[0];
        if (table == null) {
            throw new NullPointerException();
        }
        List errDataList = null;
        if (args.length > 1) {
            errDataList = (List)args[1];
        }
        Comparator comp = DEFAULT_COMPARATOR;
        if (args.length > 2) {
            comp = (Comparator)args[2];
        }
        this.initDataModel(table, errDataList, comp);
    }

    private void initDataModel(SJctrTableDataModel table, List<SJctrErrorColumnData> list, Comparator comp) {
        SJctrErrorTableModel errTable = new SJctrErrorTableModel();
        this.addDataObjectModel(KEY_TABLE, errTable);
        errTable.initialize(table, list, comp);
    }

    public void setErrColumnTableParam(String title, List<String> keyList, Object ... args) {
        SJctrTableDataModel table = null;
        table = (SJctrTableDataModel)args[0];
        if (table == null) {
            throw new NullPointerException();
        }
        List errDataList = null;
        if (args.length > 1) {
            errDataList = (List)args[1];
        }
        Comparator comp = DEFAULT_COMPARATOR;
        if (args.length > 2) {
            comp = (Comparator)args[2];
        }
        this.initDataModel(table, title, keyList, errDataList, comp);
    }

    private void initDataModel(SJctrTableDataModel table, String title, List<String> keyList, List<SJctrErrorColumnData> list, Comparator comp) {
        SJctrErrorTableModel errTable = new SJctrErrorTableModel();
        this.addDataObjectModel(KEY_TABLE, errTable);
        errTable.initialize(table, list, comp);
        if (title != null || keyList != null) {
            SJctrSimpleDataModel setting = new SJctrSimpleDataModel();
            Object manage = setting.getManageData();
            this.addDataObjectModel(KEY_TABLE_SETTING, setting);
            if (title != null) {
                ((SJctrDataObject)manage).setData(KEY_TABLE_TITLE, title);
            }
            if (keyList != null) {
                ((SJctrDataObject)manage).setData(KEY_TABLE_ALIGN_RIGHT_COLUMN, keyList);
            }
        }
    }
}

