/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Set;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterfaceInternal;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrPasswordInterface;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;

public class SJctrPasswordDC
extends SJctrDialogDataController {
    private static final String KEY_MSG = "COM_MSG";
    private static final String KEY_MSG_ICON = "COM_MSG_ICON";
    private static final String KEY_MSG_GUIDID = "COM_MSG_GUIDID";
    private static final String KEY_PASSWORD = "COM_PASSWORD";
    private static final Integer ICON_ERROR = 0;
    private static final Integer ICON_WORNING = 1;
    private static final Integer ICON_INFORMATION = 2;
    private static final Integer VISIBLE_ENABLE = 0;
    private static final Integer VISIBLE_DISABLE = 1;
    private static final Integer VISIBLE_INVISOBLE = 2;
    private static final String GUID_COMMON = "COMMON";
    private static final String GUID_SEP = "/";
    private static final String GUID_FIX_PASS = "FIXED_PW_WARNING";
    private static final String GUID_ONETIME_PASS = "ONETIME_PW_WARNING";
    private static final String MSGID_COMMON = "201";
    private static final String MSGID_CTRL = "22";
    private static final String MSGID_PASS_WRONG = "205135";
    public static final String MSGID_OK = "0";
    String FORMAT_YYYYMMDDHH = "yyyy/MM/dd HH";
    String FORMAT_SERIAL_NO = " %05d";
    String FORMAT_PASS_ID = " %s";
    String FORMAT_DETAIL_ID = "%04d";
    String FORMAT_PASSWORD = "%08X";
    long MASK_ULONG = 0xFFFFFFFFL;
    long MASK_PASS1 = 0x80000000L;
    long MASK_PASS2 = Integer.MAX_VALUE;
    private static final int DISP_ID = 50331668;

    public SJctrPasswordDC() throws SJcException {
        super(50331668);
        this.initModel();
    }

    private void initModel() {
        SJctrSimpleDataModel msg = new SJctrSimpleDataModel(){

            @Override
            protected void makeDataObject() {
                String guid;
                SJctrPasswordInterface passwordIf = (SJctrPasswordInterface)SJctrPasswordDC.this.getRelatedDataController().get(0);
                Integer icon = passwordIf.getPassIconId();
                if (icon == null) {
                    icon = ICON_WORNING;
                }
                if ((guid = passwordIf.getPassGuidanceId()) == null) {
                    String passId = passwordIf.getPassId();
                    guid = passId == "USER_PASS" ? "COMMON/FIXED_PW_WARNING" : "COMMON/ONETIME_PW_WARNING";
                }
                Object data = this.getManageData();
                ((SJctrDataObject)data).setData(SJctrPasswordDC.KEY_MSG_ICON, icon);
                ((SJctrDataObject)data).setData(SJctrPasswordDC.KEY_MSG_GUIDID, guid);
            }
        };
        this.addDataObjectModel(KEY_MSG, msg);
        SJctrTextBoxDataModel pass = new SJctrTextBoxDataModel();
        pass.setTrim(false);
        this.addDataObjectModel(KEY_PASSWORD, pass);
        this.addDataObjectModel("COM_FOOTER", (SJctrDataObjectModel)new SJctrFooterDataModel(SJctrFooterDataModel.BGO_OKCANCEL));
    }

    @Override
    protected void dialogOkAction() {
        SJctrTextBoxDataModel textBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_PASSWORD);
        String inputPass = textBox.getValue();
        String checkPass = this.getCheckPassword();
        SJctrPasswordInterface passwordIf = (SJctrPasswordInterface)this.getRelatedDataController().get(0);
        SJcException checkResult = null;
        if (!inputPass.equals(checkPass)) {
            checkResult = new SJcException(MSGID_COMMON, MSGID_CTRL, MSGID_PASS_WRONG);
            passwordIf.setPassCheckResult(checkResult);
            this.logUty.putlog("dialogOkAction", "passCheck NG");
            throw checkResult;
        }
        checkResult = new SJcException(MSGID_COMMON, MSGID_CTRL, MSGID_OK);
        passwordIf.setPassCheckResult(checkResult);
        this.logUty.putlog("dialogOkAction", "passCheck OK");
        List<SJctrRelatedDispDataObject> relatedList = passwordIf.getUpdateDispInfo();
        for (SJctrRelatedDispDataObject related : relatedList) {
            this.addUpdateDisp(related);
        }
        super.dialogOkAction();
    }

    private String getCheckPassword() {
        String pass = null;
        SJctrPasswordInterface passwordIf = (SJctrPasswordInterface)this.getRelatedDataController().get(0);
        String passId = passwordIf.getPassId();
        if (passId.equals("USER_PASS")) {
            SJbaseUserSessionInterface userSession = this.getOwner().getUserSession();
            pass = ((SJbaseUserSessionInterfaceInternal)userSession).getPassword();
            this.logUty.putlog("getCheckPassword", "userPass");
        } else {
            pass = this.createOneTimePassword();
        }
        return pass;
    }

    private String createOneTimePassword() {
        long passWordNumber;
        String pass = null;
        SimpleDateFormat sdf1 = new SimpleDateFormat(this.FORMAT_YYYYMMDDHH);
        pass = sdf1.format(new Date());
        List infoList = this.getCache(SJmoGetSubsystemInfo.class);
        SJmoSubsystemInfo subsystemInfo = (SJmoSubsystemInfo)infoList.get(0);
        int serialNumber = subsystemInfo.getDKCSNInt();
        pass = pass + String.format(this.FORMAT_SERIAL_NO, serialNumber);
        SJctrPasswordInterface passwordIf = (SJctrPasswordInterface)this.getRelatedDataController().get(0);
        String passId = passwordIf.getPassId();
        pass = pass + String.format(this.FORMAT_PASS_ID, passId);
        if (passwordIf.hasPassDetailId()) {
            short detailId = passwordIf.getPassDetailId();
            pass = pass + String.format(this.FORMAT_DETAIL_ID, detailId);
        }
        this.logUty.putlog("createOneTimePassword", "keyword = " + pass);
        long passWordNumber1 = 0L;
        long passWordNumber2 = 0L;
        int rot = 0;
        int inputLength = pass.length();
        byte[] passWordByte = pass.getBytes();
        for (int i = 0; i < inputLength; ++i) {
            passWordNumber1 ^= (long)passWordByte[i] << 8 * (i % 4);
            passWordNumber2 |= (long)passWordByte[i] << 8 * (i % 4);
            rot += passWordByte[i];
        }
        rot = (int)((long)rot & this.MASK_ULONG);
        long shiftPassWordNumber = passWordNumber = passWordNumber1 ^ passWordNumber2;
        for (int i = 0; i < rot; ++i) {
            shiftPassWordNumber = (shiftPassWordNumber & this.MASK_PASS1) != 0L ? (shiftPassWordNumber << 1) + 1L + (long)i : (shiftPassWordNumber << 1) + (long)i;
        }
        String ret = String.format(this.FORMAT_PASSWORD, shiftPassWordNumber & this.MASK_PASS2);
        return ret;
    }

    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set set = super.getModelDirect();
        SJmoGetSubsystemInfo kind = new SJmoGetSubsystemInfo();
        SJmoGetRange_IF range = null;
        List filterList = null;
        SJmoGetDirect direct = new SJmoGetDirect((SJmoGetKind_IF)kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }
}

