/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComCVSUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetHDPRelation;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.data.group.SJmoHDPRelation;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrPageReservationColumnFromLdevDetail
extends SJctrColumn {
    public SJctrPageReservationColumnFromLdevDetail(String key) {
        super(key);
        this.setPartsId("ALL_PAGE_RESERVE");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> alList = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        alList.add(SJmoGetHDPRelation.class);
        alList.add(SJmoGetLdevDetail.class);
        return alList;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<Object> retList = new ArrayList<Object>();
        if (index != null && index instanceof SJmoLdevDetail) {
            SJmoLdevDetail ldevDtl = (SJmoLdevDetail)index;
            retList.add(ldevDtl);
            ArrayList hdpRelList = new ArrayList(modelData.get(SJmoGetHDPRelation.class));
            int iHdpRelIdx = Collections.binarySearch(hdpRelList, ldevDtl);
            if (0 <= iHdpRelIdx) {
                SJmoHDPRelation hdpRel = (SJmoHDPRelation)hdpRelList.get(iHdpRelIdx);
                retList.add(hdpRel);
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getNeedModelData", "index = " + index);
        }
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String strRtn = "?";
        SJmoLdevDetail ldevDtl = null;
        SJmoHDPRelation hdpRel = null;
        if (dataList != null && !dataList.isEmpty()) {
            for (Object obj : dataList) {
                if (obj instanceof SJmoLdevDetail) {
                    ldevDtl = (SJmoLdevDetail)obj;
                    continue;
                }
                if (!(obj instanceof SJmoHDPRelation)) continue;
                hdpRel = (SJmoHDPRelation)obj;
            }
            SJctrComCVSUtility cvsUtl = this.getTable().getComUtility().getCVSUtility();
            strRtn = cvsUtl.getFullAllocationDisplay(ldevDtl, hdpRel);
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toDispString", "dataList = " + dataList);
        }
        return strRtn;
    }

    @Override
    public int getFilterType() {
        return 3;
    }
}

