/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.group.SJmoHDPRelationByPool;
import sanproject.sn2.model.data.group.SJmoPoolDetail;

public class SJctrPoolNumofVVolFromPoolDetailColumn
extends SJctrColumn {
    public SJctrPoolNumofVVolFromPoolDetailColumn(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("NUMBER_OF_VVOLS"));
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> alList = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        alList.add(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
        alList.add(SJctrPoolUtility.KEY_CLASS_HDP_RELATION_BY_POOL);
        return alList;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<Object> retList = new ArrayList<Object>();
        if (null != index && index instanceof SJmoPoolDetail) {
            SJmoPoolDetail idxPoolDetail = (SJmoPoolDetail)index;
            retList.add(idxPoolDetail);
            List<?> hdpRelList = modelData.get(SJctrPoolUtility.KEY_CLASS_HDP_RELATION_BY_POOL);
            if (null != hdpRelList && 0 != hdpRelList.size()) {
                int iHDPRelIdx = Collections.binarySearch(hdpRelList, idxPoolDetail);
                if (0 <= iHDPRelIdx) {
                    SJmoHDPRelationByPool hdpRel = (SJmoHDPRelationByPool)hdpRelList.get(iHDPRelIdx);
                    retList.add(hdpRel);
                } else {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "getNeedModelData", "SJmoHDPRelationByPool is not found");
                }
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getNeedModelData", "SJmoHDPRelationByPool List is null or size 0");
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getNeedModelData", "index is null or Class Error");
        }
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String strRtn = "?";
        SJmoPoolDetail poolDtl = new SJmoPoolDetail();
        SJmoHDPRelationByPool hdpRlt = new SJmoHDPRelationByPool();
        if (null != dataList && 0 != dataList.size()) {
            for (int iListCnt = 0; iListCnt < dataList.size(); ++iListCnt) {
                Object obj = dataList.get(iListCnt);
                if (null != obj && obj instanceof SJmoPoolDetail) {
                    poolDtl = (SJmoPoolDetail)obj;
                    continue;
                }
                if (null == obj || !(obj instanceof SJmoHDPRelationByPool)) continue;
                hdpRlt = (SJmoHDPRelationByPool)obj;
            }
            if (poolDtl.getPoolKind() == 2) {
                SJctrPoolUtility poolUtl = this.getTable().getComUtility().getPoolUtility();
                strRtn = poolUtl.toNumOfVVolDisplay(hdpRlt);
            } else if (poolDtl.getPoolKind() == 8) {
                strRtn = SJctrPoolUtility.HAIFUN_STR;
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toDispString", "dataList is null or size 0");
        }
        return strRtn;
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        List<?> dpList = null;
        Map<Class<?>, List<?>> basicMap = null;
        long lRtn = 0L;
        SJmoPoolDetail poolDetail = (SJmoPoolDetail)this.getPrimaryKeyObject(dat);
        dpList = this.getNeedModelData(poolDetail, basicMap = this.getTable().getBasicDataMap());
        String strRtn = this.toDispString(dpList);
        lRtn = strRtn == SJctrPoolUtility.HAIFUN_STR ? (long)SJctrPoolUtility.HAIFUN_NUM : (strRtn == "?" ? -2L : Long.parseLong(strRtn));
        return lRtn;
    }
}

