/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrCapacityColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.group.SJmoPoolDetail;

public class SJctrPoolTotalCapacityColumnFromPoolDetail
extends SJctrCapacityColumn {
    public SJctrPoolTotalCapacityColumnFromPoolDetail(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("TOTAL"));
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> alList = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        alList.add(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
        return alList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String strRtn = "";
        if (null != dataList && 0 != dataList.size()) {
            Object obj = dataList.get(0);
            if (obj instanceof SJmoPoolDetail) {
                SJmoPoolDetail poolDtl = (SJmoPoolDetail)obj;
                String strClmUnit = this.getUnitSelect();
                SJctrComUtility comUtl = this.getTable().getComUtility();
                SJctrPoolUtility poolUtl = comUtl.getPoolUtility();
                strRtn = poolUtl.toPoolCapacityDisplay(poolDtl, strClmUnit, comUtl);
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "toDispString", "dataList is class error");
                strRtn = "?";
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toDispString", "dataList is null or size 0");
            strRtn = "?";
        }
        return strRtn;
    }

    @Override
    public int getFilterType() {
        return 4;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        long lPoolCapa = 0L;
        long lPoolBlkNum = 0L;
        SJmoPoolDetail poolDtl = (SJmoPoolDetail)this.getPrimaryKeyObject(dat);
        int iEmulation = poolDtl.getEmulationType();
        String strClmUnit = this.getUnitSelect();
        SJctrCapacityUtility.UNIT clmUnit = SJctrCapacityUtility.UNIT.valueOf(strClmUnit);
        if (iEmulation != 0 || !clmUnit.equals((Object)SJctrCapacityUtility.UNIT.CYL)) {
            long lPageSize = poolDtl.getPageSize();
            long lPoolPages = poolDtl.getPoolPages();
            lPoolCapa = lPageSize * lPoolPages;
            SJctrCapacityUtility capaUtl = this.getTable().getComUtility().getCapacityUtility();
            lPoolBlkNum = capaUtl.valueOf(lPoolCapa, SJctrCapacityUtility.UNIT.KB);
        } else {
            lPoolBlkNum = SJctrPoolUtility.HAIFUN_NUM;
        }
        return lPoolBlkNum;
    }

    @Override
    protected long getPageNumber(Map<String, Object> dat) {
        SJmoPoolDetail poolDetail = (SJmoPoolDetail)this.getPrimaryKeyObject(dat);
        long retValue = poolDetail.getPoolPages();
        return retValue;
    }

    @Override
    protected long getCylinderNumber(Map<String, Object> dat) {
        SJmoPoolDetail poolDetail = (SJmoPoolDetail)this.getPrimaryKeyObject(dat);
        int emuType = poolDetail.getEmulationType();
        SJctrComUtility comUtl = this.getTable().getComUtility();
        SJctrPoolUtility poolUtl = comUtl.getPoolUtility();
        emuType = poolUtl.changeEmulationType(emuType);
        long block = this.getNumber(dat);
        SJctrCapacityUtility capaUtil = this.getTable().getComUtility().getCapacityUtility();
        long cylinder = capaUtil.toCylValue(block, emuType);
        return cylinder;
    }
}

