/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrVVolReservedCapacityColumnFromLdevDetailColumn;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortLunTableKey;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.data.group.SJmoHDPRelation;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrVVolReservedCapacityColumnFromPortLunTableKey
extends SJctrVVolReservedCapacityColumnFromLdevDetailColumn {
    private Map<Object, Object> modelDataMap = null;

    public SJctrVVolReservedCapacityColumnFromPortLunTableKey(String key) {
        super(key);
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        int ldevDetailIndex;
        ArrayList<Object> retList = new ArrayList<Object>();
        SJctrPortLunTableKey tableKey = (SJctrPortLunTableKey)index;
        SJmoPortLunDetail portLuDetail = tableKey.getPortLunDetail();
        List<?> ldevDetailList = modelData.get(SJmoGetLdevDetail.class);
        SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
        ldevIndex.setSLdkc(portLuDetail.getSLDKC());
        ldevIndex.setSCu(portLuDetail.getSCU());
        ldevIndex.setSLdev(portLuDetail.getSLDEV());
        if (this.modelDataMap == null) {
            this.modelDataMap = new HashMap<Object, Object>(this.getTable().getRowCount());
        }
        if ((ldevDetailIndex = Collections.binarySearch(ldevDetailList, ldevIndex)) >= 0) {
            SJmoLdevDetail ldevDetail = (SJmoLdevDetail)ldevDetailList.get(ldevDetailIndex);
            if (ldevDetail.getbAouVvol()) {
                List<?> dpvolList = modelData.get(SJctrPoolUtility.KEY_CLASS_HDP_RELATION);
                int dpVolDetailIndex = Collections.binarySearch(dpvolList, ldevDetail);
                if (dpVolDetailIndex >= 0) {
                    SJmoHDPRelation hdpRelData = (SJmoHDPRelation)dpvolList.get(dpVolDetailIndex);
                    retList.add(hdpRelData);
                    this.modelDataMap.put(index, hdpRelData);
                }
            } else {
                retList.add(ldevDetail);
                this.modelDataMap.put(index, ldevDetail);
            }
        }
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String strRtn = "?";
        if (dataList != null && dataList.size() != 0) {
            Object toDispData = dataList.get(0);
            if (toDispData instanceof SJmoHDPRelation) {
                SJmoHDPRelation hdpRelData = (SJmoHDPRelation)toDispData;
                String strCapaUnit = this.getUnitSelect();
                SJctrComUtility comUtil = this.getTable().getComUtility();
                strRtn = this.getTable().getComUtility().getPoolUtility().toVVollReservedCapacityDisplay(hdpRelData, strCapaUnit, comUtil);
            } else if (toDispData instanceof SJmoLdevDetail) {
                strRtn = SJctrPoolUtility.HAIFUN_STR;
            }
        }
        return strRtn;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        long lDPVolBlock = -2L;
        Object primaryKeyObj = this.getPrimaryKeyObject(dat);
        Object modelData = this.modelDataMap.get(primaryKeyObj);
        if (modelData != null) {
            if (modelData instanceof SJmoHDPRelation) {
                SJmoHDPRelation hdpRelData = (SJmoHDPRelation)modelData;
                long lDPVolReservedPages = hdpRelData.getLReservedPage();
                long lDPVolPageSize = hdpRelData.getLPageCapa();
                long lDPVolReservedCapa = lDPVolReservedPages * lDPVolPageSize;
                lDPVolBlock = this.getTable().getComUtility().getCapacityUtility().valueOf(lDPVolReservedCapa, SJctrCapacityUtility.UNIT.KB);
            } else if (modelData instanceof SJmoLdevDetail) {
                lDPVolBlock = SJctrPoolUtility.HAIFUN_NUM;
            }
        }
        return lDPVolBlock;
    }

    @Override
    protected long getPageNumber(Map<String, Object> dat) {
        long retValue = -2L;
        Object primaryKeyObj = this.getPrimaryKeyObject(dat);
        Object modelData = this.modelDataMap.get(primaryKeyObj);
        if (modelData != null) {
            if (modelData instanceof SJmoHDPRelation) {
                SJmoHDPRelation hdpRelData = (SJmoHDPRelation)modelData;
                retValue = hdpRelData.getLReservedPage();
            } else if (modelData instanceof SJmoLdevDetail) {
                retValue = SJctrPoolUtility.HAIFUN_NUM;
            }
        }
        return retValue;
    }

    @Override
    protected long getCylinderNumber(Map<String, Object> dat) {
        long cylinder = -2L;
        Object primaryKeyObj = this.getPrimaryKeyObject(dat);
        Object modelData = this.modelDataMap.get(primaryKeyObj);
        if (modelData != null) {
            if (modelData instanceof SJmoHDPRelation) {
                SJmoHDPRelation hdpRelData = (SJmoHDPRelation)modelData;
                int emuType = hdpRelData.getIEmulationType();
                SJctrComUtility comUtil = this.getTable().getComUtility();
                int ldevEmuType = comUtil.getPoolUtility().changeEmulationType(emuType);
                if (ldevEmuType != -1) {
                    long block = this.getNumber(dat);
                    SJctrCapacityUtility capaUtil = comUtil.getCapacityUtility();
                    cylinder = capaUtil.toCylValue(block, ldevEmuType);
                }
            } else if (modelData instanceof SJmoLdevDetail) {
                cylinder = SJctrPoolUtility.HAIFUN_NUM;
            }
        }
        return cylinder;
    }
}

