/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.replication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrCapacityColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLocalReplicationPairVolInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolIndex;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.local.manager.SJmoLocalReplicationPairVolInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrQSPoolUsedRateColumnFromPairVolInfo
extends SJctrCapacityColumn {
    public SJctrQSPoolUsedRateColumnFromPairVolInfo(String key) {
        super(key);
        this.setPartsId("POOL_USAGE_PER");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetPoolDetail.class);
        list.add(SJmoGetLocalReplicationPairVolInfoMgr.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> basicData) {
        ArrayList<Object> list = new ArrayList<Object>(2);
        SJmoLocalReplicationPairVolInfo pairInfo = (SJmoLocalReplicationPairVolInfo)index;
        list.add(pairInfo);
        if (pairInfo.isVolPos(0x400000)) {
            List<?> poolDtlList = basicData.get(SJmoGetPoolDetail.class);
            SJmoLocalReplicationPairVolInfoMgr pairVolMgr = (SJmoLocalReplicationPairVolInfoMgr)basicData.get(SJmoGetLocalReplicationPairVolInfoMgr.class).get(0);
            ArrayList sVolList = pairInfo.getAlSVolIndex();
            for (SJmoLdevIndex sVolIndex : sVolList) {
                SJmoLocalReplicationPairVolInfo sVolPairInfo = pairVolMgr.getLocalReplicationPairVolInfo(sVolIndex);
                if (sVolPairInfo == null || !sVolPairInfo.isVolPos(0x800000)) continue;
                SJmoPoolIndex poolIndex = new SJmoPoolIndex();
                poolIndex.setPoolId(sVolPairInfo.getISVolPoolId());
                int target = Collections.binarySearch(poolDtlList, poolIndex);
                if (target < 0) break;
                SJmoPoolDetail poolDtl = (SJmoPoolDetail)poolDtlList.get(target);
                list.add(poolDtl);
                break;
            }
        }
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String strRtn = "?";
        SJctrPoolUtility poolUtl = this.getTable().getComUtility().getPoolUtility();
        if (dataList != null && dataList.size() == 2) {
            StringBuffer buf = new StringBuffer();
            SJmoLocalReplicationPairVolInfo pairInfo = (SJmoLocalReplicationPairVolInfo)dataList.get(0);
            SJmoPoolDetail poolDtl = (SJmoPoolDetail)dataList.get(1);
            long usedSlot = pairInfo.getLPVolUsedPool();
            short poolGrainSize = poolDtl.getPoolGrainSize();
            long usedPage = usedSlot / (long)poolGrainSize;
            long allPage = poolDtl.getPoolPages();
            long usedRate = poolUtl.getNumRatio(usedPage, allPage);
            strRtn = Long.toString(usedRate);
        }
        return strRtn;
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        long rate = -1L;
        String strRate = this.getString(dat);
        if (!strRate.equals("?")) {
            rate = Long.valueOf(strRate);
        }
        return rate;
    }
}

