/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.uvm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrExtUtility;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.column.iscsi.SJctrRemoteIscsiTargetNameColumnFromIscsiTargetPathInfo;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetExdPhysicalPathInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdTargetPortInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetPathInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.exdevice.SJmoExdPhysicalPathInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdTargetPortInfo;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdTargetPortInfoMgr;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetPathInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetPathInfo;

public class SJctrWwnItNameColumnFromExdPhysicalPathInfo
extends SJctrRemoteIscsiTargetNameColumnFromIscsiTargetPathInfo {
    public SJctrWwnItNameColumnFromExdPhysicalPathInfo(String key) {
        super(key);
        this.setPartsId("WWN_ISCSI_TARGET_NAME");
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        String partsId = this.getPartsId();
        if (partsId != null) {
            this.setLabel(util.getGuidance(partsId));
        }
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        List<Class<? extends SJmoGetKind_IF>> list = super.getNeedModelKind();
        list.add(SJmoGetPortDetail.class);
        list.add(SJmoGetExdPhysicalPathInfoMgr.class);
        list.add(SJmoGetExdTargetPortInfoMgr.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> basicData) {
        SJmoExdPhysicalPathInfo physicalPath = (SJmoExdPhysicalPathInfo)index;
        List<SJmoPortDetail> portDtlList = basicData.get(SJmoGetPortDetail.class);
        SJmoPortDetail portDtl = SJctrExtUtility.getPortDtlFromPhysicalPathInfo(physicalPath, portDtlList);
        ArrayList<Object> list = new ArrayList<Object>();
        if (portDtl == null) {
            list.add(null);
        } else {
            List<?> targetPtMgrList = basicData.get(SJmoGetExdTargetPortInfoMgr.class);
            SJmoExdTargetPortInfoMgr targetPtMgr = (SJmoExdTargetPortInfoMgr)targetPtMgrList.get(0);
            if (SJctrPortUtility.isIscsiPort(portDtl)) {
                List<SJmoPortIscsiTargetPathInfo> portItPathlList = basicData.get(SJmoGetPortIscsiTargetPathInfo.class);
                SJmoIscsiTargetPathInfo itPathInfo = SJctrExtUtility.getiSCSITargetPathInfo(physicalPath, portItPathlList, targetPtMgr);
                list.add(itPathInfo);
            } else {
                int targetPortId = physicalPath.getRmiExdPhysicalPathInfo().referTargetPortId();
                SJmoExdTargetPortInfo targetPortInfo = targetPtMgr.getExdTargetPortInfo(targetPortId);
                list.add(targetPortInfo);
            }
        }
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "?";
        if (!dataList.isEmpty()) {
            Object obj = dataList.get(0);
            if (obj instanceof SJmoIscsiTargetPathInfo) {
                ret = super.toDispString(dataList);
            }
            if (obj instanceof SJmoExdTargetPortInfo) {
                SJmoExdTargetPortInfo targetPathInfo = (SJmoExdTargetPortInfo)obj;
                ret = targetPathInfo.getRmiExdTargetPortInfo().getDispTargetPortAddress();
            }
        }
        return ret;
    }
}

