/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.vpm;

import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.SJctrVpmUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.com.column.vpm.SJctrClprColumDiffInterface;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.system.SJmoClprInfo;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoPgIndex;

public class SJctrNumOfParityGroupColumnFromClprInfo
extends SJctrColumn
implements SJctrClprColumDiffInterface {
    List<SJmoClprInfo> diffClprList = null;
    List<SJmoPgDetail> pgList = null;
    SJctrResourceGroupUtility rsgUtil = null;

    public SJctrNumOfParityGroupColumnFromClprInfo(String key) {
        super(key);
        this.setPartsId("AG");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> alList = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        alList.add(SJctrVpmUtility.KEY_CLASS_CLPR_INFO);
        alList.add(SJctrVpmUtility.KEY_CLASS_PG_DETAIL);
        alList.add(SJctrVpmUtility.KEY_CLASS_ALL_RSG);
        return alList;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<SJmoClprInfo> retList = new ArrayList<SJmoClprInfo>();
        if (index instanceof SJmoClprInfo) {
            retList.add((SJmoClprInfo)index);
        }
        if (this.rsgUtil == null) {
            List<?> allRsgs = modelData.get(SJctrVpmUtility.KEY_CLASS_ALL_RSG);
            List<?> pgDtlList = modelData.get(SJctrVpmUtility.KEY_CLASS_PG_DETAIL);
            if (!allRsgs.isEmpty() && pgDtlList != null) {
                SJctrUserController uc = this.getTable().getDataController().getOwner();
                this.rsgUtil = new SJctrResourceGroupUtility(uc, (SJmoRSGgetAllRsgs)allRsgs.get(0));
                this.pgList = new ArrayList<SJmoPgIndex>(this.rsgUtil.extractPg(pgDtlList));
            }
        }
        if (this.diffClprList == null) {
            List<?> getModelList = modelData.get(KEY_CLASS_DIFF_CLPR_INFO_LIST);
            this.diffClprList = getModelList != null && getModelList.size() != 0 ? getModelList : Collections.emptyList();
        }
        return retList;
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        long lRet = -1L;
        Object objKey = this.getPrimaryKeyObject(dat);
        if (objKey != null && objKey instanceof SJmoClprInfo) {
            SJmoClprInfo clprInfo = (SJmoClprInfo)objKey;
            if (!this.diffClprList.isEmpty()) {
                int iSearch = Collections.binarySearch(this.diffClprList, (Object)clprInfo);
                if (iSearch >= 0) {
                    SJmoClprInfo diffClprInfo = this.diffClprList.get(iSearch);
                    lRet = SJctrVpmUtility.getPgListCnt(diffClprInfo, this.pgList);
                }
            } else {
                lRet = SJctrVpmUtility.getPgListCnt(clprInfo, this.pgList);
            }
        }
        return lRet;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String strRet = null;
        if (dataList != null && dataList.size() != 0 && dataList.get(0) instanceof SJmoClprInfo) {
            SJmoClprInfo clprInfo = (SJmoClprInfo)dataList.get(0);
            strRet = String.valueOf(SJctrVpmUtility.getPgListCnt(clprInfo, this.pgList));
            if (!this.diffClprList.isEmpty()) {
                int iSearch = Collections.binarySearch(this.diffClprList, (Object)clprInfo);
                if (iSearch >= 0) {
                    SJmoClprInfo diffClprInfo = this.diffClprList.get(iSearch);
                    String strDiff = String.valueOf(SJctrVpmUtility.getPgListCnt(diffClprInfo, this.pgList));
                    strRet = SJctrVpmUtility.toDiffParamDisplay(strRet, strDiff);
                } else {
                    SJctrLogUty.warn("SJctrNumOfParityGroupColumnFromClprInfo", "toDispString", "Search failure for CLPR. CLPRID" + clprInfo.getSClpr());
                    strRet = null;
                }
            }
        }
        if (strRet == null) {
            strRet = "?";
        }
        return strRet;
    }
}

