/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.gumLaunch;

import java.io.File;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import sanproject.sn2.base.property.SJbaseSystemPropertiesConst;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.gumLaunch.tools.SJctrGumAuthKeyStoreUty;

public class SJctrGumHttpsManager {
    private static final String LOG_TITLE = SJctrGumHttpsManager.class.getSimpleName();
    private boolean existAliasGUM = false;
    private static final String SN_STARTUP_DATA_PATH = "SN_DataPath";
    private static final String SN_DIRECTORY_DATA = "data";
    static final String SN_DIRECTORY_INIT = "init";
    private static final String SN_DIRECTORY_CONTROLLER = "controller";
    protected static final String SN_GUM_KEY_STORE_PATH = SJcFileUty.concatFolderPath(SJcEnvUty.getProperty("SN_DataPath"), "data") + "controller";
    public static final String SN_GUM_DUMMY_KEY_STORE_PATH = SJcFileUty.concatFolderPath(SJcEnvUty.getProperty("SN_DataPath"), "data") + SJbaseSystemPropertiesConst.SN_DIRECTORY_BASE_EXTAUTH;
    protected static final String SN_GUM_KEY_STORE_NAME = "GumAuth.keystore";
    protected static final String SN_GUM_BASE_KEY_STORE_NAME = "BaseGumAuth.keystore";
    protected static final String SN_GUM_DUMMY_KEY_STORE_NAME = "DummyGumAuth.keystore";
    protected static final String SN_GUM_KEY_STORE_PASS = "erotsyekonnomearodotonnak";
    private String taretKeyStoreName = "";
    private static final String SN_SECURE_SOCKET_PROTOCOL = "TLS";
    private static final String SN_GUM_KEY_MANAGER_ALGORITHM = "SunX509";
    private static final String SN_GUM_TRUST_MANAGER_ALGORITHM = "PKIX";
    private static final String SN_GUM_PROVIDER = "SunJSSE";

    public void init() throws Exception {
        SJctrGumHttpsManager.setDafaultKeystore();
        this.initHttpsURLConnection();
    }

    private static void setDafaultKeystore() throws Exception {
        String LOG_SUBTITLE = "setDafaultKeystore";
        SJctrLogUty.info(LOG_TITLE, "setDafaultKeystore", "Start.");
        try {
            String keyStoreFile = SN_DIRECTORY_CONTROLLER + File.separator + SN_GUM_KEY_STORE_NAME;
            if (!SJcFileUty.exists(keyStoreFile)) {
                SJcFileUty.copyFile(SJbaseSystemPropertiesConst.SN_DIRECTORY_BASE_INIT, SN_GUM_BASE_KEY_STORE_NAME, "", keyStoreFile);
            }
        }
        catch (Exception ex) {
            SJctrLogUty.error(LOG_TITLE, "setDafaultKeystore", "Set Default Keystore File Error.", ex);
            throw ex;
        }
        SJctrLogUty.info(LOG_TITLE, "setDafaultKeystore", "End.");
    }

    private void initHttpsURLConnection() throws Exception {
        String LOG_SUBTITLE = "initHttpsURLConnection";
        SJctrLogUty.info(LOG_TITLE, "initHttpsURLConnection", "Start.");
        try {
            TrustManager[] trustManager;
            KeyManager[] keyManager;
            block9: {
                keyManager = null;
                trustManager = null;
                if (SJcFileUty.existsAbsolutePath(SJctrGumHttpsManager.getKeyStoreName())) {
                    KeyStore keyStore = null;
                    try {
                        keyStore = SJctrGumAuthKeyStoreUty.readKeyStore(SJctrGumHttpsManager.getKeyStoreName());
                        if (null == keyStore) {
                            SJctrLogUty.warn(LOG_TITLE, "initHttpsURLConnection", "Cannot read KeyStore.");
                            this.setExistAliasGUM(false);
                            break block9;
                        }
                        this.setExistAliasGUM(SJctrGumAuthKeyStoreUty.containsAlias(keyStore));
                    }
                    catch (Exception ex) {
                        SJctrLogUty.warn(LOG_TITLE, "initHttpsURLConnection", "Cannot read KeyStore.", ex);
                        this.setExistAliasGUM(false);
                    }
                } else {
                    SJctrLogUty.warn(LOG_TITLE, "initHttpsURLConnection", "KeyStore is not exist.");
                    this.setExistAliasGUM(false);
                }
            }
            if (this.isExistAliasGUM()) {
                this.setTaretKeyStoreName(SJctrGumHttpsManager.getKeyStoreName());
            } else {
                this.setTaretKeyStoreName(SJctrGumHttpsManager.getDummyKeyStoreName());
            }
            SJctrLogUty.info(LOG_TITLE, "initHttpsURLConnection", "isExistAliasGUM():" + this.isExistAliasGUM() + " KeyStore:" + this.getTaretKeyStoreName());
            this.setDefaultHostnameVerifier();
            keyManager = this.getKeyManagerLoadCerts();
            trustManager = this.isExistAliasGUM() ? this.getTrustManagerAllowLoadCerts() : this.getTrustManagerAllowAllCerts();
            SSLContext sslcontext = SSLContext.getInstance(SN_SECURE_SOCKET_PROTOCOL);
            sslcontext.init(keyManager, trustManager, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sslcontext.getSocketFactory());
        }
        catch (Exception ex) {
            SJctrLogUty.error(LOG_TITLE, "initHttpsURLConnection", "Exception occured.", ex);
            throw ex;
        }
    }

    protected void setDefaultHostnameVerifier() {
        String LOG_SUBTITLE = "setDefaultHostnameVerifier";
        SJctrLogUty.info(LOG_TITLE, "setDefaultHostnameVerifier", "Start.");
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession sslSession) {
                SJctrLogUty.warn(LOG_TITLE, "setDefaultHostnameVerifier", "verify() is call backed. requst host:" + hostname + " peer host:" + sslSession.getPeerHost());
                return true;
            }
        });
        SJctrLogUty.info(LOG_TITLE, "setDefaultHostnameVerifier", "End");
    }

    private KeyManager[] getKeyManagerLoadCerts() throws Exception {
        String LOG_SUBTITLE = "getKeyManagerLoadCerts";
        SJctrLogUty.info(LOG_TITLE, "getKeyManagerLoadCerts", "Start.");
        KeyManager[] keyManager = null;
        String storeName = this.getTaretKeyStoreName();
        char[] storePass = SN_GUM_KEY_STORE_PASS.toCharArray();
        try {
            KeyStore keyStore = SJctrGumAuthKeyStoreUty.readKeyStore(storeName);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(SN_GUM_KEY_MANAGER_ALGORITHM);
            SJctrLogUty.info(LOG_TITLE, "getKeyManagerLoadCerts", "KeyManagerFactory DefaultAlgorithm:" + KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, storePass);
            keyManager = keyManagerFactory.getKeyManagers();
        }
        catch (Exception ex) {
            SJctrLogUty.trace(LOG_TITLE, "getKeyManagerLoadCerts", "storeName:" + storeName, ex);
            throw ex;
        }
        SJctrLogUty.info(LOG_TITLE, "getKeyManagerLoadCerts", "End.");
        return keyManager;
    }

    public TrustManager[] getTrustManagerAllowAllCerts() throws Exception {
        String LOG_SUBTITLE = "getTrustManagerAllowAllCerts";
        SJctrLogUty.info(LOG_TITLE, "getTrustManagerAllowAllCerts", "Start.");
        try {
            TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
            return trustManagerArray;
        }
        catch (Exception ex) {
            SJctrLogUty.error(LOG_TITLE, "getTrustManagerAllowAllCerts", "Exception occured. ", ex);
            throw ex;
        }
        finally {
            SJctrLogUty.info(LOG_TITLE, "getTrustManagerAllowAllCerts", "End.");
        }
    }

    private TrustManager[] getTrustManagerAllowLoadCerts() throws Exception {
        String LOG_SUBTITLE = "getTrustManagerAllowLoadCerts";
        SJctrLogUty.info(LOG_TITLE, "getTrustManagerAllowLoadCerts", "Start.");
        X509TrustManager x509TrustManager = null;
        TrustManager[] trustManager = null;
        String storeName = this.getTaretKeyStoreName();
        try {
            KeyStore keyStore = SJctrGumAuthKeyStoreUty.readKeyStore(storeName);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(SN_GUM_TRUST_MANAGER_ALGORITHM, SN_GUM_PROVIDER);
            SJctrLogUty.info(LOG_TITLE, "getTrustManagerAllowLoadCerts", "TrustManagerFactory DefaultAlgorithm:" + TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            trustManager = trustManagerFactory.getTrustManagers();
            x509TrustManager = (X509TrustManager)trustManager[0];
            trustManager[0] = x509TrustManager;
        }
        catch (Exception ex) {
            SJctrLogUty.trace(LOG_TITLE, "getTrustManagerAllowLoadCerts", "storeName:" + storeName, ex);
            throw ex;
        }
        SJctrLogUty.info(LOG_TITLE, "getTrustManagerAllowLoadCerts", "End.");
        return trustManager;
    }

    private static String getKeyStoreName() {
        String LOG_SUBTITLE = "getKeyStoreName";
        SJctrLogUty.info(LOG_TITLE, "getKeyStoreName", "Start.");
        String storeName = null;
        StringBuilder builder = new StringBuilder();
        builder.append(SN_GUM_KEY_STORE_PATH);
        builder.append(File.separator);
        builder.append(SN_GUM_KEY_STORE_NAME);
        storeName = builder.toString();
        SJctrLogUty.info(LOG_TITLE, "getKeyStoreName", "End. - storeName:" + storeName);
        return storeName;
    }

    private static String getDummyKeyStoreName() {
        String LOG_SUBTITLE = "getDummyKeyStoreName";
        SJctrLogUty.info(LOG_TITLE, "getDummyKeyStoreName", "Start.");
        String storeName = null;
        StringBuilder builder = new StringBuilder();
        builder.append(SN_GUM_DUMMY_KEY_STORE_PATH);
        builder.append(File.separator);
        builder.append(SN_GUM_DUMMY_KEY_STORE_NAME);
        storeName = builder.toString();
        SJctrLogUty.info(LOG_TITLE, "getDummyKeyStoreName", "End. - storeName:" + storeName);
        return storeName;
    }

    private String getTaretKeyStoreName() {
        return this.taretKeyStoreName;
    }

    private void setTaretKeyStoreName(String taretKeyStoreName) {
        this.taretKeyStoreName = taretKeyStoreName;
    }

    private boolean isExistAliasGUM() {
        return this.existAliasGUM;
    }

    private void setExistAliasGUM(boolean existAliasGUM) {
        this.existAliasGUM = existAliasGUM;
    }
}

