/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.gumLaunch;

import edu.emory.mathcs.backport.java.util.Collections;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.gumLaunch.SJctrGumHttpsManager;

public class SJctrGumLaunchUty {
    static final String SSONegotiation_Protocol = "https://";
    static final String SSONegotiation_Path = "/preauth.cgi";
    static final String SSOLaunch_Protocol = "https://";
    static final String SSOLaunch_Path = "/ssolaunch.cgi/";
    static final int ERROR_CODE_207001 = 207001;
    public static final String PARAMETER_FORMAT = "\"parameters\":{";
    public static final String FORMAT_TYPE1 = "{\"userId\":\"%s\",\"password\":\"%s\",";
    public static final String FORMAT_TYPE2 = "\"%s\":\"%s\",";
    public static final String FORMAT_TYPE3 = "\"%s\":\"%s\"}}";
    public static final String KEY_PARAM_DISPID = "screenId";
    public static final String KEY_PARAM_TAB = "tab";
    public static final String KEY_PARAM_CLIENT = "client";
    public static final String KEY_PARAM_AUTHTYPE = "authType";
    public static final String KEY_SSO_RESULT = "result";
    public static final String KEY_SSO_MESSAGE = "message";
    public static final String KEY_SSO_MEASURE = "measure";
    public static final String KEY_SSO_ONETIMEKEY = "onetimeKey";
    public static final int SSO_RESULT_OK = 200000;
    public static final int GUM1 = 0;
    public static final int GUM2 = 1;
    public static final int CTLR_ANY = 99;
    public static final String KEY_GGI_PARAM = "GGI_PARAMETER";
    public static final String KEY_CTRL_ID = "GGI_CTRL_ID";
    public static final String jsonEscapeChkStr = "\"\\/";
    public static final String jsonEscapeAddStr = "\\";
    public static final Pattern IPv6Pattern = Pattern.compile("((([0-9a-f]{1,4}:){7}([0-9a-f]{1,4}|:))|(([0-9a-f]{1,4}:){6}(:[0-9a-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9a-f]{1,4}:){5}(((:[0-9a-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9a-f]{1,4}:){4}(((:[0-9a-f]{1,4}){1,3})|((:[0-9a-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9a-f]{1,4}:){3}(((:[0-9a-f]{1,4}){1,4})|((:[0-9a-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9a-f]{1,4}:){2}(((:[0-9a-f]{1,4}){1,5})|((:[0-9a-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9a-f]{1,4}:){1}(((:[0-9a-f]{1,4}){1,6})|((:[0-9a-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9a-f]{1,4}){1,7})|((:[0-9a-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?\\s*$", 2);

    private SJctrGumLaunchUty() {
    }

    public static String getGGIAuthUrl(String userName, String password, Map<String, Object> mMenu) {
        Map param = (Map)mMenu.get(KEY_GGI_PARAM);
        int ctrlId = (Integer)mMenu.get(KEY_CTRL_ID);
        StringBuffer buf = new StringBuffer();
        buf.append(String.format(FORMAT_TYPE1, SJctrGumLaunchUty.jsonEscape(userName), SJctrGumLaunchUty.jsonEscape(password)));
        buf.append(PARAMETER_FORMAT);
        Iterator ite = param.keySet().iterator();
        while (ite.hasNext()) {
            String key = (String)ite.next();
            String value = param.get(key).toString();
            if (ite.hasNext()) {
                buf.append(String.format(FORMAT_TYPE2, key, SJctrGumLaunchUty.jsonEscape(value)));
                continue;
            }
            buf.append(String.format(FORMAT_TYPE3, key, SJctrGumLaunchUty.jsonEscape(value)));
        }
        return SJctrGumLaunchUty.getSSOURL(buf.toString(), ctrlId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSSOURL(String input, int ctrlId) throws SJcException {
        SJcException exp;
        String result = null;
        SJctrError err = null;
        List ipList = SJcEnvUty.getGumAddressList();
        if (ipList == null) {
            SJctrLogUty.warn("SJctrGumLaunchUty", "getSSOURL", "GUM IP is null");
            ipList = Collections.emptyList();
        }
        if (ctrlId != 99) {
            if (ipList.size() > ctrlId) {
                String ip = (String)ipList.get(ctrlId);
                ipList.clear();
                ipList.add(ip);
            } else {
                SJctrLogUty.warn("SJctrGumLaunchUty", "getSSOURL", "ctrlId failed:" + ctrlId);
                ipList = Collections.emptyList();
            }
        }
        SJctrGumHttpsManager httpsMgr = new SJctrGumHttpsManager();
        try {
            httpsMgr.init();
        }
        catch (Exception ex) {
            SJctrLogUty.warn("SJctrGumLaunchUty", "getSSOURL", "Https set Failed:" + ex.toString());
        }
        for (String ip : ipList) {
            for (int retry = 2; retry > 0; --retry) {
                err = null;
                String SsoResponse = "";
                ip = SJctrGumLaunchUty.parseUrl(ip);
                String authUrl = "https://" + ip + SSONegotiation_Path;
                HttpURLConnection connection = null;
                try {
                    URL url = new URL(authUrl);
                    connection = (HttpsURLConnection)url.openConnection();
                    connection.setDoOutput(true);
                    connection.setUseCaches(false);
                    connection.setRequestMethod("POST");
                    PrintWriter printWriter = new PrintWriter(connection.getOutputStream());
                    printWriter.print(input);
                    printWriter.close();
                    int status = connection.getResponseCode();
                    if (status != 200) {
                        SJctrLogUty.warn("SJctrGumLaunchUty", "getSSOURL", "post faild=" + status + ": IP=" + ip);
                        continue;
                    }
                    BufferedReader reader = null;
                    InputStreamReader in = null;
                    try {
                        in = new InputStreamReader(connection.getInputStream());
                        reader = new BufferedReader(in);
                        String buf = null;
                        while ((buf = reader.readLine()) != null) {
                            SsoResponse = SsoResponse + buf;
                        }
                    }
                    catch (Exception ex) {
                        SJctrLogUty.warn("SJctrGumLaunchUty", "getSSOURL", "Post Response read failed:" + ex.toString());
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                catch (Exception ex) {
                    SJctrLogUty.warn("SJctrGumLaunchUty", "getSSOURL", "GUM Access Failed: URL=" + authUrl, ex);
                }
                finally {
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
                if (SsoResponse.length() > 0) {
                    try {
                        Map<String, String> ssoParam = SJctrGumLaunchUty.jsonToHash(SsoResponse);
                        String ssoResult = ssoParam.get(KEY_SSO_RESULT);
                        int ssoEC = Integer.parseInt(ssoResult.split("-")[1]);
                        if (ssoEC == 200000) {
                            result = "https://" + ip + SSOLaunch_Path + ssoParam.get(KEY_SSO_ONETIMEKEY);
                            break;
                        }
                        SJctrLogUty.warn("SJctrGumLaunchUty", "getSSOURL", "SSO Failed:" + ssoResult);
                        int logFunc = Integer.parseInt(ssoParam.get(KEY_SSO_RESULT).substring(0, 3));
                        int logMo = Integer.parseInt(ssoParam.get(KEY_SSO_RESULT).substring(3, 5));
                        err = new SJctrError(logFunc, logMo, ssoEC);
                    }
                    catch (Exception ex) {
                        SJctrLogUty.warn("SJctrGumLaunchUty", "getSSOURL", "SSO Response Error:" + SsoResponse);
                    }
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (result == null) continue;
            break;
        }
        if (err != null) {
            exp = err.createException();
            throw exp;
        }
        if (result == null) {
            err = new SJctrError(201, 22, 207001);
            exp = err.createException();
            throw exp;
        }
        return result;
    }

    private static Map<String, String> jsonToHash(String param) {
        String[] str1Ary;
        HashMap<String, String> result = new HashMap<String, String>();
        param = param.replaceAll(Pattern.quote("{"), "");
        param = param.replaceAll(Pattern.quote("}"), "");
        param = param.replaceAll(Pattern.quote("\""), "");
        for (String toHash : str1Ary = param.split(",")) {
            if (toHash.endsWith(":")) continue;
            result.put(toHash.split(":")[0], toHash.split(":")[1]);
        }
        return result;
    }

    public static Map<String, Object> createParamMap(String dispId, String tabIndex, String client) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(KEY_PARAM_DISPID, dispId);
        if (tabIndex != null) {
            map.put(KEY_PARAM_TAB, tabIndex);
        }
        map.put(KEY_PARAM_CLIENT, client);
        return map;
    }

    public static String jsonEscape(String input) {
        StringBuffer buf = new StringBuffer();
        for (int index = 0; index < input.length(); ++index) {
            String s = input.substring(index, index + 1);
            if (jsonEscapeChkStr.indexOf(s) >= 0) {
                buf.append(jsonEscapeAddStr);
            }
            buf.append(s);
        }
        return buf.toString();
    }

    public static String parseUrl(String ip) {
        String ret = ip;
        Matcher m = IPv6Pattern.matcher(ip);
        if (m.find()) {
            ret = "[" + ip + "]";
        }
        return ret;
    }
}

