/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.model;

import java.util.HashMap;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrTextBoxDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrEventListener;
import sanproject.sn2.controller.com.model.event.SJctrItemStateLintener;
import sanproject.sn2.controller.com.model.event.SJctrObjectSetListener;
import sanproject.sn2.controller.com.model.event.SJctrRangeChangeListener;
import sanproject.sn2.controller.com.model.event.SJctrTextBoxEvent;
import sanproject.sn2.controller.com.model.event.SJctrTextChangeListener;

public class SJctrTextBoxDataModel
extends SJctrDataObjectModel<SJctrTextBoxDataObject> {
    boolean trim = true;

    public static boolean isEnable(SJctrTextBoxDataObject textBox) {
        Integer enable = textBox.visible();
        return enable.equals(SJctrTextBoxDataObject.VISIBLE_ACTIVE);
    }

    public static boolean isVisible(SJctrTextBoxDataObject textBox) {
        Integer visible = textBox.visible();
        return !visible.equals(SJctrTextBoxDataObject.VISIBLE_INVISIBLE);
    }

    public static boolean setEnable(SJctrTextBoxDataObject textBox, boolean flg) {
        Integer enable = flg ? SJctrTextBoxDataObject.VISIBLE_ACTIVE : SJctrTextBoxDataObject.VISIBLE_INACTIVE;
        boolean result = !textBox.visible().equals(enable);
        textBox.visible(enable);
        return result;
    }

    public static boolean setState(SJctrTextBoxDataObject textBox, Integer state) {
        boolean result = !textBox.visible().equals(state);
        textBox.visible(state);
        return result;
    }

    public static boolean setVisible(SJctrTextBoxDataObject textBox, boolean flg) {
        Integer visible = flg ? SJctrTextBoxDataObject.VISIBLE_ACTIVE : SJctrTextBoxDataObject.VISIBLE_INVISIBLE;
        boolean result = !textBox.visible().equals(visible);
        textBox.visible(visible);
        return result;
    }

    public static boolean setFixed(SJctrTextBoxDataObject textBox, boolean flg) {
        Integer visible = flg ? SJctrTextBoxDataObject.VISIBLE_FIXED : SJctrTextBoxDataObject.VISIBLE_ACTIVE;
        boolean result = !textBox.visible().equals(visible);
        textBox.visible(visible);
        return result;
    }

    public static boolean setValueDefault(SJctrTextBoxDataObject textBox, boolean flg) {
        boolean result = !textBox.valuedefault().equals(flg);
        textBox.valuedefault(flg);
        return result;
    }

    public SJctrTextBoxDataModel() {
        this(null);
    }

    public SJctrTextBoxDataModel(String label) {
        SJctrTextBoxDataObject textBox = (SJctrTextBoxDataObject)this.getManageData();
        SJctrTextBoxDataModel.setState(textBox, SJctrTextBoxDataObject.VISIBLE_ACTIVE);
        this.setValue("");
        if (label != null) {
            textBox.label(label);
        }
        this.initListener();
    }

    @Override
    public void addItemStateChangeLintener(SJctrItemStateLintener lintener) {
        super.addItemStateChangeLintener(lintener);
    }

    public void addRangeChangeListener(SJctrRangeChangeListener listener) {
        this.addEventListener(listener);
    }

    public void addTextChangeListener(SJctrTextChangeListener listener) {
        this.addEventListener(listener);
    }

    public String getMax() {
        return ((SJctrTextBoxDataObject)this.getManageData()).max();
    }

    public String getMin() {
        return ((SJctrTextBoxDataObject)this.getManageData()).min();
    }

    public String getValue() {
        return ((SJctrTextBoxDataObject)this.getManageData()).value();
    }

    public boolean isEnable() {
        SJctrTextBoxDataObject textBox = (SJctrTextBoxDataObject)this.getManageData();
        return SJctrTextBoxDataModel.isEnable(textBox);
    }

    public boolean isVisible() {
        SJctrTextBoxDataObject textBox = (SJctrTextBoxDataObject)this.getManageData();
        return SJctrTextBoxDataModel.isVisible(textBox);
    }

    public void setEnable(boolean flg) {
        SJctrTextBoxDataObject textBox = (SJctrTextBoxDataObject)this.getManageData();
        boolean result = SJctrTextBoxDataModel.setEnable(textBox, flg);
        if (result) {
            this.fireItemStateChanged();
        }
    }

    public void setLabel(String label) {
        SJctrTextBoxDataObject textBox = (SJctrTextBoxDataObject)this.getManageData();
        boolean equal = textBox.label().equals(label);
        if (!equal) {
            textBox.label(label);
            this.fireItemStateChanged();
        }
    }

    public void setMax(String max) {
        SJctrTextBoxDataObject textBox = (SJctrTextBoxDataObject)this.getManageData();
        boolean equal = textBox.max().equals(max);
        if (!equal) {
            textBox.max(max);
            this.fireRangeChanged();
        }
    }

    public void setMin(String min) {
        SJctrTextBoxDataObject textBox = (SJctrTextBoxDataObject)this.getManageData();
        boolean equal = textBox.min().equals(min);
        if (!equal) {
            textBox.min(min);
            this.fireRangeChanged();
        }
    }

    public void setValue(String value) {
        boolean equal;
        SJctrTextBoxDataObject textBox = (SJctrTextBoxDataObject)this.getManageData();
        String trimValue = value;
        if (this.trim) {
            trimValue = value.trim();
        }
        if (!(equal = textBox.value().equals(trimValue))) {
            textBox.value(trimValue);
            this.fireTextChanged();
        }
    }

    public void setVisible(boolean flg) {
        SJctrTextBoxDataObject textBox = (SJctrTextBoxDataObject)this.getManageData();
        boolean result = SJctrTextBoxDataModel.setVisible(textBox, flg);
        if (result) {
            this.fireItemStateChanged();
        }
    }

    public void setFixed(boolean flg) {
        SJctrTextBoxDataObject textBox = (SJctrTextBoxDataObject)this.getManageData();
        boolean result = SJctrTextBoxDataModel.setFixed(textBox, flg);
        if (result) {
            this.fireItemStateChanged();
        }
    }

    public void setValueDefault(boolean flg) {
        SJctrTextBoxDataObject textBox = (SJctrTextBoxDataObject)this.getManageData();
        boolean result = SJctrTextBoxDataModel.setValueDefault(textBox, flg);
        if (result) {
            this.fireItemStateChanged();
        }
    }

    @Override
    protected SJctrTextBoxDataObject createManageData() {
        return new SJctrTextBoxDataObject();
    }

    @Override
    protected void fireItemStateChanged() {
        super.fireItemStateChanged();
    }

    protected void fireRangeChanged() {
        SJctrTextBoxEvent event = null;
        this.setDirty();
        for (SJctrEventListener listener : this.getEventListeners()) {
            if (!(listener instanceof SJctrRangeChangeListener)) continue;
            if (event == null) {
                event = new SJctrTextBoxEvent((SJctrDataObjectModel<? extends SJctrDataObject>)this, (SJctrTextBoxDataObject)this.getManageData());
            }
            ((SJctrRangeChangeListener)listener).rangeChanged(event);
        }
    }

    protected void fireTextChanged() {
        SJctrTextBoxEvent event = null;
        this.setDirty();
        for (SJctrEventListener listener : this.getEventListeners()) {
            if (!(listener instanceof SJctrTextChangeListener)) continue;
            if (event == null) {
                event = new SJctrTextBoxEvent((SJctrDataObjectModel<? extends SJctrDataObject>)this, (SJctrTextBoxDataObject)this.getManageData());
            }
            ((SJctrTextChangeListener)listener).textChanged(event);
        }
    }

    @Override
    protected void makeDataObject() {
    }

    @Override
    protected void makeModelDirect() {
    }

    private void initListener() {
        this.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObject) {
                if (setObject instanceof SJctrTextBoxDataObject) {
                    SJctrTextBoxDataModel.this.setValueAction((SJctrTextBoxDataObject)setObject);
                }
            }
        });
        this.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObject) {
                if (setObject instanceof SJctrTextBoxDataObject) {
                    SJctrTextBoxDataModel.this.setVisibleAction((SJctrTextBoxDataObject)setObject);
                }
            }
        });
    }

    private void setValueAction(SJctrTextBoxDataObject setObject) {
        this.setValue(setObject.value());
    }

    private void setVisibleAction(SJctrTextBoxDataObject setObject) {
        if (!setObject.getDataMap().containsKey("COM_VISIBLE")) {
            return;
        }
        if (SJctrTextBoxDataModel.setState((SJctrTextBoxDataObject)this.getManageData(), setObject.visible())) {
            this.fireItemStateChanged();
        }
    }

    @Override
    public void setOwnControlData(HashMap<String, Object> controlData) {
        Object obj = controlData.get("COM_VALUE");
        if (obj instanceof String) {
            String value = (String)obj;
            this.setValue(value);
        } else {
            this.dataRestoreFailed("COM_VALUE", obj);
        }
    }

    @Override
    public HashMap<String, Object> getOwnControlData() {
        HashMap<String, Object> controlData = new HashMap<String, Object>();
        controlData.put("COM_VALUE", this.getValue());
        return controlData;
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }
}

