/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.systemcall;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import java.io.File;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.Certificate;
import org.slf4j.LoggerFactory;
import sanproject.sn2.base.authentication.def.SJbaseHcsConst;
import sanproject.sn2.base.property.SJbaseSystemPropertiesConst;
import sanproject.sn2.base.property.SJbaseSystemPropertiesManager;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.tools.SetExAuthKeyStoreUty;

public class SJcmdSetHCSServerCert {
    private static final String LOG_FUNCTION = "HCS";
    private static final String LOG_TITLE = SJcmdSetHCSServerCert.class.getSimpleName();
    private static final String SET_MODE_STR = "-set";
    private static final String DEL_MODE_STR = "-del";
    private static final int EXIT_CODE_ERROR = 1;
    private static final String KEY_STORE_INIT = "ExternalAuth.keystore";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        String LOG_SUBTITLE = "main";
        SJbaseSystemPropertiesManager clsEnv = null;
        try {
            SJcmdSetHCSServerCert.initLogger();
            SJcmdSetHCSServerCert.initEnv();
            SJcLogUty.getLogger().info(LOG_FUNCTION, LOG_TITLE, "main", "Start.");
            clsEnv = new SJbaseSystemPropertiesManager();
            clsEnv.initialize(0);
            boolean check = SJcmdSetHCSServerCert.checkArgv(argv);
            if (!check) {
                System.exit(1);
            }
            if (SET_MODE_STR.equals(argv[0])) {
                SJcmdSetHCSServerCert.executeSetHCSCert(argv[1]);
            } else if (DEL_MODE_STR.equals(argv[0])) {
                SJcmdSetHCSServerCert.executeDelHCSCert();
            }
        }
        catch (Exception e) {
            if (clsEnv != null) {
                SJcLogUty.getLogger().error(LOG_FUNCTION, LOG_TITLE, "main", "Exception.", e);
            }
            System.exit(1);
        }
        finally {
            try {
                if (clsEnv != null) {
                    clsEnv.finish();
                }
            }
            catch (Exception e) {
                SJcLogUty.getLogger().error(LOG_FUNCTION, LOG_TITLE, "main", "SJbaseSystemPropertiesManager finish error.", e);
            }
            SJcLogUty.getLogger().info(LOG_FUNCTION, LOG_TITLE, "main", "End.");
        }
    }

    private static void initLogger() throws Exception {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)lc);
        lc.reset();
        URL logurl = SJcmdSetHCSServerCert.class.getResource("logback.xml");
        configurator.doConfigure(logurl);
    }

    private static void initEnv() {
        System.setProperty("SN_DataPath", "C:\\dkc200\\san\\SN2\\SN2Files");
        System.setProperty("SN_EnvFile", "C:\\dkc200\\san\\SN2\\SN2Files\\data\\base\\setting\\system\\properties\\SN2_Startup.properties");
        System.setProperty("SN_EnvFileV", "C:\\dkc200\\san\\SN2\\SN2Files\\data\\base\\setting\\system\\properties\\SN2_StartupV.properties");
        System.setProperty("SN_LogPath", "SetExternalHCS");
    }

    private static boolean checkArgv(String[] argv) {
        String LOG_SUBTITLE = "checkArgv";
        SJcLoggerInterface logger = SJcLogUty.getLogger();
        boolean rtn = false;
        logger.info(LOG_FUNCTION, LOG_TITLE, "checkArgv", "Start.");
        if (argv.length == 0) {
            logger.error(LOG_FUNCTION, LOG_TITLE, "checkArgv", "Parameter is invalid. (argv length is zero.)");
            return rtn;
        }
        if (SET_MODE_STR.equals(argv[0])) {
            if (argv.length < 2) {
                logger.error(LOG_FUNCTION, LOG_TITLE, "checkArgv", "Parameter is invalid. (Certificate file path is not specified.)");
                return rtn;
            }
        } else if (!DEL_MODE_STR.equals(argv[0])) {
            logger.error(LOG_FUNCTION, LOG_TITLE, "checkArgv", "Parameter is invalid. (not supported mode.)");
            return rtn;
        }
        rtn = true;
        logger.info(LOG_FUNCTION, LOG_TITLE, "checkArgv", "End.");
        return rtn;
    }

    private static void executeSetHCSCert(String certFile) throws Exception {
        String LOG_SUBTITLE = "executeSetHCSCert";
        SJcLoggerInterface logger = SJcLogUty.getLogger();
        KeyStore key_store = null;
        logger.info(LOG_FUNCTION, LOG_TITLE, "executeSetHCSCert", "Start.");
        try {
            String keyStoreFileA = SJbaseHcsConst.SN_HCS_KEY_STORE_PATH + File.separator + "HcsExternalAuth.keystore";
            String keyStoreFile = SJbaseSystemPropertiesConst.SN_DIRECTORY_BASE_SETTING_EXTAUTH + File.separator + "HcsExternalAuth.keystore";
            if (!SJcFileUty.exists(keyStoreFile)) {
                SJcFileUty.copyFile(SJbaseSystemPropertiesConst.SN_DIRECTORY_BASE_INIT, KEY_STORE_INIT, "", keyStoreFile);
            }
            key_store = SetExAuthKeyStoreUty.readKeyStore(keyStoreFileA);
            Certificate cert = SetExAuthKeyStoreUty.readCertificate(certFile);
            SetExAuthKeyStoreUty.updateKeyStore(keyStoreFileA, key_store, cert);
        }
        catch (Exception ex) {
            logger.error(LOG_FUNCTION, LOG_TITLE, "executeSetHCSCert", "Set HCS Certification File Error.", ex);
            throw ex;
        }
        logger.info(LOG_FUNCTION, LOG_TITLE, "executeSetHCSCert", "End.");
    }

    private static void executeDelHCSCert() throws Exception {
        String LOG_SUBTITLE = "executeDelHCSCert";
        SJcLoggerInterface logger = SJcLogUty.getLogger();
        KeyStore key_store = null;
        logger.info(LOG_FUNCTION, LOG_TITLE, "executeDelHCSCert", "Start.");
        try {
            String keyStoreFileA = SJbaseHcsConst.SN_HCS_KEY_STORE_PATH + File.separator + "HcsExternalAuth.keystore";
            String keyStoreFile = SJbaseSystemPropertiesConst.SN_DIRECTORY_BASE_SETTING_EXTAUTH + File.separator + "HcsExternalAuth.keystore";
            if (SJcFileUty.exists(keyStoreFile)) {
                key_store = SetExAuthKeyStoreUty.readKeyStore(keyStoreFileA);
                SetExAuthKeyStoreUty.deleteCertificate(keyStoreFileA, key_store);
            }
        }
        catch (Exception ex) {
            logger.error(LOG_FUNCTION, LOG_TITLE, "executeDelHCSCert", "Delete HCS Certification File Error.", ex);
            throw ex;
        }
        logger.info(LOG_FUNCTION, LOG_TITLE, "executeDelHCSCert", "End.");
    }
}

