/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.server.adapters.coma.cimxml;

import com.ws.cim.xmlcim.CIMXMLElementsParser;
import com.ws.wbem.jserver.WBEMServer;
import com.ws.wbem.jserver.WBEMServerAuthentication;
import com.ws.wbem.jserver.embed.HttpConnection;
import com.ws.wbem.server.adapters.coma.cimxml.CIMXMLResponseStreamWriter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.cim.CIMArgument;
import javax.cim.CIMClass;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMQualifierType;
import javax.cim.UnsignedInteger32;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class CIMXMLRequestStreamParser {
    private String mCIMVersion;
    private String mDTDVersion;
    private final XMLInputFactory mFactory;
    private String mMessageID;
    private String mProtocolVersion;
    private final WBEMServer mServer;

    public CIMXMLRequestStreamParser(WBEMServer wBEMServer) {
        this.mServer = wBEMServer;
        this.mFactory = XMLInputFactory.newInstance();
        this.mFactory.setProperty("javax.xml.stream.isCoalescing", true);
    }

    public String getCIMVersion() {
        return this.mCIMVersion;
    }

    public String getDTDVersion() {
        return this.mDTDVersion;
    }

    public String getMessageID() {
        return this.mMessageID;
    }

    public String getProtocolVersion() {
        return this.mProtocolVersion;
    }

    public void parseSimpleRequest(HttpConnection httpConnection, WBEMServerAuthentication wBEMServerAuthentication) throws WBEMException {
        InputStream inputStream = httpConnection.getRequestBody();
        String string = null;
        WBEMOperation wBEMOperation = null;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        CIMObjectPath cIMObjectPath = new CIMObjectPath(wBEMServerAuthentication.getScheme(), wBEMServerAuthentication.getServerHost(), wBEMServerAuthentication.getPort(), null, "", null);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            XMLStreamReader xMLStreamReader = this.mFactory.createXMLStreamReader(inputStream);
            String string2 = null;
            QName qName = null;
            int n = xMLStreamReader.next();
            while (n != 8) {
                block1 : switch (n) {
                    case 1: {
                        Object object;
                        qName = xMLStreamReader.getName();
                        if (null == qName) break;
                        if ("CIM".equals(qName.getLocalPart())) {
                            this.mCIMVersion = xMLStreamReader.getAttributeValue(null, "CIMVERSION");
                            this.mDTDVersion = xMLStreamReader.getAttributeValue(null, "DTDVERSION");
                            break;
                        }
                        if ("MESSAGE".equals(qName.getLocalPart())) {
                            this.mMessageID = xMLStreamReader.getAttributeValue(null, "ID");
                            this.mProtocolVersion = xMLStreamReader.getAttributeValue(null, "PROTOCOLVERSION");
                            break;
                        }
                        if ("METHODCALL".equals(qName.getLocalPart())) {
                            string = xMLStreamReader.getAttributeValue(null, "NAME");
                            break;
                        }
                        if ("IMETHODCALL".equals(qName.getLocalPart())) {
                            string = xMLStreamReader.getAttributeValue(null, "NAME");
                            break;
                        }
                        if ("LOCALNAMESPACEPATH".equals(qName.getLocalPart())) {
                            object = CIMXMLElementsParser.parseLocalNamespacePath((XMLStreamReader)xMLStreamReader);
                            cIMObjectPath = new CIMObjectPath(wBEMServerAuthentication.getScheme(), wBEMServerAuthentication.getServerHost(), wBEMServerAuthentication.getPort(), (String)object, "", null);
                            break;
                        }
                        if ("LOCALCLASSPATH".equals(qName.getLocalPart())) {
                            cIMObjectPath = CIMXMLElementsParser.parseLocalClassPath((XMLStreamReader)xMLStreamReader, (CIMObjectPath)cIMObjectPath);
                            break;
                        }
                        if ("LOCALINSTANCEPATH".equals(qName.getLocalPart())) {
                            cIMObjectPath = CIMXMLElementsParser.parseLocalInstancePath((XMLStreamReader)xMLStreamReader, (CIMObjectPath)cIMObjectPath);
                            break;
                        }
                        if ("IPARAMVALUE".equals(qName.getLocalPart())) {
                            string2 = xMLStreamReader.getAttributeValue(null, "NAME");
                            break;
                        }
                        if ("VALUE".equals(qName.getLocalPart())) {
                            if (null != string2) {
                                switch (string2) {
                                    case "OperationTimeout": 
                                    case "MaxObjectCount": {
                                        hashtable.put(string2, CIMXMLElementsParser.parseValue((XMLStreamReader)xMLStreamReader, (CIMDataType)CIMDataType.UINT32_T, (boolean)false));
                                        break block1;
                                    }
                                    case "LocalOnly": 
                                    case "DeepInheritance": 
                                    case "ContinueOnError": 
                                    case "IncludeClassOrigin": 
                                    case "IncludeQualifiers": 
                                    case "EndOfSequence": 
                                    case "ReturnQueryResultClass": {
                                        hashtable.put(string2, CIMXMLElementsParser.parseValue((XMLStreamReader)xMLStreamReader, (CIMDataType)CIMDataType.BOOLEAN_T, (boolean)false));
                                        break block1;
                                    }
                                    case "QualifierName": {
                                        cIMObjectPath = new CIMObjectPath(cIMObjectPath.getScheme(), cIMObjectPath.getHost(), cIMObjectPath.getPort(), cIMObjectPath.getNamespace(), (String)CIMXMLElementsParser.parseValue((XMLStreamReader)xMLStreamReader, (CIMDataType)CIMDataType.STRING_T, (boolean)false), null);
                                        break block1;
                                    }
                                }
                                hashtable.put(string2, CIMXMLElementsParser.parseValue((XMLStreamReader)xMLStreamReader, (CIMDataType)CIMDataType.STRING_T, (boolean)false));
                                break;
                            }
                            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (String)"XML malformed: No name for operation", (WBEMOperation)(wBEMOperation == null ? WBEMOperation.ENUMERATEINSTANCES : wBEMOperation), (String)cIMObjectPath.getObjectName());
                        }
                        if ("VALUE.ARRAY".equals(qName.getLocalPart())) {
                            hashtable.put(string2, CIMXMLElementsParser.parseValueArray((XMLStreamReader)xMLStreamReader, (CIMDataType)CIMDataType.STRING_ARRAY_T, (boolean)false));
                            break;
                        }
                        if ("VALUE.REFERENCE".equals(qName.getLocalPart())) {
                            hashtable.put(string2, CIMXMLElementsParser.parseValueReference((XMLStreamReader)xMLStreamReader, (CIMObjectPath)cIMObjectPath));
                            break;
                        }
                        if ("CLASSNAME".equals(qName.getLocalPart())) {
                            if ("AssocClass".equals(string2) || "ResultClass".equals(string2)) {
                                object = CIMXMLElementsParser.parseClassName((XMLStreamReader)xMLStreamReader, (CIMObjectPath)cIMObjectPath);
                                hashtable.put(string2, object.getObjectName());
                                break;
                            }
                            cIMObjectPath = CIMXMLElementsParser.parseClassName((XMLStreamReader)xMLStreamReader, (CIMObjectPath)cIMObjectPath);
                            hashtable.put(string2, cIMObjectPath);
                            break;
                        }
                        if ("INSTANCENAME".equals(qName.getLocalPart())) {
                            cIMObjectPath = CIMXMLElementsParser.parseInstanceName((XMLStreamReader)xMLStreamReader, (CIMObjectPath)cIMObjectPath);
                            if (null == string2) break;
                            hashtable.put(string2, cIMObjectPath);
                            break;
                        }
                        if ("QUALIFIER.DECLARATION".equals(qName.getLocalPart())) {
                            hashtable.put(string2, CIMXMLElementsParser.parseQualifierType((XMLStreamReader)xMLStreamReader, (CIMObjectPath)cIMObjectPath, (int)n));
                            break;
                        }
                        if ("CLASS".equals(qName.getLocalPart())) {
                            hashtable.put(string2, CIMXMLElementsParser.parseClass((XMLStreamReader)xMLStreamReader, (CIMObjectPath)cIMObjectPath));
                            break;
                        }
                        if ("INSTANCE".equals(qName.getLocalPart())) {
                            hashtable.put(string2, CIMXMLElementsParser.parseInstance((XMLStreamReader)xMLStreamReader, (CIMObjectPath)cIMObjectPath));
                            break;
                        }
                        if ("VALUE.NAMEDINSTANCE".equals(qName.getLocalPart())) {
                            hashtable.put(string2, CIMXMLElementsParser.parseValueNamedInstance((XMLStreamReader)xMLStreamReader, (CIMObjectPath)cIMObjectPath));
                            break;
                        }
                        if (!"PARAMVALUE".equals(qName.getLocalPart()) || null == (object = CIMXMLElementsParser.parseParamValue((XMLStreamReader)xMLStreamReader, (CIMObjectPath)cIMObjectPath)).getValue()) break;
                        arrayList.add(object);
                        break;
                    }
                    case 2: {
                        Object object = xMLStreamReader.getName();
                        if ("IMETHODCALL".equals(((QName)object).getLocalPart())) {
                            CIMXMLResponseStreamWriter cIMXMLResponseStreamWriter = new CIMXMLResponseStreamWriter(this.mMessageID, this.mServer, httpConnection, wBEMServerAuthentication);
                            if (null != string) {
                                switch (string) {
                                    case "AssociatorNames": {
                                        wBEMOperation = WBEMOperation.ASSOCIATORS;
                                        if (0 == cIMObjectPath.getKeys().length) {
                                            cIMXMLResponseStreamWriter.associatorClassNames(cIMObjectPath, this.getStringValueFromTable(hashtable, "AssocClass"), this.getStringValueFromTable(hashtable, "ResultClass"), this.getStringValueFromTable(hashtable, "Role"), this.getStringValueFromTable(hashtable, "ResultRole"), this.getBooleanValueFromTable(hashtable, "IncludeQualifiers", true), this.getBooleanValueFromTable(hashtable, "IncludeClassOrigin", false));
                                            break;
                                        }
                                        cIMXMLResponseStreamWriter.associatorInstanceNames(cIMObjectPath, this.getStringValueFromTable(hashtable, "AssocClass"), this.getStringValueFromTable(hashtable, "ResultClass"), this.getStringValueFromTable(hashtable, "Role"), this.getStringValueFromTable(hashtable, "ResultRole"));
                                        break;
                                    }
                                    case "Associators": {
                                        wBEMOperation = WBEMOperation.ASSOCIATORS;
                                        if (0 == cIMObjectPath.getKeys().length) {
                                            cIMXMLResponseStreamWriter.associatorClasses(cIMObjectPath, this.getStringValueFromTable(hashtable, "AssocClass"), this.getStringValueFromTable(hashtable, "ResultClass"), this.getStringValueFromTable(hashtable, "Role"), this.getStringValueFromTable(hashtable, "ResultRole"), this.getBooleanValueFromTable(hashtable, "IncludeQualifiers", true));
                                            break;
                                        }
                                        cIMXMLResponseStreamWriter.associatorInstances(cIMObjectPath, this.getStringValueFromTable(hashtable, "AssocClass"), this.getStringValueFromTable(hashtable, "ResultClass"), this.getStringValueFromTable(hashtable, "Role"), this.getStringValueFromTable(hashtable, "ResultRole"), null == hashtable.get("PropertyList") ? null : (String[])hashtable.get("PropertyList"));
                                        break;
                                    }
                                    case "CloseEnumeration": {
                                        wBEMOperation = WBEMOperation.CLOSEENUMERATION;
                                        cIMXMLResponseStreamWriter.closeEnumeration(cIMObjectPath, this.getStringValueFromTable(hashtable, "EnumerationContext"));
                                        break;
                                    }
                                    case "CreateClass": {
                                        wBEMOperation = WBEMOperation.CREATECLASS;
                                        cIMXMLResponseStreamWriter.createClass((CIMClass)hashtable.get("NewClass"));
                                        break;
                                    }
                                    case "CreateInstance": {
                                        wBEMOperation = WBEMOperation.CREATEINSTANCE;
                                        cIMXMLResponseStreamWriter.createInstance((CIMInstance)hashtable.get("NewInstance"));
                                        break;
                                    }
                                    case "DeleteClass": {
                                        wBEMOperation = WBEMOperation.DELETECLASS;
                                        cIMXMLResponseStreamWriter.deleteClass(cIMObjectPath);
                                        break;
                                    }
                                    case "DeleteInstance": {
                                        wBEMOperation = WBEMOperation.DELETEINSTANCE;
                                        cIMXMLResponseStreamWriter.deleteInstance(cIMObjectPath);
                                        break;
                                    }
                                    case "DeleteQualifier": {
                                        wBEMOperation = WBEMOperation.DELETEQUALIFIERTYPE;
                                        cIMXMLResponseStreamWriter.deleteQualifierType(cIMObjectPath);
                                        break;
                                    }
                                    case "EnumerateClasses": {
                                        wBEMOperation = WBEMOperation.ENUMERATECLASSES;
                                        cIMXMLResponseStreamWriter.enumerateClasses(cIMObjectPath, this.getBooleanValueFromTable(hashtable, "DeepInheritance", false), this.getBooleanValueFromTable(hashtable, "LocalOnly", true), this.getBooleanValueFromTable(hashtable, "IncludeQualifiers", true));
                                        break;
                                    }
                                    case "EnumerateClassNames": {
                                        wBEMOperation = WBEMOperation.ENUMERATECLASSES;
                                        cIMXMLResponseStreamWriter.enumerateClassNames(cIMObjectPath, this.getBooleanValueFromTable(hashtable, "DeepInheritance", false));
                                        break;
                                    }
                                    case "EnumerateInstances": {
                                        wBEMOperation = WBEMOperation.ENUMERATEINSTANCES;
                                        cIMXMLResponseStreamWriter.enumerateInstances(cIMObjectPath, null == hashtable.get("PropertyList") ? null : (String[])hashtable.get("PropertyList"));
                                        break;
                                    }
                                    case "EnumerateInstanceNames": {
                                        wBEMOperation = WBEMOperation.ENUMERATEINSTANCES;
                                        cIMXMLResponseStreamWriter.enumerateInstanceNames(cIMObjectPath);
                                        break;
                                    }
                                    case "EnumerateQualifiers": {
                                        wBEMOperation = WBEMOperation.ENUMERATEQUALIFIERTYPES;
                                        cIMXMLResponseStreamWriter.enumerateQualifierTypes(cIMObjectPath);
                                        break;
                                    }
                                    case "ExecQuery": {
                                        wBEMOperation = WBEMOperation.EXECUTEQUERY;
                                        cIMXMLResponseStreamWriter.execQuery(cIMObjectPath, this.getStringValueFromTable(hashtable, "Query"), this.getStringValueFromTable(hashtable, "QueryLanguage"));
                                        break;
                                    }
                                    case "GetClass": {
                                        wBEMOperation = WBEMOperation.GETCLASS;
                                        cIMXMLResponseStreamWriter.getClass(cIMObjectPath, this.getBooleanValueFromTable(hashtable, "LocalOnly", true), this.getBooleanValueFromTable(hashtable, "IncludeQualifiers", true));
                                        break;
                                    }
                                    case "GetInstance": {
                                        wBEMOperation = WBEMOperation.GETINSTANCE;
                                        cIMXMLResponseStreamWriter.getInstance(cIMObjectPath, null == hashtable.get("PropertyList") ? null : (String[])hashtable.get("PropertyList"));
                                        break;
                                    }
                                    case "GetQualifier": {
                                        wBEMOperation = WBEMOperation.GETQUALIFIERTYPE;
                                        cIMXMLResponseStreamWriter.getQualifierType(cIMObjectPath);
                                        break;
                                    }
                                    case "ModifyClass": {
                                        wBEMOperation = WBEMOperation.MODIFYCLASS;
                                        cIMXMLResponseStreamWriter.modifyClass((CIMClass)hashtable.get("CLASS"));
                                        break;
                                    }
                                    case "ModifyInstance": {
                                        wBEMOperation = WBEMOperation.MODIFYINSTANCE;
                                        cIMXMLResponseStreamWriter.modifyInstance((CIMInstance)hashtable.get("ModifiedInstance"), null == hashtable.get("PropertyList") ? null : (String[])hashtable.get("PropertyList"));
                                        break;
                                    }
                                    case "OpenQueryInstances": {
                                        wBEMOperation = WBEMOperation.OPENQUERYINSTANCES;
                                        cIMXMLResponseStreamWriter.execQueryInstances(cIMObjectPath, this.getStringValueFromTable(hashtable, "FilterQuery"), this.getStringValueFromTable(hashtable, "FilterQueryLanguage"), this.getBooleanValueFromTable(hashtable, "ReturnQueryResultClass", false), this.getUint32FromTable(hashtable, "OperationTimeout", null), this.getBooleanValueFromTable(hashtable, "ContinueOnError", false), this.getUint32FromTable(hashtable, "MaxObjectCount", null), null);
                                        break;
                                    }
                                    case "OpenAssociatorInstancePaths": {
                                        wBEMOperation = WBEMOperation.OPENASSOCIATORS;
                                        cIMXMLResponseStreamWriter.associatorNames(cIMObjectPath, this.getStringValueFromTable(hashtable, "AssocClass"), this.getStringValueFromTable(hashtable, "ResultClass"), this.getStringValueFromTable(hashtable, "Role"), this.getStringValueFromTable(hashtable, "ResultRole"), this.getStringValueFromTable(hashtable, "FilterQueryLanguage"), this.getStringValueFromTable(hashtable, "FilterQuery"), this.getUint32FromTable(hashtable, "OperationTimeout", null), this.getBooleanValueFromTable(hashtable, "ContinueOnError", false), this.getUint32FromTable(hashtable, "MaxObjectCount", null));
                                        break;
                                    }
                                    case "OpenAssociatorInstances": {
                                        wBEMOperation = WBEMOperation.OPENASSOCIATORS;
                                        cIMXMLResponseStreamWriter.associators(cIMObjectPath, this.getStringValueFromTable(hashtable, "AssocClass"), this.getStringValueFromTable(hashtable, "ResultClass"), this.getStringValueFromTable(hashtable, "Role"), this.getStringValueFromTable(hashtable, "ResultRole"), null == hashtable.get("PropertyList") ? null : (String[])hashtable.get("PropertyList"), this.getStringValueFromTable(hashtable, "FilterQueryLanguage"), this.getStringValueFromTable(hashtable, "FilterQuery"), this.getUint32FromTable(hashtable, "OperationTimeout", null), this.getBooleanValueFromTable(hashtable, "ContinueOnError", false), this.getUint32FromTable(hashtable, "MaxObjectCount", null));
                                        break;
                                    }
                                    case "OpenEnumerateInstancePaths": {
                                        wBEMOperation = WBEMOperation.OPENENUMERATEINSTANCES;
                                        cIMXMLResponseStreamWriter.enumerateInstanceNames(cIMObjectPath, this.getStringValueFromTable(hashtable, "FilterQueryLanguage"), this.getStringValueFromTable(hashtable, "FilterQuery"), this.getUint32FromTable(hashtable, "OperationTimeout", null), this.getBooleanValueFromTable(hashtable, "ContinueOnError", false), this.getUint32FromTable(hashtable, "MaxObjectCount", null));
                                        break;
                                    }
                                    case "OpenEnumerateInstances": {
                                        wBEMOperation = WBEMOperation.OPENENUMERATEINSTANCES;
                                        cIMXMLResponseStreamWriter.enumerateInstances(cIMObjectPath, null == hashtable.get("PropertyList") ? null : (String[])hashtable.get("PropertyList"), this.getStringValueFromTable(hashtable, "FilterQueryLanguage"), this.getStringValueFromTable(hashtable, "FilterQuery"), this.getUint32FromTable(hashtable, "OperationTimeout", null), this.getBooleanValueFromTable(hashtable, "ContinueOnError", false), this.getUint32FromTable(hashtable, "MaxObjectCount", null));
                                        break;
                                    }
                                    case "OpenReferenceInstancePaths": {
                                        wBEMOperation = WBEMOperation.OPENREFERENCES;
                                        cIMXMLResponseStreamWriter.referenceNames(cIMObjectPath, this.getStringValueFromTable(hashtable, "ResultClass"), this.getStringValueFromTable(hashtable, "Role"), this.getStringValueFromTable(hashtable, "FilterQueryLanguage"), this.getStringValueFromTable(hashtable, "FilterQuery"), this.getUint32FromTable(hashtable, "OperationTimeout", null), this.getBooleanValueFromTable(hashtable, "ContinueOnError", false), this.getUint32FromTable(hashtable, "MaxObjectCount", null));
                                        break;
                                    }
                                    case "OpenReferenceInstances": {
                                        wBEMOperation = WBEMOperation.OPENREFERENCES;
                                        cIMXMLResponseStreamWriter.references(cIMObjectPath, this.getStringValueFromTable(hashtable, "ResultClass"), this.getStringValueFromTable(hashtable, "Role"), null == hashtable.get("PropertyList") ? null : (String[])hashtable.get("PropertyList"), this.getStringValueFromTable(hashtable, "FilterQueryLanguage"), this.getStringValueFromTable(hashtable, "FilterQuery"), this.getUint32FromTable(hashtable, "OperationTimeout", null), this.getBooleanValueFromTable(hashtable, "ContinueOnError", false), this.getUint32FromTable(hashtable, "MaxObjectCount", null));
                                        break;
                                    }
                                    case "PullInstancePaths": {
                                        wBEMOperation = WBEMOperation.PULLINSTANCES;
                                        cIMXMLResponseStreamWriter.getInstancePaths(cIMObjectPath, this.getStringValueFromTable(hashtable, "EnumerationContext"), this.getUint32FromTable(hashtable, "MaxObjectCount", null));
                                        break;
                                    }
                                    case "PullInstances": {
                                        wBEMOperation = WBEMOperation.PULLINSTANCES;
                                        cIMXMLResponseStreamWriter.getInstances(cIMObjectPath, this.getStringValueFromTable(hashtable, "EnumerationContext"), this.getUint32FromTable(hashtable, "MaxObjectCount", null));
                                        break;
                                    }
                                    case "PullInstancesWithPath": {
                                        wBEMOperation = WBEMOperation.PULLINSTANCESWITHPATH;
                                        cIMXMLResponseStreamWriter.getInstancesWithPath(cIMObjectPath, this.getStringValueFromTable(hashtable, "EnumerationContext"), this.getUint32FromTable(hashtable, "MaxObjectCount", null));
                                        break;
                                    }
                                    case "ReferenceNames": {
                                        wBEMOperation = WBEMOperation.REFERENCES;
                                        if (0 == cIMObjectPath.getKeys().length) {
                                            cIMXMLResponseStreamWriter.referenceClassNames(cIMObjectPath, this.getStringValueFromTable(hashtable, "ResultClass"), this.getStringValueFromTable(hashtable, "Role"));
                                            break;
                                        }
                                        cIMXMLResponseStreamWriter.referenceInstanceNames(cIMObjectPath, this.getStringValueFromTable(hashtable, "ResultClass"), this.getStringValueFromTable(hashtable, "Role"));
                                        break;
                                    }
                                    case "References": {
                                        wBEMOperation = WBEMOperation.REFERENCES;
                                        if (0 == cIMObjectPath.getKeys().length) {
                                            cIMXMLResponseStreamWriter.referenceClasses(cIMObjectPath, this.getStringValueFromTable(hashtable, "ResultClass"), this.getStringValueFromTable(hashtable, "Role"), this.getBooleanValueFromTable(hashtable, "IncludeQualifiers", true));
                                            break;
                                        }
                                        cIMXMLResponseStreamWriter.referenceInstances(cIMObjectPath, this.getStringValueFromTable(hashtable, "ResultClass"), this.getStringValueFromTable(hashtable, "Role"), null == hashtable.get("PropertyList") ? null : (String[])hashtable.get("PropertyList"));
                                        break;
                                    }
                                    case "SetQualifier": {
                                        wBEMOperation = WBEMOperation.CREATEQUALIFIERTYPE;
                                        cIMXMLResponseStreamWriter.setQualifierType((CIMQualifierType)hashtable.get("QualifierDeclaration"));
                                        break;
                                    }
                                    default: {
                                        cIMXMLResponseStreamWriter.writeException(wBEMOperation == null ? WBEMOperation.ENUMERATEINSTANCES : wBEMOperation, string, cIMObjectPath, WBEMOperationErrors.getOperationNotSupportedByWBEMServerException((CIMObjectPath)cIMObjectPath, (String)string, (String)cIMObjectPath.getObjectName()));
                                        break;
                                    }
                                }
                            } else {
                                cIMXMLResponseStreamWriter.writeException(wBEMOperation == null ? WBEMOperation.ENUMERATEINSTANCES : wBEMOperation, string, cIMObjectPath, WBEMOperationErrors.getOperationNotSupportedByWBEMServerException((CIMObjectPath)cIMObjectPath, (String)string, (String)cIMObjectPath.getObjectName()));
                            }
                            cIMXMLResponseStreamWriter.close();
                            break;
                        }
                        if (!"METHODCALL".equals(((QName)object).getLocalPart())) break;
                        CIMXMLResponseStreamWriter cIMXMLResponseStreamWriter = new CIMXMLResponseStreamWriter(this.mMessageID, this.mServer, httpConnection, wBEMServerAuthentication);
                        cIMXMLResponseStreamWriter.invokeMethod(cIMObjectPath, string, arrayList.toArray(new CIMArgument[arrayList.size()]), null);
                        cIMXMLResponseStreamWriter.close();
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
                n = xMLStreamReader.next();
            }
            xMLStreamReader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)cIMObjectPath, (Throwable)xMLStreamException, (WBEMOperation)(wBEMOperation == null ? WBEMOperation.ENUMERATEINSTANCES : wBEMOperation), (String)cIMObjectPath.getObjectName());
        }
    }

    private boolean getBooleanValueFromTable(Hashtable<String, Object> hashtable, String string, boolean bl) {
        if (null != hashtable.get(string)) {
            return (Boolean)hashtable.get(string);
        }
        return bl;
    }

    private String getStringValueFromTable(Hashtable<String, Object> hashtable, String string) {
        return this.getStringValueFromTable(hashtable, string, null);
    }

    private String getStringValueFromTable(Hashtable<String, Object> hashtable, String string, String string2) {
        if (null != hashtable.get(string)) {
            return (String)hashtable.get(string);
        }
        return string2;
    }

    private UnsignedInteger32 getUint32FromTable(Hashtable<String, Object> hashtable, String string, UnsignedInteger32 unsignedInteger32) {
        if (null != hashtable.get(string)) {
            return (UnsignedInteger32)hashtable.get(string);
        }
        return unsignedInteger32;
    }
}

