/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.server.adapters.coma.common;

import com.ws.utilities.CipherUtilities;
import com.ws.wbem.client.adapter.common.HTTPServer;
import com.ws.wbem.client.adapter.common.TLSInfo;
import com.ws.wbem.jserver.ClientProtocolAdapter;
import com.ws.wbem.jserver.WBEMServer;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wbem.WBEMException;

public abstract class ProtocolServiceHTTP
implements ClientProtocolAdapter {
    protected static Logger mLogger = Logger.getLogger("com.ws.wbem.jserver");
    private final Map<String, HTTPServer> mServerMap;
    protected WBEMServer mServer;
    protected final String mProtocolName;

    public ProtocolServiceHTTP(String string) throws Exception {
        this.mProtocolName = string;
        mLogger = Logger.getLogger("com.ws.wbem.jserver");
        this.mServerMap = new ConcurrentHashMap<String, HTTPServer>();
    }

    public void initialize(WBEMServer wBEMServer) {
        this.mServer = wBEMServer;
    }

    public abstract void setRequestHandler(HTTPServer var1);

    public void createListeningPort(int n, String string, TLSInfo tLSInfo) throws WBEMException {
        Object[] objectArray = new Object[]{this.getProtocolName(), n};
        MessageFormat messageFormat = new MessageFormat("createListeningPort called for {0} {1}");
        String string2 = messageFormat.format(objectArray);
        mLogger.info(string2);
        String string3 = String.valueOf(n);
        HTTPServer hTTPServer = this.mServerMap.get(string3);
        if (null != hTTPServer) {
            String string4 = "Cannot start " + n + "TCPProtocolEndpoint because a TCPProtocolEndpoint " + "with those values is already started";
            throw new WBEMException(1, string4);
        }
        String string5 = null == tLSInfo ? "http" : "https";
        try {
            hTTPServer = this.startServer(n, string, tLSInfo);
            if (null != hTTPServer) {
                Object[] objectArray2 = new Object[]{this.mProtocolName, string5, string3};
                mLogger.log(Level.INFO, "{0} Protocol Endpoint now listening on {1} port {2}", objectArray2);
                this.mServerMap.put(string3, hTTPServer);
            }
        }
        catch (Throwable throwable) {
            Object[] objectArray3 = new Object[]{this.mProtocolName, string5, string3, throwable.getMessage()};
            MessageFormat messageFormat2 = new MessageFormat("Caught exception when starting {0} Protocol Endpoint on {1} port {2}:\n{3}");
            String string6 = messageFormat2.format(objectArray3);
            mLogger.log(Level.SEVERE, string6);
            throw new WBEMException(1, string6);
        }
    }

    private HTTPServer startServer(int n, String string, TLSInfo tLSInfo) throws Exception {
        String string2;
        if (null != tLSInfo && null != (string2 = CipherUtilities.validateCiphers((String[])tLSInfo.getCiphers()))) {
            mLogger.severe("Could not start " + this.mProtocolName + " protocol service " + "because the SettingData instances contains the " + "following invalid ciphers:" + string2);
            return null;
        }
        HTTPServer hTTPServer = new HTTPServer(tLSInfo);
        this.setRequestHandler(hTTPServer);
        hTTPServer.start(string, n);
        return hTTPServer;
    }

    public void deleteListeningPort(int n) {
        HTTPServer hTTPServer = this.mServerMap.remove(String.valueOf(n));
        if (null != hTTPServer) {
            hTTPServer.stop();
        }
    }
}

