/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver;

import com.ws.wbem.jserver.ClientProtocolAdapter;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wbem.WBEMException;

public final class ProtocolServiceFactory {
    private static final String FILE_NAME = "com.ws.wbem.jserver.ProtocolServiceFactory";
    private static final Logger mLogger = Logger.getLogger("com.ws.wbem.jserver");
    private static final Map<String, ClientProtocolAdapter> mProtocolAdapter = new HashMap<String, ClientProtocolAdapter>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientProtocolAdapter getProtocolAdapter(String protocolName) throws WBEMException {
        ClientProtocolAdapter adapter = mProtocolAdapter.get(protocolName);
        if (null == adapter) {
            try {
                Map<String, ClientProtocolAdapter> map = mProtocolAdapter;
                synchronized (map) {
                    PropertyResourceBundle props;
                    String clazz;
                    adapter = mProtocolAdapter.get(protocolName);
                    if (null == adapter && null != (clazz = (props = (PropertyResourceBundle)ResourceBundle.getBundle(FILE_NAME)).getString(protocolName))) {
                        Class<?> cl = null;
                        try {
                            cl = Class.forName(clazz);
                        }
                        catch (Exception ex) {
                            mLogger.log(Level.SEVERE, "Class.forName failed!", ex);
                            throw new WBEMException(1, "Unable to load protocol service", null, (Throwable)ex);
                        }
                        Class[] paramTypes = new Class[]{};
                        Object[] paramList = new Object[]{};
                        Constructor<?> ctr = cl.getConstructor(paramTypes);
                        adapter = (ClientProtocolAdapter)ctr.newInstance(paramList);
                        mProtocolAdapter.put(protocolName, adapter);
                    }
                }
            }
            catch (Exception e) {
                mLogger.log(Level.SEVERE, "ProtocolService.getAdapter failed!", e);
                throw new WBEMException(1);
            }
        }
        return adapter;
    }

    public static Enumeration<String> getProtocolList() {
        PropertyResourceBundle props = (PropertyResourceBundle)ResourceBundle.getBundle(FILE_NAME);
        return props.getKeys();
    }
}

