/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver.profiles.snia.server;

import com.ws.utilities.ShutdownThread;
import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.JServerSettings;
import com.ws.wbem.jserver.profiles.common.BaseInstanceProvider;
import com.ws.wbem.jserver.profiles.common.CommonProviderUtils;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTime;
import javax.cim.CIMDateTimeAbsolute;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger32;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;
import javax.wbem.provider.ProviderHandle;

public class ObjectManagerProvider
extends BaseInstanceProvider {
    private static final String TRACE_METHOD_STOPSERVICE = "ObjectManager.StopService called";
    private static final String UNKNOWN = "unknown";
    private CIMDateTime mCPVInstallDate = null;

    @Override
    public void close() throws WBEMException {
        mLogger.info(this.mClassName + "_ObjectManagerAdapter.close() called");
    }

    public synchronized CloseableIterator<CIMInstance> enumerateInstances(CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError) throws WBEMException {
        CloseableIterator ciArray = mInternalProvider.enumerateInstances(op, null, filterQueryLanguage, filterQuery, continueOnError);
        ArrayList<CIMInstance> l = new ArrayList<CIMInstance>();
        while (ciArray.hasNext()) {
            CIMInstance ci = this.verifyInstance((CIMInstance)ciArray.next());
            ci = ci.filterProperties(propertyList);
            l.add(ci);
        }
        return new CloseableAddableIterator(l.iterator());
    }

    public synchronized CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        ArrayList<CIMProperty> keyList = new ArrayList<CIMProperty>();
        for (int i = 0; i < op.getKeys().length; ++i) {
            CIMProperty cp = op.getKeys()[i];
            if (cp.getName().equalsIgnoreCase("SystemName")) {
                keyList.add(new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)UNKNOWN, true));
                continue;
            }
            if (cp.getName().equalsIgnoreCase("Name")) {
                keyList.add(new CIMProperty("Name", CIMDataType.STRING_T, (Object)UNKNOWN, true));
                continue;
            }
            keyList.add(cp);
        }
        CIMObjectPath uOP = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), op.getObjectName(), keyList.toArray(new CIMProperty[keyList.size()]));
        CIMInstance fullInst = mInternalProvider.getInstance(uOP, null);
        fullInst = this.verifyInstance(fullInst);
        fullInst = new CIMInstance(this.verifyObjectPath(fullInst.getObjectPath()), fullInst.getProperties());
        return fullInst.filterProperties(propertyList);
    }

    @Override
    public void initialize(ProviderHandle ch) throws WBEMException {
        super.initialize(ch);
        this.mClassName = JServerSettings.replaceSchemaClassName("WS_ObjectManager");
        String installDate = JServerProperties.getInstallDate();
        if (null != installDate && installDate.length() > 0) {
            try {
                this.mCPVInstallDate = new CIMDateTimeAbsolute(installDate);
            }
            catch (IllegalArgumentException e) {
                Object[] objs = new Object[]{installDate};
                mLogger.log(Level.WARNING, "InstallDate value, {0}, in jserver.properties file is an invalid CIMDateTime value.  This value will be ignored", objs);
            }
        }
    }

    @Override
    public synchronized Object invokeMethod(CIMObjectPath op, String methodName, CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs) throws WBEMException {
        if (methodName.equalsIgnoreCase("StartService")) {
            return this.startService(op, inArgs, outArgs);
        }
        if (methodName.equalsIgnoreCase("StopService")) {
            return this.stopService(op, inArgs, outArgs);
        }
        throw WBEMOperationErrors.getMethodNotSupportedException((CIMObjectPath)op, (String)methodName, (WBEMOperation)WBEMOperation.INVOKEMETHOD);
    }

    private Object startService(CIMObjectPath op, CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs) throws WBEMException {
        throw WBEMOperationErrors.getMethodNotSupportedException((CIMObjectPath)op, (String)"StartService", (WBEMOperation)WBEMOperation.INVOKEMETHOD);
    }

    private Object stopService(CIMObjectPath op, CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs) throws WBEMException {
        mLogger.info(TRACE_METHOD_STOPSERVICE);
        new ShutdownThread().start();
        return new UnsignedInteger32(0L);
    }

    private CIMInstance verifyInstance(CIMInstance ci) throws WBEMException {
        ArrayList<CIMProperty> propList = new ArrayList<CIMProperty>();
        propList.add(new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)this.getHostName(), false));
        propList.add(new CIMProperty("Name", CIMDataType.STRING_T, (Object)CommonProviderUtils.getWBEMServerName(), true));
        if (null != this.mCPVInstallDate) {
            propList.add(new CIMProperty("InstallDate", CIMDataType.DATETIME_T, (Object)this.mCPVInstallDate, false));
        }
        CIMInstance i = this.deriveInstance(ci, propList.toArray(new CIMProperty[propList.size()]));
        i = i.deriveInstance(this.verifyObjectPath(ci.getObjectPath()));
        i = this.checkInstallDate(i);
        return i;
    }

    private CIMObjectPath verifyObjectPath(CIMObjectPath op) {
        CIMProperty[] keys;
        ArrayList<CIMProperty> keyList = new ArrayList<CIMProperty>();
        for (CIMProperty key : keys = op.getKeys()) {
            if (key.getName().equalsIgnoreCase("SystemName")) {
                keyList.add(new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)this.getHostName(), true));
                continue;
            }
            if (key.getName().equalsIgnoreCase("Name")) {
                keyList.add(new CIMProperty("Name", CIMDataType.STRING_T, (Object)CommonProviderUtils.getWBEMServerName(), true));
                continue;
            }
            keyList.add(key);
        }
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), op.getObjectName(), keyList.toArray(new CIMProperty[keyList.size()]));
    }
}

