/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver.soma;

import com.ws.cim.CIMOctetString;
import com.ws.wbem.jserver.AuthService;
import com.ws.wbem.jserver.AuthServiceType;
import com.ws.wbem.jserver.CIMRepository;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.JServerSettings;
import com.ws.wbem.jserver.soma.JServerRoleSupport;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.security.auth.Subject;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperationErrors;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;
import javax.wbem.provider.ProviderHandle;
import org.wbemservices.wbem.repository.PSRlogImpl;

public final class JServerAuthService
implements AuthService {
    private static final String SERVICENAME = "J Server Secruity Service";
    private static Logger mLogger = Logger.getLogger("com.ws.wbem.jserver");
    private ProviderHandle mProviderHandle;
    private final CIMRepository mRepository = PSRlogImpl.getRepository();

    @Override
    public String authenticate(Subject subject, String clientIP) throws WBEMException {
        Set<PasswordCredential> pcSet;
        String user = null;
        String password = null;
        Set<UserPrincipal> upSet = subject.getPrincipals(UserPrincipal.class);
        if (!upSet.isEmpty()) {
            UserPrincipal up = upSet.iterator().next();
            user = up.getName();
        }
        if (!(pcSet = subject.getPrivateCredentials(PasswordCredential.class)).isEmpty()) {
            PasswordCredential pc = pcSet.iterator().next();
            password = new String(pc.getUserPassword());
        }
        CIMProperty[] keyProps = new CIMProperty[]{new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)"unknown", true), new CIMProperty("Name", CIMDataType.STRING_T, (Object)(JServerProperties.getSchemaName() + ":" + user), true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)JServerSettings.replaceSchemaClassName("WS_WBEMServerSystem"), true), new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)JServerSettings.replaceSchemaClassName("CIM_Account"), true)};
        CIMObjectPath opAccount = new CIMObjectPath(null, null, null, JServerProperties.getInteropNamespace(), JServerSettings.replaceSchemaClassName("CIM_Account"), keyProps);
        CIMInstance instAccount = null;
        try {
            instAccount = this.mRepository.getInstance(opAccount, null);
        }
        catch (Exception e) {
            mLogger.log(Level.INFO, "J Server Secruity Service: Could not find Account instance for user - rejecting.", e);
            throw WBEMOperationErrors.getAccessDeniedException();
        }
        String accountPassword = null;
        try {
            accountPassword = CIMOctetString.getString((String[])((String[])instAccount.getPropertyValue("UserPassword")));
        }
        catch (Throwable e) {
            mLogger.log(Level.INFO, "J Server Secruity Service: Error trying to get user password from account instance.", e);
            throw WBEMOperationErrors.getAccessDeniedException();
        }
        if (!accountPassword.equals(password)) {
            throw WBEMOperationErrors.getAccessDeniedException();
        }
        mLogger.info("J Server Secruity Service: user authenticated!");
        UUID uuid = UUID.randomUUID();
        return uuid.toString();
    }

    @Override
    public void authorizeRequest(Subject subject, String operationName, String sessionID, CIMObjectPath target) throws WBEMException {
        String user = null;
        Set<UserPrincipal> upSet = subject.getPrincipals(UserPrincipal.class);
        if (!upSet.isEmpty()) {
            UserPrincipal up = upSet.iterator().next();
            user = up.getName();
        }
        CIMInstance ci = this.getIdentityInstance(user);
        String[] roleNames = (String[])ci.getPropertyValue("Roles");
        JServerRoleSupport rs = new JServerRoleSupport();
        for (String roleName : roleNames) {
            rs.authorizeRole(roleName, operationName);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void initialize(ProviderHandle providerClient) {
        this.mProviderHandle = providerClient;
    }

    @Override
    public void sessionCompleted(String sessionID) {
    }

    @Override
    public AuthServiceType getType() {
        return AuthServiceType.ACCOUNTS;
    }

    private CIMInstance getIdentityInstance(String user) {
        CIMProperty kp = new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)(JServerProperties.getSchemaName() + ":" + user), true);
        CIMObjectPath opIdentity = new CIMObjectPath(null, null, null, JServerProperties.getInteropNamespace(), JServerSettings.replaceSchemaClassName("CIM_Identity"), new CIMProperty[]{kp});
        try {
            return this.mProviderHandle.getInstance(opIdentity, null);
        }
        catch (Exception e) {
            mLogger.log(Level.INFO, "J Server Secruity Service: Could not find CIM_Identity instance for user - rejecting.", e);
            return null;
        }
    }
}

