/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.sanproject.rmi.server.managers;

import com.hitachi.sanproject.data.SanData;
import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanDataInternalUtility;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanInterface;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import com.hitachi.sanproject.rmi.SanRmiErrorCode;
import com.hitachi.sanproject.rmi.SanRmiException;
import com.hitachi.sanproject.rmi.server.SanRemoteObject;
import com.hitachi.sanproject.rmi.server.SanRmiServer;
import com.hitachi.sanproject.rmi.server.managers.SanAuthenticationManager;
import com.hitachi.sanproject.rmi.server.managers.SanResourcelockStatus;
import com.hitachi.sanproject.rmi.server.managers.SanUserAccount;
import com.hitachi.sanproject.util.SanLogger;
import java.util.BitSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class SanResourcelockManager {
    protected Logger logger;
    protected ConcurrentHashMap<Long, SanResourcelockStatus> resourcelockMap;
    protected SanRemoteObject robj;
    protected SanData generalParameter;
    protected SanAuthenticationManager authentificationManager;
    private static final int AUTHBIT_TASK_DELETE = 42;

    public void initialize() {
        this.logger = SanRmiServer.getLogger();
        this.resourcelockMap = new ConcurrentHashMap();
        this.robj = SanRmiServer.getRemoteObject();
        this.generalParameter = SanRmiServer.getGeneralParameter();
        this.authentificationManager = SanRmiServer.getAuthenticationManager();
    }

    public SanData getLockStatus(SanData sanData) throws SanRmiException {
        this.logger.info("start");
        SanData sanData2 = null;
        try {
            SanObject sanObject = sanData.getObj("AccountInfo");
            if (sanObject == null) {
                throw SanRmiErrorCode.newException(SanRmiErrorCode.INVALID_ACCOUNT_INFO, "AccountInfo=null");
            }
            Long l = (Long)sanObject.getMember("ResourcelockId");
            if (l == null) {
                throw SanRmiErrorCode.newException(SanRmiErrorCode.INVALID_ACCOUNT_INFO, "AccountInfo.ResourcelockId=null");
            }
            SanResourcelockStatus sanResourcelockStatus = this.resourcelockMap.get(l);
            if (sanResourcelockStatus == null) {
                throw SanRmiErrorCode.newException(SanRmiErrorCode.INVALID_RESOURCELOCK_ID, String.format("ResourcelockId=%d", l));
            }
            this.logger.info(String.format("locked : ResourcelockId=%d", l));
            sanData2 = SanRemoteObject.newGeneralParameterInstance(this.generalParameter, sanData);
            SanRemoteObject.copyStorageInfoOfGeneralParameter(sanData2, sanData);
            sanData2 = sanResourcelockStatus.copyProperties(sanData2);
            sanData2 = SanDataInternalUtility.copyHiddenMembersOfGeneralParameter((SanData)sanData2, (SanData)sanData);
        }
        catch (SanDataException sanDataException) {
            this.logger.severe(SanLogger.getStackTrace((Throwable)sanDataException));
            throw SanRmiErrorCode.newException(SanRmiErrorCode.INTERNAL_ERROR);
        }
        this.logger.info("end");
        return sanData2;
    }

    protected SanUserAccount authenticateStorageUser(SanData sanData, String string, String string2, int n, Long l, SanResponse sanResponse) throws SanDataException, SanRmiException {
        SanUserAccount sanUserAccount = null;
        if (l == null) {
            try {
                sanUserAccount = this.authentificationManager.authenticateStorageUser(sanData, string, string2, n, null);
            }
            catch (SanRmiException sanRmiException) {
                if (sanResponse != null) {
                    SanObject sanObject = sanResponse.newObj("ErrorInfo");
                    if (sanRmiException.getCode() == 4000) {
                        sanObject.putInt("ErrorCode", 4000);
                        sanObject.putIntArray("MessageId", new int[]{2, 8000});
                    } else {
                        sanObject.putInt("ErrorCode", 3000);
                        sanObject.putIntArray("MessageId", new int[]{1, 5014});
                    }
                    return null;
                }
                throw sanRmiException;
            }
        } else {
            SanResourcelockStatus sanResourcelockStatus = this.resourcelockMap.get(l);
            if (sanResourcelockStatus == null) {
                this.logger.warning(String.format("Aucentication NG : resourcelockId=%d", l));
                if (sanResponse != null) {
                    SanObject sanObject = sanResponse.newObj("ErrorInfo");
                    sanObject.putInt("ErrorCode", 3000);
                    sanObject.putIntArray("MessageId", new int[]{2, 8005});
                }
                return null;
            }
            sanUserAccount = sanResourcelockStatus.getUserAccount();
        }
        return sanUserAccount;
    }

    public SanResourcelockStatus lockSystem(SanData sanData, SanRequest sanRequest, SanResponse sanResponse) throws SanDataException, SanRmiException {
        SanResourcelockStatus sanResourcelockStatus = null;
        String string = sanRequest.getString("UserName");
        String string2 = sanRequest.getString("Password");
        Long l = (Long)sanRequest.getMember("ResourcelockId");
        int n = sanRequest.getInt("SsoOption");
        SanUserAccount sanUserAccount = this.authenticateStorageUser(sanData, string, string2, n, l, sanResponse);
        if (sanUserAccount == null) {
            return null;
        }
        SanInterface sanInterface = this.robj.getInterface("NativeSANlockSystem");
        SanRequest sanRequest2 = sanInterface.getRequest().clone();
        sanRequest2.putString("UserName", string);
        sanRequest2.putString("Password", string2);
        sanRequest2.putInt("SsoOption", n);
        sanRequest2.putMember("ResourcelockId", (Object)l);
        SanData sanData2 = SanRemoteObject.newGeneralParameterInstance(this.generalParameter, sanData);
        SanRemoteObject.copyStorageInfoOfGeneralParameter(sanData2, sanData);
        sanData2 = sanUserAccount.copyProperties(sanData2);
        sanData2 = SanDataInternalUtility.copyHiddenMembersOfGeneralParameter((SanData)sanData2, (SanData)sanData);
        SanResponse sanResponse2 = this.robj.privateinvoke(sanInterface, sanData2, sanRequest2);
        if (sanResponse2.errorCode() == 0) {
            l = (Long)sanResponse2.getMember("ResourcelockId");
            this.logger.info(String.format("lockSystem OK : resourcelockId=%d", l));
            sanResourcelockStatus = new SanResourcelockStatus(l, sanUserAccount, true, null);
            this.resourcelockMap.put(l, sanResourcelockStatus);
            if (sanResponse != null) {
                SanObject sanObject = sanResponse.newObj("ErrorInfo");
                sanObject.putInt("ErrorCode", 0);
                sanObject.putIntArray("MessageId", new int[]{0, 0});
                sanResponse.putMember("ResourcelockId", (Object)l);
            }
            this.logger.info(String.format("resourcelockMap.size=%d", this.resourcelockMap.size()));
            return sanResourcelockStatus;
        }
        this.logger.warning(String.format("lockSystem NG : resourcelockId=%d, errorCode=%d", l, sanResponse2.errorCode()));
        if (sanResponse != null) {
            SanObject sanObject = sanResponse.newObj("ErrorInfo");
            SanObject sanObject2 = sanResponse2.getObj("ErrorInfo");
            sanObject.putMember("ErrorCode", sanObject2.getMember("ErrorCode"));
            sanObject.putMember("MessageId", sanObject2.getMember("MessageId"));
        }
        return null;
    }

    public SanResourcelockStatus unlockSystem(SanData sanData, SanRequest sanRequest, SanResponse sanResponse) throws SanDataException, SanRmiException {
        SanResourcelockStatus sanResourcelockStatus = null;
        Long l = (Long)sanRequest.getMember("ResourcelockId");
        SanUserAccount sanUserAccount = this.authenticateStorageUser(sanData, null, null, 0, l, sanResponse);
        if (sanUserAccount == null) {
            return null;
        }
        SanInterface sanInterface = this.robj.getInterface("NativeSANunlockSystem");
        SanRequest sanRequest2 = sanInterface.getRequest().clone();
        sanRequest2.putMember("ResourcelockId", (Object)l);
        SanData sanData2 = SanRemoteObject.newGeneralParameterInstance(this.generalParameter, sanData);
        SanRemoteObject.copyStorageInfoOfGeneralParameter(sanData2, sanData);
        sanData2 = sanUserAccount.copyProperties(sanData2);
        sanData2 = SanDataInternalUtility.copyHiddenMembersOfGeneralParameter((SanData)sanData2, (SanData)sanData);
        SanResponse sanResponse2 = this.robj.privateinvoke(sanInterface, sanData2, sanRequest2);
        if (sanResponse2.errorCode() == 0) {
            this.logger.info(String.format("unlockSystem OK : resourcelockId=%d", l));
            if (!sanResponse2.getBoolean("LockStatus")) {
                this.resourcelockMap.remove(l);
            }
            if (sanResponse != null) {
                SanObject sanObject = sanResponse.newObj("ErrorInfo");
                sanObject.putInt("ErrorCode", 0);
                sanObject.putIntArray("MessageId", new int[]{0, 0});
                sanResponse.putMember("LockStatus", sanResponse2.getMember("LockStatus"));
            }
            this.logger.info(String.format("resourcelockMap.size=%d", this.resourcelockMap.size()));
            return sanResourcelockStatus;
        }
        this.logger.warning(String.format("unlockSystem NG : resourcelockId=%d, errorCode=%d", l, sanResponse2.errorCode()));
        if (sanResponse != null) {
            SanObject sanObject = sanResponse.newObj("ErrorInfo");
            SanObject sanObject2 = sanResponse2.getObj("ErrorInfo");
            sanObject.putMember("ErrorCode", sanObject2.getMember("ErrorCode"));
            sanObject.putMember("MessageId", sanObject2.getMember("MessageId"));
        }
        return null;
    }

    public SanResourcelockStatus unlockSystemForcibly(SanData sanData, SanRequest sanRequest, SanResponse sanResponse) throws SanDataException, SanRmiException {
        SanResourcelockStatus sanResourcelockStatus = null;
        Long l = (Long)sanRequest.getMember("ResourcelockId");
        SanUserAccount sanUserAccount = this.authenticateStorageUser(sanData, null, null, 0, l, sanResponse);
        if (sanUserAccount == null) {
            return null;
        }
        SanInterface sanInterface = this.robj.getInterface("NativeSANunlockSystemForcibly");
        SanRequest sanRequest2 = sanInterface.getRequest().clone();
        sanRequest2.putMember("ResourcelockId", (Object)l);
        SanData sanData2 = SanRemoteObject.newGeneralParameterInstance(this.generalParameter, sanData);
        SanRemoteObject.copyStorageInfoOfGeneralParameter(sanData2, sanData);
        sanData2 = sanUserAccount.copyProperties(sanData2);
        sanData2 = SanDataInternalUtility.copyHiddenMembersOfGeneralParameter((SanData)sanData2, (SanData)sanData);
        SanResponse sanResponse2 = this.robj.privateinvoke(sanInterface, sanData2, sanRequest2);
        if (sanResponse2.errorCode() == 0) {
            this.logger.info(String.format("unlockSystemForcibly OK : resourcelockId=%d", l));
            this.resourcelockMap.remove(l);
            if (sanResponse != null) {
                SanObject sanObject = sanResponse.newObj("ErrorInfo");
                sanObject.putInt("ErrorCode", 0);
                sanObject.putIntArray("MessageId", new int[]{0, 0});
            }
            this.logger.info(String.format("resourcelockMap.size=%d", this.resourcelockMap.size()));
            return sanResourcelockStatus;
        }
        this.logger.warning(String.format("unlockSystemForcibly NG : resourcelockId=%d, errorCode=%d", l, sanResponse2.errorCode()));
        if (sanResponse != null) {
            SanObject sanObject = sanResponse.newObj("ErrorInfo");
            SanObject sanObject2 = sanResponse2.getObj("ErrorInfo");
            sanObject.putMember("ErrorCode", sanObject2.getMember("ErrorCode"));
            sanObject.putMember("MessageId", sanObject2.getMember("MessageId"));
        }
        return null;
    }

    public SanResourcelockStatus lockResource(SanData sanData, SanRequest sanRequest, SanResponse sanResponse) throws SanDataException, SanRmiException {
        SanResourcelockStatus sanResourcelockStatus = null;
        String string = sanRequest.getString("UserName");
        String string2 = sanRequest.getString("Password");
        Long l = (Long)sanRequest.getMember("ResourcelockId");
        int n = sanRequest.getInt("SsoOption");
        SanUserAccount sanUserAccount = this.authenticateStorageUser(sanData, string, string2, n, l, sanResponse);
        if (sanUserAccount == null) {
            return null;
        }
        BitSet bitSet = (BitSet)sanRequest.getMember("ResourceGroupBitmap");
        if (bitSet == null) {
            if (sanResponse != null) {
                SanObject sanObject = sanResponse.newObj("ErrorInfo");
                sanObject.putInt("ErrorCode", 3000);
                sanObject.putIntArray("MessageId", new int[]{2, 8005});
            }
            return null;
        }
        SanInterface sanInterface = this.robj.getInterface("NativeSANlockResource");
        SanRequest sanRequest2 = sanInterface.getRequest().clone();
        sanRequest2.putString("UserName", string);
        sanRequest2.putString("Password", string2);
        sanRequest2.putInt("SsoOption", n);
        sanRequest2.putMember("ResourcelockId", (Object)l);
        sanRequest2.putBitSet("ResourceGroupBitmap", bitSet);
        SanData sanData2 = SanRemoteObject.newGeneralParameterInstance(this.generalParameter, sanData);
        SanRemoteObject.copyStorageInfoOfGeneralParameter(sanData2, sanData);
        sanData2 = sanUserAccount.copyProperties(sanData2);
        sanData2 = SanDataInternalUtility.copyHiddenMembersOfGeneralParameter((SanData)sanData2, (SanData)sanData);
        SanResponse sanResponse2 = this.robj.privateinvoke(sanInterface, sanData2, sanRequest2);
        if (sanResponse2.errorCode() == 0) {
            l = (Long)sanResponse2.getMember("ResourcelockId");
            this.logger.info(String.format("lockResource OK : resourcelockId=%d", l));
            BitSet bitSet2 = (BitSet)sanRequest.getMember("ResourceGroupBitmap");
            sanResourcelockStatus = new SanResourcelockStatus(l, sanUserAccount, false, bitSet2);
            this.resourcelockMap.put(l, sanResourcelockStatus);
            if (sanResponse != null) {
                SanObject sanObject = sanResponse.newObj("ErrorInfo");
                sanObject.putInt("ErrorCode", 0);
                sanObject.putIntArray("MessageId", new int[]{0, 0});
                sanResponse.putMember("ResourcelockId", (Object)l);
                sanResponse.putMember("ResourceGroupBitmap", (Object)bitSet2);
            }
            this.logger.info(String.format("resourcelockMap.size=%d", this.resourcelockMap.size()));
            return sanResourcelockStatus;
        }
        this.logger.warning(String.format("lockResource NG : resourcelockId=%d, errorCode=%d", l, sanResponse2.errorCode()));
        if (sanResponse != null) {
            SanObject sanObject = sanResponse.newObj("ErrorInfo");
            SanObject sanObject2 = sanResponse2.getObj("ErrorInfo");
            sanObject.putMember("ErrorCode", sanObject2.getMember("ErrorCode"));
            sanObject.putMember("MessageId", sanObject2.getMember("MessageId"));
        }
        return null;
    }

    public SanResourcelockStatus unlockResource(SanData sanData, SanRequest sanRequest, SanResponse sanResponse) throws SanDataException, SanRmiException {
        SanResourcelockStatus sanResourcelockStatus = null;
        Long l = (Long)sanRequest.getMember("ResourcelockId");
        SanUserAccount sanUserAccount = this.authenticateStorageUser(sanData, null, null, 0, l, sanResponse);
        if (sanUserAccount == null) {
            return null;
        }
        BitSet bitSet = (BitSet)sanRequest.getMember("ResourceGroupBitmap");
        if (bitSet == null) {
            if (sanResponse != null) {
                SanObject sanObject = sanResponse.newObj("ErrorInfo");
                sanObject.putInt("ErrorCode", 3000);
                sanObject.putIntArray("MessageId", new int[]{2, 8005});
            }
            return null;
        }
        SanInterface sanInterface = this.robj.getInterface("NativeSANunlockResource");
        SanRequest sanRequest2 = sanInterface.getRequest().clone();
        sanRequest2.putMember("ResourcelockId", (Object)l);
        sanRequest2.putBitSet("ResourceGroupBitmap", bitSet);
        SanData sanData2 = SanRemoteObject.newGeneralParameterInstance(this.generalParameter, sanData);
        SanRemoteObject.copyStorageInfoOfGeneralParameter(sanData2, sanData);
        sanData2 = sanUserAccount.copyProperties(sanData2);
        sanData2 = SanDataInternalUtility.copyHiddenMembersOfGeneralParameter((SanData)sanData2, (SanData)sanData);
        SanResponse sanResponse2 = this.robj.privateinvoke(sanInterface, sanData2, sanRequest2);
        if (sanResponse2.errorCode() == 0) {
            this.logger.info(String.format("unlockResource OK : resourcelockId=%d", l));
            BitSet bitSet2 = sanResponse2.getBitSet("ResourceGroupBitmap");
            if (bitSet2.nextSetBit(0) < 0) {
                this.resourcelockMap.remove(l);
            }
            if (sanResponse != null) {
                SanObject sanObject = sanResponse.newObj("ErrorInfo");
                sanObject.putInt("ErrorCode", 0);
                sanObject.putIntArray("MessageId", new int[]{0, 0});
                sanResponse.putMember("ResourceGroupBitmap", (Object)bitSet2);
            }
            this.logger.info(String.format("resourcelockMap.size=%d", this.resourcelockMap.size()));
            return sanResourcelockStatus;
        }
        this.logger.warning(String.format("unlockResource NG : resourcelockId=%d, errorCode=%d", l, sanResponse2.errorCode()));
        if (sanResponse != null) {
            SanObject sanObject = sanResponse.newObj("ErrorInfo");
            SanObject sanObject2 = sanResponse2.getObj("ErrorInfo");
            sanObject.putMember("ErrorCode", sanObject2.getMember("ErrorCode"));
            sanObject.putMember("MessageId", sanObject2.getMember("MessageId"));
        }
        return null;
    }

    public SanResourcelockStatus unlockResourceForcibly(SanData sanData, SanRequest sanRequest, SanResponse sanResponse) throws SanDataException, SanRmiException {
        SanResourcelockStatus sanResourcelockStatus = null;
        Long l = (Long)sanRequest.getMember("ResourcelockId");
        SanUserAccount sanUserAccount = this.authenticateStorageUser(sanData, null, null, 0, l, sanResponse);
        if (sanUserAccount == null) {
            return null;
        }
        BitSet bitSet = (BitSet)sanRequest.getMember("ResourceGroupBitmap");
        if (bitSet == null) {
            if (sanResponse != null) {
                SanObject sanObject = sanResponse.newObj("ErrorInfo");
                sanObject.putInt("ErrorCode", 3000);
                sanObject.putIntArray("MessageId", new int[]{2, 8005});
            }
            return null;
        }
        SanInterface sanInterface = this.robj.getInterface("NativeSANunlockResourceForcibly");
        SanRequest sanRequest2 = sanInterface.getRequest().clone();
        sanRequest2.putMember("ResourcelockId", (Object)l);
        sanRequest2.putBitSet("ResourceGroupBitmap", bitSet);
        SanData sanData2 = SanRemoteObject.newGeneralParameterInstance(this.generalParameter, sanData);
        SanRemoteObject.copyStorageInfoOfGeneralParameter(sanData2, sanData);
        sanData2 = sanUserAccount.copyProperties(sanData2);
        sanData2 = SanDataInternalUtility.copyHiddenMembersOfGeneralParameter((SanData)sanData2, (SanData)sanData);
        SanResponse sanResponse2 = this.robj.privateinvoke(sanInterface, sanData2, sanRequest2);
        if (sanResponse2.errorCode() == 0) {
            this.logger.info(String.format("unlockResourceForcibly OK : resourcelockId=%d", l));
            BitSet bitSet2 = sanResponse2.getBitSet("ResourceGroupBitmap");
            if (bitSet2.nextSetBit(0) < 0) {
                this.resourcelockMap.remove(l);
            }
            if (sanResponse != null) {
                SanObject sanObject = sanResponse.newObj("ErrorInfo");
                sanObject.putInt("ErrorCode", 0);
                sanObject.putIntArray("MessageId", new int[]{0, 0});
                sanResponse.putMember("ResourceGroupBitmap", (Object)bitSet2);
            }
            this.logger.info(String.format("resourcelockMap.size=%d", this.resourcelockMap.size()));
            return sanResourcelockStatus;
        }
        this.logger.warning(String.format("unlockResourceForcibly NG : resourcelockId=%d, errorCode=%d", l, sanResponse2.errorCode()));
        if (sanResponse != null) {
            SanObject sanObject = sanResponse.newObj("ErrorInfo");
            SanObject sanObject2 = sanResponse2.getObj("ErrorInfo");
            sanObject.putMember("ErrorCode", sanObject2.getMember("ErrorCode"));
            sanObject.putMember("MessageId", sanObject2.getMember("MessageId"));
        }
        return null;
    }

    public SanResourcelockStatus unlockSystemAndResourceForcibly(SanData sanData, SanRequest sanRequest, SanResponse sanResponse) throws SanDataException, SanRmiException {
        int n;
        String string;
        SanResourcelockStatus sanResourcelockStatus = null;
        String string2 = (String)sanRequest.getMember("UserName");
        SanUserAccount sanUserAccount = this.authenticateStorageUser(sanData, string2, string = (String)sanRequest.getMember("Password"), n = ((Integer)sanRequest.getMember("SsoOption")).intValue(), null, sanResponse);
        if (sanUserAccount == null) {
            return null;
        }
        if (!sanUserAccount.isAllResourcegroup()) {
            this.logger.warning(String.format("unlockSystemAndResourceForcibly NG : AccountInfo.allResourceGroups=false", new Object[0]));
            if (sanResponse != null) {
                SanObject sanObject = sanResponse.newObj("ErrorInfo");
                sanObject.putInt("ErrorCode", 3000);
                sanObject.putIntArray("MessageId", new int[]{2, 8005});
            }
            return null;
        }
        if (!sanUserAccount.getAuthorityBitmap().get(42)) {
            this.logger.warning(String.format("unlockSystemAndResourceForcibly NG : AccountInfo.authorityBitmap=%s", sanUserAccount.getAuthorityBitmap().toString()));
            if (sanResponse != null) {
                SanObject sanObject = sanResponse.newObj("ErrorInfo");
                sanObject.putInt("ErrorCode", 3000);
                sanObject.putIntArray("MessageId", new int[]{2, 8005});
            }
            return null;
        }
        SanInterface sanInterface = this.robj.getInterface("NativeSANunlockSystemAndResourceForcibly");
        SanRequest sanRequest2 = sanInterface.getRequest().clone();
        sanRequest2.putMember("UserName", (Object)string2);
        sanRequest2.putMember("Password", (Object)string);
        sanRequest2.putMember("SsoOption", (Object)n);
        SanData sanData2 = SanRemoteObject.newGeneralParameterInstance(this.generalParameter, sanData);
        SanRemoteObject.copyStorageInfoOfGeneralParameter(sanData2, sanData);
        sanData2 = sanUserAccount.copyProperties(sanData2);
        sanData2 = SanDataInternalUtility.copyHiddenMembersOfGeneralParameter((SanData)sanData2, (SanData)sanData);
        SanResponse sanResponse2 = this.robj.privateinvoke(sanInterface, sanData2, sanRequest2);
        if (sanResponse2.errorCode() == 0) {
            this.logger.info(String.format("unlockSystemAndResourceForcibly OK : UserName=%s, Password=%s", string2, string));
            this.resourcelockMap.clear();
            if (sanResponse != null) {
                SanObject sanObject = sanResponse.newObj("ErrorInfo");
                sanObject.putInt("ErrorCode", 0);
                sanObject.putIntArray("MessageId", new int[]{0, 0});
            }
            this.logger.info(String.format("resourcelockMap.size=%d", this.resourcelockMap.size()));
            return sanResourcelockStatus;
        }
        this.logger.warning(String.format("unlockSystemAndResourceForcibly NG : UserName=%s, Password=%s, errorCode=%d", string2, string, sanResponse2.errorCode()));
        if (sanResponse != null) {
            SanObject sanObject = sanResponse.newObj("ErrorInfo");
            SanObject sanObject2 = sanResponse2.getObj("ErrorInfo");
            sanObject.putMember("ErrorCode", sanObject2.getMember("ErrorCode"));
            sanObject.putMember("MessageId", sanObject2.getMember("MessageId"));
        }
        return null;
    }
}

