/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.sanproject.rmi.server.managers;

import com.hitachi.sanproject.data.SanData;
import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanObject;
import java.util.BitSet;

public class SanUserAccount {
    private String username;
    private String password;
    private BitSet authorityBitmap;
    private BitSet availableResourcegroups;
    private boolean allResourcegroup;
    private long authTime;

    SanUserAccount(String string, String string2, BitSet bitSet, BitSet bitSet2, boolean bl, long l) {
        this.username = string;
        this.password = string2;
        this.authorityBitmap = (BitSet)bitSet.clone();
        this.availableResourcegroups = (BitSet)bitSet2.clone();
        this.allResourcegroup = bl;
        this.authTime = l;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public BitSet getAuthorityBitmap() {
        return (BitSet)this.authorityBitmap.clone();
    }

    public BitSet getAvailableResourcegroups() {
        return (BitSet)this.availableResourcegroups.clone();
    }

    public boolean isAllResourcegroup() {
        return this.allResourcegroup;
    }

    public long getAuthTime() {
        return this.authTime;
    }

    public SanData copyProperties(SanData sanData) throws SanDataException {
        SanObject sanObject = sanData.newObj("AccountInfo");
        sanObject.putString("UserName", this.username);
        sanObject.putString("Password", this.password);
        sanObject.putBitSet("AuthBitmap", this.authorityBitmap);
        sanObject.putBitSet("ResourceGroupBitmap", this.availableResourcegroups);
        sanObject.putBoolean("AllResourceGroup", this.allResourcegroup);
        return sanData;
    }
}

