/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.codegen.cmpi;

import com.ws.cim.codegen.cmpi.CArgument;
import com.ws.cim.codegen.cmpi.CFunction;
import com.ws.cim.codegen.cmpi.CFunctionBody;
import java.util.ArrayList;
import javax.cim.CIMClass;

class AssociationMIGenerator {
    private CIMClass mCIMClass;
    private ArrayList<CFunction> mFunctionList;

    public AssociationMIGenerator(CIMClass pCIMClass) {
        this.mCIMClass = pCIMClass;
        this.mFunctionList = new ArrayList();
        this.setFunctions();
    }

    private void setFunctions() {
        this.addAssociatorNames();
        this.addAssociators();
        this.addReferenceNames();
        this.addReferences();
        this.addCleanup();
    }

    public ArrayList<CFunction> getFunctions() {
        return this.mFunctionList;
    }

    protected CFunction createAssociationMI() {
        ArrayList<CArgument> arguments = new ArrayList<CArgument>();
        ArrayList<String> bText = new ArrayList<String>();
        arguments.add(new CArgument(false, "*pBrk", "CMPIBroker"));
        arguments.add(new CArgument(false, "*pCtx", "CMPIContext"));
        arguments.add(new CArgument(false, "*pStatus", "CMPIStatus"));
        bText.add("/* The provider factory - Association provider must have this. */");
        bText.add("static CMPIAssociationMIFT associationMIFT = {");
        bText.add("CMPIVersion100,");
        bText.add("CMPIVersion100,");
        bText.add("\"" + this.mCIMClass.getName() + "\",");
        bText.add("associationCleanup,");
        bText.add("associators,");
        bText.add("associatorNames,");
        bText.add("references,");
        bText.add("referenceNames");
        bText.add("};");
        bText.add("");
        bText.add("static CMPIAssociationMI associationMI = {NULL, &associationMIFT};");
        bText.add("CMPIStatus status = {CMPI_RC_OK, NULL}; ");
        bText.add("CMPIAssociationMI* ret = NULL;");
        bText.add("");
        bText.add("/* perform any one time initialization code here */ ");
        bText.add("");
        bText.add("/* if initialization succeeds  set ret */ ");
        bText.add("ret = &associationMI;");
        bText.add("");
        bText.add("/* if pStatus isn't NULL we need to update it with a success/failure value */ ");
        bText.add("if (pStatus != NULL) {");
        bText.add("pStatus->rc = status.rc;");
        bText.add("pStatus->msg = status.msg;");
        bText.add("}");
        bText.add("return ret;");
        CFunctionBody body = new CFunctionBody(null, bText);
        String comment = "The " + this.mCIMClass.getName() + "_Create_AssociationMI() functions shall perform any necessary" + " initialization operations of this MI group.";
        CFunction method = new CFunction(comment, false, "CMPIAssociationMI", "*" + this.mCIMClass.getName() + "_Create_AssociationMI", arguments, body.toString());
        return method;
    }

    private void addAssociatorNames() {
        ArrayList<CArgument> arguments = new ArrayList<CArgument>();
        ArrayList<String> bText = new ArrayList<String>();
        arguments.add(new CArgument(false, "*pMI", "CMPIAssociationMI"));
        arguments.add(new CArgument(true, "*pCtx", "CMPIContext"));
        arguments.add(new CArgument(true, "*pRslt", "CMPIResult"));
        arguments.add(new CArgument(true, "*pPath", "CMPIObjectPath"));
        arguments.add(new CArgument(true, "*pAssocClass", "char"));
        arguments.add(new CArgument(true, "*pResultClass", "char"));
        arguments.add(new CArgument(true, "*pRole", "char"));
        arguments.add(new CArgument(true, "*pResultRole", "char"));
        bText.add("/* not supported */");
        bText.add("CMPIStatus ret = {CMPI_RC_ERR_NOT_SUPPORTED,NULL};");
        bText.add("pRslt->ft->returnDone(pRslt);");
        bText.add("return ret;");
        CFunctionBody body = new CFunctionBody(null, bText);
        String comment = "Enumerate ObjectPaths of Instances associated with an Instance.";
        CFunction method = new CFunction(comment, true, "CMPIStatus", "associatorNames", arguments, body.toString());
        this.mFunctionList.add(method);
    }

    private void addAssociators() {
        ArrayList<CArgument> arguments = new ArrayList<CArgument>();
        ArrayList<String> bText = new ArrayList<String>();
        arguments.add(new CArgument(false, "*pMI", "CMPIAssociationMI"));
        arguments.add(new CArgument(true, "*pCtx", "CMPIContext"));
        arguments.add(new CArgument(true, "*pRslt", "CMPIResult"));
        arguments.add(new CArgument(true, "*pObjName", "CMPIObjectPath"));
        arguments.add(new CArgument(true, "*pAssocClass", "char"));
        arguments.add(new CArgument(true, "*pResultClass", "char"));
        arguments.add(new CArgument(true, "*pRole", "char"));
        arguments.add(new CArgument(true, "*pResultRole", "char"));
        arguments.add(new CArgument(true, "**pPropList", "char"));
        bText.add("/* not supported */");
        bText.add("CMPIStatus ret = {CMPI_RC_ERR_NOT_SUPPORTED,NULL};");
        bText.add("pRslt->ft->returnDone(pRslt);");
        bText.add("return ret;");
        CFunctionBody body = new CFunctionBody(null, bText);
        String comment = "Enumerate Instances associated with an Instance.";
        CFunction method = new CFunction(comment, true, "CMPIStatus", "associators", arguments, body.toString());
        this.mFunctionList.add(method);
    }

    private void addReferenceNames() {
        ArrayList<CArgument> arguments = new ArrayList<CArgument>();
        ArrayList<String> bText = new ArrayList<String>();
        arguments.add(new CArgument(false, "*pMI", "CMPIAssociationMI"));
        arguments.add(new CArgument(true, "*pCtx", "CMPIContext"));
        arguments.add(new CArgument(true, "*pRslt", "CMPIResult"));
        arguments.add(new CArgument(true, "*pPath", "CMPIObjectPath"));
        arguments.add(new CArgument(true, "*pRole", "char"));
        arguments.add(new CArgument(true, "*pResultRole", "char"));
        bText.add("/* not supported */");
        bText.add("CMPIStatus ret = {CMPI_RC_ERR_NOT_SUPPORTED,NULL};");
        bText.add("pRslt->ft->returnDone(pRslt);");
        bText.add("return ret;");
        CFunctionBody body = new CFunctionBody(null, bText);
        String comment = "Enumerate the ObjectPaths of Association Instances that refer to an Instance.";
        CFunction method = new CFunction(comment, true, "CMPIStatus", "referenceNames", arguments, body.toString());
        this.mFunctionList.add(method);
    }

    private void addReferences() {
        ArrayList<CArgument> arguments = new ArrayList<CArgument>();
        ArrayList<String> bText = new ArrayList<String>();
        arguments.add(new CArgument(false, "*pMI", "CMPIAssociationMI"));
        arguments.add(new CArgument(true, "*pCtx", "CMPIContext"));
        arguments.add(new CArgument(true, "*pRslt", "CMPIResult"));
        arguments.add(new CArgument(true, "*pObjName", "CMPIObjectPath"));
        arguments.add(new CArgument(true, "*pRole", "char"));
        arguments.add(new CArgument(true, "*pResultRole", "char"));
        arguments.add(new CArgument(true, "**pPropList", "char"));
        bText.add("/* not supported */");
        bText.add("CMPIStatus ret = {CMPI_RC_ERR_NOT_SUPPORTED,NULL};");
        bText.add("pRslt->ft->returnDone(pRslt);");
        bText.add("return ret;");
        CFunctionBody body = new CFunctionBody(null, bText);
        String comment = "Enumerate the Association Instances that refer to an Instance.";
        CFunction method = new CFunction(comment, true, "CMPIStatus", "references", arguments, body.toString());
        this.mFunctionList.add(method);
    }

    private void addCleanup() {
        ArrayList<CArgument> arguments = new ArrayList<CArgument>();
        arguments.add(new CArgument(false, "*pMI", "CMPIAssociationMI"));
        arguments.add(new CArgument(true, "*pCtx", "CMPIContext"));
        arguments.add(new CArgument(false, "pBool", "CMPIBoolean"));
        ArrayList<String> bText = new ArrayList<String>();
        bText.add("CMPIStatus ret = {CMPI_RC_OK,NULL};");
        bText.add("return ret;");
        CFunctionBody body = new CFunctionBody(null, bText);
        String comment = "Perform cleanup prior to unloading the Association provider.";
        CFunction method = new CFunction(comment, true, "CMPIStatus", "associationCleanup", arguments, body.toString());
        this.mFunctionList.add(method);
    }
}

