/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.codegen.jsr48.provider;

import com.ws.cim.codegen.jsr48.CodeGeneratorUtils;
import com.ws.cim.codegen.jsr48.provider.BaseProviderGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.cim.CIMClass;

public class ProviderCodeGenerator
extends BaseProviderGenerator {
    public static final String IMPLEMENTATION_DIR_NAME = "implementation";
    private static final String ABSTRACT_IMPL_TEMPLATE_TXT = "AbstractImplTemplate.txt";
    private static final String ABSTRACT_PROVIDER_TEMPLATE = "AbstractProviderTemplate.txt";
    private static final String ASSOC_PROVIDER_TEMPLATE = "AssocProviderTemplate.txt";
    private static final String ASSOC_PROVIDER_TEMPLATE_WITH_METHOD = "AssocProviderTemplateWithMethod.txt";
    private static final String PROVIDER_TEMPLATE = "ProviderTemplate.txt";
    private static final String PROVIDER_TEMPLATE_WITH_METHOD = "ProviderTemplateWithMethod.txt";
    private static final String ASSOC_IMPL_TEMPLATE = "AssocImplTemplate.txt";
    private static final String ASSOC_IMPL_TEMPLATE_WITH_METHOD = "AssocImplTemplateWithMethod.txt";
    private static final String IMPL_TEMPLATE = "ImplTemplate.txt";
    private static final String IMPL_TEMPLATE_WITH_METHOD = "ImplTemplateWithMethod.txt";
    private static Map<String, String> templateMap = new HashMap<String, String>(20);
    private static String mAbstractDir = null;
    private static String mAbstractImplDir = null;
    private static String mGeneratedProviderDir = null;
    private static String mProvidersDir = null;
    private String mProviderTemplateDir;
    private String mProviderImplTemplateDir;

    public static String getAbstractImplDirName(String outputDirectory) {
        StringBuilder ret = ProviderCodeGenerator.getBasePart(outputDirectory);
        ret.append("abstractImpl");
        return ret.toString();
    }

    public static String getDataDirName(String outputDirectory) {
        StringBuilder ret = ProviderCodeGenerator.getBasePart(outputDirectory);
        ret.append("data");
        return ret.toString();
    }

    public static String getImplementationDirName(String outputDirectory) {
        StringBuilder ret = ProviderCodeGenerator.getBasePart(outputDirectory);
        ret.append(IMPLEMENTATION_DIR_NAME);
        return ret.toString();
    }

    public static String getProviderDirName(String outputDirectory) {
        StringBuilder ret = ProviderCodeGenerator.getBasePart(outputDirectory);
        ret.append("providers");
        return ret.toString();
    }

    public static String getSchemaDirName(String outputDirectory) {
        StringBuilder ret = ProviderCodeGenerator.getBasePart(outputDirectory);
        ret.append("schema");
        return ret.toString();
    }

    public ProviderCodeGenerator(CIMClass pClass, String pDirPath, HashMap<String, String> pCustomPropMap, ArrayList<String> pSelectedSchema, ArrayList<String> pSelectedClasses) throws Exception {
        super(pClass, pDirPath, pCustomPropMap, pSelectedSchema, pSelectedClasses);
        if (null == mAbstractDir) {
            mAbstractDir = ProviderCodeGenerator.getDataDirName(this.mOutdir);
        }
        if (null == mAbstractImplDir) {
            mAbstractImplDir = ProviderCodeGenerator.getAbstractImplDirName(this.mOutdir);
        }
        if (null == mGeneratedProviderDir) {
            mGeneratedProviderDir = ProviderCodeGenerator.getProviderDirName(this.mOutdir);
        }
        if (null == mProvidersDir) {
            mProvidersDir = ProviderCodeGenerator.getImplementationDirName(this.mOutdir);
        }
        if (null == this.mProviderTemplateDir) {
            this.mProviderTemplateDir = "com/ws/cim/codegen/jsr48/templates/providers";
        }
        if (null == this.mProviderImplTemplateDir) {
            this.mProviderImplTemplateDir = "com/ws/cim/codegen/jsr48/templates/providers/impl";
        }
    }

    public void generateCode() throws Exception {
        boolean hasSchemaOrClassFilter = false;
        String className = this.mCIMClass.getName();
        String schemaName = CodeGeneratorUtils.getSchemaName(className);
        if (null != this.mSelectedSchema && !this.mSelectedSchema.isEmpty()) {
            hasSchemaOrClassFilter = true;
            if (this.mSelectedSchema.contains(schemaName.toUpperCase())) {
                this.generateProvider();
            }
        }
        if (null != this.mSelectedClasses && !this.mSelectedClasses.isEmpty()) {
            hasSchemaOrClassFilter = true;
            if (this.mSelectedClasses.contains(className.toUpperCase())) {
                this.generateProvider();
            }
        }
        if (!hasSchemaOrClassFilter) {
            this.generateProvider();
        }
    }

    private void generateProvider() throws Exception {
        String strProviderImplTemplate;
        String strProviderTemplate;
        String className = this.mCIMClass.getName();
        int methodCount = this.mCIMClass.getMethodCount();
        if (this.mCIMClass.isAssociation()) {
            if (methodCount > 0) {
                strProviderTemplate = ASSOC_PROVIDER_TEMPLATE_WITH_METHOD;
                strProviderImplTemplate = ASSOC_IMPL_TEMPLATE_WITH_METHOD;
            } else {
                strProviderTemplate = ASSOC_PROVIDER_TEMPLATE;
                strProviderImplTemplate = ASSOC_IMPL_TEMPLATE;
            }
        } else if (methodCount > 0) {
            strProviderTemplate = PROVIDER_TEMPLATE_WITH_METHOD;
            strProviderImplTemplate = IMPL_TEMPLATE_WITH_METHOD;
        } else {
            strProviderTemplate = PROVIDER_TEMPLATE;
            strProviderImplTemplate = IMPL_TEMPLATE;
        }
        String abstractProviderTemplate = templateMap.get(ABSTRACT_PROVIDER_TEMPLATE);
        if (null == abstractProviderTemplate) {
            abstractProviderTemplate = this.getTemplate(this.mProviderTemplateDir, ABSTRACT_PROVIDER_TEMPLATE);
            templateMap.put(ABSTRACT_PROVIDER_TEMPLATE, abstractProviderTemplate);
        }
        String abstractProvider = this.readReplaceContent(abstractProviderTemplate, className);
        String providerTemplate = templateMap.get(strProviderTemplate);
        if (null == providerTemplate) {
            providerTemplate = this.getTemplate(this.mProviderTemplateDir, strProviderTemplate);
            templateMap.put(strProviderTemplate, providerTemplate);
        }
        String generatedProvider = this.readReplaceContent(providerTemplate, className);
        String providerImplTemplate = templateMap.get(strProviderImplTemplate);
        if (null == providerImplTemplate) {
            providerImplTemplate = this.getTemplate(this.mProviderImplTemplateDir, strProviderImplTemplate);
            templateMap.put(strProviderImplTemplate, providerImplTemplate);
        }
        String providersImpl = this.readReplaceContent(providerImplTemplate, className);
        String abstractProviderImplTemplate = templateMap.get(ABSTRACT_IMPL_TEMPLATE_TXT);
        if (null == abstractProviderImplTemplate) {
            abstractProviderImplTemplate = this.getTemplate(this.mProviderImplTemplateDir, ABSTRACT_IMPL_TEMPLATE_TXT);
            templateMap.put(ABSTRACT_IMPL_TEMPLATE_TXT, abstractProviderImplTemplate);
        }
        String abstractProviderImpl = this.readReplaceContent(abstractProviderImplTemplate, className);
        if (null == abstractProvider || null == generatedProvider || null == providersImpl || null == abstractProviderImpl) {
            String msg = String.format("Missing the following template(s) %s %s %s", null == abstractProvider ? abstractProviderTemplate : "", null == generatedProvider ? strProviderTemplate : "", null == providersImpl ? providerImplTemplate : "");
            throw new Exception(msg);
        }
        this.writeFile(mAbstractDir, className + "Data", abstractProvider, true);
        this.writeFile(mGeneratedProviderDir, className + "Provider", generatedProvider, true);
        this.writeFile(mAbstractImplDir, className + "AbstractImpl", abstractProviderImpl, true);
        this.writeFile(mProvidersDir, className + "Impl", providersImpl, false);
    }
}

