/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.mof.compiler;

import com.ws.cim.mof.compiler.CIMMutableClassProperty;
import com.ws.cim.mof.compiler.CIMMutableMethod;
import com.ws.cim.mof.compiler.CIMMutableQualifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.cim.CIMClass;
import javax.cim.CIMClassProperty;
import javax.cim.CIMMethod;
import javax.cim.CIMObjectPath;
import javax.cim.CIMQualifier;

public class CIMMutableClass {
    private String mClassComments = "";
    private String mClassEndComments = "";
    private boolean mIsAssociation;
    private boolean mIsKeyedClass;
    private CIMMutableMethod[] mMethods;
    private String mName;
    private String mNamespace;
    private CIMMutableClassProperty[] mProperties;
    private String mQualifierComments = "";
    private CIMMutableQualifier[] mQualifiers = new CIMMutableQualifier[0];
    private String mSuperClass;

    public CIMMutableClass() {
        this.mProperties = new CIMMutableClassProperty[0];
        this.mMethods = new CIMMutableMethod[0];
    }

    public CIMMutableClass(CIMClass clazz) {
        this();
        CIMMethod[] clazzMethods;
        CIMClassProperty[] clazzProps;
        CIMQualifier[] clazzQuals;
        this.setName(clazz.getName());
        this.setSuperClass(clazz.getSuperClassName());
        this.setIsAssociation(clazz.isAssociation());
        this.setIsKeyed(clazz.isKeyed());
        this.setNamespace(clazz.getObjectPath().getNamespace());
        for (CIMQualifier q : clazzQuals = clazz.getQualifiers()) {
            this.addQualifier(new CIMMutableQualifier(q));
        }
        for (CIMClassProperty p : clazzProps = clazz.getProperties()) {
            this.addProperty(new CIMMutableClassProperty(p));
        }
        for (CIMMethod m : clazzMethods = clazz.getMethods()) {
            this.addMethod(new CIMMutableMethod(m));
        }
    }

    public void addComment(String pComments) {
        if (pComments != null) {
            this.mClassComments = this.mClassComments + pComments;
        }
    }

    public void addEndComment(String pComments) {
        if (pComments != null) {
            this.mClassEndComments = this.mClassEndComments + pComments;
        }
    }

    public void addMethod(CIMMutableMethod m) {
        List<CIMMutableMethod> l = Arrays.asList(this.mMethods);
        ArrayList<CIMMutableMethod> listProperties = new ArrayList<CIMMutableMethod>(l);
        listProperties.add(m);
        this.mMethods = listProperties.toArray(new CIMMutableMethod[listProperties.size()]);
    }

    public void addProperty(CIMMutableClassProperty p) {
        List<CIMMutableClassProperty> l = Arrays.asList(this.mProperties);
        ArrayList<CIMMutableClassProperty> listProperties = new ArrayList<CIMMutableClassProperty>(l);
        listProperties.add(p);
        this.mProperties = listProperties.toArray(new CIMMutableClassProperty[listProperties.size()]);
    }

    public void addQualifier(CIMMutableQualifier p) {
        List<CIMMutableQualifier> l = Arrays.asList(this.mQualifiers);
        ArrayList<CIMMutableQualifier> listProperties = new ArrayList<CIMMutableQualifier>(l);
        listProperties.add(p);
        this.mQualifiers = listProperties.toArray(new CIMMutableQualifier[listProperties.size()]);
    }

    public void addQualifierComments(String pComments) {
        if (pComments != null) {
            this.mQualifierComments = this.mQualifierComments + pComments;
        }
    }

    public CIMClass getCIMClass() {
        return new CIMClass(new CIMObjectPath(null, null, null, this.mNamespace, this.mName, null, null), this.mSuperClass, this.getCIMQualifiers(), this.getCIMClassProperties(), this.getCIMMethods(), this.mIsAssociation, this.mIsKeyedClass);
    }

    public CIMClassProperty<?>[] getCIMClassProperties() {
        ArrayList l = new ArrayList();
        for (CIMMutableClassProperty p : this.mProperties) {
            l.add(p.getCIMProperty());
        }
        return l.toArray(new CIMClassProperty[l.size()]);
    }

    public CIMMethod<?>[] getCIMMethods() {
        ArrayList l = new ArrayList();
        for (CIMMutableMethod m : this.mMethods) {
            l.add(m.getMethod());
        }
        return l.toArray(new CIMMethod[l.size()]);
    }

    public CIMQualifier<?>[] getCIMQualifiers() {
        ArrayList l = new ArrayList();
        if (this.mQualifiers != null) {
            for (CIMMutableQualifier q : this.mQualifiers) {
                l.add(q.getCIMQualifier());
            }
        }
        return l.toArray(new CIMQualifier[l.size()]);
    }

    public String getClassComments() {
        return this.mClassComments;
    }

    public String getClassEndComments() {
        return this.mClassEndComments;
    }

    public CIMMutableMethod getMethod(String name) {
        for (CIMMutableMethod m : this.mMethods) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    public CIMMutableMethod[] getMethods() {
        return this.mMethods;
    }

    public String getName() {
        return this.mName;
    }

    public CIMMutableClassProperty[] getProperties() {
        return this.mProperties;
    }

    public CIMMutableClassProperty getProperty(String name) {
        for (CIMMutableClassProperty m : this.mProperties) {
            if (!m.getName().equalsIgnoreCase(name)) continue;
            return m;
        }
        return null;
    }

    public CIMMutableQualifier getQualifier(String name) {
        for (CIMMutableQualifier m : this.mQualifiers) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    public String getQualifierListComments() {
        return this.mQualifierComments;
    }

    public CIMMutableQualifier[] getQualifiers() {
        return this.mQualifiers;
    }

    public String getSuperClass() {
        return this.mSuperClass;
    }

    public void removeMethod(CIMMutableMethod p) {
        List<CIMMutableMethod> l = Arrays.asList(this.mMethods);
        ArrayList<CIMMutableMethod> listProperties = new ArrayList<CIMMutableMethod>(l);
        listProperties.remove(p);
        this.mMethods = listProperties.toArray(new CIMMutableMethod[listProperties.size()]);
    }

    public void removeProperty(CIMMutableClassProperty p) {
        List<CIMMutableClassProperty> l = Arrays.asList(this.mProperties);
        ArrayList<CIMMutableClassProperty> listProperties = new ArrayList<CIMMutableClassProperty>(l);
        listProperties.remove(p);
        this.mProperties = listProperties.toArray(new CIMMutableClassProperty[listProperties.size()]);
    }

    public void removeQualifier(CIMMutableQualifier p) {
        List<CIMMutableQualifier> l = Arrays.asList(this.mQualifiers);
        ArrayList<CIMMutableQualifier> listProperties = new ArrayList<CIMMutableQualifier>(l);
        listProperties.remove(p);
        this.mQualifiers = listProperties.toArray(new CIMMutableQualifier[listProperties.size()]);
    }

    public void replaceMethod(CIMMutableMethod p) {
        for (int i = 0; i < this.mMethods.length; ++i) {
            CIMMutableMethod prop = this.mMethods[i];
            if (!prop.getName().equals(p.getName())) continue;
            this.mMethods[i] = p;
            return;
        }
    }

    public void replaceProperty(CIMMutableClassProperty p) {
        for (int i = 0; i < this.mProperties.length; ++i) {
            CIMMutableClassProperty prop = this.mProperties[i];
            if (!prop.getName().equals(p.getName())) continue;
            this.mProperties[i] = p;
            return;
        }
    }

    public void replaceQualifier(CIMMutableQualifier p) {
        for (int i = 0; i < this.mQualifiers.length; ++i) {
            CIMMutableQualifier prop = this.mQualifiers[i];
            if (null == prop || null == prop.getName() || null == p || null == p.getName()) {
                return;
            }
            if (!prop.getName().equals(p.getName())) continue;
            this.mQualifiers[i] = p;
            return;
        }
    }

    public void setIsAssociation(boolean isAssociation) {
        this.mIsAssociation = isAssociation;
    }

    public void setIsKeyed(boolean isKeyed) {
        this.mIsKeyedClass = isKeyed;
    }

    public void setMethods(CIMMutableMethod[] pMethods) {
        this.mMethods = pMethods;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public void setNamespace(String pName) {
        this.mNamespace = pName;
    }

    public void setProperties(CIMMutableClassProperty[] pProperties) {
        this.mProperties = pProperties;
    }

    public void setQualifierComments(String comments) {
        this.mQualifierComments = comments;
    }

    public void setQualifiers(CIMMutableQualifier[] pQualifiers) {
        this.mQualifiers = pQualifiers;
    }

    public void setSuperClass(String pName) {
        this.mSuperClass = pName;
    }
}

