/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.ws;

import com.ws.cim.ws.WSCIMNamespaceConstants;
import com.ws.cim.ws.WSCIMXSDMapping;
import com.ws.wbem.apps.common.WSProductInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.cim.CIMClass;
import javax.cim.CIMElement;
import javax.cim.CIMInstance;
import javax.cim.CIMMethod;
import javax.cim.CIMQualifier;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSCIMWSDLMapping {
    private static final String TARGET_NAMESPACE = "targetNamespace";
    private static final String NAMESPACE_SOAP = "http://schemas.xmlsoap.org/wsdl/soap/";
    private static final String STYLE = "style";
    private static final String TYPE = "type";
    private static final String PRS = "PRS";
    private static final String CIM = "CIM";
    private static final String TYPES = "types";
    private static final String IMPORT = "import";
    private static final String NAMESPACE = "namespace";
    private static final String OPERATION = "operation";
    private static final String PORTTYPE = "portType";
    private static final String THIS_WSDL = "thisWSDL";
    private static final String INPUT = "input";
    private static final String INPUT_MESSAGE = "_InputMessage";
    private static final String _INPUT = "_INPUT";
    private static final String OUTPUT_MESSAGE = "_OutputMessage";
    private static final String OUTPUT = "output";
    private static final String _OUTPUT = "_OUTPUT";
    private static final String MESSAGE = "message";
    private static final String PART = "part";
    private static final String CIM_CLASS = "cimClass";
    private static final String ELEMENT = "element";
    private static final String BODY = "body";
    private static final String NAME = "name";
    private static final String XMLNS = "xmlns";
    private final Properties mProps;
    private final String mOutdir;

    public WSCIMWSDLMapping(CIMElement element, String outdir, Properties props) throws Exception {
        this.mProps = props;
        this.mOutdir = outdir;
        if (element instanceof CIMClass) {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            DocumentBuilder db = docFactory.newDocumentBuilder();
            Document xsd = db.newDocument();
            this.mapCIMClass((CIMClass)element, xsd);
            this.writeFile(xsd, element.getName());
        }
    }

    public void mapCIMClass(CIMClass clazz, Document xml) {
        String COLON = ":";
        String className = clazz.getName();
        String schemaName = CIM;
        String xsdNamespace = WSCIMNamespaceConstants.getNamespace("class");
        try {
            schemaName = className.substring(0, className.indexOf(95));
            if (!schemaName.equalsIgnoreCase(CIM) && !schemaName.equalsIgnoreCase(PRS) && this.mProps.containsKey(schemaName)) {
                xsdNamespace = this.mProps.getProperty(schemaName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        WSProductInfo pInfo = new WSProductInfo("com.ws.wbem.apps.mofmorph");
        Comment cmt = xml.createComment(pInfo.getGeneratedByText());
        xml.appendChild(cmt);
        Element root = xml.createElementNS(WSCIMNamespaceConstants.getNamespace("wsdl"), "wsdl:definitions");
        root.setAttribute("xmlns:wsdl", WSCIMNamespaceConstants.getNamespace("wsdl"));
        String target = this.mProps.getProperty(TARGET_NAMESPACE, "http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/");
        root.setAttribute(TARGET_NAMESPACE, target + className);
        root.setAttribute("xmlns:cimClass", xsdNamespace + clazz.getName());
        root.setAttribute("xmlns:thisWSDL", target + className);
        root.setAttribute("xmlns:soap", NAMESPACE_SOAP);
        xml.appendChild(root);
        Element wsdlImport = xml.createElementNS(WSCIMNamespaceConstants.getNamespace("wsdl"), "wsdl:import");
        wsdlImport.setAttribute(NAMESPACE, "http://www.w3.org/2005/08/addressing");
        wsdlImport.setAttribute("location", "http://www.w3.org/2005/08/addressing/ws-addr.xsd");
        root.appendChild(wsdlImport);
        try {
            WSCIMXSDMapping xsdM = new WSCIMXSDMapping();
            Element wsdlTypes = xml.createElementNS(WSCIMNamespaceConstants.getNamespace("wsdl"), "wsdl:types");
            xsdM.createXSD(clazz, xml, wsdlTypes);
            root.appendChild(wsdlTypes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (CIMMethod method : clazz.getMethods()) {
            Element wsdlMessageInput = xml.createElementNS(WSCIMNamespaceConstants.getNamespace("wsdl"), "wsdl:message");
            wsdlMessageInput.setAttribute(NAME, method.getName() + INPUT_MESSAGE);
            Element wsdlInputPart = xml.createElementNS(WSCIMNamespaceConstants.getNamespace("wsdl"), "wsdl:part");
            wsdlInputPart.setAttribute(NAME, BODY);
            wsdlInputPart.setAttribute(ELEMENT, "cimClass:" + method.getName() + _INPUT);
            wsdlMessageInput.appendChild(wsdlInputPart);
            root.appendChild(wsdlMessageInput);
            Element wsdlMessageOutput = xml.createElementNS(WSCIMNamespaceConstants.getNamespace("wsdl"), "wsdl:message");
            wsdlMessageOutput.setAttribute(NAME, method.getName() + OUTPUT_MESSAGE);
            Element wsdlOutputPart = xml.createElementNS(WSCIMNamespaceConstants.getNamespace("wsdl"), "wsdl:part");
            wsdlOutputPart.setAttribute(NAME, BODY);
            wsdlOutputPart.setAttribute(ELEMENT, "cimClass:" + method.getName() + _OUTPUT);
            wsdlMessageOutput.appendChild(wsdlOutputPart);
            root.appendChild(wsdlMessageOutput);
        }
        Element wsdlPortType = xml.createElementNS(WSCIMNamespaceConstants.getNamespace("wsdl"), "wsdl:portType");
        wsdlPortType.setAttribute(NAME, className);
        root.appendChild(wsdlPortType);
        for (CIMMethod method : clazz.getMethods()) {
            Element wsdlOperation = xml.createElementNS(WSCIMNamespaceConstants.getNamespace("wsdl"), "wsdl:operation");
            wsdlOperation.setAttribute(NAME, method.getName());
            Element wsdlOperationInput = xml.createElementNS(WSCIMNamespaceConstants.getNamespace("wsdl"), "wsdl:input");
            wsdlOperationInput.setAttribute(NAME, method.getName() + INPUT_MESSAGE);
            wsdlOperationInput.setAttribute(MESSAGE, "thisWSDL:" + method.getName() + INPUT_MESSAGE);
            wsdlOperation.appendChild(wsdlOperationInput);
            Element wsdlOperationOutput = xml.createElementNS(WSCIMNamespaceConstants.getNamespace("wsdl"), "wsdl:output");
            wsdlOperationOutput.setAttribute(NAME, method.getName() + OUTPUT_MESSAGE);
            wsdlOperationOutput.setAttribute(MESSAGE, "thisWSDL:" + method.getName() + OUTPUT_MESSAGE);
            wsdlOperation.appendChild(wsdlOperationOutput);
            wsdlPortType.appendChild(wsdlOperation);
        }
        if (null != this.mProps.getProperty("gb")) {
            Element wsdlBindings = xml.createElementNS(WSCIMNamespaceConstants.getNamespace("wsdl"), "wsdl:binding");
            wsdlBindings.setAttribute(NAME, className + "Binding");
            wsdlBindings.setAttribute(TYPE, "thisWSDL:" + className);
            root.appendChild(wsdlBindings);
            Element soapBinding = xml.createElementNS(NAMESPACE_SOAP, "soap:binding");
            soapBinding.setAttribute(STYLE, "document");
            soapBinding.setAttribute("transport", "http://schemas.xmlsoap.org/soap/http");
            wsdlBindings.appendChild(soapBinding);
            for (CIMMethod method : clazz.getMethods()) {
                Element wsdlOperation = xml.createElementNS(WSCIMNamespaceConstants.getNamespace("wsdl"), "wsdl:operation");
                wsdlOperation.setAttribute(NAME, method.getName());
                Element soapOperation = xml.createElementNS(NAMESPACE_SOAP, "soap:operation");
                soapOperation.setAttribute("soapAction", xsdNamespace + clazz.getName() + "/" + method.getName());
                wsdlOperation.appendChild(soapOperation);
                Element wsdlOperationInput = xml.createElementNS(WSCIMNamespaceConstants.getNamespace("wsdl"), "wsdl:input");
                Element soapBody = xml.createElementNS(NAMESPACE_SOAP, "soap:body");
                soapBody.setAttribute("use", "literal");
                wsdlOperationInput.appendChild(soapBody);
                wsdlOperation.appendChild(wsdlOperationInput);
                Element wsdlOperationOutput = xml.createElementNS(WSCIMNamespaceConstants.getNamespace("wsdl"), "wsdl:output");
                wsdlOperationOutput.appendChild(soapBody.cloneNode(true));
                wsdlOperation.appendChild(wsdlOperationOutput);
                wsdlBindings.appendChild(wsdlOperation);
            }
            Element wsdlService = xml.createElementNS(WSCIMNamespaceConstants.getNamespace("wsdl"), "wsdl:service");
            wsdlService.setAttribute(NAME, className);
            Element wsdlServicePort = xml.createElementNS(WSCIMNamespaceConstants.getNamespace("wsdl"), "wsdl:port");
            wsdlServicePort.setAttribute(NAME, className + "Binding");
            wsdlServicePort.setAttribute("binding", "thisWSDL:" + className + "Binding");
            Element soapAddress = xml.createElementNS(NAMESPACE_SOAP, "soap:address");
            soapAddress.setAttribute("location", "http://localhost/" + className);
            wsdlServicePort.appendChild(soapAddress);
            wsdlService.appendChild(wsdlServicePort);
            root.appendChild(wsdlService);
        }
    }

    public void mapCIMInstance(CIMInstance instance) throws Exception {
    }

    public void mapQualifier(CIMQualifier<?> qualifier, Element element, Document xsd) {
        if (qualifier.getDataType() != null && qualifier.getDataType().isArray()) {
            for (Object o : (Object[])qualifier.getValue()) {
                Element qElement = this.mapQualifierElement(qualifier.getName(), o.toString(), xsd);
                element.appendChild(qElement);
            }
        } else {
            Element qElement = this.mapQualifierElement(qualifier.getName(), qualifier.getValue(), xsd);
            element.appendChild(qElement);
        }
    }

    private Element mapQualifierElement(String name, Object value, Document xsd) {
        Element element = xsd.createElementNS(WSCIMNamespaceConstants.getNamespace("cimQ"), "cimQ:" + name);
        element.setAttribute("cim:qualifier", "true");
        if (value != null) {
            element.setTextContent(value.toString());
        } else {
            element.setTextContent("true");
        }
        return element;
    }

    private void writeFile(Document xsd, String name) throws Exception {
        String WSDL = ".wsdl";
        Transformer tr = TransformerFactory.newInstance().newTransformer();
        tr.setOutputProperty("indent", "yes");
        tr.setOutputProperty("method", "xml");
        tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        String outName = this.mOutdir + File.separator + name + ".wsdl";
        tr.transform(new DOMSource(xsd), new StreamResult(new FileOutputStream(outName)));
    }
}

