/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.xmi;

import com.ws.cim.xmi.XMICodeWriter;
import com.ws.cim.xmi.metaclass.AssociationClassMetaClass;
import com.ws.cim.xmi.metaclass.ClassMetaClass;
import com.ws.cim.xmi.metaclass.XMIModel;
import com.ws.cim.xmi.metaclass.XMIPackage;
import com.ws.utilities.Resources;
import java.util.ArrayList;
import javax.cim.CIMClass;

public class XMIGenerator {
    private static final String BUNDLE = "com.ws.cim.xmi.XMIGenerator";
    private static final String ASSOCIATION_QUALIFIER = "Association";
    private Resources mResourceHandle;
    private String mOutdir;
    private ArrayList<String> mXMIData;
    private final String mFileName = "all_classes.xmi";
    private ArrayList<XMIModel> mXMIModelList;
    private String UMLPACKAGEPATH = "UmlPackagePath";
    private String V_UMLPACKAGEPATH = "CIM::Default";

    public XMIGenerator(String pOutdir) {
        this.mOutdir = pOutdir;
        this.mResourceHandle = new Resources(BUNDLE);
        this.mXMIData = new ArrayList();
        this.mXMIModelList = new ArrayList();
        this.mXMIData.add(this.mResourceHandle.loadString("XML_HEADER"));
        this.mXMIData.add(this.mResourceHandle.loadString("XMI_OPEN_TAG"));
        this.mXMIData.add(this.mResourceHandle.loadString("XMI_CLOSE_TAG"));
    }

    public void generateXMI(CIMClass pClass) {
        try {
            String pp = (String)pClass.getQualifierValue(this.UMLPACKAGEPATH);
            if (pp == null) {
                pp = this.V_UMLPACKAGEPATH;
            }
            this.generateXMIModel(pClass, this.getPackageInfo(pp));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ArrayList<String> getPackageInfo(String pPackagePath) {
        ArrayList<String> packageInfo = new ArrayList<String>();
        if (null != pPackagePath) {
            for (String p : pPackagePath.split("::")) {
                packageInfo.add(p);
            }
        }
        return packageInfo;
    }

    private void generateXMIModel(CIMClass pClass, ArrayList<String> pPackageInfo) {
        XMIModel model;
        String modelName = pPackageInfo.get(0);
        if (!this.isModelExist(modelName)) {
            this.mXMIModelList.add(new XMIModel(modelName));
        }
        if (null != (model = this.retrieveModel(modelName))) {
            int startIndex = 1;
            this.generateXMIPackage(model, null, pClass, pPackageInfo, startIndex);
        }
    }

    private void generateXMIPackage(XMIModel pModel, XMIPackage pPackage, CIMClass pClass, ArrayList<String> pPackageInfo, int pStartIndex) {
        String packageName = pPackageInfo.get(pStartIndex++);
        XMIPackage subPackage = new XMIPackage(packageName);
        if (null == pPackage) {
            if (!pModel.isPackageExist(packageName)) {
                pModel.addPackage(subPackage);
            } else {
                subPackage = pModel.getPackage(packageName);
            }
        } else if (!pPackage.isSubPackageExist(packageName)) {
            pPackage.addSubPackage(subPackage);
        } else {
            subPackage = pPackage.getPackage(packageName);
        }
        if (pStartIndex < pPackageInfo.size()) {
            this.generateXMIPackage(pModel, subPackage, pClass, pPackageInfo, pStartIndex);
        } else {
            ClassMetaClass classInfo = this.generateClassInfo(pClass);
            subPackage.addClass(classInfo);
        }
    }

    private XMIModel retrieveModel(String pModelName) {
        for (XMIModel m : this.mXMIModelList) {
            if (!m.getName().equalsIgnoreCase(pModelName)) continue;
            return m;
        }
        return null;
    }

    private boolean isModelExist(String pName) {
        for (XMIModel m : this.mXMIModelList) {
            if (!m.getName().equalsIgnoreCase(pName)) continue;
            return true;
        }
        return false;
    }

    private ClassMetaClass generateClassInfo(CIMClass pClass) {
        if (!pClass.hasQualifier(ASSOCIATION_QUALIFIER)) {
            ClassMetaClass classMetaClass = new ClassMetaClass(pClass);
            return classMetaClass;
        }
        AssociationClassMetaClass assocClassMetaClass = new AssociationClassMetaClass(pClass);
        return assocClassMetaClass;
    }

    public void writeXMIFile() throws Exception {
        StringBuilder strBuild = new StringBuilder();
        for (XMIModel m : this.mXMIModelList) {
            strBuild.append(m.toString());
        }
        this.mXMIData.add(2, strBuild.toString());
        XMICodeWriter xmiWriter = new XMICodeWriter(this.mOutdir);
        StringBuilder xmiDataStr = new StringBuilder();
        for (String data : this.mXMIData) {
            xmiDataStr.append(data);
        }
        xmiWriter.write("all_classes.xmi", xmiDataStr.toString());
    }
}

