/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.xmi.metaclass;

import com.ws.cim.xmi.metaclass.BaseMetaClass;
import com.ws.cim.xmi.metaclass.ParameterMetaClass;
import com.ws.utilities.Resources;
import java.text.MessageFormat;
import javax.cim.CIMMethod;
import javax.cim.CIMParameter;

public class OperationMetaClass
extends BaseMetaClass {
    private static final String BUNDLE = "com.ws.cim.xmi.XMIGenerator";
    private final String STATIC_QUALIFIER = "Static";
    private CIMMethod<?> mMethod;
    private Resources mLocalResourceHandle;

    public OperationMetaClass(CIMMethod<?> pMethod) {
        this.mMethod = pMethod;
        this.mName = pMethod.getName();
        this.mLocalResourceHandle = new Resources(BUNDLE);
    }

    public String toString(String pTabs) {
        boolean isQuery = false;
        boolean isLeaf = false;
        String tabs = pTabs + "\t";
        String ownedParameter = this.generateOwnedParameter(tabs);
        String ownedComment = this.generateOwnedComment(this.mMethod, tabs);
        String ownedOperation = MessageFormat.format(this.mLocalResourceHandle.loadString("OPERATION_METACLASS"), pTabs, this.mName, isQuery, this.isStatic(), isLeaf, this.mVisibility, ownedParameter, ownedComment);
        return ownedOperation;
    }

    private boolean isStatic() {
        return this.mMethod.hasQualifierValue("Static", (Object)Boolean.TRUE);
    }

    private String generateOwnedParameter(String pTabs) {
        StringBuffer parameterInfos = new StringBuffer();
        CIMParameter[] methodParameters = this.mMethod.getParameters();
        if (null != methodParameters && methodParameters.length > 0) {
            for (CIMParameter methodParameter : methodParameters) {
                ParameterMetaClass parameterMetaClass = new ParameterMetaClass(methodParameter);
                parameterInfos.append(parameterMetaClass.toString(pTabs));
            }
        }
        return parameterInfos.toString();
    }
}

