/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.account;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import sanproject.client.account.RJAccApplyData;
import sanproject.client.account.RJAccDef;
import sanproject.client.account.RJAccIconTable;
import sanproject.client.com.RJcAbsDataSupplier;
import sanproject.client.com.RJcException;
import sanproject.client.data.RJDataControl;
import sanproject.client.data.RJDataMethodInfo;
import sanproject.client.data.RJDataStartParam;
import sanproject.common.RCobj_interface_CheckRet;
import sanproject.serverux.data.ChgUserEntryList;
import sanproject.serverux.data.ChgUserPasswordList;
import sanproject.serverux.data.DelUserEntry;
import sanproject.serverux.data.SetUserEntryList;
import sanproject.serverux.data.UserEntryInfoSx;
import sanproject.serverux.data.UserPasswordList;
import sanproject.serverux.dataimpl.PRMName;
import sanproject.serverux.dataimpl.PRMSLPRName;

public class RJAccDataSupplier
extends RJcAbsDataSupplier
implements RJAccDef {
    private boolean modify = false;
    private RJAccApplyData applyData = null;
    private ArrayList slprList = new ArrayList();
    public String strLoginUserName = null;
    private UserEntryInfoSx[] UserEntryInfo = null;
    private UserPasswordList[] UserPassword = null;
    private PRMName SlprName = null;
    private RJDataStartParam wParamData = null;

    public RJAccDataSupplier() {
        this(null);
    }

    public RJAccDataSupplier(RJDataControl rJDataControl) {
        super(rJDataControl);
        RJAccIconTable.setDataControl(rJDataControl);
    }

    public void initialize() throws RJcException {
        this.strLoginUserName = this.remakeUsrName(this.getLoginUserNameFromRMI());
        this.UserEntryInfo = this.chgUsrListSlpr(this.getUserEntryInfoSx());
        this.UserPassword = this.getUserPasswordListFromRMI();
        this.SlprName = this.getUserSlprNameFromRMI();
    }

    private String remakeUsrName(String string) {
        int n;
        if (this.getVenderID() == 10 && (n = this.getDataControl().getStartParamClass().getCryptFlag_int()) == 4) {
            string = "";
        }
        return string;
    }

    public boolean isModify() {
        return this.modify;
    }

    public void setMode(boolean bl) {
        this.modify = bl && !this.chkHP_CmnView();
    }

    public boolean chkHP_CmnView() {
        boolean bl = false;
        if (this.getVenderID() == 10 && this.getDataControl().getStartParamClass().getCryptFlag_int() == 2) {
            bl = true;
        }
        return bl;
    }

    public RJAccApplyData getApplyData() {
        if (this.applyData == null) {
            this.applyData = new RJAccApplyData(this);
        }
        return this.applyData;
    }

    public void setObject(Object object) {
        this.putLogApplyObject(object);
        super.setObject(object);
    }

    private void putLogApplyObject(Object object) {
        if (object instanceof ArrayList) {
            this.putLog("[Account]", "[ApplyArg]", "DelUserEntryList ");
            String string = "";
            Iterator iterator = ((ArrayList)object).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                if (n % 8 == 0 & n != 0) {
                    this.putLog("[Account]", "[ApplyArg]", "        " + string);
                    string = "";
                }
                DelUserEntry delUserEntry = (DelUserEntry)iterator.next();
                string = string + "[" + delUserEntry.strUserID + "]";
                ++n;
            }
            this.putLog("[Account]", "[ApplyArg]", "        " + string);
        }
    }

    public String getLoginUserNameFromRMI() {
        return this.controller.getUserName();
    }

    public int getAccountPermissionFromRMI() {
        int n = 0;
        this.wParamData = this.getDataControl().getStartParamClass();
        boolean bl = this.wParamData.getTABOption(0, 64);
        boolean bl2 = this.wParamData.getPermissionTABOption(0, 64);
        n = bl2 && bl ? 2 : (bl ? 1 : 0);
        return n;
    }

    private UserEntryInfoSx[] getUserEntryInfoSx() throws RJcException {
        RJDataMethodInfo rJDataMethodInfo = new RJDataMethodInfo("getUserEntryInfoSx");
        this.waitControl();
        this.controller.getServerInfo(rJDataMethodInfo);
        this.confirm();
        return (UserEntryInfoSx[])this.controller.getServerInfoData();
    }

    private UserPasswordList[] getUserPasswordListFromRMI() throws RJcException {
        this.waitControl();
        this.controller.getUserPasswordList();
        this.confirm();
        return this.controller.getUserPasswordListData();
    }

    private PRMName getUserSlprNameFromRMI() throws RJcException {
        this.waitControl();
        this.controller.getPRMName();
        this.confirm();
        return this.controller.getPRMNameData();
    }

    public boolean IsBuiltInACC(String string) {
        boolean bl = false;
        if (string.equals("root") && this.getVenderID() != 10 || string.equals("administrator") && this.getVenderID() == 10) {
            bl = true;
        }
        return bl;
    }

    public void setUserEntryListToRMI(SetUserEntryList setUserEntryList) {
        this.controller.setObject(setUserEntryList);
    }

    public void chgUserEntryListToRMI(ChgUserEntryList chgUserEntryList) {
        this.controller.setObject(chgUserEntryList);
    }

    public void delUserEntryListToRMI(DelUserEntry delUserEntry) {
        this.controller.setObject(delUserEntry);
    }

    public void chgUserPasswordListToRMI(ChgUserPasswordList chgUserPasswordList) {
        this.controller.setObject(chgUserPasswordList);
    }

    public String getUserPasswordStrFromUserID(String string) {
        int n = 0;
        String string2 = "";
        for (n = 0; n < this.UserPassword.length; ++n) {
            if (!this.UserPassword[n].strUserID.equals(string)) continue;
            string2 = this.UserPassword[n].strHashPassword;
            break;
        }
        return string2;
    }

    public ArrayList getSlprNameArrayList() {
        ArrayList<PRMSLPRName> arrayList = new ArrayList<PRMSLPRName>();
        PRMSLPRName pRMSLPRName = new PRMSLPRName();
        boolean bl = false;
        if (this.getMySLPRID() == Short.MAX_VALUE && this.getAccountPermissionFromRMI() != 0) {
            pRMSLPRName.nID = Short.MAX_VALUE;
            pRMSLPRName.strName = "SA";
            arrayList.add(pRMSLPRName);
            for (int i = 1; i < 32; ++i) {
                pRMSLPRName = new PRMSLPRName();
                pRMSLPRName.nID = (short)i;
                pRMSLPRName.strName = this.getSlprName(i);
                arrayList.add(pRMSLPRName);
            }
        } else if (this.getMySLPRID() == Short.MAX_VALUE) {
            pRMSLPRName.nID = Short.MAX_VALUE;
            pRMSLPRName.strName = "SA";
            arrayList.add(pRMSLPRName);
        } else {
            pRMSLPRName.nID = (short)this.getMySLPRID();
            pRMSLPRName.strName = this.getSlprName(this.getMySLPRID());
            arrayList.add(pRMSLPRName);
        }
        return arrayList;
    }

    private String getSlprName(int n) {
        Object[] objectArray;
        int n2 = 0;
        String string = null;
        for (n2 = 0; n2 < this.SlprName.prmSLPRName.length; ++n2) {
            if (this.SlprName.prmSLPRName[n2].nID != n) continue;
            objectArray = new Object[]{new Integer(this.SlprName.prmSLPRName[n2].nID), this.SlprName.prmSLPRName[n2].strName};
            string = MessageFormat.format("{0,number,00}:{1}", objectArray);
            break;
        }
        if (n2 == this.SlprName.prmSLPRName.length) {
            objectArray = new Object[]{new Integer(n), new Integer(n)};
            string = MessageFormat.format("{0,number,00}:SLPR{1,number,00}", objectArray);
        }
        return string;
    }

    public ArrayList getUserEntryInfo(int n) {
        int n2;
        ArrayList<UserEntryInfoSx> arrayList = new ArrayList<UserEntryInfoSx>();
        if (this.getAccountPermissionFromRMI() != 0) {
            n2 = 0;
            for (n2 = 0; n2 < this.UserEntryInfo.length; ++n2) {
                if (this.UserEntryInfo[n2].getNSLPRno() != n) continue;
                arrayList.add(this.UserEntryInfo[n2]);
            }
        } else {
            n2 = this.getLoginUserEntryIndex();
            if (n2 < this.UserEntryInfo.length) {
                arrayList.add(this.UserEntryInfo[n2]);
            }
        }
        ArrayList arrayList2 = this.UserEntrySort(arrayList);
        return arrayList2;
    }

    private ArrayList UserEntrySort(ArrayList arrayList) {
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        Object[] objectArray = arrayList.toArray();
        AccComparetor accComparetor = new AccComparetor();
        Arrays.sort(objectArray, accComparetor);
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList2.add(objectArray[i]);
        }
        return arrayList2;
    }

    private int getLoginUserEntryIndex() {
        int n;
        for (n = 0; n < this.UserEntryInfo.length && !this.UserEntryInfo[n].getStrUserID().equals(this.strLoginUserName); ++n) {
        }
        return n;
    }

    public int getMySLPRID() {
        RCobj_interface_CheckRet rCobj_interface_CheckRet = this.controller.getCheckRetObjSx();
        int n = rCobj_interface_CheckRet.getNSLPR();
        if (this.getVenderID() == 10 && this.getDataControl().getStartParamClass().getCryptFlag_int() == 4) {
            n = Short.MAX_VALUE;
        }
        n = RJAccDataSupplier.chgSlprID_O2I(n);
        System.out.println(n);
        return n;
    }

    private UserEntryInfoSx[] chgUsrListSlpr(UserEntryInfoSx[] userEntryInfoSxArray) {
        for (int i = 0; i < userEntryInfoSxArray.length; ++i) {
            userEntryInfoSxArray[i].nSLPRno = RJAccDataSupplier.chgSlprID_O2I(userEntryInfoSxArray[i].nSLPRno);
        }
        return userEntryInfoSxArray;
    }

    public static int chgSlprID_O2I(int n) {
        if (n == 65535) {
            n = Short.MAX_VALUE;
        }
        return n;
    }

    public static int chgSlprID_I2O(int n) {
        if (n == Short.MAX_VALUE) {
            n = 65535;
        }
        return n;
    }

    class AccComparetor
    implements Comparator {
        AccComparetor() {
        }

        public int compare(Object object, Object object2) {
            int n = 0;
            String string = ((UserEntryInfoSx)object).getStrUserID();
            String string2 = ((UserEntryInfoSx)object2).getStrUserID();
            n = string.compareTo(string2);
            return n;
        }

        public boolean equals(Object object) {
            return true;
        }
    }
}

