/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.com.restoreview;

import java.awt.Component;
import javax.swing.JComboBox;
import sanproject.client.com.restoreview.ComboBoxComponentParser;
import sanproject.client.com.restoreview.ComponentParser;
import sanproject.client.com.restoreview.DefaultComboBoxComponentParser;
import sanproject.client.com.restoreview.UnsupportedComponentException;
import sanproject.client.com.restoreview.UnsupportedRestoreModeException;
import sanproject.client.com.restoreview.ViewRestorer;
import sanproject.client.com.restoreview.utility.ComboBoxComponentUtilities;

public class DefaultComboBoxViewRestorer
implements ViewRestorer {
    private int miRestoreMode;
    private JComboBox mclsSaveComboBox;
    private ComboBoxComponentParser mclsComponentParser;

    public DefaultComboBoxViewRestorer() {
        this.initInstance();
    }

    public DefaultComboBoxViewRestorer(JComboBox jComboBox) throws UnsupportedComponentException {
        this();
        this.saveViewComponent(jComboBox);
    }

    private void initInstance() {
        int n = 0;
        n |= 1;
        try {
            this.setRestoreMode(n);
        }
        catch (UnsupportedRestoreModeException unsupportedRestoreModeException) {
            throw new RuntimeException();
        }
        this.mclsComponentParser = this.createDefaultComponentParser();
    }

    protected void finalize() throws Throwable {
        this.mclsSaveComboBox = null;
        this.mclsComponentParser = null;
        super.finalize();
    }

    public void saveViewComponent(Component component) throws UnsupportedComponentException {
        if (!(component instanceof JComboBox)) {
            String string = "Any components other than 'javax.swing.JComboBox' are not supported.";
            throw new UnsupportedComponentException(string);
        }
        try {
            JComboBox jComboBox = (JComboBox)component;
            this.mclsSaveComboBox = ComboBoxComponentUtilities.createCopyComboBox(jComboBox);
            ComboBoxComponentParser comboBoxComponentParser = (ComboBoxComponentParser)this.getComponentParser();
            comboBoxComponentParser.setAnalysisComponent(this.mclsSaveComboBox);
            Object object = jComboBox.getSelectedItem();
            int n = comboBoxComponentParser.searchComboBoxRow(object);
            if (n != -1) {
                this.mclsSaveComboBox.setSelectedIndex(n);
            }
        }
        catch (Exception exception) {
            System.err.println("[Default ComboBox]Save View Failure");
            exception.printStackTrace();
            this.releaseSavedViewComponent();
        }
    }

    public void restoreViewComponent(Component component) throws UnsupportedComponentException {
        if (!(component instanceof JComboBox)) {
            String string = "Any components other than 'javax.swing.JComboBox' are not supported.";
            throw new UnsupportedComponentException(string);
        }
        try {
            if (this.hasSavedViewComponent()) {
                Object object;
                int n;
                JComboBox jComboBox = (JComboBox)component;
                ComboBoxComponentParser comboBoxComponentParser = (ComboBoxComponentParser)this.getComponentParser();
                comboBoxComponentParser.setAnalysisComponent(jComboBox);
                int n2 = this.getRestoreMode();
                if ((n2 & 1) > 0 && (n = comboBoxComponentParser.searchComboBoxRow(object = this.mclsSaveComboBox.getSelectedItem())) != -1) {
                    jComboBox.setSelectedIndex(n);
                }
            }
        }
        catch (Exception exception) {
            System.err.println("[Default ComboBox]Restore View Failure");
            exception.printStackTrace();
        }
    }

    public void setRestoreMode(int n) throws UnsupportedRestoreModeException {
        if (!this.isSupportedRestoreMode(n)) {
            String string = "The parameter which is not supported was specified [" + n + "].";
            throw new UnsupportedRestoreModeException(string);
        }
        this.miRestoreMode = n;
    }

    public int getRestoreMode() {
        return this.miRestoreMode;
    }

    public void setComponentParser(ComponentParser componentParser) throws IllegalArgumentException {
        if (componentParser == null || !(componentParser instanceof ComboBoxComponentParser)) {
            String string = "Any components other than 'restoreview.ComboBoxComponentParser' are not supported.";
            throw new IllegalArgumentException(string);
        }
        this.mclsComponentParser = (ComboBoxComponentParser)componentParser;
    }

    public ComponentParser getComponentParser() {
        return this.mclsComponentParser;
    }

    public boolean isSupportedRestoreMode(int n) {
        int n2 = n;
        return (n2 &= 0xFFFFFFFE) == 0;
    }

    public boolean hasSavedViewComponent() {
        return this.mclsSaveComboBox != null;
    }

    public void releaseSavedViewComponent() {
        this.mclsSaveComboBox = null;
    }

    protected ComboBoxComponentParser createDefaultComponentParser() {
        return new DefaultComboBoxComponentParser();
    }

    protected JComboBox getSavedViewComponent() {
        return this.mclsSaveComboBox;
    }
}

