/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.cvs.com;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComCBox;
import sanproject.client.com.RJComFont;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.RJcPanel;
import sanproject.client.cvs.com.RJCVSComUty;
import sanproject.client.cvs.com.RJCVSMacro;
import sanproject.client.cvs.com.RJCVSTablePanel;
import sanproject.client.cvs.com.RJCVSTreePanel;
import sanproject.client.cvs.data.RJCVSDataSupplier;
import sanproject.client.cvs.data.RJCVSMakeData;
import sanproject.client.cvs.dlg.RJCVSAttributeDlg;
import sanproject.client.cvs.dlg.RJCVSCreateCVDlg;
import sanproject.client.cvs.dlg.RJCVSDetailDlg;
import sanproject.client.cvs.dlg.RJCVSLDEVDlg;
import sanproject.client.cvs.dlg.RJCVSRepPGDlg;
import sanproject.client.cvs.dlg.RJCVSSSIDDlg;

public class RJCVSCenterPanel
extends RJcPanel
implements RJCVSMacro {
    RJCVSDataSupplier supplier;
    private RJCVSTreePanel treePanel;
    private RJCVSTablePanel TablePanel;
    private RJComCBox CapacityComb;
    private JToggleButton DetailBtn;
    private boolean m_Doing;
    private CardLayout LDEVTblPanel_Layout;
    private JPanel TblCardPanel;
    private JLabel PresetCntLabel;

    public RJCVSCenterPanel(RJCVSDataSupplier rJCVSDataSupplier) {
        this.supplier = rJCVSDataSupplier;
        this.setLayout(new BorderLayout());
        this.add((Component)this.createCenterPanel(), "Center");
        this.addMouseListener(this.createHiddenCommandMouseListener());
        this.setOpaque(false);
    }

    private JPanel createCenterPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.getTitlePanel(), "North");
        jPanel.add((Component)this.getBottomPanel(), "Center");
        return jPanel;
    }

    private JPanel getTitlePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(RJcGuide.text("COMMON/PGLDEV"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        jLabel.setFont(RJComFont.labelFont);
        jLabel.setForeground(Color.WHITE);
        JPanel jPanel2 = new JPanel();
        jPanel2.setMaximumSize(new Dimension(10, 10));
        jPanel.add((Component)jPanel2, "South");
        jPanel.add((Component)jLabel, "Center");
        jPanel.add((Component)this.getDetailPanel(), "East");
        jPanel.setBackground(RJcGuide.color("CVS/CVSTitlebarBgClr"));
        return jPanel;
    }

    private JPanel getDetailPanel() {
        this.m_Doing = false;
        JPanel jPanel = new JPanel();
        this.CapacityComb = new RJComCBox();
        this.CapacityComb.setPreferredSize(new Dimension(100, 24));
        this.CapacityComb.setBackground(Color.WHITE);
        this.CapacityComb.setFont(RJComFont.itemFont);
        this.CapacityComb.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1 && RJCVSCenterPanel.this.m_Doing) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            RJCVSCenterPanel.this.chgCapacity();
                        }
                    });
                }
            }
        });
        this.CapacityComb.addItem(RJcGuide.text("COMMON/UNIT_MB"));
        this.CapacityComb.addItem(RJcGuide.text("COMMON/UNIT_CYL"));
        this.CapacityComb.addItem(RJcGuide.text("CVS/CAPUNITCMBBLK"));
        this.DetailBtn = new JToggleButton(RJcGuide.text("COMMON/Detail"));
        this.DetailBtn.setFont(RJComFont.buttonFont);
        this.DetailBtn.setPreferredSize(new Dimension(100, 24));
        this.DetailBtn.setSelected(true);
        this.DetailBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJCVSCenterPanel.this.Detail_actionPerformed();
            }
        });
        jPanel.add((Component)this.CapacityComb, "Center");
        jPanel.add((Component)this.DetailBtn, "East");
        this.DetailBtn.setVisible(false);
        jPanel.setOpaque(false);
        this.m_Doing = true;
        return jPanel;
    }

    private void chgCapacity() {
        if (this.m_Doing) {
            this.reset();
        }
    }

    private void Detail_actionPerformed() {
        if (this.m_Doing) {
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        try {
            RJCom.waitCursor(this);
            this.treePanel.resetSelectionPath();
            this.setPresetcount();
        }
        catch (Exception exception) {
            System.out.println("reset-Excception");
        }
        finally {
            RJCom.defCursor(this);
        }
    }

    public void init() {
        this.TablePanel.init();
        this.treePanel.init();
        this.setPresetcount();
    }

    private void setPresetcount() {
        int[] nArray = this.supplier.getApplyPGLDEVcount();
        this.PresetCntLabel.setText("  " + RJcGuide.text("COMMON/PG") + "  " + ":" + "  " + nArray[0] + "  " + RJcGuide.text("COMMON/LDEV") + "  " + ":" + "  " + nArray[1]);
    }

    private JSplitPane getBottomPanel() {
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setOrientation(1);
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setDividerSize(4);
        jSplitPane.setDividerLocation(240);
        jSplitPane.setOpaque(false);
        jSplitPane.add((Component)this.createTreePanel(), "left");
        jSplitPane.add((Component)this.createTablePanel(), "right");
        this.showCardPanel("LDEVTBLPANEL");
        return jSplitPane;
    }

    private JPanel createTreePanel() {
        JPanel jPanel = new JPanel(new BorderLayout(8, 4));
        Border border = BorderFactory.createEmptyBorder(4, 8, 4, 8);
        this.treePanel = new RJCVSTreePanel(this.supplier, this);
        this.treePanel.setBorder(border);
        this.treePanel.setBackground(RJcGuide.color("CVS/CVSTreePanelBgClr"));
        jPanel.setOpaque(false);
        this.treePanel.init();
        jPanel.add((Component)this.treePanel, "Center");
        jPanel.add((Component)this.getPresetPanel(), "South");
        return jPanel;
    }

    private JPanel getPresetPanel() {
        JPanel jPanel = new JPanel();
        this.PresetCntLabel = new JLabel();
        this.PresetCntLabel.setFont(RJComFont.labelFont);
        jPanel.setLayout(new BorderLayout());
        jPanel.setBackground(Color.WHITE);
        jPanel.add((Component)this.PresetCntLabel, "Center");
        return jPanel;
    }

    private JPanel createTablePanel() {
        if (this.TblCardPanel == null) {
            this.TblCardPanel = new JPanel();
            this.LDEVTblPanel_Layout = new CardLayout();
            this.TblCardPanel.setLayout(this.LDEVTblPanel_Layout);
            this.TblCardPanel.add((Component)this.VolInitPnl(), "VOLINITPANEL");
            this.TblCardPanel.add((Component)this.LDEVTablePanel(), "LDEVTBLPANEL");
        }
        return this.TblCardPanel;
    }

    private JPanel LDEVTablePanel() {
        JPanel jPanel = new JPanel(new BorderLayout(8, 4));
        Border border = BorderFactory.createEmptyBorder(4, 8, 4, 8);
        this.TablePanel = new RJCVSTablePanel(this.supplier);
        this.TablePanel.setTreePanel(this.treePanel);
        this.TablePanel.setBorder(border);
        this.TablePanel.setBackground(RJcGuide.color("CVS/CVSTblPanelBgClr"));
        jPanel.setOpaque(false);
        jPanel.add((Component)this.TablePanel, "Center");
        return jPanel;
    }

    private JPanel VolInitPnl() {
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel(RJcGuide.text("CVS/MSKLBL"));
        jPanel.add((Component)jLabel, "Center");
        return jPanel;
    }

    public RJCVSTreePanel getTreePanel() {
        return this.treePanel;
    }

    public RJCVSTablePanel getTablePanel() {
        return this.TablePanel;
    }

    public String getCapacityUnit() {
        return (String)this.CapacityComb.getSelectedItem();
    }

    public boolean isDetalBtn() {
        return this.DetailBtn.isSelected();
    }

    public boolean chkPopupMenu(MouseEvent mouseEvent) {
        boolean bl = false;
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (jPopupMenu.isPopupTrigger(mouseEvent)) {
            bl = true;
        }
        return bl;
    }

    public boolean setCVS(RJCVSMakeData rJCVSMakeData) {
        boolean bl = false;
        String string = RJCVSComUty.getApplySts_CVSDlgTtile(rJCVSMakeData.getISetData());
        int n = RJCVSComUty.getApplySts_CVSDlg(rJCVSMakeData.getISetData());
        boolean bl2 = true;
        if (rJCVSMakeData.getISetData() == 2 && rJCVSMakeData.getLDEVList().size() == 0) {
            bl2 = false;
            n = 6;
        }
        rJCVSMakeData.createLDEVID();
        block9: while (bl2) {
            switch (n) {
                case 1: {
                    RJCVSCreateCVDlg rJCVSCreateCVDlg = new RJCVSCreateCVDlg(RJComUty.getTopFrame(this), string, rJCVSMakeData);
                    rJCVSCreateCVDlg.show();
                    n = rJCVSCreateCVDlg.getIDlgStatus();
                    continue block9;
                }
                case 2: {
                    RJCVSLDEVDlg rJCVSLDEVDlg = new RJCVSLDEVDlg(RJComUty.getTopFrame(this), string, rJCVSMakeData);
                    rJCVSLDEVDlg.show();
                    n = rJCVSLDEVDlg.getIDlgStatus();
                    continue block9;
                }
                case 3: {
                    RJCVSSSIDDlg rJCVSSSIDDlg = new RJCVSSSIDDlg(RJComUty.getTopFrame(this), string, rJCVSMakeData);
                    rJCVSSSIDDlg.show();
                    n = rJCVSSSIDDlg.getIDlgStatus();
                    continue block9;
                }
                case 4: {
                    RJCVSAttributeDlg rJCVSAttributeDlg = new RJCVSAttributeDlg(RJComUty.getTopFrame(this), string, rJCVSMakeData);
                    rJCVSAttributeDlg.show();
                    n = rJCVSAttributeDlg.getIDlgStatus();
                    continue block9;
                }
                case 5: {
                    RJCVSDetailDlg rJCVSDetailDlg = new RJCVSDetailDlg(RJComUty.getTopFrame(this), string, rJCVSMakeData);
                    rJCVSDetailDlg.show();
                    n = rJCVSDetailDlg.getIDlgStatus();
                    continue block9;
                }
                case 0: {
                    System.out.println("Cancel--Push");
                    bl2 = false;
                    continue block9;
                }
                case 6: {
                    System.out.println("OK--Push");
                    bl2 = false;
                    continue block9;
                }
            }
            System.out.println("Default");
            bl2 = false;
        }
        if (n == 6) {
            this.supplier.setCVS_ApplyObj(rJCVSMakeData);
            bl = true;
        }
        return bl;
    }

    public void showRepPGDlg(int n, int n2, int n3) {
        RJCVSRepPGDlg rJCVSRepPGDlg = new RJCVSRepPGDlg(RJComUty.getTopFrame(this), this.supplier.getPGtoRepPG(n, n2), n3);
        rJCVSRepPGDlg.show();
    }

    public void showCardPanel(String string) {
        this.LDEVTblPanel_Layout.show(this.createTablePanel(), string);
    }

    public void chgCapacityComb(boolean bl) {
        this.m_Doing = false;
        if (bl) {
            this.CapacityComb.setEnabled(true);
        } else {
            this.CapacityComb.setSelectedItem(RJcGuide.text("COMMON/UNIT_CYL"));
            this.CapacityComb.setEnabled(false);
        }
        this.m_Doing = true;
    }

    public MouseListener createHiddenCommandMouseListener() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getModifiers();
                if ((n & 2) > 0 && (n & 1) > 0 && (n & 8) > 0) {
                    if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                        RJCVSCenterPanel.this.DetailBtn.setVisible(true);
                    }
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        RJCVSCenterPanel.this.DetailBtn.setVisible(false);
                    }
                }
            }
        };
        return mouseAdapter;
    }
}

