/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.luoperation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import sanproject.client.com.RJcCushionPanel;
import sanproject.client.com.RJcDlgMainTitlePanel;
import sanproject.client.com.RJcMainTitlePanel;
import sanproject.client.exdevice.com.Button;
import sanproject.client.exdevice.com.DefaultTablePanel;
import sanproject.client.exdevice.com.DialogContentsPanel;
import sanproject.client.exdevice.com.Message;
import sanproject.client.exdevice.data.AddVolumeData;
import sanproject.client.exdevice.data.EXDException;
import sanproject.client.exdevice.data.EmulationTypeInfo;
import sanproject.client.exdevice.data.ExternalVolumeInfo;
import sanproject.client.exdevice.data.LdevManager;
import sanproject.client.exdevice.luoperation.AddVolumeConfigElement;
import sanproject.client.exdevice.luoperation.AddVolumeDirectorElement;
import sanproject.client.exdevice.luoperation.HDEVElement;
import sanproject.client.exdevice.luoperation.HDEVTableDataModel;
import sanproject.client.exdevice.luoperation.LDEVMapPanel;
import sanproject.client.exdevice.luoperation.LDEVSelectPanel;
import sanproject.client.exdevice.luoperation.LocalGuidance;
import sanproject.common.Robj_interface_RJiCUIndex;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.serversx.data.RJiCUIndex;
import sanproject.serverux.dataimpl.RJiLDEVInfoDetail;

public class LDEVMappingPanel
extends DialogContentsPanel {
    private static final String KEY_NAME = "LDEVMapping";
    private AddVolumeDirectorElement volumeDirector;
    private AddVolumeConfigElement[] targets;
    private transient EmulationTypeInfo targetEmulation;
    private int targetSLPR;
    private transient HDEVTableDataModel hdevListDataModel;
    private DefaultTablePanel hdevList;
    private LDEVSelectPanel selectionPanel;
    private Button applyButton;
    private Button cancelButton;

    public LDEVMappingPanel(AddVolumeDirectorElement addVolumeDirectorElement, AddVolumeConfigElement[] addVolumeConfigElementArray, EmulationTypeInfo emulationTypeInfo, int n) {
        this.volumeDirector = addVolumeDirectorElement;
        this.targets = (AddVolumeConfigElement[])addVolumeConfigElementArray.clone();
        this.targetEmulation = emulationTypeInfo;
        this.targetSLPR = n;
        this.hdevListDataModel = null;
        this.hdevList = null;
        this.selectionPanel = null;
        this.applyButton = null;
        this.cancelButton = null;
        this.initializePanel();
        this.buildPanelLayout();
    }

    public void addNotify() {
        Object object;
        super.addNotify();
        final Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            object = new WindowAdapter(){

                public void windowOpened(WindowEvent windowEvent) {
                    LDEVMappingPanel.this.putLog(LDEVMappingPanel.KEY_NAME, "[LDEVMapping] opened.");
                    try {
                        LDEVMappingPanel.this.updateHDEVList();
                    }
                    catch (EXDException eXDException) {
                        LDEVMappingPanel.this.processEXDException(eXDException);
                    }
                }

                public void windowClosed(WindowEvent windowEvent) {
                    LDEVMappingPanel.this.putLog(LDEVMappingPanel.KEY_NAME, "[LDEVMapping] closed.");
                    window.removeWindowListener(this);
                }
            };
            window.addWindowListener((WindowListener)object);
        }
        if ((object = this.getWindowRootPane()) != null) {
            ((JRootPane)object).setDefaultButton(this.cancelButton);
        }
    }

    public String getWindowName() {
        String string = "ExDevice_LU";
        return string;
    }

    private void initializePanel() {
        Object object = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    LDEVMappingPanel.this.putLog(LDEVMappingPanel.KEY_NAME, "[LDEVMapping] update LDEVMap Selection(HDEVList).");
                    LDEVMappingPanel.this.updateLDEVMapSelection();
                }
            }
        };
        this.hdevListDataModel = new HDEVTableDataModel();
        this.hdevList = new DefaultTablePanel();
        this.hdevList.createTable(this.hdevListDataModel);
        this.hdevList.completedTable();
        EventListener eventListener = this.hdevList.getTable();
        ListSelectionModel listSelectionModel = eventListener.getSelectionModel();
        listSelectionModel.addListSelectionListener((ListSelectionListener)object);
        Dimension dimension = eventListener.getPreferredSize();
        JScrollPane jScrollPane = this.hdevList.getScrollPane();
        jScrollPane.setPreferredSize(dimension);
        jScrollPane.setVerticalScrollBarPolicy(22);
        object = new LDEVSelectPanel.SelectPanelListener(){

            public void selectionChanged(LDEVSelectPanel.SelectPanelEvent selectPanelEvent) {
                LDEVMappingPanel.this.putLog(LDEVMappingPanel.KEY_NAME, "[LDEVMapping] update LDEVMap Selection(LDEVSelectPanel).");
                LDEVMappingPanel.this.updateLDEVMapSelection();
            }
        };
        eventListener = new LDEVMapPanel.TileSelectedListener(){

            public void tileSelected(LDEVMapPanel.TileSelectedEvent tileSelectedEvent) {
                LDEVMappingPanel.this.putLog(LDEVMappingPanel.KEY_NAME, "[LDEVMapping] LDEVTile Selected.");
                int n = LDEVMappingPanel.this.selectionPanel.getLDKCNumber();
                int n2 = LDEVMappingPanel.this.selectionPanel.getCUNumber();
                int n3 = tileSelectedEvent.getLDEVIndex();
                RJiLDEVInfoDetail rJiLDEVInfoDetail = new RJiLDEVInfoDetail();
                rJiLDEVInfoDetail.setLDEVIndex((short)n, (short)n2, (short)n3);
                HDEVElement[] hDEVElementArray = LDEVMappingPanel.this.hdevListDataModel.getSelectedHDEVElements();
                LDEVMappingPanel.this.executeLDEVMapping(hDEVElementArray, rJiLDEVInfoDetail);
            }
        };
        this.selectionPanel = new LDEVSelectPanel(this.volumeDirector, this.targetEmulation, this.targetSLPR, false);
        this.selectionPanel.setEnabledLDEVMap(false);
        this.selectionPanel.addSelectPanelListener((LDEVSelectPanel.SelectPanelListener)object);
        this.selectionPanel.addTileSelectedListener((LDEVMapPanel.TileSelectedListener)eventListener);
        object = LocalGuidance.BUTTON_OK.getItemID();
        eventListener = new AbstractAction((String)object){

            public void actionPerformed(ActionEvent actionEvent) {
                LDEVMappingPanel.this.putLog(LDEVMappingPanel.KEY_NAME, "[LDEVMapping] onClick Apply.");
                LDEVMappingPanel.this.onClickApply();
            }
        };
        this.applyButton = new Button((String)object);
        this.applyButton.setAction((Action)eventListener);
        object = LocalGuidance.BUTTON_CANCEL.getItemID();
        eventListener = new AbstractAction((String)object){

            public void actionPerformed(ActionEvent actionEvent) {
                LDEVMappingPanel.this.putLog(LDEVMappingPanel.KEY_NAME, "[LDEVMapping] onClick Close.");
                LDEVMappingPanel.this.onClickCancel();
            }
        };
        this.cancelButton = new Button((String)object);
        this.cancelButton.setAction((Action)eventListener);
    }

    private void buildPanelLayout() {
        Object object = LocalGuidance.TITLE_LDEVMAPPINGMANUAL.getItemID();
        JPanel jPanel = new RJcDlgMainTitlePanel();
        ((RJcMainTitlePanel)jPanel).setMainTitle((String)object);
        RJcDlgMainTitlePanel rJcDlgMainTitlePanel = jPanel;
        jPanel = new RJcCushionPanel((JComponent)this.hdevList, 1);
        LayoutManager layoutManager = new BorderLayout(4, 4);
        Serializable serializable = new JPanel();
        serializable.setLayout(layoutManager);
        serializable.setOpaque(false);
        serializable.add(this.selectionPanel, "North");
        layoutManager = new BorderLayout(4, 4);
        object = new JPanel();
        ((Container)object).setLayout(layoutManager);
        ((JComponent)object).setOpaque(false);
        ((Container)object).add((Component)jPanel, "Center");
        ((Container)object).add((Component)serializable, "East");
        layoutManager = new GridLayout(1, 0, 4, 4);
        serializable = new JPanel();
        serializable.setLayout(layoutManager);
        serializable.setOpaque(false);
        serializable.add(this.applyButton);
        serializable.add(this.cancelButton);
        layoutManager = new BorderLayout(4, 4);
        Border border = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        jPanel = new JPanel();
        jPanel.setLayout(layoutManager);
        jPanel.setOpaque(false);
        jPanel.setBorder(border);
        jPanel.add((Component)serializable, "East");
        serializable = new BorderLayout(4, 4);
        this.setLayout((LayoutManager)((Object)serializable));
        this.add((Component)object, "Center");
        this.add((Component)rJcDlgMainTitlePanel, "North");
        this.add((Component)jPanel, "South");
    }

    private void updateHDEVList() throws EXDException {
        this.hdevListDataModel.removeAll();
        if (this.targets != null) {
            for (int i = 0; i < this.targets.length; ++i) {
                AddVolumeConfigElement addVolumeConfigElement = this.targets[i];
                ExternalVolumeInfo externalVolumeInfo = addVolumeConfigElement.getVolumeInfo();
                AddVolumeData addVolumeData = addVolumeConfigElement.getConfigData();
                RJiLDEVInfoDetail[] rJiLDEVInfoDetailArray = addVolumeData.getLdevInfo();
                if (rJiLDEVInfoDetailArray == null) continue;
                for (int j = 0; j < rJiLDEVInfoDetailArray.length; ++j) {
                    RJiLDEVInfoDetail rJiLDEVInfoDetail = rJiLDEVInfoDetailArray[j];
                    HDEVElement hDEVElement = new HDEVElement(externalVolumeInfo, rJiLDEVInfoDetail);
                    this.hdevListDataModel.addRow(hDEVElement);
                }
            }
        }
    }

    private void updateLDEVMapSelection() {
        HDEVElement[] hDEVElementArray = this.hdevListDataModel.getSelectedHDEVElements();
        if (hDEVElementArray != null) {
            boolean bl = hDEVElementArray.length > 0;
            this.selectionPanel.setEnabledLDEVMap(bl);
            int n = this.selectionPanel.getLDKCNumber();
            int n2 = this.selectionPanel.getCUNumber();
            RJiCUIndex rJiCUIndex = new RJiCUIndex();
            rJiCUIndex.setCUIndex((short)n, (short)n2);
            ArrayList<RJiLDEVInfoDetail> arrayList = new ArrayList<RJiLDEVInfoDetail>();
            arrayList.ensureCapacity(hDEVElementArray.length);
            for (n2 = 0; n2 < hDEVElementArray.length; ++n2) {
                HDEVElement hDEVElement = hDEVElementArray[n2];
                if (!hDEVElement.isSame((Robj_interface_RJiCUIndex)rJiCUIndex)) continue;
                RJiLDEVInfoDetail rJiLDEVInfoDetail = hDEVElement.getDetailInfo();
                arrayList.add(rJiLDEVInfoDetail);
            }
            int[] nArray = new int[]{};
            if (!arrayList.isEmpty()) {
                int n3 = arrayList.size();
                nArray = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    RJiLDEVInfoDetail rJiLDEVInfoDetail = (RJiLDEVInfoDetail)arrayList.get(i);
                    short s = rJiLDEVInfoDetail.getSLDEV();
                    nArray[i] = s;
                }
            }
            this.selectionPanel.setSelectedIndexes(nArray);
        } else {
            this.selectionPanel.setEnabledLDEVMap(false);
        }
    }

    private void executeLDEVMapping(HDEVElement[] hDEVElementArray, RJiLDEVInfoDetail rJiLDEVInfoDetail) {
        if (hDEVElementArray != null && rJiLDEVInfoDetail != null) {
            Object object;
            boolean bl;
            ArrayList<RJiLDEVInfoDetail> arrayList = new ArrayList<RJiLDEVInfoDetail>();
            arrayList.ensureCapacity(hDEVElementArray.length);
            for (bl = false; bl < hDEVElementArray.length; bl += 1) {
                object = hDEVElementArray[bl];
                RJiLDEVInfoDetail rJiLDEVInfoDetail2 = ((HDEVElement)object).getDetailInfo();
                arrayList.add(rJiLDEVInfoDetail2);
            }
            RJiLDEVInfoDetail[] rJiLDEVInfoDetailArray = new RJiLDEVInfoDetail[]{};
            rJiLDEVInfoDetailArray = arrayList.toArray(rJiLDEVInfoDetailArray);
            int n = this.selectionPanel.getMappingInterval();
            bl = this.selectionPanel.isSLPRLimited();
            object = LdevManager.getInstance();
            ((LdevManager)object).removeLdevMap((Robj_interface_RJiLDEVIndex[])rJiLDEVInfoDetailArray);
            boolean bl2 = ((LdevManager)object).setLdevId(rJiLDEVInfoDetailArray, this.targetEmulation, (Robj_interface_RJiLDEVIndex)rJiLDEVInfoDetail, n, (short)this.targetSLPR, bl);
            for (int i = 0; i < hDEVElementArray.length; ++i) {
                HDEVElement hDEVElement = hDEVElementArray[i];
                this.hdevListDataModel.updateRow(hDEVElement);
            }
            this.updateLDEVMapSelection();
            if (!bl2) {
                Message.showOKDialog(this, 610, 59022);
            }
        }
    }

    private void chekLDEVs() throws EXDException {
        boolean bl = false;
        if (this.hdevListDataModel != null) {
            int n = this.hdevListDataModel.getRowCount();
            for (int i = 0; i < n; ++i) {
                String string;
                HDEVElement hDEVElement = (HDEVElement)this.hdevListDataModel.getElementAt(i);
                if (hDEVElement == null || (string = hDEVElement.getLDEVIdentifier()) != null) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            EXDException eXDException = new EXDException(610, 59017);
            throw eXDException;
        }
    }

    private void onClickApply() {
        try {
            this.chekLDEVs();
            this.setDialogStatus(APPLY_STATUS);
            this.closeContentDialog();
        }
        catch (EXDException eXDException) {
            this.processEXDException(eXDException);
        }
    }

    private void onClickCancel() {
        this.closeContentDialog();
    }
}

