/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.luoperation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import sanproject.client.com.RJComFont;
import sanproject.client.com.RJComSpringUtilities;
import sanproject.client.com.RJcCushionPanel;
import sanproject.client.com.RJcDlgMainTitlePanel;
import sanproject.client.com.RJcElement;
import sanproject.client.com.RJcListPanel;
import sanproject.client.com.RJcMainTitlePanel;
import sanproject.client.exdevice.com.Button;
import sanproject.client.exdevice.com.DialogContentsPanel;
import sanproject.client.exdevice.com.Message;
import sanproject.client.exdevice.com.RadioButton;
import sanproject.client.exdevice.data.EXDException;
import sanproject.client.exdevice.data.EmulationTypeInfo;
import sanproject.client.exdevice.data.LdevManager;
import sanproject.client.exdevice.data.PolicyInfo;
import sanproject.client.exdevice.luoperation.AddLUPolicyElement;
import sanproject.client.exdevice.luoperation.AddVolumeDirectorElement;
import sanproject.client.exdevice.luoperation.LDEVMapPanel;
import sanproject.client.exdevice.luoperation.LocalGuidance;
import sanproject.client.exdevice.utility.Debug;
import sanproject.common.Robj_interface_RJiCUIndex;
import sanproject.common.Robj_interface_RJiLDEVInfoDetail;
import sanproject.serversx.data.RJiCUIndex;
import sanproject.serverux.dataimpl.RJiLDEVInfoDetail;

public class LDEVSelectPanel
extends DialogContentsPanel {
    private static final String KEY_NAME = "LDEVSelect";
    private AddVolumeDirectorElement volumeDirector;
    private transient EmulationTypeInfo targetEmulation;
    private int targetSLPR;
    private boolean hasDecoration;
    private RadioButton slprLimited;
    private RadioButton slprUnlimited;
    private JComboBox ldkcCombo;
    private JComboBox cuCombo;
    private JComboBox intervalCombo;
    private LDEVMapPanel mapPanel;
    private Button applyButton;
    private Button cancelButton;
    private Robj_interface_RJiLDEVInfoDetail selectedLDEV;
    static /* synthetic */ Class class$sanproject$client$exdevice$luoperation$LDEVSelectPanel$SelectPanelListener;

    public LDEVSelectPanel(AddVolumeDirectorElement addVolumeDirectorElement, EmulationTypeInfo emulationTypeInfo, int n) {
        this(addVolumeDirectorElement, emulationTypeInfo, n, true);
    }

    public LDEVSelectPanel(AddVolumeDirectorElement addVolumeDirectorElement, EmulationTypeInfo emulationTypeInfo, int n, boolean bl) {
        this.volumeDirector = addVolumeDirectorElement;
        this.targetSLPR = n;
        this.targetEmulation = emulationTypeInfo;
        this.hasDecoration = bl;
        this.slprLimited = null;
        this.slprUnlimited = null;
        this.ldkcCombo = null;
        this.cuCombo = null;
        this.intervalCombo = null;
        this.mapPanel = null;
        this.applyButton = null;
        this.cancelButton = null;
        this.selectedLDEV = null;
        this.initializePanel();
        this.buildPanelLayout();
    }

    public void addNotify() {
        super.addNotify();
        if (this.hasDecoration) {
            Object object;
            final Window window = SwingUtilities.getWindowAncestor(this);
            if (window != null) {
                object = new WindowAdapter(){

                    public void windowOpened(WindowEvent windowEvent) {
                        LDEVSelectPanel.this.putLog(LDEVSelectPanel.KEY_NAME, "[LDEVSelect] opened.");
                    }

                    public void windowClosed(WindowEvent windowEvent) {
                        LDEVSelectPanel.this.putLog(LDEVSelectPanel.KEY_NAME, "[LDEVSelect] closed.");
                        window.removeWindowListener(this);
                    }
                };
                window.addWindowListener((WindowListener)object);
            }
            if ((object = this.getWindowRootPane()) != null) {
                ((JRootPane)object).setDefaultButton(this.cancelButton);
            }
        }
    }

    public String getWindowName() {
        String string = "ExDevice_LU";
        return string;
    }

    public void setEnabledLDEVMap(boolean bl) {
        this.mapPanel.setOperationEnabled(bl);
    }

    public void setSelectedIndexes(int[] nArray) {
        this.mapPanel.setSelectedIndexes(nArray);
    }

    public boolean isSLPRLimited() {
        boolean bl = this.slprLimited.isSelected();
        return bl;
    }

    public int getLDKCNumber() {
        int n;
        String string = (String)this.ldkcCombo.getSelectedItem();
        try {
            n = Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        return n;
    }

    public int getCUNumber() {
        int n;
        String string = (String)this.cuCombo.getSelectedItem();
        try {
            n = Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        return n;
    }

    public int getMappingInterval() {
        Integer n = (Integer)this.intervalCombo.getSelectedItem();
        int n2 = n;
        return n2;
    }

    public Robj_interface_RJiLDEVInfoDetail getSelectedLDEV() {
        Robj_interface_RJiLDEVInfoDetail robj_interface_RJiLDEVInfoDetail = this.selectedLDEV;
        return robj_interface_RJiLDEVInfoDetail;
    }

    public void addSelectPanelListener(SelectPanelListener selectPanelListener) {
        this.listenerList.add(class$sanproject$client$exdevice$luoperation$LDEVSelectPanel$SelectPanelListener == null ? (class$sanproject$client$exdevice$luoperation$LDEVSelectPanel$SelectPanelListener = LDEVSelectPanel.class$("sanproject.client.exdevice.luoperation.LDEVSelectPanel$SelectPanelListener")) : class$sanproject$client$exdevice$luoperation$LDEVSelectPanel$SelectPanelListener, selectPanelListener);
    }

    public void removeSelectPanelListener(SelectPanelListener selectPanelListener) {
        this.listenerList.remove(class$sanproject$client$exdevice$luoperation$LDEVSelectPanel$SelectPanelListener == null ? (class$sanproject$client$exdevice$luoperation$LDEVSelectPanel$SelectPanelListener = LDEVSelectPanel.class$("sanproject.client.exdevice.luoperation.LDEVSelectPanel$SelectPanelListener")) : class$sanproject$client$exdevice$luoperation$LDEVSelectPanel$SelectPanelListener, selectPanelListener);
    }

    public void addTileSelectedListener(LDEVMapPanel.TileSelectedListener tileSelectedListener) {
        this.mapPanel.addTileSelectedListener(tileSelectedListener);
    }

    public void removeTileSelectedListener(LDEVMapPanel.TileSelectedListener tileSelectedListener) {
        this.mapPanel.removeTileSelectedListener(tileSelectedListener);
    }

    protected void fireSelectPanelEvent() {
        SelectPanelEvent selectPanelEvent = new SelectPanelEvent(this);
        EventListener[] eventListenerArray = this.getListeners(class$sanproject$client$exdevice$luoperation$LDEVSelectPanel$SelectPanelListener == null ? (class$sanproject$client$exdevice$luoperation$LDEVSelectPanel$SelectPanelListener = LDEVSelectPanel.class$("sanproject.client.exdevice.luoperation.LDEVSelectPanel$SelectPanelListener")) : class$sanproject$client$exdevice$luoperation$LDEVSelectPanel$SelectPanelListener);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            SelectPanelListener selectPanelListener = (SelectPanelListener)eventListenerArray[i];
            selectPanelListener.selectionChanged(selectPanelEvent);
        }
    }

    private void initializePanel() {
        Object object;
        Object object2 = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                int n = itemEvent.getStateChange();
                if (n == 1) {
                    LDEVSelectPanel.this.putLog(LDEVSelectPanel.KEY_NAME, "[LDEVSelect] onChange SLPRLimit.");
                    LDEVSelectPanel.this.onChangeSLPRLimit();
                }
            }
        };
        Object object3 = LocalGuidance.BUTTON_LIMITED.getText();
        this.slprLimited = new RadioButton((String)object3);
        this.slprLimited.setFont(RJComFont.labelFont);
        this.slprLimited.setOpaque(false);
        this.slprLimited.addItemListener((ItemListener)object2);
        object3 = LocalGuidance.BUTTON_UNLIMITED.getText();
        this.slprUnlimited = new RadioButton((String)object3);
        this.slprUnlimited.setFont(RJComFont.labelFont);
        this.slprUnlimited.setOpaque(false);
        this.slprUnlimited.addItemListener((ItemListener)object2);
        object3 = new ButtonGroup();
        ((ButtonGroup)object3).add(this.slprLimited);
        ((ButtonGroup)object3).add(this.slprUnlimited);
        object2 = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                int n = itemEvent.getStateChange();
                if (n == 1) {
                    LDEVSelectPanel.this.putLog(LDEVSelectPanel.KEY_NAME, "[LDEVSelect] update CUList.");
                    LDEVSelectPanel.this.updateCUList();
                }
            }
        };
        object3 = new DefaultListCellRenderer();
        ((JLabel)object3).setHorizontalAlignment(4);
        this.ldkcCombo = new JComboBox();
        this.ldkcCombo.addItemListener((ItemListener)object2);
        this.ldkcCombo.setRenderer(object3);
        object2 = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                int n = itemEvent.getStateChange();
                if (n == 1) {
                    LDEVSelectPanel.this.putLog(LDEVSelectPanel.KEY_NAME, "[LDEVSelect] update LDEVMap.");
                    LDEVSelectPanel.this.updateLDEVMap();
                }
            }
        };
        object3 = new DefaultListCellRenderer();
        ((JLabel)object3).setHorizontalAlignment(4);
        this.cuCombo = new JComboBox();
        this.cuCombo.addItemListener((ItemListener)object2);
        this.cuCombo.setRenderer(object3);
        object2 = new DefaultComboBoxModel();
        for (int i = 0; i < 256; ++i) {
            object = new Integer(i);
            ((DefaultComboBoxModel)object2).addElement(object);
        }
        Object object4 = new DefaultListCellRenderer();
        ((JLabel)object4).setHorizontalAlignment(4);
        this.intervalCombo = new JComboBox(object2);
        this.intervalCombo.setRenderer(object4);
        object2 = new LDEVMapPanel.TileSelectedListener(){

            public void tileSelected(LDEVMapPanel.TileSelectedEvent tileSelectedEvent) {
                LDEVSelectPanel.this.putLog(LDEVSelectPanel.KEY_NAME, "[LDEVSelect] onSelect LDEVPosition.");
                LDEVSelectPanel.this.onSelectLDEVPosition(tileSelectedEvent);
            }
        };
        object4 = BorderFactory.createLoweredBevelBorder();
        this.mapPanel = new LDEVMapPanel();
        this.mapPanel.setBorder((Border)object4);
        this.mapPanel.addTileSelectedListener((LDEVMapPanel.TileSelectedListener)object2);
        object2 = LocalGuidance.BUTTON_OK.getItemID();
        object4 = new AbstractAction((String)object2){

            public void actionPerformed(ActionEvent actionEvent) {
                LDEVSelectPanel.this.putLog(LDEVSelectPanel.KEY_NAME, "[LDEVSelect] onClick Apply.");
                LDEVSelectPanel.this.onClickApply();
            }
        };
        this.applyButton = new Button((String)object2);
        this.applyButton.setAction((Action)object4);
        object2 = LocalGuidance.BUTTON_CANCEL.getItemID();
        object4 = new AbstractAction((String)object2){

            public void actionPerformed(ActionEvent actionEvent) {
                LDEVSelectPanel.this.putLog(LDEVSelectPanel.KEY_NAME, "[LDEVSelect] onClick Cancel.");
                LDEVSelectPanel.this.onClickCancel();
            }
        };
        this.cancelButton = new Button((String)object2);
        this.cancelButton.setAction((Action)object4);
        object4 = this.volumeDirector.getPolicy();
        object2 = ((AddLUPolicyElement)object4).getPolicyInfo();
        boolean bl = ((PolicyInfo)object2).isEnableSlprLimited();
        this.slprLimited.setSelected(bl);
        Object object5 = ((PolicyInfo)object2).getMappingStartLdev();
        short s = object5.getSLDKC();
        object = RJcElement.toHexString(s, 2);
        short s2 = object5.getSCU();
        String string = RJcElement.toHexString(s2, 2);
        this.ldkcCombo.setSelectedItem(object);
        this.cuCombo.setSelectedItem(string);
        int n = ((PolicyInfo)object2).getLdevMappingInterval();
        object5 = new Integer(n);
        this.intervalCombo.setSelectedItem(object5);
    }

    private void buildPanelLayout() {
        Object object = LocalGuidance.TITLE_LDEVMAPPINGAUTO.getItemID();
        JPanel jPanel = new RJcDlgMainTitlePanel();
        ((RJcMainTitlePanel)jPanel).setMainTitle((String)object);
        RJcDlgMainTitlePanel rJcDlgMainTitlePanel = jPanel;
        Object object2 = new RJcListPanel();
        Object object3 = LocalGuidance.TEXT_SLPRLIMITED.getText();
        Serializable serializable = new GridLayout(1, 0, 4, 4);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)((Object)serializable));
        jPanel2.setOpaque(false);
        jPanel2.add(this.slprLimited);
        jPanel2.add(this.slprUnlimited);
        serializable = new BorderLayout(4, 4);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)((Object)serializable));
        jPanel3.setOpaque(false);
        jPanel3.add((Component)jPanel2, "West");
        ((RJcListPanel)object2).addEntry((String)object3, jPanel3);
        object3 = LocalGuidance.TEXT_LDKC.getText();
        serializable = Box.createVerticalStrut(1);
        Component component = Box.createHorizontalStrut(54);
        SpringLayout springLayout = new SpringLayout();
        jPanel2 = new JPanel();
        jPanel2.setLayout(springLayout);
        jPanel2.setOpaque(false);
        jPanel2.add((Component)serializable);
        jPanel2.add(this.ldkcCombo);
        jPanel2.add(component);
        RJComSpringUtilities.makeCompactGrid(jPanel2, 3, 1, 0, 0, 0, 0);
        serializable = new BorderLayout(4, 4);
        jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)((Object)serializable));
        jPanel3.setOpaque(false);
        jPanel3.add((Component)jPanel2, "West");
        ((RJcListPanel)object2).addEntry((String)object3, jPanel3);
        object3 = LocalGuidance.TEXT_CU.getText();
        serializable = Box.createVerticalStrut(1);
        component = Box.createHorizontalStrut(54);
        springLayout = new SpringLayout();
        jPanel2 = new JPanel();
        jPanel2.setLayout(springLayout);
        jPanel2.setOpaque(false);
        jPanel2.add((Component)serializable);
        jPanel2.add(this.cuCombo);
        jPanel2.add(component);
        RJComSpringUtilities.makeCompactGrid(jPanel2, 3, 1, 0, 0, 0, 0);
        serializable = new BorderLayout(4, 4);
        jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)((Object)serializable));
        jPanel3.setOpaque(false);
        jPanel3.add((Component)jPanel2, "West");
        ((RJcListPanel)object2).addEntry((String)object3, jPanel3);
        object3 = LocalGuidance.TEXT_INTERVAL.getText();
        serializable = Box.createVerticalStrut(1);
        component = Box.createHorizontalStrut(54);
        springLayout = new SpringLayout();
        jPanel2 = new JPanel();
        jPanel2.setLayout(springLayout);
        jPanel2.setOpaque(false);
        jPanel2.add((Component)serializable);
        jPanel2.add(this.intervalCombo);
        jPanel2.add(component);
        RJComSpringUtilities.makeCompactGrid(jPanel2, 3, 1, 0, 0, 0, 0);
        serializable = new BorderLayout(4, 4);
        jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)((Object)serializable));
        jPanel3.setOpaque(false);
        jPanel3.add((Component)jPanel2, "West");
        ((RJcListPanel)object2).addEntry((String)object3, jPanel3);
        Serializable serializable2 = object2;
        object2 = new RJcCushionPanel((JComponent)this.mapPanel, 1);
        object3 = new BorderLayout(4, 4);
        jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)object3);
        jPanel.setOpaque(false);
        jPanel.add((Component)serializable2, "North");
        jPanel.add((Component)object2, "Center");
        serializable2 = new BorderLayout();
        object = new JPanel();
        ((Container)object).setLayout((LayoutManager)((Object)serializable2));
        ((JComponent)object).setOpaque(false);
        ((Container)object).add((Component)jPanel, "North");
        object2 = new GridLayout(1, 0, 4, 4);
        serializable2 = new JPanel();
        ((Container)serializable2).setLayout((LayoutManager)object2);
        ((JComponent)serializable2).setOpaque(false);
        ((Container)serializable2).add(this.applyButton);
        ((Container)serializable2).add(this.cancelButton);
        object2 = new BorderLayout(4, 4);
        object3 = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)object2);
        jPanel.setOpaque(false);
        jPanel.setBorder((Border)object3);
        jPanel.add((Component)serializable2, "East");
        serializable2 = new BorderLayout(4, 4);
        this.setLayout((LayoutManager)((Object)serializable2));
        this.add((Component)object, "Center");
        if (this.hasDecoration) {
            this.add((Component)rJcDlgMainTitlePanel, "North");
            this.add((Component)jPanel, "South");
        } else {
            object2 = BorderFactory.createEmptyBorder();
            this.setBorder((Border)object2);
        }
    }

    private void updateLDKCList() {
        Debug.println("updateLDKCList()");
        boolean bl = this.slprLimited.isSelected();
        Object object = this.ldkcCombo.getSelectedItem();
        LdevManager ldevManager = LdevManager.getInstance();
        Collection collection = ldevManager.getLdkcList(this.targetSLPR, bl);
        Integer[] integerArray = new Integer[]{};
        if (collection != null) {
            integerArray = collection.toArray(integerArray);
        }
        Object[] objectArray = new Object[integerArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Integer n = integerArray[i];
            int n2 = n;
            objectArray[i] = RJcElement.toHexString(n2, 2);
        }
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(objectArray);
        this.ldkcCombo.setModel(defaultComboBoxModel);
        if (object != null) {
            this.ldkcCombo.setSelectedItem(object);
        }
        this.updateCUList();
    }

    private void updateCUList() {
        Debug.println("updateCUList()");
        int n = this.getLDKCNumber();
        boolean bl = this.slprLimited.isSelected();
        Object object = this.cuCombo.getSelectedItem();
        LdevManager ldevManager = LdevManager.getInstance();
        Collection collection = null;
        if (n != -1) {
            collection = ldevManager.getCuList(n, this.targetSLPR, bl);
        }
        Integer[] integerArray = new Integer[]{};
        if (collection != null) {
            integerArray = collection.toArray(integerArray);
        }
        Object[] objectArray = new Object[integerArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Integer n2 = integerArray[i];
            int n3 = n2;
            objectArray[i] = RJcElement.toHexString(n3, 2);
        }
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(objectArray);
        this.cuCombo.setModel(defaultComboBoxModel);
        if (object != null) {
            this.cuCombo.setSelectedItem(object);
        }
        this.updateLDEVMap();
    }

    private void updateLDEVMap() {
        short s;
        Debug.println("updateLDEVMap()");
        int n = this.getLDKCNumber();
        int n2 = this.getCUNumber();
        int[] nArray = new int[]{};
        if (this.selectedLDEV != null && n == (s = this.selectedLDEV.getSLDKC()) && n2 == (s = this.selectedLDEV.getSCU())) {
            nArray = new int[]{this.selectedLDEV.getSLDEV()};
        }
        RJiCUIndex rJiCUIndex = new RJiCUIndex();
        rJiCUIndex.setCUIndex((short)n, (short)n2);
        LdevManager ldevManager = LdevManager.getInstance();
        boolean[] blArray = ldevManager.getUsableLdevMap((Robj_interface_RJiCUIndex)rJiCUIndex, this.targetEmulation);
        this.mapPanel.setUsableMap(blArray);
        this.mapPanel.setSelectedIndexes(nArray);
        this.fireSelectPanelEvent();
    }

    private void onChangeSLPRLimit() {
        int n;
        boolean bl = true;
        boolean bl2 = this.slprUnlimited.isSelected();
        if (bl2 && (n = Message.showOKCancelDialog(this, 610, 59066)) != 0) {
            this.slprLimited.setSelected(true);
            bl = false;
        }
        if (bl) {
            this.updateLDKCList();
            this.selectedLDEV = null;
        }
    }

    private void checkLDEVs() throws EXDException {
        boolean bl = false;
        Robj_interface_RJiLDEVInfoDetail robj_interface_RJiLDEVInfoDetail = this.getSelectedLDEV();
        if (robj_interface_RJiLDEVInfoDetail == null) {
            bl = true;
        }
        if (bl) {
            EXDException eXDException = new EXDException(610, 59017);
            throw eXDException;
        }
    }

    private void onSelectLDEVPosition(LDEVMapPanel.TileSelectedEvent tileSelectedEvent) {
        int n = this.getLDKCNumber();
        int n2 = this.getCUNumber();
        int n3 = tileSelectedEvent.getLDEVIndex();
        this.selectedLDEV = new RJiLDEVInfoDetail();
        if (n != -1 && n2 != -1) {
            this.selectedLDEV.setLDEVIndex((short)n, (short)n2, (short)n3);
        }
        this.updateLDEVMap();
    }

    private void onClickApply() {
        try {
            this.checkLDEVs();
            this.setDialogStatus(APPLY_STATUS);
            this.closeContentDialog();
        }
        catch (EXDException eXDException) {
            this.processEXDException(eXDException);
        }
    }

    private void onClickCancel() {
        this.closeContentDialog();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class SelectPanelEvent
    extends EventObject {
        public SelectPanelEvent(LDEVSelectPanel lDEVSelectPanel) {
            super(lDEVSelectPanel);
        }
    }

    public static interface SelectPanelListener
    extends EventListener {
        public void selectionChanged(SelectPanelEvent var1);
    }
}

