/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.hur.dialog.com;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.Icon;
import javax.swing.JButton;
import sanproject.client.com.RJComFont;
import sanproject.client.hur.RJHurGuide;
import sanproject.client.hur.RJHurMacro;

public class RJHurBaseButton
extends JButton
implements RJHurMacro {
    private static final String CLASSNAME = "RJHurBaseButton";
    private String m_strKey = null;
    private boolean m_bInitialized = false;

    public RJHurBaseButton(String string) {
        this(string, null);
    }

    public RJHurBaseButton(String string, Icon icon) {
        super(null, icon);
        super.setText(this.guide(string));
        this.initInstance();
    }

    public void setText(String string) {
        super.setText(this.guide(string));
        this.adjustSize();
    }

    private void initInstance() {
        this.setFont(RJComFont.buttonFont);
        this.m_bInitialized = true;
        this.adjustSize();
    }

    private void adjustSize() {
        if (this.m_bInitialized) {
            int n = 90;
            int n2 = 24;
            int n3 = 0;
            int n4 = 0;
            String string = this.getText();
            Font font = this.getFont();
            Icon icon = this.getIcon();
            if (icon != null) {
                n4 = icon.getIconWidth();
            }
            if (font != null) {
                FontMetrics fontMetrics = this.getFontMetrics(font);
                if (string != null) {
                    n3 = fontMetrics.stringWidth(string);
                }
                if (n3 + n4 + 40 > n) {
                    n = n3 + n4 + 60;
                }
                this.setPreferredSize(new Dimension(n, n2));
            }
        }
    }

    private String guide(String string) {
        String string2;
        String string3 = string;
        if (string != null && (string2 = RJHurGuide.text(string)) != null) {
            this.m_strKey = string;
            string3 = string2;
            this.setForeground(RJHurGuide.color(string));
            this.setBackground(RJHurGuide.color(string + "_BGClr"));
            this.setToolTip();
        }
        return string3;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.setToolTip();
    }

    private void setToolTip() {
        if (this.m_strKey != null) {
            String string = RJHurGuide.text(this.m_strKey + (this.isEnabled() ? "_TIP" : "_TIPDIS"));
            super.setToolTipText(string);
        }
    }
}

