/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.hur.dialog.pair;

import java.util.ArrayList;
import sanproject.client.hur.RJHurAbsChildPanel;
import sanproject.client.hur.RJHurAbsPresetData;
import sanproject.client.hur.RJHurDataControl;
import sanproject.client.hur.RJHurMacro;

public abstract class RJHurAbstractInfo
implements RJHurMacro {
    public static final String PP_HUROPEN = "HUR_OPEN";
    public static final String PP_HURMF = "HUR_MF";
    public static final String PATHID_SUPPORT = "PATHID_SUPPORT";
    public static final String PATHID_UNSUPPORT = "PATHID_UNSUPPORT";
    protected String dialogName = null;
    protected RJHurAbsChildPanel childPanel;
    protected RJHurDataControl controller = null;
    protected boolean presetFlg;
    protected ArrayList presetData;
    private int[] target;
    protected int detailIndex = 0;
    protected boolean error = false;

    public RJHurAbstractInfo(String string, RJHurAbsChildPanel rJHurAbsChildPanel, RJHurDataControl rJHurDataControl, boolean bl, ArrayList arrayList, int[] nArray) {
        this.dialogName = string;
        this.childPanel = rJHurAbsChildPanel;
        this.controller = rJHurDataControl;
        this.presetFlg = bl;
        this.presetData = arrayList;
        this.target = nArray;
    }

    public RJHurAbstractInfo(String string, RJHurAbsChildPanel rJHurAbsChildPanel, RJHurDataControl rJHurDataControl, int n) {
        this.dialogName = string;
        this.controller = rJHurDataControl;
        this.childPanel = rJHurAbsChildPanel;
        this.detailIndex = n;
    }

    public String guideKey(String string) {
        return this.guideKey("", string);
    }

    public String guideKey(String string, String string2) {
        String string3 = null;
        if (string2 != null) {
            string3 = this.dialogName + string + string2;
        }
        return string3;
    }

    public String trimKey(String string) {
        return this.trimKey("", string);
    }

    public String trimKey(String string, String string2) {
        String string3 = null;
        String string4 = this.dialogName + string;
        if (string2 != null && string2.startsWith(string4)) {
            string3 = string2.substring(string4.length());
        }
        return string3;
    }

    public RJHurDataControl getController() {
        return this.controller;
    }

    public RJHurAbsChildPanel getChildPanel() {
        return this.childPanel;
    }

    public boolean isPresetFlg() {
        return this.presetFlg;
    }

    public int[] getTarget() {
        return this.target;
    }

    public ArrayList getPresetData() {
        return this.presetData;
    }

    public int getDetailIndex() {
        return this.detailIndex;
    }

    public int getPPKind() {
        return this.controller.getPPKind();
    }

    public boolean isOpen() {
        return this.getPPKind() == 1;
    }

    public String getPPKindString() {
        String string = PP_HUROPEN;
        if (this.getPPKind() == 0) {
            string = PP_HURMF;
        }
        return string;
    }

    public boolean isPathIDSupported() {
        return false;
    }

    public String getPathIDSupportedString() {
        String string = PATHID_UNSUPPORT;
        if (this.isPathIDSupported()) {
            string = PATHID_SUPPORT;
        }
        return string;
    }

    public int getTargetSize() {
        int n = -1;
        if (this.target != null) {
            n = this.target.length;
        }
        return n;
    }

    public boolean isTarget(int n) {
        boolean bl = false;
        for (int i = 0; i < this.target.length; ++i) {
            if (this.target[i] != n) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public RJHurAbsPresetData getPresetData(int n) {
        RJHurAbsPresetData rJHurAbsPresetData = null;
        if (this.presetData != null && n >= 0) {
            rJHurAbsPresetData = (RJHurAbsPresetData)this.presetData.get(this.target[n]);
        }
        return rJHurAbsPresetData;
    }

    public ArrayList getTargetPresetList() {
        ArrayList<RJHurAbsPresetData> arrayList = new ArrayList<RJHurAbsPresetData>();
        for (int i = 0; i < this.target.length; ++i) {
            arrayList.add(this.getPresetData(i));
        }
        return arrayList;
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean bl) {
        this.error = bl;
    }
}

