/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.openldevguard.gui.restoreview;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import sanproject.client.com.restoreview.ComponentParser;
import sanproject.client.com.restoreview.DefaultTreeComponentParser;
import sanproject.client.com.restoreview.TreeComponentParser;
import sanproject.client.com.restoreview.UnsupportedComponentException;
import sanproject.client.com.restoreview.UnsupportedRestoreModeException;
import sanproject.client.com.restoreview.ViewRestorer;
import sanproject.client.com.restoreview.utility.TreeComponentUtilities;

public class SimpleTreeViewRestorer
implements ViewRestorer {
    public static final int TREE_EXPAND_ONLY_SELECTION_RESTORE = 0x100000;
    public static final int TREE_EXPAND_ALL_RESTORE = 0x200000;
    public static final int TREE_EXPAND_COMPLETENESS_RESTORE = 0x400000;
    public static final int TREE_EXPAND_MAINTENANCE_RESTORE = 0x800000;
    private int miRestoreMode;
    private TreeComponentParser mclsComponentParser;
    private List mlstExpandedPath;
    private List mlstSelectionPath;

    public SimpleTreeViewRestorer() {
        int n = 0;
        n |= 1;
        n |= 0x100000;
        n |= 0x800000;
        try {
            this.setRestoreMode(n);
        }
        catch (UnsupportedRestoreModeException unsupportedRestoreModeException) {
            throw new RuntimeException();
        }
        DefaultTreeComponentParser defaultTreeComponentParser = new DefaultTreeComponentParser();
        this.setComponentParser(defaultTreeComponentParser);
        this.mlstExpandedPath = new ArrayList();
        this.mlstSelectionPath = new ArrayList();
    }

    public final void saveViewComponent(Component component) throws UnsupportedComponentException {
        if (!(component instanceof JTree)) {
            String string = "Any components other than 'javax.swing.JTree' are not supported.";
            throw new UnsupportedComponentException(string);
        }
        JTree jTree = (JTree)component;
        this.mlstExpandedPath.clear();
        this.mlstSelectionPath.clear();
        int n = jTree.getRowCount();
        for (int i = 0; i < n; ++i) {
            TreePath treePath = jTree.getPathForRow(i);
            if (jTree.isExpanded(treePath)) {
                this.mlstExpandedPath.add(treePath);
            }
            if (!jTree.isRowSelected(i)) continue;
            this.mlstSelectionPath.add(treePath);
        }
    }

    public final void restoreViewComponent(Component component) throws UnsupportedComponentException {
        if (!(component instanceof JTree)) {
            String string = "Any components other than 'javax.swing.JTree' are not supported.";
            throw new UnsupportedComponentException(string);
        }
        if (this.hasSavedViewComponent()) {
            TreePath treePath;
            Object object;
            JTree jTree = (JTree)component;
            int n = 0;
            n = this.getRestoreMode();
            TreeComponentParser treeComponentParser = (TreeComponentParser)this.getComponentParser();
            treeComponentParser.setAnalysisComponent(jTree);
            if ((n & 0x400000) > 0) {
                TreeComponentUtilities.collapseAllNodes(jTree);
            }
            jTree.clearSelection();
            boolean bl = (n & 0x100000) > 0;
            Iterator iterator = this.mlstExpandedPath.iterator();
            while (iterator.hasNext()) {
                object = (TreePath)iterator.next();
                if (bl && !this.mlstSelectionPath.contains(object) || (treePath = treeComponentParser.searchTreeNode((TreePath)object)) == null) continue;
                jTree.expandPath(treePath);
            }
            if ((n & 1) > 0) {
                object = this.mlstSelectionPath.iterator();
                while (object.hasNext()) {
                    treePath = (TreePath)object.next();
                    TreePath treePath2 = treeComponentParser.searchTreeNode(treePath);
                    if (treePath2 == null) continue;
                    jTree.addSelectionPath(treePath2);
                }
            }
            treeComponentParser.setAnalysisComponent(null);
        }
    }

    public final void setRestoreMode(int n) throws UnsupportedRestoreModeException {
        if (!this.isSupportedRestoreMode(n)) {
            String string = "The parameter which is not supported was specified [" + n + "].";
            throw new UnsupportedRestoreModeException(string);
        }
        this.miRestoreMode = n;
    }

    public final int getRestoreMode() {
        return this.miRestoreMode;
    }

    public final void setComponentParser(ComponentParser componentParser) {
        if (componentParser == null || !(componentParser instanceof TreeComponentParser)) {
            String string = "Any components other than 'restoreview.TreeComponentParser' are not supported.";
            throw new IllegalArgumentException(string);
        }
        this.mclsComponentParser = (TreeComponentParser)componentParser;
    }

    public final ComponentParser getComponentParser() {
        return this.mclsComponentParser;
    }

    public final boolean isSupportedRestoreMode(int n) {
        int n2 = n;
        n2 &= 0xFFFFFFFE;
        n2 &= 0xFFDFFFFF;
        n2 &= 0xFFEFFFFF;
        n2 &= 0xFFBFFFFF;
        return (n2 &= 0xFF7FFFFF) == 0;
    }

    public final boolean hasSavedViewComponent() {
        boolean bl = !this.mlstExpandedPath.isEmpty() || !this.mlstSelectionPath.isEmpty();
        return bl;
    }

    public final void releaseSavedViewComponent() {
        this.mlstExpandedPath.clear();
        this.mlstSelectionPath.clear();
    }
}

