/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.syslog;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.NumberFormat;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import sanproject.client.syslog.RJColleague;
import sanproject.client.syslog.RJMediator;
import sanproject.client.syslog.RJslDef;

public class RJslNumberField_IPv6
extends JTextField
implements RJslDef,
DocumentListener,
RJColleague,
FocusListener {
    private NumberFormat integerFormatter;
    private int off = 0;
    private int len = 0;
    RJMediator mediator;
    boolean chg_state = false;
    int italic = 3;
    int not_italic = 0;
    Color blue = Color.blue;
    Color black = Color.black;
    private int min;
    private int max;

    public RJslNumberField_IPv6() {
        this(4, 0, 0);
    }

    public RJslNumberField_IPv6(int n, int n2, int n3) {
        super(n);
        this.min = n2;
        this.max = n3;
        this.integerFormatter = NumberFormat.getNumberInstance();
        this.integerFormatter.setParseIntegerOnly(true);
        this.setHorizontalAlignment(4);
        this.getDocument().addDocumentListener(this);
        this.addFocusListener(this);
    }

    public void setMin(int n) {
        this.min = n;
    }

    public void setMax(int n) {
        this.max = n;
    }

    protected Document createDefaultModel() {
        return new NumberDocument();
    }

    public Integer getValue() {
        Integer n = null;
        String string = this.getText();
        if (string != null) {
            string = this.rebuildStr(string);
            int n2 = Integer.parseInt(string, 16);
            n = new Integer(n2);
        }
        return n;
    }

    public String rebuildStr(String string) {
        String string2 = "";
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (Character.UnicodeBlock.of(c) != Character.UnicodeBlock.BASIC_LATIN) continue;
                string2 = string2 + c;
            }
        }
        return string2;
    }

    public void setValue(Integer n) {
        if (n != null) {
            this.setValue((int)n);
        }
    }

    public void setValue(int n) {
        String string = Integer.toHexString(n);
        this.setText(string.toUpperCase());
    }

    protected boolean isRange(int n, String string) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(this.getText());
        stringBuffer = stringBuffer.insert(n, string);
        try {
            int n2 = Integer.parseInt(stringBuffer.toString(), 16);
            if (n2 >= this.min && n2 <= this.max) {
                bl = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return bl;
    }

    private boolean checkWidth(int n) {
        boolean bl = false;
        if (this.getText().length() + n >= this.getColumns()) {
            bl = true;
        }
        return bl;
    }

    public void setItalic(boolean bl) {
        this.chg_state = bl;
        if (bl) {
            this.setFont(new Font(null, this.italic, 12));
        } else {
            this.setFont(new Font(null, this.not_italic, 12));
        }
    }

    public void setBlue(boolean bl) {
        if (bl) {
            this.setForeground(this.blue);
        } else {
            this.setForeground(this.black);
        }
    }

    public boolean getstate() {
        return this.chg_state;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.selectAll();
    }

    public void focusLost(FocusEvent focusEvent) {
        String string = this.rebuildStr(this.getText());
        this.setText(string);
        if (this.getText().length() > 0) {
            this.setValue(this.getValue());
        }
        if (this.getText().equals("")) {
            this.setValue(0);
        }
    }

    public void setMediator(RJMediator rJMediator) {
        this.mediator = rJMediator;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.update();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.update();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.update();
    }

    public void update() {
        String string = this.getText();
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.UnicodeBlock.of(c) == Character.UnicodeBlock.BASIC_LATIN) continue;
            bl = false;
            break;
        }
        if (bl && this.mediator != null) {
            this.mediator.colleagueChanged();
        }
    }

    public void setListener() {
        this.getDocument().addDocumentListener(this);
        this.addFocusListener(this);
    }

    public void releaseListener() {
        Document document = this.getDocument();
        DocumentListener[] documentListenerArray = ((PlainDocument)document).getDocumentListeners();
        for (int i = 0; i < documentListenerArray.length; ++i) {
            if (!documentListenerArray[i].getClass().toString().equals(this.getClass().toString())) continue;
            document.removeDocumentListener(this);
        }
        this.removeFocusListener(this);
    }

    protected class NumberDocument
    extends PlainDocument {
        protected NumberDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string != null && !string.equals("")) {
                if (attributeSet == null) {
                    RJslNumberField_IPv6.this.len = 0;
                    boolean bl = false;
                    for (int i = 0; i < string.length(); ++i) {
                        char c = string.charAt(i);
                        String string2 = string.substring(0, i + 1);
                        if (Character.UnicodeBlock.of(c) == Character.UnicodeBlock.BASIC_LATIN && (c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f') && !RJslNumberField_IPv6.this.checkWidth(i) && RJslNumberField_IPv6.this.isRange(n, string2)) continue;
                        string = string.substring(0, i);
                        break;
                    }
                } else {
                    RJslNumberField_IPv6.this.off = n;
                    RJslNumberField_IPv6.this.len = string.length();
                }
                super.insertString(n, string, attributeSet);
            }
        }
    }
}

