/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim3.mof;

import com.ws.cim3.mof.MOFCompConstants;
import com.ws.cim3.mof.MOFCompTokenManager;
import com.ws.cim3.mof.ParseException;
import com.ws.cim3.mof.SimpleCharStream;
import com.ws.cim3.mof.Token;
import com.ws.cim3.utilities.CIMUtilities;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.cim3.CIMClass;
import javax.cim3.CIMClassProperty;
import javax.cim3.CIMDataType;
import javax.cim3.CIMEnumeration;
import javax.cim3.CIMEnumerationEntry;
import javax.cim3.CIMMethod;
import javax.cim3.CIMObjectPath;
import javax.cim3.CIMParameter;
import javax.cim3.CIMPolicyKind;
import javax.cim3.CIMQualifier;
import javax.cim3.CIMQualifierType;
import javax.cim3.CIMStructure;
import javax.wbem.WBEMException;

public class MOFComp
implements MOFCompConstants {
    private String mNamespace;
    public MOFCompTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[67];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public MOFComp() {
        this.mNamespace = "interp";
    }

    public static void main(String[] args) {
        MOFComp parser = null;
        if (args.length == 0) {
            System.out.println("MOFComp...must pass file as arg");
        } else if (args.length == 1) {
            System.out.println("Reading from file " + args[0] + " . . .");
            try {
                parser = new MOFComp(new FileInputStream(args[0]));
                try {
                    parser.mofSpecification();
                    System.out.println("MOF file parsed successfully.");
                }
                catch (Exception e) {
                    System.out.println("MOF File Encountered errors.");
                    e.printStackTrace();
                }
            }
            catch (FileNotFoundException e) {
                System.out.println("File " + args[0] + " not found.");
                return;
            }
        }
    }

    public final void mofSpecification() throws ParseException, WBEMException {
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 9: 
                case 12: 
                case 13: 
                case 28: 
                case 31: 
                case 42: 
                case 45: 
                case 71: {
                    this.mofProduction();
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                }
            }
            this.jj_consume_token(0);
        }
        catch (ParseException e) {
            System.err.println("ERROR: " + e);
            throw e;
        }
    }

    public final void mofProduction() throws ParseException, WBEMException {
        block18: while (true) {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 12: 
                case 13: 
                case 28: 
                case 42: 
                case 45: 
                case 71: {
                    ArrayList<CIMQualifier<?>> qList = null;
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 71: {
                            qList = this.qualifierList();
                            break;
                        }
                        default: {
                            this.jj_la1[1] = this.jj_gen;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 45: {
                            this.structureDeclaration(qList);
                            break block0;
                        }
                        case 13: {
                            this.classDeclaration(qList);
                            break block0;
                        }
                        case 12: {
                            this.associationDeclaration(qList);
                            break block0;
                        }
                        case 28: {
                            this.enumerationDeclaration(qList);
                            break block0;
                        }
                        case 42: {
                            this.qualifierTypeDeclaration(qList);
                            break block0;
                        }
                    }
                    this.jj_la1[2] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                case 31: {
                    this.instanceDeclaration();
                    break;
                }
                case 9: {
                    this.compilerDirective();
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 9: 
                case 12: 
                case 13: 
                case 28: 
                case 31: 
                case 42: 
                case 45: 
                case 71: {
                    continue block18;
                }
            }
            break;
        }
        this.jj_la1[4] = this.jj_gen;
    }

    public final void compilerDirective() throws ParseException, WBEMException {
        this.jj_consume_token(9);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 33: {
                this.namespacePragma();
                break;
            }
            case 30: {
                this.includePragma();
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void namespacePragma() throws ParseException, WBEMException {
        this.jj_consume_token(33);
        this.jj_consume_token(73);
        Token t = this.jj_consume_token(57);
        this.mNamespace = t.image;
        this.jj_consume_token(74);
    }

    public final void includePragma() throws ParseException, WBEMException {
        this.jj_consume_token(30);
        this.jj_consume_token(73);
        Token t = this.jj_consume_token(57);
        String s = t.image;
        this.jj_consume_token(74);
    }

    public final ArrayList<CIMQualifier<?>> qualifierList() throws ParseException, WBEMException {
        CIMQualifier<?> q = null;
        ArrayList qList = new ArrayList();
        this.jj_consume_token(71);
        q = this.qualifier();
        qList.add(q);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 65: {
                block6: while (true) {
                    this.jj_consume_token(65);
                    q = this.qualifier();
                    qList.add(q);
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 65: {
                            continue block6;
                        }
                    }
                    break;
                }
                this.jj_la1[6] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
        this.jj_consume_token(72);
        if ("" != null) {
            return qList;
        }
        throw new Error("Missing return statement in function");
    }

    public final CIMQualifier<?> qualifier() throws ParseException, WBEMException {
        Object[] value = null;
        Token t = this.jj_consume_token(59);
        String qualifierName = t.image;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 69: 
            case 73: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 73: {
                        this.jj_consume_token(73);
                        value = this.getValue();
                        this.jj_consume_token(74);
                        if ("" == null) break block0;
                        return new CIMQualifier<Object[]>(qualifierName, CIMDataType.UNKNOWN_T, value);
                    }
                    case 69: {
                        this.jj_consume_token(69);
                        value = this.getArrayValue();
                        this.jj_consume_token(70);
                        if ("" == null) break block0;
                        return new CIMQualifier<Object[]>(qualifierName, CIMDataType.UNKNOWN_T, value);
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
            }
        }
        if ("" != null) {
            return new CIMQualifier<Boolean>(qualifierName, CIMDataType.BOOLEAN_T, true);
        }
        throw new Error("Missing return statement in function");
    }

    public final void qualifierTypeDeclaration(ArrayList<CIMQualifier<?>> qList) throws ParseException, WBEMException {
        Token t = null;
        CIMDataType dt = null;
        int qualifierScope = 0;
        CIMPolicyKind qualifierPolicy = null;
        this.jj_consume_token(42);
        CIMObjectPath path = this.getObjectPath();
        this.jj_consume_token(66);
        dt = this.getDataType();
        this.jj_consume_token(68);
        t = this.getValue();
        Object qualifierValue = CIMUtilities.convertStringToProperType(dt, t.image);
        this.jj_consume_token(44);
        this.jj_consume_token(73);
        qualifierScope = this.getScope(qualifierScope);
        block11: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 65: {
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    break block11;
                }
            }
            this.jj_consume_token(65);
            qualifierScope = this.getScope(qualifierScope);
        }
        this.jj_consume_token(74);
        this.jj_consume_token(39);
        this.jj_consume_token(73);
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 36: 
            case 37: 
            case 38: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 36: {
                        this.jj_consume_token(36);
                        qualifierPolicy = CIMPolicyKind.DISABLEOVERRIDE;
                        break block3;
                    }
                    case 37: {
                        this.jj_consume_token(37);
                        qualifierPolicy = CIMPolicyKind.ENABLEOVERRIDE;
                        break block3;
                    }
                    case 38: {
                        this.jj_consume_token(38);
                        qualifierPolicy = CIMPolicyKind.RESTRICTED;
                        break block3;
                    }
                }
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
            }
        }
        this.jj_consume_token(74);
        this.jj_consume_token(67);
        CIMQualifierType<Object> cqt = new CIMQualifierType<Object>(path, dt, qualifierValue, qualifierScope, qualifierPolicy, qList.toArray(new CIMQualifier[qList.size()]));
        System.out.println(cqt);
    }

    public final int getScope(int scope) throws ParseException, WBEMException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 12: {
                this.jj_consume_token(12);
                ++scope;
                break;
            }
            case 13: {
                this.jj_consume_token(13);
                scope += 2;
                break;
            }
            case 28: {
                this.jj_consume_token(28);
                scope += 4;
                break;
            }
            case 29: {
                this.jj_consume_token(29);
                scope += 8;
                break;
            }
            case 32: {
                this.jj_consume_token(32);
                scope += 16;
                break;
            }
            case 35: {
                this.jj_consume_token(35);
                scope += 32;
                break;
            }
            case 40: {
                this.jj_consume_token(40);
                scope += 64;
                break;
            }
            case 42: {
                this.jj_consume_token(42);
                scope += 128;
                break;
            }
            case 41: {
                this.jj_consume_token(41);
                scope += 256;
                break;
            }
            case 45: {
                this.jj_consume_token(45);
                scope += 512;
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                scope += 1023;
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return scope;
        }
        throw new Error("Missing return statement in function");
    }

    public final CIMStructure structureDeclaration(ArrayList<CIMQualifier<?>> qList) throws ParseException, WBEMException {
        CIMObjectPath className;
        String superClassName;
        ArrayList enumList;
        ArrayList<CIMStructure> structList;
        ArrayList propList;
        block19: {
            Token t;
            propList = new ArrayList();
            structList = new ArrayList<CIMStructure>();
            enumList = new ArrayList();
            ArrayList<CIMQualifier<?>> eqList = new ArrayList();
            superClassName = null;
            className = null;
            String elementName = null;
            CIMDataType dt = null;
            boolean keyed = false;
            this.jj_consume_token(45);
            className = this.getObjectPath();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 66: {
                    this.jj_consume_token(66);
                    t = this.jj_consume_token(59);
                    superClassName = t.image;
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                }
            }
            this.jj_consume_token(69);
            block17: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 45: 
                    case 59: 
                    case 71: {
                        break;
                    }
                    default: {
                        this.jj_la1[15] = this.jj_gen;
                        break block19;
                    }
                }
                eqList = new ArrayList();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 71: {
                        eqList = this.qualifierList();
                        break;
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 28: {
                        CIMEnumeration<?> cimEnum = this.enumerationDeclaration(eqList);
                        enumList.add(cimEnum);
                        continue block17;
                    }
                    case 45: {
                        CIMStructure cimStruct = this.structureDeclaration(eqList);
                        structList.add(cimStruct);
                        continue block17;
                    }
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 59: {
                        dt = this.getDataType();
                        t = this.jj_consume_token(59);
                        elementName = t.image;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 67: 
                            case 68: 
                            case 71: {
                                CIMClassProperty<?> prop = this.propertyDeclaration(eqList, elementName, dt);
                                propList.add(prop);
                                if (!prop.hasQualifier("Key")) continue block17;
                                keyed = true;
                                continue block17;
                            }
                        }
                        this.jj_la1[17] = this.jj_gen;
                        continue block17;
                    }
                }
                break;
            }
            this.jj_la1[18] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(70);
        this.jj_consume_token(67);
        CIMStructure c = new CIMStructure(className, superClassName, qList.toArray(new CIMQualifier[qList.size()]), propList.toArray(new CIMClassProperty[propList.size()]), structList.toArray(new CIMStructure[structList.size()]), enumList.toArray(new CIMEnumeration[enumList.size()]));
        System.out.println(c);
        if ("" != null) {
            return c;
        }
        throw new Error("Missing return statement in function");
    }

    public final void classDeclaration(ArrayList<CIMQualifier<?>> qList) throws ParseException, WBEMException {
        boolean keyed;
        CIMObjectPath className;
        String superClassName;
        ArrayList enumList;
        ArrayList<CIMStructure> structList;
        ArrayList methodList;
        ArrayList propList;
        block22: {
            Token t;
            propList = new ArrayList();
            methodList = new ArrayList();
            ArrayList<CIMQualifier<?>> eqList = new ArrayList();
            structList = new ArrayList<CIMStructure>();
            enumList = new ArrayList();
            superClassName = null;
            className = null;
            String elementName = null;
            CIMDataType dt = null;
            keyed = false;
            this.jj_consume_token(13);
            className = this.getObjectPath();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 66: {
                    this.jj_consume_token(66);
                    t = this.jj_consume_token(59);
                    superClassName = t.image;
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                }
            }
            this.jj_consume_token(69);
            block21: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 45: 
                    case 59: 
                    case 71: {
                        break;
                    }
                    default: {
                        this.jj_la1[20] = this.jj_gen;
                        break block22;
                    }
                }
                eqList = new ArrayList();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 71: {
                        eqList = this.qualifierList();
                        break;
                    }
                    default: {
                        this.jj_la1[21] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 28: {
                        CIMEnumeration<?> cimEnum = this.enumerationDeclaration(eqList);
                        enumList.add(cimEnum);
                        continue block21;
                    }
                    case 45: {
                        CIMStructure cimStruct = this.structureDeclaration(eqList);
                        structList.add(cimStruct);
                        continue block21;
                    }
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 59: {
                        dt = this.getDataType();
                        t = this.jj_consume_token(59);
                        elementName = t.image;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 67: 
                            case 68: 
                            case 71: 
                            case 73: {
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 67: 
                                    case 68: 
                                    case 71: {
                                        CIMClassProperty<?> prop = this.propertyDeclaration(eqList, elementName, dt);
                                        propList.add(prop);
                                        if (!prop.hasQualifier("Key")) continue block21;
                                        keyed = true;
                                        continue block21;
                                    }
                                    case 73: {
                                        CIMMethod<?> method = this.methodDeclaration(eqList, elementName, dt);
                                        methodList.add(method);
                                        continue block21;
                                    }
                                }
                                this.jj_la1[22] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.jj_la1[23] = this.jj_gen;
                        continue block21;
                    }
                }
                break;
            }
            this.jj_la1[24] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(70);
        this.jj_consume_token(67);
        CIMClass c = new CIMClass(className, superClassName, qList.toArray(new CIMQualifier[qList.size()]), propList.toArray(new CIMClassProperty[propList.size()]), methodList.toArray(new CIMMethod[methodList.size()]), structList.toArray(new CIMStructure[structList.size()]), enumList.toArray(new CIMEnumeration[enumList.size()]), false, keyed);
        System.out.println(c);
    }

    public final void associationDeclaration(ArrayList<CIMQualifier<?>> qList) throws ParseException, WBEMException {
        boolean keyed;
        CIMObjectPath className;
        String superClassName;
        ArrayList enumList;
        ArrayList<CIMStructure> structList;
        ArrayList methodList;
        ArrayList propList;
        block22: {
            Token t;
            propList = new ArrayList();
            methodList = new ArrayList();
            ArrayList<CIMQualifier<?>> eqList = new ArrayList();
            structList = new ArrayList<CIMStructure>();
            enumList = new ArrayList();
            superClassName = null;
            className = null;
            String elementName = null;
            CIMDataType dt = null;
            keyed = false;
            this.jj_consume_token(12);
            className = this.getObjectPath();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 66: {
                    this.jj_consume_token(66);
                    t = this.jj_consume_token(59);
                    superClassName = t.image;
                    break;
                }
                default: {
                    this.jj_la1[25] = this.jj_gen;
                }
            }
            this.jj_consume_token(69);
            block21: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 45: 
                    case 59: 
                    case 71: {
                        break;
                    }
                    default: {
                        this.jj_la1[26] = this.jj_gen;
                        break block22;
                    }
                }
                eqList = new ArrayList();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 71: {
                        eqList = this.qualifierList();
                        break;
                    }
                    default: {
                        this.jj_la1[27] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 28: {
                        CIMEnumeration<?> cimEnum = this.enumerationDeclaration(eqList);
                        enumList.add(cimEnum);
                        continue block21;
                    }
                    case 45: {
                        CIMStructure cimStruct = this.structureDeclaration(eqList);
                        structList.add(cimStruct);
                        continue block21;
                    }
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 59: {
                        dt = this.getDataType();
                        t = this.jj_consume_token(59);
                        elementName = t.image;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 67: 
                            case 68: 
                            case 71: 
                            case 73: {
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 67: 
                                    case 68: 
                                    case 71: {
                                        CIMClassProperty<?> prop = this.propertyDeclaration(eqList, elementName, dt);
                                        propList.add(prop);
                                        if (!prop.hasQualifier("Key")) continue block21;
                                        keyed = true;
                                        continue block21;
                                    }
                                    case 73: {
                                        CIMMethod<?> method = this.methodDeclaration(eqList, elementName, dt);
                                        methodList.add(method);
                                        continue block21;
                                    }
                                }
                                this.jj_la1[28] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.jj_la1[29] = this.jj_gen;
                        continue block21;
                    }
                }
                break;
            }
            this.jj_la1[30] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(70);
        this.jj_consume_token(67);
        CIMClass c = new CIMClass(className, superClassName, qList.toArray(new CIMQualifier[qList.size()]), propList.toArray(new CIMClassProperty[propList.size()]), methodList.toArray(new CIMMethod[methodList.size()]), structList.toArray(new CIMStructure[structList.size()]), enumList.toArray(new CIMEnumeration[enumList.size()]), true, keyed);
        System.out.println(c);
    }

    public final CIMClassProperty<?> propertyDeclaration(ArrayList<CIMQualifier<?>> qList, String name, CIMDataType dt) throws ParseException, WBEMException {
        Object t = null;
        Object[] value = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 71: {
                this.jj_consume_token(71);
                this.jj_consume_token(72);
                dt = CIMUtilities.getArrayType(dt);
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
            }
        }
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 68: {
                this.jj_consume_token(68);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 69: {
                        this.jj_consume_token(69);
                        value = this.getArrayValue();
                        this.jj_consume_token(70);
                        break block3;
                    }
                    case 46: 
                    case 47: 
                    case 48: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: {
                        value = this.getValue();
                        break block3;
                    }
                }
                this.jj_la1[32] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
            }
        }
        this.jj_consume_token(67);
        CIMClassProperty<Object[]> prop = new CIMClassProperty<Object[]>(name, dt, value, qList.toArray(new CIMQualifier[qList.size()]), false, false);
        if ("" != null) {
            return prop;
        }
        throw new Error("Missing return statement in function");
    }

    public final CIMMethod<?> methodDeclaration(ArrayList<CIMQualifier<?>> qList, String name, CIMDataType dt) throws ParseException, WBEMException {
        ArrayList parameters = new ArrayList();
        CIMParameter<?> param = null;
        this.jj_consume_token(73);
        param = this.parameterDeclaration();
        parameters.add(param);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 65: {
                block6: while (true) {
                    this.jj_consume_token(65);
                    param = this.parameterDeclaration();
                    parameters.add(param);
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 65: {
                            continue block6;
                        }
                    }
                    break;
                }
                this.jj_la1[34] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
            }
        }
        this.jj_consume_token(74);
        this.jj_consume_token(67);
        if ("" != null) {
            return new CIMMethod(name, dt, qList.toArray(new CIMQualifier[qList.size()]), parameters.toArray(new CIMParameter[parameters.size()]), false);
        }
        throw new Error("Missing return statement in function");
    }

    public final CIMParameter<?> parameterDeclaration() throws ParseException, WBEMException {
        Token t = null;
        CIMDataType pdt = null;
        ArrayList<CIMQualifier<?>> pqList = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 71: {
                pqList = this.qualifierList();
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
            }
        }
        pdt = this.getDataType();
        t = this.jj_consume_token(59);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 71: {
                this.jj_consume_token(71);
                this.jj_consume_token(72);
                pdt = CIMUtilities.getArrayType(pdt);
                break;
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
            }
        }
        if ("" != null) {
            return new CIMParameter(t.image, pdt, pqList.toArray(new CIMQualifier[pqList.size()]));
        }
        throw new Error("Missing return statement in function");
    }

    public final CIMEnumeration<?> enumerationDeclaration(ArrayList<CIMQualifier<?>> qList) throws ParseException, WBEMException {
        String parent = null;
        CIMEnumerationEntry<?> cee = null;
        ArrayList eList = new ArrayList();
        ArrayList<CIMQualifier<?>> eeqList = new ArrayList();
        this.jj_consume_token(28);
        CIMObjectPath name = this.getObjectPath();
        this.jj_consume_token(66);
        CIMDataType dt = this.getStringIntDataType();
        this.jj_consume_token(69);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 71: {
                eeqList = this.qualifierList();
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
            }
        }
        cee = this.enumerationEntry(dt, eeqList);
        eList.add(cee);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 65: {
                block12: while (true) {
                    this.jj_consume_token(65);
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 71: {
                            eeqList = this.qualifierList();
                            break;
                        }
                        default: {
                            this.jj_la1[39] = this.jj_gen;
                        }
                    }
                    cee = this.enumerationEntry(dt, eeqList);
                    eList.add(cee);
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 65: {
                            continue block12;
                        }
                    }
                    break;
                }
                this.jj_la1[40] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
            }
        }
        this.jj_consume_token(70);
        this.jj_consume_token(67);
        CIMEnumeration cEnum = new CIMEnumeration(name, dt, parent, eList.toArray(new CIMEnumerationEntry[eList.size()]), qList.toArray(new CIMQualifier[qList.size()]));
        System.out.println(cEnum);
        if ("" != null) {
            return cEnum;
        }
        throw new Error("Missing return statement in function");
    }

    public final CIMEnumerationEntry<?> enumerationEntry(CIMDataType dt, ArrayList<CIMQualifier<?>> qList) throws ParseException, WBEMException {
        Token t = null;
        String name = null;
        Object value = null;
        t = this.jj_consume_token(59);
        name = t.image;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 68: {
                this.jj_consume_token(68);
                value = this.getSimpleValue();
                break;
            }
            default: {
                this.jj_la1[42] = this.jj_gen;
            }
        }
        if ("" != null) {
            return new CIMEnumerationEntry<Object>(name, dt, value == null ? name : value, qList.toArray(new CIMQualifier[qList.size()]));
        }
        throw new Error("Missing return statement in function");
    }

    public final void instanceDeclaration() throws ParseException, WBEMException {
        this.jj_consume_token(31);
        this.jj_consume_token(34);
        this.jj_consume_token(59);
        this.jj_consume_token(69);
        this.jj_consume_token(70);
        this.jj_consume_token(67);
    }

    public final CIMDataType getStringIntDataType() throws ParseException, WBEMException {
        CIMDataType t = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 24: {
                        this.jj_consume_token(24);
                        t = CIMDataType.UINT8_T;
                        break block0;
                    }
                    case 25: {
                        this.jj_consume_token(25);
                        t = CIMDataType.UINT16_T;
                        break block0;
                    }
                    case 26: {
                        this.jj_consume_token(26);
                        t = CIMDataType.UINT32_T;
                        break block0;
                    }
                    case 27: {
                        this.jj_consume_token(27);
                        t = CIMDataType.UINT64_T;
                        break block0;
                    }
                    case 19: {
                        this.jj_consume_token(19);
                        t = CIMDataType.SINT8_T;
                        break block0;
                    }
                    case 20: {
                        this.jj_consume_token(20);
                        t = CIMDataType.SINT16_T;
                        break block0;
                    }
                    case 21: {
                        this.jj_consume_token(21);
                        t = CIMDataType.SINT32_T;
                        break block0;
                    }
                    case 22: {
                        this.jj_consume_token(22);
                        t = CIMDataType.SINT64_T;
                        break block0;
                    }
                    case 23: {
                        this.jj_consume_token(23);
                        t = CIMDataType.STRING_T;
                        break block0;
                    }
                }
                this.jj_la1[43] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[44] = this.jj_gen;
            }
        }
        if ("" != null) {
            return t;
        }
        throw new Error("Missing return statement in function");
    }

    public final CIMDataType getDataType() throws ParseException, WBEMException {
        Token i = null;
        CIMDataType t = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 59: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 24: {
                        this.jj_consume_token(24);
                        t = CIMDataType.UINT8_T;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 71: {
                                this.jj_consume_token(71);
                                this.jj_consume_token(72);
                                t = CIMDataType.UINT8_ARRAY_T;
                                break block0;
                            }
                        }
                        this.jj_la1[45] = this.jj_gen;
                        break block0;
                    }
                    case 25: {
                        this.jj_consume_token(25);
                        t = CIMDataType.UINT16_T;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 71: {
                                this.jj_consume_token(71);
                                this.jj_consume_token(72);
                                t = CIMDataType.UINT16_ARRAY_T;
                                break block0;
                            }
                        }
                        this.jj_la1[46] = this.jj_gen;
                        break block0;
                    }
                    case 26: {
                        this.jj_consume_token(26);
                        t = CIMDataType.UINT32_T;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 71: {
                                this.jj_consume_token(71);
                                this.jj_consume_token(72);
                                t = CIMDataType.UINT32_ARRAY_T;
                                break block0;
                            }
                        }
                        this.jj_la1[47] = this.jj_gen;
                        break block0;
                    }
                    case 27: {
                        this.jj_consume_token(27);
                        t = CIMDataType.UINT64_T;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 71: {
                                this.jj_consume_token(71);
                                this.jj_consume_token(72);
                                t = CIMDataType.UINT64_ARRAY_T;
                                break block0;
                            }
                        }
                        this.jj_la1[48] = this.jj_gen;
                        break block0;
                    }
                    case 19: {
                        this.jj_consume_token(19);
                        t = CIMDataType.SINT8_T;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 71: {
                                this.jj_consume_token(71);
                                this.jj_consume_token(72);
                                t = CIMDataType.SINT8_ARRAY_T;
                                break block0;
                            }
                        }
                        this.jj_la1[49] = this.jj_gen;
                        break block0;
                    }
                    case 20: {
                        this.jj_consume_token(20);
                        t = CIMDataType.SINT16_T;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 71: {
                                this.jj_consume_token(71);
                                this.jj_consume_token(72);
                                t = CIMDataType.SINT16_ARRAY_T;
                                break block0;
                            }
                        }
                        this.jj_la1[50] = this.jj_gen;
                        break block0;
                    }
                    case 21: {
                        this.jj_consume_token(21);
                        t = CIMDataType.SINT32_T;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 71: {
                                this.jj_consume_token(71);
                                this.jj_consume_token(72);
                                t = CIMDataType.SINT32_ARRAY_T;
                                break block0;
                            }
                        }
                        this.jj_la1[51] = this.jj_gen;
                        break block0;
                    }
                    case 22: {
                        this.jj_consume_token(22);
                        t = CIMDataType.SINT64_T;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 71: {
                                this.jj_consume_token(71);
                                this.jj_consume_token(72);
                                t = CIMDataType.SINT64_ARRAY_T;
                                break block0;
                            }
                        }
                        this.jj_la1[52] = this.jj_gen;
                        break block0;
                    }
                    case 23: {
                        this.jj_consume_token(23);
                        t = CIMDataType.STRING_T;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 71: {
                                this.jj_consume_token(71);
                                this.jj_consume_token(72);
                                t = CIMDataType.STRING_ARRAY_T;
                                break block0;
                            }
                        }
                        this.jj_la1[53] = this.jj_gen;
                        break block0;
                    }
                    case 14: {
                        this.jj_consume_token(14);
                        t = CIMDataType.BOOLEAN_T;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 71: {
                                this.jj_consume_token(71);
                                this.jj_consume_token(72);
                                t = CIMDataType.BOOLEAN_ARRAY_T;
                                break block0;
                            }
                        }
                        this.jj_la1[54] = this.jj_gen;
                        break block0;
                    }
                    case 15: {
                        this.jj_consume_token(15);
                        t = CIMDataType.DATETIME_T;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 71: {
                                this.jj_consume_token(71);
                                this.jj_consume_token(72);
                                t = CIMDataType.DATETIME_ARRAY_T;
                                break block0;
                            }
                        }
                        this.jj_la1[55] = this.jj_gen;
                        break block0;
                    }
                    case 16: {
                        this.jj_consume_token(16);
                        t = CIMDataType.OCTETSTRING_T;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 71: {
                                this.jj_consume_token(71);
                                this.jj_consume_token(72);
                                t = CIMDataType.OCTETSTRING_ARRAY_T;
                                break block0;
                            }
                        }
                        this.jj_la1[56] = this.jj_gen;
                        break block0;
                    }
                    case 17: {
                        this.jj_consume_token(17);
                        t = CIMDataType.REAL32_T;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 71: {
                                this.jj_consume_token(71);
                                this.jj_consume_token(72);
                                t = CIMDataType.REAL32_ARRAY_T;
                                break block0;
                            }
                        }
                        this.jj_la1[57] = this.jj_gen;
                        break block0;
                    }
                    case 18: {
                        this.jj_consume_token(18);
                        t = CIMDataType.REAL64_T;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 71: {
                                this.jj_consume_token(71);
                                this.jj_consume_token(72);
                                t = CIMDataType.REAL64_ARRAY_T;
                                break block0;
                            }
                        }
                        this.jj_la1[58] = this.jj_gen;
                        break block0;
                    }
                    case 59: {
                        i = this.jj_consume_token(59);
                        t = new CIMDataType(20, i.image, false);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 43: {
                                this.jj_consume_token(43);
                                t = new CIMDataType(14, i.image, false);
                                break block0;
                            }
                        }
                        this.jj_la1[59] = this.jj_gen;
                        break block0;
                    }
                }
                this.jj_la1[60] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[61] = this.jj_gen;
            }
        }
        if ("" != null) {
            return t;
        }
        throw new Error("Missing return statement in function");
    }

    public final Token getValue() throws ParseException, WBEMException {
        Token t = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 46: {
                t = this.jj_consume_token(46);
                break;
            }
            case 47: {
                t = this.jj_consume_token(47);
                break;
            }
            case 48: {
                this.jj_consume_token(48);
                break;
            }
            case 50: {
                t = this.jj_consume_token(50);
                break;
            }
            case 51: {
                t = this.jj_consume_token(51);
                break;
            }
            case 52: {
                t = this.jj_consume_token(52);
                break;
            }
            case 53: {
                t = this.jj_consume_token(53);
                break;
            }
            case 54: {
                t = this.jj_consume_token(54);
                break;
            }
            case 55: {
                t = this.jj_consume_token(55);
                break;
            }
            case 56: {
                t = this.jj_consume_token(56);
                break;
            }
            case 57: {
                t = this.jj_consume_token(57);
                break;
            }
            case 58: {
                t = this.jj_consume_token(58);
                break;
            }
            case 59: {
                t = this.jj_consume_token(59);
                break;
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return t;
        }
        throw new Error("Missing return statement in function");
    }

    public final Object getSimpleValue() throws ParseException, WBEMException {
        Token t = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 50: {
                t = this.jj_consume_token(50);
                break;
            }
            case 51: {
                t = this.jj_consume_token(51);
                break;
            }
            case 52: {
                t = this.jj_consume_token(52);
                break;
            }
            case 54: {
                t = this.jj_consume_token(54);
                break;
            }
            case 55: {
                t = this.jj_consume_token(55);
                break;
            }
            default: {
                this.jj_la1[64] = this.jj_gen;
                String value = "";
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 57: {
                            break;
                        }
                        default: {
                            this.jj_la1[63] = this.jj_gen;
                            break block10;
                        }
                    }
                    t = this.jj_consume_token(57);
                    value = value + CIMUtilities.parseQuotedString(t.image);
                }
                if ("" == null) break;
                return value;
            }
        }
        if ("" != null) {
            return t.image;
        }
        throw new Error("Missing return statement in function");
    }

    public final Object[] getArrayValue() throws ParseException, WBEMException {
        Object value = null;
        ArrayList<Object> values = new ArrayList<Object>();
        value = this.getSimpleValue();
        values.add(value);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 65: {
                block6: while (true) {
                    this.jj_consume_token(65);
                    value = this.getSimpleValue();
                    values.add(value);
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 65: {
                            continue block6;
                        }
                    }
                    break;
                }
                this.jj_la1[65] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[66] = this.jj_gen;
            }
        }
        if ("" != null) {
            return values.toArray(new Object[values.size()]);
        }
        throw new Error("Missing return statement in function");
    }

    public final CIMObjectPath getObjectPath() throws ParseException, WBEMException {
        Token t = this.jj_consume_token(59);
        if ("" != null) {
            return new CIMObjectPath(t.image);
        }
        throw new Error("Missing return statement in function");
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{-1879035392, 0, 0x10003000, -1879035392, -1879035392, 0x40000000, 0, 0, 0, 0, 0, 0, 0, 0x30003400, 0, 536854528, 0, 0, 536854528, 0, 536854528, 0, 0, 0, 536854528, 0, 536854528, 0, 0, 0, 536854528, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0xFF80000, 0xFF80000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0xFFFC000, 0xFFFC000, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{9216, 0, 9216, 9216, 9216, 2, 0, 0, 0, 0, 0, 112, 112, 9993, 0, 0x8002000, 0, 0, 0x8002000, 0, 0x8002000, 0, 0, 0, 0x8002000, 0, 0x8002000, 0, 0, 0, 0x8002000, 0, 268288000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2048, 0x8000000, 0x8000000, 268288000, 0x2000000, 0xDC0000, 0, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{128, 128, 0, 128, 128, 0, 2, 2, 544, 544, 2, 0, 0, 0, 4, 128, 128, 152, 0, 4, 128, 128, 664, 664, 0, 4, 128, 128, 664, 664, 0, 128, 32, 16, 2, 2, 128, 128, 128, 128, 2, 2, 16, 0, 0, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 0, 0, 0, 0, 0, 0, 2, 2};
    }

    public MOFComp(InputStream stream) {
        this(stream, null);
    }

    public MOFComp(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new MOFCompTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 67; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 67; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public MOFComp(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new MOFCompTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 67; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 67; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public MOFComp(MOFCompTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 67; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(MOFCompTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 67; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[75];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 67; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 75; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        MOFComp.jj_la1_init_0();
        MOFComp.jj_la1_init_1();
        MOFComp.jj_la1_init_2();
    }
}

