/*
 * Decompiled with CFR 0.152.
 */
package javax.cim3;

import com.ws.cim3.mof.MOFStyle;
import java.io.Serializable;
import javax.cim3.CIMDataType;
import javax.cim3.CIMEnumerationEntry;
import javax.cim3.CIMNamedElementInterface;
import javax.cim3.CIMObjectPath;
import javax.cim3.CIMQualifiedElementInterface;
import javax.cim3.CIMQualifier;
import javax.cim3.CIMTypedElement;

public class CIMEnumeration<E>
extends CIMTypedElement<E>
implements CIMQualifiedElementInterface,
CIMNamedElementInterface,
Serializable {
    private static final long serialVersionUID = 1L;
    private final CIMObjectPath mObjectPath;
    private final CIMQualifier<?>[] mQualifiers;
    private final CIMEnumerationEntry<?>[] mEntries;
    private final String mParentEnumName;

    public CIMEnumeration(CIMObjectPath name, CIMDataType type, String parentEnumName, CIMEnumerationEntry<?>[] entries, CIMQualifier<?>[] qualifiers) {
        super(name.getObjectName(), type);
        this.mObjectPath = name;
        this.mParentEnumName = parentEnumName;
        this.mEntries = entries;
        this.mQualifiers = qualifiers != null ? qualifiers : new CIMQualifier[]{};
    }

    public CIMEnumerationEntry<?>[] getEntries() {
        return this.mEntries;
    }

    public String getEntryName(Object value) {
        if (null == value) {
            throw new IllegalArgumentException("value shall not be null.");
        }
        for (CIMEnumerationEntry<?> e : this.mEntries) {
            if (!value.equals(e.getValue())) continue;
            return e.getName();
        }
        return null;
    }

    public Object getEntryValue(String name) {
        if (null == name) {
            throw new IllegalArgumentException("name shall not be null.");
        }
        for (CIMEnumerationEntry<?> e : this.mEntries) {
            if (!name.equals(e.getName())) continue;
            return e.getValue();
        }
        return null;
    }

    @Override
    public CIMObjectPath getObjectPath() {
        return this.mObjectPath;
    }

    @Override
    public CIMQualifier<?> getQualifier(int index) throws ArrayIndexOutOfBoundsException {
        return this.mQualifiers[index];
    }

    @Override
    public CIMQualifier<?> getQualifier(String name) {
        if (name != null) {
            for (CIMQualifier<?> mQualifier : this.mQualifiers) {
                if (!mQualifier.getName().equalsIgnoreCase(name)) continue;
                return mQualifier;
            }
        }
        return null;
    }

    @Override
    public int getQualifierCount() {
        return this.mQualifiers.length;
    }

    @Override
    public CIMQualifier<?>[] getQualifiers() {
        return this.mQualifiers;
    }

    @Override
    public Object getQualifierValue(String name) {
        CIMQualifier<?> q = this.getQualifier(name);
        if (q != null) {
            return q.getValue();
        }
        return null;
    }

    public String getSuperClassName() {
        return this.mParentEnumName;
    }

    @Override
    public boolean hasQualifier(String name) {
        return this.getQualifier(name) != null;
    }

    @Override
    public boolean hasQualifierValue(String name, Object value) {
        CIMQualifier<?> q = this.getQualifier(name);
        return q != null && q.getValue() != null && q.getValue().equals(value);
    }

    @Override
    public String toString() {
        MOFStyle mf = new MOFStyle();
        return mf.generateMOF(this);
    }
}

