/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.messaging.config.ConfigurationException;
import flex.messaging.config.ConfigurationFileResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class LocalFileResolver
implements ConfigurationFileResolver {
    public static final int CLIENT = 0;
    public static final int SERVER = 1;
    public static final int LIVECYCLE = 2;
    private static final int ERR_MSG_INVALID_PATH_CLIENT = 11106;
    private static final int ERR_MSG_INVALID_PATH_SERVER = 11108;
    private static final int ERR_MSG_INVALID_PATH_LIVECYCLE = 11122;
    private Stack configurationPathStack = new Stack();
    int version = 0;

    public LocalFileResolver() {
    }

    public LocalFileResolver(int version) {
        this.version = version;
    }

    public void setErrorMessage(ConfigurationException e, String path) {
        if (this.version == 2) {
            e.setMessage(11122, new Object[]{path});
        } else if (this.version == 1) {
            e.setMessage(11108, new Object[]{path});
        } else {
            e.setMessage(11106);
        }
    }

    @Override
    public InputStream getConfigurationFile(String path) {
        File f = new File(path);
        try {
            if (f != null && f.exists() && f.isAbsolute()) {
                FileInputStream fin = new FileInputStream(f);
                this.pushConfigurationFile(f.getParent());
                return fin;
            }
            ConfigurationException e = new ConfigurationException();
            this.setErrorMessage(e, path);
            throw e;
        }
        catch (FileNotFoundException ex) {
            ConfigurationException e = new ConfigurationException();
            this.setErrorMessage(e, path);
            e.setRootCause(ex);
            throw e;
        }
        catch (SecurityException se) {
            ConfigurationException e = new ConfigurationException();
            this.setErrorMessage(e, path);
            e.setRootCause(se);
            throw e;
        }
    }

    @Override
    public InputStream getIncludedFile(String src) {
        String path = this.configurationPathStack.peek() + File.separator + src;
        File f = new File(path);
        try {
            if (f != null && f.exists() && f.isAbsolute()) {
                FileInputStream fin = new FileInputStream(f);
                this.pushConfigurationFile(f.getParent());
                return fin;
            }
            ConfigurationException e = new ConfigurationException();
            e.setMessage(11107, new Object[]{path});
            throw e;
        }
        catch (FileNotFoundException ex) {
            ConfigurationException e = new ConfigurationException();
            e.setMessage(11107, new Object[]{path});
            e.setRootCause(ex);
            throw e;
        }
        catch (SecurityException se) {
            ConfigurationException e = new ConfigurationException();
            e.setMessage(11107, new Object[]{path});
            e.setRootCause(se);
            throw e;
        }
    }

    @Override
    public void popIncludedFile() {
        this.configurationPathStack.pop();
    }

    @Override
    public List getFiles(String dir) {
        ArrayList<String> result = new ArrayList<String>();
        File f = new File(this.configurationPathStack.peek().toString(), dir);
        if (f.exists() && f.isDirectory()) {
            String[] xmlFiles = f.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".xml");
                }
            });
            for (int i = 0; i < xmlFiles.length; ++i) {
                String file = xmlFiles[i];
                result.add(dir + File.separator + file);
            }
            return result;
        }
        ConfigurationException e = new ConfigurationException();
        e.setMessage(11113, new Object[]{dir});
        throw e;
    }

    private void pushConfigurationFile(String topLevelPath) {
        this.configurationPathStack.push(topLevelPath);
    }

    public String getIncludedPath(String src) {
        return this.configurationPathStack.peek() + File.separator + src;
    }

    public long getIncludedLastModified(String src) {
        String path = this.configurationPathStack.peek() + File.separator + src;
        File f = new File(path);
        return f.lastModified();
    }
}

