/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wbem.WBEMException;

class CachedObject<T extends Serializable>
implements Serializable {
    private static final Logger mLogger = Logger.getLogger("com.hitachi.smis.logger.cache");
    private static final long serialVersionUID = 2L;
    private Class<?> theClass = null;
    private List<T> data = null;
    private transient ReadWriteLock rwl;

    CachedObject(List<T> obj, Class<?> clzType) {
        this.data = obj;
        this.theClass = clzType;
        this.rwl = new ReentrantReadWriteLock();
    }

    void addData(List<T> addList, Class<?> clzType) throws WBEMException {
        block9: {
            if (addList != null && addList.size() > 0) {
                try {
                    this.rwl.writeLock().lock();
                    if (this.theClass.isAssignableFrom(clzType)) {
                        this.logListData("Adding", addList, this.data);
                        if (!this.data.addAll(addList)) {
                            mLogger.severe("Cached Data was not updated!");
                        } else {
                            this.logListData("Adding", null, this.data);
                        }
                        break block9;
                    }
                    throw new ClassCastException("Expected " + this.theClass.toString() + " got " + clzType.toString());
                }
                catch (Throwable exp) {
                    String msg = "Failed to add cache object: " + exp.toString();
                    mLogger.log(Level.SEVERE, msg, exp);
                    throw new WBEMException(1, msg, null, exp);
                }
                finally {
                    this.rwl.writeLock().unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T[] getData() {
        Serializable[] ret = null;
        try {
            Serializable[] t;
            this.rwl.readLock().lock();
            ret = t = this.data.toArray((Serializable[])Array.newInstance(this.theClass.getComponentType(), this.data.size()));
        }
        catch (Throwable exp) {
            mLogger.log(Level.SEVERE, "Exception accessing cache: " + exp.toString(), exp);
            ret = null;
        }
        finally {
            this.rwl.readLock().unlock();
        }
        return ret;
    }

    ReadWriteLock getRWL() {
        return this.rwl;
    }

    private void logListData(String pItemAction, List<?> items, List<?> cachedData) {
        if (items != null && items.isEmpty()) {
            return;
        }
        try {
            Object item;
            int x;
            StringBuilder msg = new StringBuilder("Cache has ");
            msg.append(cachedData.size());
            msg.append(' ');
            msg.append(this.data.size() > 0 ? ((Serializable)this.data.get(0)).getClass().getSimpleName() : "UNKNOWN");
            msg.append(" elements for specified key");
            if (mLogger.isLoggable(Level.FINE)) {
                msg.append("\n");
                for (x = 0; x < this.data.size(); ++x) {
                    item = this.data.get(x);
                    if (x != 0) {
                        msg.append(',');
                    } else {
                        msg.append(": ");
                    }
                    if (mLogger.isLoggable(Level.FINEST)) {
                        msg.append(item);
                    } else {
                        msg.append(item.hashCode());
                    }
                    msg.append("\n");
                }
            }
            if (items != null) {
                msg.append(", ");
                msg.append(pItemAction == null ? "null" : pItemAction);
                msg.append(' ');
                msg.append(items != null ? Integer.valueOf(items.size()) : "0");
                msg.append(" elements");
                if (mLogger.isLoggable(Level.FINE)) {
                    msg.append("\n");
                    for (x = 0; items != null && x < items.size(); ++x) {
                        if (x != 0) {
                            msg.append(',');
                        } else {
                            msg.append(": ");
                        }
                        item = items.get(x);
                        if (mLogger.isLoggable(Level.FINEST)) {
                            msg.append(item);
                            continue;
                        }
                        msg.append(item.hashCode());
                    }
                    msg.append("\n");
                }
            }
            mLogger.info(msg.toString());
        }
        catch (Throwable t) {
            mLogger.log(Level.INFO, "non-fatal exception logging cache data " + t, t);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.rwl = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int removeItems(List<?> removedList) {
        try {
            this.rwl.writeLock().lock();
            this.logListData("Removing", removedList, this.data);
            if (!this.data.removeAll(removedList)) {
                mLogger.warning("Cached Data was not updated, element may have been removed already.");
            } else {
                this.logListData("Removing", null, this.data);
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        return this.data.size();
    }

    void setData(List<T> pData, Class<?> clzType) throws WBEMException {
        block6: {
            try {
                this.rwl.writeLock().lock();
                Class<?> f = clzType;
                if (this.theClass.isInstance(f)) {
                    this.data = pData;
                    break block6;
                }
                throw new ClassCastException("Expected " + this.theClass + " got " + f);
            }
            catch (Throwable exp) {
                String msg = "Failed to set cache object: " + exp.toString();
                mLogger.log(Level.SEVERE, msg, exp);
                throw new WBEMException(1, msg, null, exp);
            }
            finally {
                this.rwl.writeLock().unlock();
            }
        }
    }
}

