/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.cache;

import com.hitachi.smi.cache.AbstractVersionChecker;
import com.hitachi.smi.cache.CacheUpdateType;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.common.LDevNickname;
import com.hitachi.smi.common.PoolNickname;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_VerLeaf;

public class NicknameVersionChecker
extends AbstractVersionChecker {
    protected NicknameVersionChecker(String serialNum) {
        super(serialNum);
        CacheUpdater.registerVersionChecker(CacheUpdater.ConfVerID.NICKNAME, this);
    }

    private void checkLDevVersionDetails(Robj_interface_VerLeaf currentChildren, Robj_interface_VerLeaf prevChildren) {
        if (currentChildren == null || prevChildren == null) {
            mLogger.info("VerLeaf can not be null, current: " + currentChildren + ", prior: " + prevChildren);
        } else {
            LinkedList<LDevNickname> added = new LinkedList<LDevNickname>();
            LinkedList<LDevNickname> removed = new LinkedList<LDevNickname>();
            LinkedList<LDevNickname> modified = new LinkedList<LDevNickname>();
            try {
                LDevNickname.modifyCachedNickename(added, removed, modified, this.getSerialNumber());
                if (!modified.isEmpty()) {
                    CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.MODIFY, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.LDEVNICKNAME, (Serializable[])modified.toArray(new LDevNickname[modified.size()]));
                    modified = null;
                }
                if (!removed.isEmpty()) {
                    CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.DELETE, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.LDEVNICKNAME, (Serializable[])removed.toArray(new LDevNickname[removed.size()]));
                    removed = null;
                }
                if (!added.isEmpty()) {
                    CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.ADD, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.LDEVNICKNAME, (Serializable[])added.toArray(new LDevNickname[added.size()]));
                    added = null;
                }
            }
            catch (WBEMException we) {
                mLogger.log(Level.SEVERE, "Excpetion occurred trying to update LDEV Nicknames: " + (Object)((Object)we), we);
            }
        }
    }

    private void checkPoolVersionDetails(Robj_interface_VerLeaf currentChildren, Robj_interface_VerLeaf prevChildren) {
        if (currentChildren == null || prevChildren == null) {
            mLogger.info("VerLeaf can not be null, current: " + currentChildren + ", prior: " + prevChildren);
        } else if (currentChildren.getNVer() != prevChildren.getNVer()) {
            LinkedList<PoolNickname> added = new LinkedList<PoolNickname>();
            LinkedList<PoolNickname> removed = new LinkedList<PoolNickname>();
            LinkedList<PoolNickname> modified = new LinkedList<PoolNickname>();
            try {
                PoolNickname.modifyCachedNickename(added, removed, modified, this.getSerialNumber());
                if (!modified.isEmpty()) {
                    CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.MODIFY, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.POOLNICKNAME, (Serializable[])modified.toArray(new PoolNickname[modified.size()]));
                    modified = null;
                }
                if (!removed.isEmpty()) {
                    CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.DELETE, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.POOLNICKNAME, (Serializable[])removed.toArray(new PoolNickname[removed.size()]));
                    removed = null;
                }
                if (!added.isEmpty()) {
                    CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.ADD, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.POOLNICKNAME, (Serializable[])added.toArray(new PoolNickname[added.size()]));
                    added = null;
                }
            }
            catch (WBEMException we) {
                mLogger.log(Level.SEVERE, "Excpetion occurred trying to update Pool Nicknames: " + (Object)((Object)we), we);
            }
        }
    }

    @Override
    public void checkVersionDetails(Robj_interface_VerLeaf[] currentChildren, Robj_interface_VerLeaf[] prevChildren) {
        this.checkLDevVersionDetails(currentChildren[0], prevChildren[0]);
        this.checkPoolVersionDetails(currentChildren[1], prevChildren[1]);
    }
}

