/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.cache.CacheLib;
import com.hitachi.smi.cache.HitachiCacheInterface;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.FindMethodCallbackHandler;
import com.hitachi.smi.common.IteratorCallback;
import com.hitachi.smi.common.PGInfo;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.paralleltasker.Task;
import com.hitachi.smi.paralleltasker.TaskProcessor;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_CloneMaker;
import sanproject.common.Robj_interface_EXDExternalLogicalPath;
import sanproject.common.Robj_interface_EXDExternalLogicalPathEx;
import sanproject.common.Robj_interface_EXDExternalLogicalPathSx;
import sanproject.common.Robj_interface_EXDExternalVolumeSx;
import sanproject.common.Robj_interface_EXDgetMappedExternalVolume_Fb4PgSx_IN;
import sanproject.common.Robj_interface_EXDgetMappedExternalVolume_Fb4PgSx_OUT;
import sanproject.common.Robj_interface_RJiPGIndex;
import sanproject.serversx.data.RJiPGIndex;
import sanproject.serverux.data.GetRmiException;
import sanproject.serverux.data.SANRmiException;

public class ExternalChassisArrayGroup
extends ChassisArrayGroup {
    private static final long serialVersionUID = 2L;
    private static final String ECAG = "ECAG:";
    private static final Class<ExternalChassisArrayGroup[]> clz = ExternalChassisArrayGroup[].class;
    private byte altPathBmp;
    private int exg;
    private short lBMode;
    private int pathGrpNum;
    private String extVendor;
    private final ArrayList<String> extLuns;
    private final ArrayList<String> extWWNs;
    private final ArrayList<String> extPortIDs;
    private final ArrayList<Short> extQDepths;
    private final ArrayList<Short> extIOTimeOuts;
    private final ArrayList<Short> extPathWatches;
    private String exStorageName;
    private String exSerialNum;
    private String exDeviceID;
    private String exStorageVolumeName;
    private String exVendor;
    private UnsignedInteger16 mDataOrg;
    private int optionFlag;
    private int extID;
    private String extDeviceID2;
    private short extPathMode;

    private static void addCAGToMap(HashMap<String, List<ExternalChassisArrayGroup>> cagMap, ExternalChassisArrayGroup cag) {
        String key = CacheLib.getCAGFB4String(ECAG, cag.getFb4());
        CacheLib.addToMap(cagMap, key, cag);
        key = null;
        key = CacheLib.getCAGString(ECAG, cag.getFb4(), cag.getArrayGroup());
        CacheLib.addToMap(cagMap, key, cag);
        key = null;
        key = CacheLib.getFB4PgString(ECAG, cag.getFb4(), cag.getPg());
        CacheLib.addToMap(cagMap, key, cag);
        key = null;
        key = CacheLib.getCAGAllString(ECAG, cag.getFb4(), cag.getPg(), cag.getVdev(), cag.getArrayGroup());
        CacheLib.addToMap(cagMap, key, cag);
    }

    public static ExternalChassisArrayGroup[] addExternalCAGFromCache(HashMap<Integer, List<Integer>> added, String serialNum) {
        ArrayList<ExternalChassisArrayGroup> ret = new ArrayList<ExternalChassisArrayGroup>();
        try {
            ExternalChassisArrayGroup ecag;
            RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(serialNum).getRMIObject();
            CommonClassAsList<ExternalChassisArrayGroup> callback = new CommonClassAsList<ExternalChassisArrayGroup>();
            ExternalChassisArrayGroup.getUnCachedExternalChassisArrayGroup(rmiObj, callback, false, -1, -1, -1);
            LinkedList<ExternalChassisArrayGroup> ecags = callback.getReturnValue();
            callback = null;
            ProviderLibs.sortHashMapList(added);
            HashMap<String, List<ExternalChassisArrayGroup>> pathMap = new HashMap<String, List<ExternalChassisArrayGroup>>();
            while ((ecag = (ExternalChassisArrayGroup)ecags.poll()) != null) {
                List<Integer> addedList = added.get(ecag.getFb4());
                if (null == addedList || Collections.binarySearch(addedList, ecag.getPg()) < 0) continue;
                ret.add(ecag);
                ExternalChassisArrayGroup.addCAGToMap(pathMap, ecag);
            }
            CacheLib.addDataToCache(pathMap, ret, clz, serialNum);
        }
        catch (WBEMException we) {
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
            logger.log(Level.SEVERE, "Exception trying to get new PGInfo on " + serialNum, we);
        }
        return ret.toArray(new ExternalChassisArrayGroup[ret.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cache(RMIObjectMapping mapObj) throws WBEMException {
        RMIObjectCache rmiObj = mapObj.getRMIObject();
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (!cache.isCached(clz)) {
            Class<ExternalChassisArrayGroup> clazz = ExternalChassisArrayGroup.class;
            synchronized (ExternalChassisArrayGroup.class) {
                if (!cache.isCached(clz)) {
                    CommonClassAsList<ExternalChassisArrayGroup> callback = new CommonClassAsList<ExternalChassisArrayGroup>();
                    ExternalChassisArrayGroup.getUnCachedExternalChassisArrayGroup(rmiObj, callback, false, -1, -1, -1);
                    LinkedList<ExternalChassisArrayGroup> cags = callback.getReturnValue();
                    callback = null;
                    HashMap<String, List<ExternalChassisArrayGroup>> cagMap = new HashMap<String, List<ExternalChassisArrayGroup>>();
                    for (ExternalChassisArrayGroup cag : cags) {
                        ExternalChassisArrayGroup.addCAGToMap(cagMap, cag);
                    }
                    CacheLib.addDataToCache(cagMap, cags, clz, mapObj.getSerialNumber());
                } else {
                    Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
                    logger.warning("ExternalChassisArrayGroup is already in the cache");
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else {
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
            logger.warning("ExternalChassisArrayGroup is already in the cache");
        }
    }

    public static ExternalChassisArrayGroup find(Integer chassis, Integer arrayGroup, RMIObjectCache rmiobj, boolean isObjectPath) throws WBEMException {
        ExternalChassisArrayGroup ret = null;
        FindMethodCallbackHandler<ExternalChassisArrayGroup> callback = new FindMethodCallbackHandler<ExternalChassisArrayGroup>();
        ExternalChassisArrayGroup.getExternalChassisArrayGroup(rmiobj, callback, isObjectPath, chassis, -1, arrayGroup);
        ret = callback.getReturnValue();
        return ret;
    }

    public static void getExternalChassisArrayGroup(RMIObjectCache rmiobj, IteratorCallback<ExternalChassisArrayGroup> callback, boolean isObjectPath) throws WBEMException {
        ExternalChassisArrayGroup.getExternalChassisArrayGroup(rmiobj, callback, isObjectPath, -1, -1, -1);
    }

    public static void getExternalChassisArrayGroup(RMIObjectCache rmiobj, IteratorCallback<ExternalChassisArrayGroup> callback, boolean isObjectPath, int pFB4) throws WBEMException {
        ExternalChassisArrayGroup.getExternalChassisArrayGroup(rmiobj, callback, isObjectPath, pFB4, -1, -1);
    }

    public static void getExternalChassisArrayGroup(RMIObjectCache rmiObj, IteratorCallback<ExternalChassisArrayGroup> callback, boolean isObjectPath, int pFB4, int pPG, int pAG) throws WBEMException {
        Class<ExternalChassisArrayGroup[]> clz;
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (cache.isCached(clz = ExternalChassisArrayGroup[].class)) {
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
            AbstractBaseCommonObject[] cags = null;
            String key = null;
            if (pFB4 == -1) {
                cags = (ExternalChassisArrayGroup[])cache.getCachedObject(clz);
            } else if (pPG != -1 && pAG != -1) {
                key = CacheLib.getCAGAllString(ECAG, pFB4, pPG, -1, pAG);
                cags = (ExternalChassisArrayGroup[])cache.getCachedObject(key, clz);
            } else if (pPG != -1 && pAG == -1) {
                key = CacheLib.getFB4PgString(ECAG, pFB4, pPG);
                cags = (ExternalChassisArrayGroup[])cache.getCachedObject(key, clz);
            } else if (pAG != -1) {
                key = CacheLib.getCAGString(ECAG, pFB4, pAG);
                cags = (ExternalChassisArrayGroup[])cache.getCachedObject(key, clz);
            } else {
                throw new WBEMException(1, "Unexpected key combination for ExternalChassisArrayGroup(" + pFB4 + ", " + pPG + ", " + pAG);
            }
            if (cags != null) {
                callback.returnItems(cags);
            } else {
                logger.info("No ExternalChassisArrayGroup (VDEVs) in cache.");
                callback.done();
            }
        } else {
            LogRecord record = new LogRecord(Level.WARNING, "ExternalChassisArray not cached on {0}, performance issue");
            record.setParameters(new Object[]{rmiObj.getSMISMappingContainer().getSerialNumber()});
            record.setThrown(new Exception(record.getMessage()));
            cacheLogger.log(record);
            ExternalChassisArrayGroup.getUnCachedExternalChassisArrayGroup(rmiObj, callback, isObjectPath, pFB4, pPG, pAG);
        }
    }

    private static Robj_interface_EXDExternalVolumeSx[] getInfoSxData(RMIObjectCache rmiobj, LinkedList<PGInfo> pgIndexes) throws RemoteException, SANRmiException, WBEMException {
        Robj_interface_EXDExternalVolumeSx[] ret;
        Robj_interface_CloneMaker cloner = rmiobj.getCloneMaker();
        Robj_interface_EXDgetMappedExternalVolume_Fb4PgSx_IN inObj = (Robj_interface_EXDgetMappedExternalVolume_Fb4PgSx_IN)rmiobj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.EXDGETEXTERNALMAPPEDVOLUME_IN);
        RJiPGIndex pgIndex = (RJiPGIndex)rmiobj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.RJIPGINDEX);
        Iterator iter = pgIndexes.iterator();
        while (iter.hasNext()) {
            PGInfo val = (PGInfo)iter.next();
            if (val.isExternalVolume()) {
                Robj_interface_RJiPGIndex index = (Robj_interface_RJiPGIndex)cloner.createClone((Object)pgIndex);
                index.setIFB4(val.getFB4());
                index.setIPG(val.getPG());
                inObj.setRJiPGIndex(index);
                continue;
            }
            iter.remove();
        }
        if (0 != pgIndexes.size()) {
            Robj_interface_EXDgetMappedExternalVolume_Fb4PgSx_OUT outObj = (Robj_interface_EXDgetMappedExternalVolume_Fb4PgSx_OUT)rmiobj.getCmnData(inObj);
            ret = outObj.getAllEXDExternalVolume();
            if (null == ret || 0 == ret.length) {
                ret = new Robj_interface_EXDExternalVolumeSx[pgIndexes.size()];
            } else if (pgIndexes.size() != ret.length) {
                String msg = String.format("We have %d pgIndexes but only %d EXDExternalVolumeSx", pgIndexes.size(), ret.length);
                throw new WBEMException(msg);
            }
        } else {
            ret = new Robj_interface_EXDExternalVolumeSx[pgIndexes.size()];
        }
        return ret;
    }

    public static void getUnCachedExternalChassisArrayGroup(RMIObjectCache rmiobj, IteratorCallback<ExternalChassisArrayGroup> callback, boolean isObjectPath, int pFB4, int pPG, int pAG) throws WBEMException {
        block9: {
            try {
                LinkedList<Object> pgIndexes;
                if (-1 != pFB4 && -1 != pPG) {
                    pgIndexes = new LinkedList();
                    PGInfo pg = PGInfo.find(rmiobj, pFB4, pPG);
                    if (null != pg) {
                        pgIndexes.offer(pg);
                    }
                } else {
                    CommonClassAsList<PGInfo> pgs = new CommonClassAsList<PGInfo>();
                    PGInfo.getPGInfos(rmiobj, pgs);
                    pgIndexes = pgs.getReturnValue();
                }
                int index = 0;
                if (pgIndexes.size() > 0) {
                    Robj_interface_EXDExternalVolumeSx[] infoSx = !isObjectPath ? ExternalChassisArrayGroup.getInfoSxData(rmiobj, pgIndexes) : new Robj_interface_EXDExternalVolumeSx[pgIndexes.size()];
                    if (pgIndexes.size() > 0) {
                        TaskProcessor task = new TaskProcessor(ECAG, pgIndexes.size());
                        PGInfo pgIndex = (PGInfo)pgIndexes.poll();
                        while (pgIndex != null) {
                            if (task.shouldStop()) {
                                callback.done();
                                break block9;
                            }
                            WorkerThread worker = new WorkerThread(callback, rmiobj, pgIndex, infoSx[index++], isObjectPath, task, pAG);
                            task.addTask(worker);
                            pgIndex = (PGInfo)pgIndexes.poll();
                        }
                        break block9;
                    }
                    callback.done();
                    break block9;
                }
                callback.done();
            }
            catch (Exception e) {
                WBEMException we = new WBEMException(1, e.toString(), null, (Throwable)e);
                callback.exceptionOccurred(we);
                callback.done();
            }
        }
    }

    public static ExternalChassisArrayGroup[] modifyECAGInCache(Map<Integer, List<Integer>> modified, String serialNum) {
        LinkedList<ExternalChassisArrayGroup> modifiedECAGs = new LinkedList<ExternalChassisArrayGroup>();
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
        try {
            ExternalChassisArrayGroup actualECAG;
            RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(serialNum).getRMIObject();
            CommonClassAsList<ExternalChassisArrayGroup> callback = new CommonClassAsList<ExternalChassisArrayGroup>();
            ExternalChassisArrayGroup.getUnCachedExternalChassisArrayGroup(rmiObj, callback, false, -1, -1, -1);
            LinkedList<ExternalChassisArrayGroup> actualECAGs = callback.getReturnValue();
            callback = null;
            logger.log(Level.INFO, "Processing {0} ExternalChassisArrayGroup on {1}", new Object[]{actualECAGs.size(), serialNum});
            while ((actualECAG = actualECAGs.poll()) != null) {
                List<Integer> modifiedPGs = modified.get(actualECAG.getFb4());
                if (modifiedPGs == null || Collections.binarySearch(modifiedPGs, actualECAG.getPg()) < 0) continue;
                ExternalChassisArrayGroup cachedECAG = ExternalChassisArrayGroup.find(actualECAG.getFb4(), (Integer)ExternalChassisArrayGroup.makeArrayGroup(actualECAG.getFb4(), actualECAG.getPg(), -1), rmiObj, false);
                if (cachedECAG != null) {
                    if (cachedECAG.equals(actualECAG)) continue;
                    modifiedECAGs.add(new ExternalChassisArrayGroup(cachedECAG));
                    cachedECAG.copyECAG(actualECAG);
                    continue;
                }
                logger.info("ECAG (" + actualECAG.getFb4() + ", " + ExternalChassisArrayGroup.makeArrayGroup(actualECAG.getFb4(), actualECAG.getPg(), -1) + " was marked modified but it is not in the cache");
            }
            logger.info("Done processimg ExternalChassisArrayGroup");
        }
        catch (WBEMException we) {
            logger.log(Level.SEVERE, "Exception trying to get new ExternalChassisArrayGroup", we);
        }
        return modifiedECAGs.toArray(new ExternalChassisArrayGroup[modifiedECAGs.size()]);
    }

    private static boolean processInfoDetail(IteratorCallback<ExternalChassisArrayGroup> callback, RMIObjectCache rmiobj, PGInfo theVal, Robj_interface_EXDExternalVolumeSx infoSx, boolean isObjectPath, int pAG) {
        boolean ret = true;
        try {
            ExternalChassisArrayGroup ecag;
            if (theVal.isExternalVolume() && (ecag = new ExternalChassisArrayGroup(rmiobj.getSMISMappingContainer().getSerialNumber(), theVal.getFB4(), theVal.getPG())).isValid() && (pAG == -1 || pAG == ecag.getArrayGroup())) {
                if (!isObjectPath) {
                    Logger logger;
                    ecag.seqNum = theVal.getRaidLevel();
                    ecag.raidLevel = ProviderLibs.getRaidLevelAsString(rmiobj, ecag.seqNum);
                    ChassisArrayGroup cag = ChassisArrayGroup.find(rmiobj, ecag.getFb4(), ecag.getPg(), false);
                    if (null != cag) {
                        ecag.numConsumableBlocks = cag.getNumberOfBlocks();
                    } else {
                        ecag.numConsumableBlocks = ProviderConstants.UINT64_ZED;
                        logger = Logger.getLogger("com.hitachi.smis.logger.provider");
                        logger.log(Level.WARNING, "Unable to find CAG with FB4: {0} and ArrayGroup: {1}", new Object[]{ecag.fb4, ecag.arrayGroup});
                    }
                    ecag.setBlockSize(theVal);
                    if (null != infoSx) {
                        ecag.exStorageName = infoSx.getProduct();
                        ecag.exSerialNum = infoSx.getSerialNumber();
                        ecag.exDeviceID = infoSx.getDeviceId();
                        ecag.exStorageVolumeName = infoSx.getExtProductId();
                        ecag.exVendor = infoSx.getVendor();
                        ecag.optionFlag = infoSx.getOptionFlag();
                        ecag.extID = infoSx.getId();
                        ecag.extDeviceID2 = infoSx.getDeviceId2();
                        ecag.extPathMode = infoSx.getPathMode();
                        Robj_interface_EXDExternalLogicalPathSx[] paths = infoSx.getExtPathList();
                        ecag.altPathBmp = infoSx.getAltpathbmp();
                        ecag.exg = infoSx.getExG();
                        ecag.lBMode = infoSx.getLBmode();
                        ecag.pathGrpNum = infoSx.getPathGroupNo();
                        ecag.extVendor = infoSx.getVendor();
                        ExternalChassisArrayGroup.setExternalDeviceNum(ecag, (Robj_interface_EXDExternalLogicalPath[])paths);
                    } else {
                        logger = Logger.getLogger("com.hitachi.smis.logger.provider");
                        logger.log(Level.SEVERE, "'null' EXDExternalVolumeSx for {0}", ecag.toString());
                    }
                }
                callback.returnItem(ecag);
            }
        }
        catch (Throwable e) {
            WBEMException we = new WBEMException(1, e.toString(), null, e);
            callback.exceptionOccurred(we);
            ret = false;
        }
        return ret;
    }

    public static ExternalChassisArrayGroup[] removeExternalCAGFromCache(HashMap<Integer, List<Integer>> removed, String serialNum) {
        Serializable[] ret = new ExternalChassisArrayGroup[]{};
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
        try {
            ArrayList<ExternalChassisArrayGroup> removedEcags = new ArrayList<ExternalChassisArrayGroup>();
            HashMap<String, List<ExternalChassisArrayGroup>> ecagMap = new HashMap<String, List<ExternalChassisArrayGroup>>();
            Set<Integer> keys = removed.keySet();
            for (Integer key : keys) {
                List<Integer> removedList = removed.get(key);
                logger.info("Processing " + removedList.size() + " External CAGS with FB4: " + key + ", for removal");
                if (removedList == null) continue;
                for (Integer ecagPG : removedList) {
                    ExternalChassisArrayGroup cached = ExternalChassisArrayGroup.find(key, (Integer)ChassisArrayGroup.makeArrayGroup(key, ecagPG, -1), RMIObjectMapping.getRMIObjectMapping(serialNum).getRMIObject(), false);
                    if (null != cached) {
                        ExternalChassisArrayGroup.addCAGToMap(ecagMap, cached);
                        removedEcags.add(cached);
                        continue;
                    }
                    logger.info("ExternalChassisArrayGroup(" + key + ", " + ChassisArrayGroup.makeArrayGroup(key, ecagPG, 1) + ") was removed but it is not in cache");
                }
            }
            ret = removedEcags.toArray(new ExternalChassisArrayGroup[removedEcags.size()]);
            CacheLib.removeDataFromCache(ecagMap, (Serializable[])ret, clz, (String)serialNum);
            logger.info("Done removing ExternalChassisArrayGroup");
        }
        catch (WBEMException we) {
            logger.log(Level.SEVERE, "Exception trying to get new PGInfo on " + serialNum, we);
        }
        return ret;
    }

    private static void setExternalDeviceNum(ExternalChassisArrayGroup ecag, Robj_interface_EXDExternalLogicalPath[] paths) {
        for (Robj_interface_EXDExternalLogicalPath tPath : paths) {
            Robj_interface_EXDExternalLogicalPathEx path = (Robj_interface_EXDExternalLogicalPathEx)tPath;
            if (path == null) continue;
            String extLUN = Integer.toString(path.getExtLUN());
            String extWWN = ProviderLibs.getHexString(path.getExtWWN());
            String extPortID = Integer.toString(path.getExtPortID());
            ecag.extLuns.add(extLUN);
            ecag.extWWNs.add(extWWN);
            ecag.extPortIDs.add(extPortID);
            ecag.extQDepths.add(path.getQdepth());
            ecag.extIOTimeOuts.add(path.getIoTov());
            ecag.extPathWatches.add(path.getPathWatch());
        }
    }

    private ExternalChassisArrayGroup(ExternalChassisArrayGroup cachedECAG) {
        this(cachedECAG.getSerialNumber(), cachedECAG.getFb4(), cachedECAG.getPg());
        this.copyECAG(cachedECAG);
    }

    private ExternalChassisArrayGroup(String serialNum, int fb4, int pg) {
        super(serialNum, fb4, pg);
        this.valid = true == this.valid && fb4 >= 65;
        this.extLuns = new ArrayList();
        this.extWWNs = new ArrayList();
        this.extPortIDs = new ArrayList();
        this.extQDepths = new ArrayList();
        this.extIOTimeOuts = new ArrayList();
        this.extPathWatches = new ArrayList();
        this.extID = -1;
        this.extDeviceID2 = null;
        this.extPathMode = (short)-1;
        this.altPathBmp = (byte)-1;
        this.exg = -1;
        this.lBMode = (short)-1;
        this.pathGrpNum = -1;
        this.extVendor = null;
        this.mDataOrg = ProviderConstants.UINT16_TWO;
        this.exStorageName = null;
        this.exSerialNum = null;
        this.exDeviceID = null;
        this.exStorageVolumeName = null;
        this.exVendor = null;
        this.optionFlag = 0;
    }

    private void copyECAG(ExternalChassisArrayGroup other) {
        String[] otherExtPortIDs;
        String[] otherExtWWNs;
        String[] otherExtLuns;
        this.copyCAG(other);
        for (String extLun : otherExtLuns = other.getExternalDeviceNumber()) {
            this.extLuns.add(new String(extLun));
        }
        for (String extWwn : otherExtWWNs = other.getExternalTargetPortWWN()) {
            this.extWWNs.add(new String(extWwn));
        }
        for (String portID : otherExtPortIDs = other.getExternalPortID()) {
            this.extWWNs.add(new String(portID));
        }
        ArrayList<Short> qDepths = other.getQDepths();
        for (Short qDepth : qDepths) {
            this.extQDepths.add(new Short(qDepth));
        }
        ArrayList<Short> timeOuts = other.getExtIOTimeOuts();
        for (Short timeOut : timeOuts) {
            this.extIOTimeOuts.add(new Short(timeOut));
        }
        ArrayList<Short> pathWatches = other.getPathWatches();
        for (Short pathWatch : pathWatches) {
            this.extPathWatches.add(new Short(pathWatch));
        }
        this.extID = other.getExtID();
        String otherDevID2 = other.getDeviceID2();
        this.extDeviceID2 = null != otherDevID2 ? new String(otherDevID2) : null;
        this.extPathMode = other.getPathMode();
        this.mDataOrg = new UnsignedInteger16(other.getDataOrg().intValue());
        this.exStorageName = new String(other.getExternalStorageName());
        this.exSerialNum = new String(other.exSerialNum);
        this.exDeviceID = new String(other.getExternalDeviceID());
        this.exStorageVolumeName = new String(other.getExternalStorageVolumeName());
        this.exVendor = new String(other.getExternalVendor());
        this.optionFlag = other.getOptionFlag();
        this.altPathBmp = other.getAltPathBmp();
        this.exg = other.getExg();
        this.lBMode = other.getlBMode();
        this.pathGrpNum = other.getPathGrpNum();
        this.extVendor = other.getExtVendor();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExternalChassisArrayGroup other = (ExternalChassisArrayGroup)obj;
        if (this.exDeviceID == null ? other.exDeviceID != null : !this.exDeviceID.equals(other.exDeviceID)) {
            return false;
        }
        if (this.exSerialNum == null ? other.exSerialNum != null : !this.exSerialNum.equals(other.exSerialNum)) {
            return false;
        }
        if (this.exStorageName == null ? other.exStorageName != null : !this.exStorageName.equals(other.exStorageName)) {
            return false;
        }
        if (this.exStorageVolumeName == null ? other.exStorageVolumeName != null : !this.exStorageVolumeName.equals(other.exStorageVolumeName)) {
            return false;
        }
        if (this.exVendor == null ? other.exVendor != null : !this.exVendor.equals(other.exVendor)) {
            return false;
        }
        if (this.extDeviceID2 == null ? other.extDeviceID2 != null : !this.extDeviceID2.equals(other.extDeviceID2)) {
            return false;
        }
        if (this.extID != other.extID) {
            return false;
        }
        if (this.extIOTimeOuts == null ? other.extIOTimeOuts != null : !this.extIOTimeOuts.equals(other.extIOTimeOuts)) {
            return false;
        }
        if (this.extLuns == null ? other.extLuns != null : !this.extLuns.equals(other.extLuns)) {
            return false;
        }
        if (this.extPathMode != other.extPathMode) {
            return false;
        }
        if (this.extPathWatches == null ? other.extPathWatches != null : !this.extPathWatches.equals(other.extPathWatches)) {
            return false;
        }
        if (this.extPortIDs == null ? other.extPortIDs != null : !this.extPortIDs.equals(other.extPortIDs)) {
            return false;
        }
        if (this.extQDepths == null ? other.extQDepths != null : !this.extQDepths.equals(other.extQDepths)) {
            return false;
        }
        if (this.extWWNs == null ? other.extWWNs != null : !this.extWWNs.equals(other.extWWNs)) {
            return false;
        }
        if (this.mDataOrg == null ? other.mDataOrg != null : !this.mDataOrg.equals((Object)other.mDataOrg)) {
            return false;
        }
        return this.optionFlag == other.optionFlag;
    }

    public byte getAltPathBmp() {
        return this.altPathBmp;
    }

    public UnsignedInteger16 getDataOrg() {
        return this.mDataOrg;
    }

    public String getDeviceID2() {
        return this.extDeviceID2;
    }

    public int getExg() {
        return this.exg;
    }

    public String getExternalDeviceID() {
        return this.exDeviceID;
    }

    public String[] getExternalDeviceNumber() {
        return this.extLuns.toArray(new String[this.extLuns.size()]);
    }

    private String[] getExternalPortID() {
        return this.extPortIDs.toArray(new String[this.extPortIDs.size()]);
    }

    public String getExternalStorageName() {
        return this.exStorageName;
    }

    public String getExternalStorageProductName() {
        return this.exStorageName;
    }

    public String getExternalStorageSerialNumber() {
        return this.exSerialNum;
    }

    public String getExternalStorageVolumeName() {
        return this.exStorageVolumeName;
    }

    public String[] getExternalTargetPortWWN() {
        return this.extWWNs.toArray(new String[this.extWWNs.size()]);
    }

    public String getExternalVendor() {
        return this.exVendor;
    }

    public int getExtID() {
        return this.extID;
    }

    public ArrayList<Short> getExtIOTimeOuts() {
        return this.extIOTimeOuts;
    }

    public String getExtVendor() {
        return this.extVendor;
    }

    public UnsignedInteger32[] getIOTimeOutsAsArray() {
        int size = this.extIOTimeOuts.size();
        UnsignedInteger32[] ret = new UnsignedInteger32[size];
        for (int x = 0; x < size; ++x) {
            Short iot = this.extIOTimeOuts.get(x);
            ret[x] = new UnsignedInteger32((long)iot.shortValue());
        }
        return ret;
    }

    public short getlBMode() {
        return this.lBMode;
    }

    public int getOptionFlag() {
        return this.optionFlag;
    }

    public int getPathGrpNum() {
        return this.pathGrpNum;
    }

    public short getPathMode() {
        return this.extPathMode;
    }

    public ArrayList<Short> getPathWatches() {
        return this.extPathWatches;
    }

    public ArrayList<Short> getQDepths() {
        return this.extQDepths;
    }

    public UnsignedInteger32[] getQDepthsAsArray() {
        int size = this.extQDepths.size();
        UnsignedInteger32[] qDepths = new UnsignedInteger32[size];
        for (int x = 0; x < size; ++x) {
            Short qd = this.extQDepths.get(x);
            qDepths[x] = new UnsignedInteger32((long)qd.shortValue());
        }
        return qDepths;
    }

    public String[] getSVDeviceIDs(String pClassName) {
        StringBuffer buf = new StringBuffer(pClassName);
        buf.append(".");
        buf.append(this.getChassisArrayID());
        String[] ret = new String[]{buf.toString()};
        return ret;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.exDeviceID == null ? 0 : this.exDeviceID.hashCode());
        result = 31 * result + (this.exSerialNum == null ? 0 : this.exSerialNum.hashCode());
        result = 31 * result + (this.exStorageName == null ? 0 : this.exStorageName.hashCode());
        result = 31 * result + (this.exStorageVolumeName == null ? 0 : this.exStorageVolumeName.hashCode());
        result = 31 * result + (this.exVendor == null ? 0 : this.exVendor.hashCode());
        result = 31 * result + (this.extDeviceID2 == null ? 0 : this.extDeviceID2.hashCode());
        result = 31 * result + this.extID;
        result = 31 * result + (this.extIOTimeOuts == null ? 0 : this.extIOTimeOuts.hashCode());
        result = 31 * result + (this.extLuns == null ? 0 : this.extLuns.hashCode());
        result = 31 * result + this.extPathMode;
        result = 31 * result + (this.extPathWatches == null ? 0 : this.extPathWatches.hashCode());
        result = 31 * result + (this.extPortIDs == null ? 0 : this.extPortIDs.hashCode());
        result = 31 * result + (this.extQDepths == null ? 0 : this.extQDepths.hashCode());
        result = 31 * result + (this.extWWNs == null ? 0 : this.extWWNs.hashCode());
        result = 31 * result + (this.mDataOrg == null ? 0 : this.mDataOrg.hashCode());
        result = 31 * result + this.optionFlag;
        return result;
    }

    private void setBlockSize(PGInfo theVal) throws WBEMException {
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
        try {
            Hashtable<Integer, String> emulationID = ProviderLibs.getSupportedEmulation(false);
            String emulation = emulationID.get(theVal.getBaseEmulationType());
            Hashtable<String, Integer> emulationType = ProviderLibs.getEmulationType();
            Integer volumeFlag = emulationType.get(emulation);
            int flag = volumeFlag == null ? -1 : volumeFlag;
            switch (flag) {
                case 1: 
                case 2: {
                    this.blockSize = ProviderConstants.UINT64_ONE;
                    break;
                }
                case 3: {
                    this.blockSize = ProviderConstants.UINT64_512;
                    break;
                }
                default: {
                    logger.severe("Unable to get emulation type for PGInfo:" + theVal.getFB4() + "." + theVal.getPG() + " with baseEmultionType: " + theVal.getBaseEmulationType() + "(" + emulation + ")" + ", Emulationtype: " + emulationType + " defaulting to 512 block size.");
                    this.blockSize = ProviderConstants.UINT64_512;
                    break;
                }
            }
        }
        catch (RemoteException re) {
            this.blockSize = ProviderConstants.UINT64_512;
            logger.log(Level.SEVERE, "RemoteException getting Emulationtype: " + re, re);
        }
        catch (GetRmiException gre) {
            this.blockSize = ProviderConstants.UINT64_512;
            logger.log(Level.SEVERE, "GetRmiException getting Emulationtype: " + gre.getErrMsgEn(), gre);
        }
    }

    public void setDataOrg() {
        this.mDataOrg = ProviderConstants.UINT16_TWO;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ExternalChassisArrayGroup [altPathBmp=");
        builder.append(this.altPathBmp);
        builder.append(", exg=");
        builder.append(this.exg);
        builder.append(", lBMode=");
        builder.append(this.lBMode);
        builder.append(", pathGrpNum=");
        builder.append(this.pathGrpNum);
        builder.append(", extVendor=");
        builder.append(this.extVendor);
        builder.append(", extLuns=");
        builder.append(this.extLuns);
        builder.append(", extWWNs=");
        builder.append(this.extWWNs);
        builder.append(", extPortIDs=");
        builder.append(this.extPortIDs);
        builder.append(", extQDepths=");
        builder.append(this.extQDepths);
        builder.append(", extIOTimeOuts=");
        builder.append(this.extIOTimeOuts);
        builder.append(", extPathWatches=");
        builder.append(this.extPathWatches);
        builder.append(", exStorageName=");
        builder.append(this.exStorageName);
        builder.append(", exSerialNum=");
        builder.append(this.exSerialNum);
        builder.append(", exDeviceID=");
        builder.append(this.exDeviceID);
        builder.append(", exStorageVolumeName=");
        builder.append(this.exStorageVolumeName);
        builder.append(", exVendor=");
        builder.append(this.exVendor);
        builder.append(", mDataOrg=");
        builder.append(this.mDataOrg);
        builder.append(", optionFlag=");
        builder.append(this.optionFlag);
        builder.append(", extID=");
        builder.append(this.extID);
        builder.append(", extDeviceID2=");
        builder.append(this.extDeviceID2);
        builder.append(", extPathMode=");
        builder.append(this.extPathMode);
        builder.append("]");
        return builder.toString();
    }

    private static class WorkerThread
    implements Task {
        private PGInfo theVal = null;
        private RMIObjectCache rmiobj = null;
        private final boolean isObjectPath;
        private final TaskProcessor mTheTask;
        private final IteratorCallback<ExternalChassisArrayGroup> callback;
        private final int AG;
        private final Robj_interface_EXDExternalVolumeSx infoSx;

        public WorkerThread(IteratorCallback<ExternalChassisArrayGroup> callback, RMIObjectCache rmiobj, PGInfo pgindex, Robj_interface_EXDExternalVolumeSx infoSx, boolean isObjectPath, TaskProcessor theTask, int pAG) {
            this.rmiobj = rmiobj;
            this.callback = callback;
            this.theVal = pgindex;
            this.isObjectPath = isObjectPath;
            this.mTheTask = theTask;
            this.AG = pAG;
            this.infoSx = infoSx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doTask() {
            try {
                boolean ret;
                if (!this.mTheTask.shouldStop() && !(ret = ExternalChassisArrayGroup.processInfoDetail(this.callback, this.rmiobj, this.theVal, this.infoSx, this.isObjectPath, this.AG))) {
                    this.mTheTask.setStop(true);
                }
            }
            catch (Throwable e) {
                WBEMException we = new WBEMException(1, "Exception while processing items", null, e);
                this.callback.exceptionOccurred(we);
                this.mTheTask.setStop(true);
            }
            finally {
                int counter = this.mTheTask.taskDone();
                if (counter < 1) {
                    this.callback.done();
                }
            }
        }
    }
}

