/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanResponse;
import com.hitachi.smi.cache.CacheLib;
import com.hitachi.smi.cache.HitachiCacheInterface;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.cache.comparator.ISCSIreadAlliSCSIInitiatorsComparator;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.FindMethodCallbackHandler;
import com.hitachi.smi.common.IteratorCallback;
import com.hitachi.smi.common.RMIObjectMapping;
import com.ws.wbem.CloseableAddableIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.wbem.WBEMException;

public class ISCSIreadAlliScsiInitiator
extends AbstractBaseCommonObject
implements Comparable<ISCSIreadAlliScsiInitiator> {
    private static final long serialVersionUID = 1L;
    private static final Class<ISCSIreadAlliScsiInitiator[]> clz = ISCSIreadAlliScsiInitiator[].class;
    private int portID;
    private String name;
    private String userID;
    private String secret;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cache(RMIObjectMapping rmiMapping) throws WBEMException {
        RMIObjectCache rmiObj = rmiMapping.getRMIObject();
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (!cache.isCached(clz)) {
            Class<ISCSIreadAlliScsiInitiator> clazz = ISCSIreadAlliScsiInitiator.class;
            synchronized (ISCSIreadAlliScsiInitiator.class) {
                if (!cache.isCached(clz)) {
                    ClosableAddableIteratorCB<ISCSIreadAlliScsiInitiator> callback = new ClosableAddableIteratorCB<ISCSIreadAlliScsiInitiator>();
                    ISCSIreadAlliScsiInitiator.getUnCached(rmiObj, callback, -1);
                    ArrayList<Object> iSCSIPorts = new ArrayList<Object>();
                    CloseableAddableIterator<ISCSIreadAlliScsiInitiator> iter = callback.getWrappedCloseableAddableIter();
                    while (iter.hasNext()) {
                        iSCSIPorts.add(iter.next());
                    }
                    CacheLib.addItemsToCache(iSCSIPorts, clz, rmiMapping.getSerialNumber());
                } else {
                    cacheLogger.log(Level.SEVERE, "{0} is already in the cache", clz);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else {
            cacheLogger.log(Level.SEVERE, "{0} is already in the cache", clz);
        }
    }

    public static ISCSIreadAlliScsiInitiator find(RMIObjectCache rmiObj, int portID) throws WBEMException {
        if (portID < 0) {
            throw new WBEMException("Find method called with invalid search parameter: " + portID);
        }
        FindMethodCallbackHandler<ISCSIreadAlliScsiInitiator> finder = new FindMethodCallbackHandler<ISCSIreadAlliScsiInitiator>();
        ISCSIreadAlliScsiInitiator.getAll(rmiObj, finder, portID);
        ISCSIreadAlliScsiInitiator ret = finder.getReturnValue();
        return ret;
    }

    public static void getAll(RMIObjectCache rmiObj, IteratorCallback<ISCSIreadAlliScsiInitiator> callback, int portID) throws WBEMException {
        if (null == rmiObj) {
            ISCSIreadAlliScsiInitiator.getISCSIReadAlliSCSIInitiators(callback, portID);
            return;
        }
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (cache.isCached(clz)) {
            ISCSIreadAlliScsiInitiator[] ports = (ISCSIreadAlliScsiInitiator[])cache.getCachedObject(clz);
            if (null != ports) {
                ISCSIreadAlliSCSIInitiatorsComparator<ISCSIreadAlliScsiInitiator> comparator = new ISCSIreadAlliSCSIInitiatorsComparator<ISCSIreadAlliScsiInitiator>(portID);
                for (ISCSIreadAlliScsiInitiator port : ports) {
                    if (!comparator.isMatch(port)) continue;
                    callback.returnItem(port);
                    if (-1 != portID) break;
                }
            }
            callback.done();
        } else {
            LogRecord record = new LogRecord(Level.WARNING, "iSCSIReadAlliSCSIInitiator not cached on {0}, performance issue");
            record.setParameters(new Object[]{rmiObj.getSMISMappingContainer().getSerialNumber()});
            record.setThrown(new Exception(record.getMessage()));
            cacheLogger.log(record);
            ISCSIreadAlliScsiInitiator.getUnCached(rmiObj, callback, portID);
        }
    }

    private static void getISCSIReadAlliSCSIInitiators(IteratorCallback<ISCSIreadAlliScsiInitiator> callback, int portID) throws WBEMException {
        Collection<RMIObjectMapping> mappings = RMIObjectMapping.getAllRMIObjectMappings();
        for (RMIObjectMapping mapObj : mappings) {
            if (null != mapObj) {
                ISCSIreadAlliScsiInitiator.getAll(mapObj.getRMIObject(), callback, portID);
                continue;
            }
            providerLogger.severe("One of the objects returned from getAllMappings is null");
        }
    }

    private static void getUnCached(RMIObjectCache rmiObj, IteratorCallback<ISCSIreadAlliScsiInitiator> callback, int portID2Match) throws WBEMException {
        String serialNumber = rmiObj.getSMISMappingContainer().getSerialNumber();
        try {
            cacheLogger.log(Level.INFO, "Entered getUncached ISCSIreadAlliScsiInitiators for {0}", serialNumber);
            SanResponse responseData = rmiObj.keyValueAPI_InvokeKeyValueAPI("iSCSIreadAlliScsiInitiators", true);
            SanList ports = responseData.getList("iScsiPorts");
            cacheLogger.log(Level.INFO, "Found {0} initiators", ports.size());
            ISCSIreadAlliSCSIInitiatorsComparator<ISCSIreadAlliScsiInitiator> comparator = new ISCSIreadAlliSCSIInitiatorsComparator<ISCSIreadAlliScsiInitiator>(portID2Match);
            for (SanObject port : ports) {
                int portID = port.getInt("Id");
                if (-1 != portID2Match && portID != portID2Match) continue;
                ISCSIreadAlliScsiInitiator element = new ISCSIreadAlliScsiInitiator(serialNumber, portID, port.getObj("iScsiInitiator"));
                if (comparator.isMatch(element)) {
                    callback.returnItem(element);
                }
                if (-1 == portID2Match) continue;
                break;
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            Throwable temp = t;
            while (null != temp.getCause()) {
                temp = temp.getCause();
            }
            throw new WBEMException(1, t.toString() + " getting iSCSI ports", null, temp);
        }
        finally {
            if (null != callback) {
                callback.done();
            }
            cacheLogger.log(Level.INFO, "leaving getUncached network conditions for {0}", serialNumber);
        }
    }

    public static void update(String serialNumber, List<ISCSIreadAlliScsiInitiator> added, List<ISCSIreadAlliScsiInitiator> modified, List<ISCSIreadAlliScsiInitiator> removed) throws WBEMException {
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(serialNumber);
        if (null == device) {
            cacheLogger.log(Level.SEVERE, "Update called for device {0} but no device with that serial number is being managed", serialNumber);
            return;
        }
        final RMIObjectCache rmiObj = device.getRMIObject();
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (cache.isCached(clz)) {
            List<Object> cached;
            ISCSIreadAlliScsiInitiator[] cachedArray = (ISCSIreadAlliScsiInitiator[])cache.getCachedObject(clz);
            if (null != cachedArray) {
                cached = Arrays.asList(cachedArray);
                cachedArray = null;
            } else {
                cached = Collections.emptyList();
            }
            cacheLogger.log(Level.FINE, "Cache has {0} ISCSIreadAlliScsiInitiator", cached.size());
            final ClosableAddableIteratorCB callback = new ClosableAddableIteratorCB();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        ISCSIreadAlliScsiInitiator.getUnCached(rmiObj, callback, -1);
                    }
                    catch (WBEMException we) {
                        callback.exceptionOccurred(we);
                    }
                    catch (Throwable t) {
                        while (null != t.getCause()) {
                            t = t.getCause();
                        }
                        callback.exceptionOccurred(new WBEMException(1, "Exception getting uncached elements during update", null, t));
                    }
                }
            };
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName("ISCSIreadAlliScsiInitiator updater");
            t.start();
            Collections.sort(cached);
            CloseableAddableIterator iter = callback.getWrappedCloseableAddableIter();
            while (iter.hasNext()) {
                ISCSIreadAlliScsiInitiator nonCachedPort = (ISCSIreadAlliScsiInitiator)iter.next();
                int index = Collections.binarySearch(cached, nonCachedPort);
                if (index >= 0) {
                    ISCSIreadAlliScsiInitiator cachedPort = (ISCSIreadAlliScsiInitiator)cached.remove(index);
                    if (nonCachedPort.equals(cachedPort)) continue;
                    StringBuilder msg = new StringBuilder("ISCSIreadAlliScsiInitiator ");
                    msg.append(cachedPort.getPortID());
                    msg.append(" changed");
                    if (cacheLogger.isLoggable(Level.FINER)) {
                        msg.append(System.lineSeparator());
                        msg.append("Cached:");
                        msg.append(System.lineSeparator());
                        msg.append(cachedPort);
                        msg.append("Modified:");
                        msg.append(System.lineSeparator());
                        msg.append(nonCachedPort);
                    } else {
                        cacheLogger.log(Level.FINE, msg.toString());
                    }
                    modified.add(new ISCSIreadAlliScsiInitiator(cachedPort));
                    cachedPort.copy(nonCachedPort);
                    continue;
                }
                cacheLogger.log(Level.FINE, "ISCSITargetPort {0} added", nonCachedPort.getPortID());
                added.add(nonCachedPort);
            }
            removed.addAll(cached);
            if (cacheLogger.isLoggable(Level.FINER) && !removed.isEmpty()) {
                cacheLogger.log(Level.FINER, "Removed ISCSIreadAlliScsiInitiator{0}{1}", new Object[]{System.lineSeparator(), removed});
            }
        } else {
            cacheLogger.log(Level.SEVERE, "ISCSIreadAlliScsiInitiator is not cached for {0}, will cache now", serialNumber);
            ISCSIreadAlliScsiInitiator.cache(device);
        }
    }

    private ISCSIreadAlliScsiInitiator(ISCSIreadAlliScsiInitiator copy) {
        super(copy.getSerialNumber());
        this.copy(copy);
    }

    private ISCSIreadAlliScsiInitiator(String serialNumber, int portID, SanObject obj) throws WBEMException {
        super(serialNumber);
        this.portID = portID;
        try {
            this.name = obj.getString("Name");
        }
        catch (SanDataException e) {
            throw new WBEMException(1, "Unable to obtain 'Name' from initiator with port ID " + portID, null, (Throwable)e);
        }
        try {
            SanObject user = obj.getObj("iScsiUser");
            this.userID = user.getString("UserId");
            this.secret = user.getString("Secret");
        }
        catch (SanDataException e) {
            cacheLogger.log(Level.WARNING, "NON-FATAL: Unable to get user data from initiator with port ID " + portID, e);
        }
    }

    @Override
    public int compareTo(ISCSIreadAlliScsiInitiator o) {
        int otherID = o.getPortID();
        return this.portID == otherID ? 0 : (this.portID < otherID ? -1 : 1);
    }

    private void copy(ISCSIreadAlliScsiInitiator port2Copy) {
        this.portID = port2Copy.getPortID();
        this.name = port2Copy.getName();
        this.userID = port2Copy.getUserID();
        this.secret = port2Copy.getSecret();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ISCSIreadAlliScsiInitiator other = (ISCSIreadAlliScsiInitiator)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.portID != other.portID) {
            return false;
        }
        if (this.secret == null ? other.secret != null : !this.secret.equals(other.secret)) {
            return false;
        }
        return !(this.userID == null ? other.userID != null : !this.userID.equals(other.userID));
    }

    public final String getName() {
        return this.name;
    }

    public final int getPortID() {
        return this.portID;
    }

    public final String getSecret() {
        return this.secret;
    }

    public final String getUserID() {
        return this.userID;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.portID;
        result = 31 * result + (this.secret == null ? 0 : this.secret.hashCode());
        result = 31 * result + (this.userID == null ? 0 : this.userID.hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ISCSIreadAlliScsiInitiators [portID=");
        builder.append(this.portID);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", userID=");
        builder.append(this.userID);
        builder.append(", secret=");
        builder.append(this.secret);
        builder.append("]");
        return builder.toString();
    }
}

