/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.common.IndicationPollingWorker;
import com.ws.wbem.jserver.DaemonThreadFactory;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;
import javax.wbem.provider.ProviderHandle;

public class PollingIndicationManager {
    protected static final Logger mLogger = Logger.getLogger("com.hitachi.smis.logger.provider");
    private static final int NUM_THREADS = 5;
    private static PollingIndicationManager singleton = null;
    private final ExecutorService mExecutor;
    private final ProviderHandle mHandle;
    private final Hashtable<CIMObjectPath, IndicationPollingWorker> mWorkerTable;

    public static synchronized PollingIndicationManager getInstance() throws WBEMException {
        if (null == singleton) {
            throw new WBEMException("PollingIndicationManager null");
        }
        return singleton;
    }

    public static synchronized PollingIndicationManager getInstance(ProviderHandle pHandle) {
        if (null == singleton) {
            singleton = new PollingIndicationManager(pHandle);
        }
        return singleton;
    }

    private PollingIndicationManager(ProviderHandle pHandle) {
        this.mHandle = pHandle;
        this.mWorkerTable = new Hashtable();
        this.mExecutor = Executors.newFixedThreadPool(5, (ThreadFactory)new DaemonThreadFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(CIMObjectPath opClass, Operation operation, boolean activate) {
        CIMObjectPath op = new CIMObjectPath(opClass.getScheme(), opClass.getHost(), opClass.getPort(), opClass.getNamespace(), opClass.getObjectName(), null);
        Hashtable<CIMObjectPath, IndicationPollingWorker> hashtable = this.mWorkerTable;
        synchronized (hashtable) {
            IndicationPollingWorker worker = this.mWorkerTable.get(op);
            if (activate) {
                if (null == worker) {
                    worker = new IndicationPollingWorker(this.mHandle, op);
                    this.mExecutor.execute(worker);
                    this.mWorkerTable.put(op, worker);
                }
                worker.setIndicationType(operation, true);
            } else if (null != worker) {
                worker.setIndicationType(operation, false);
                if (!worker.isListening()) {
                    worker.stop();
                    while (null != worker && worker.isRunning()) {
                        try {
                            this.mWorkerTable.wait(1000L);
                        }
                        catch (InterruptedException e) {
                            mLogger.log(Level.INFO, "Wait was interrupted, ignoring", e);
                        }
                    }
                    this.mWorkerTable.remove(op);
                    worker = null;
                }
            } else {
                mLogger.severe("Trying to deactivate listening for subscriptions for \"" + op + " but there are no " + "active subscriptions");
            }
        }
    }

    public void updateEvent(CIMObjectPath op) {
        IndicationPollingWorker worker = this.mWorkerTable.get(new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), op.getObjectName(), null));
        if (null != worker) {
            worker.updateEvent();
        }
    }

    public static enum Operation {
        InstCreation,
        InstDeletion,
        InstModification;

    }
}

