/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.ISCSITargetPort;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PortandHostGroupInfo;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.List;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class RemoteiSCSINamesCallback<E extends ISCSITargetPort>
extends IteratorCallbackIMPL<E> {
    private final short expCtrID;
    private final String expClientType;
    private final short expDomainID;
    private final BaseInstrumentation instrumentation;
    private final String expHostID;

    public RemoteiSCSINamesCallback(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList, String expClientType, String expHostID, String expCtrID, String expDomainID, BaseInstrumentation instrumentation) {
        super(iter, isObjectPath, refInfo, op, propertyList);
        this.expHostID = expHostID;
        this.expCtrID = (short)(null == expCtrID ? -1 : (int)Short.parseShort(expCtrID));
        this.expClientType = expClientType;
        this.expDomainID = (short)(null == expDomainID ? -1 : (int)Short.parseShort(expDomainID));
        this.instrumentation = instrumentation;
    }

    @Override
    public boolean returnItem(E item) {
        boolean ret = true;
        if (!this.mIter.isDone()) {
            try {
                E port = item;
                List<ISCSITargetPort.ISCSITarget> targets = ((ISCSITargetPort)port).getTargets();
                for (ISCSITargetPort.ISCSITarget target : targets) {
                    List<ISCSITargetPort.RemoteiSCSIName> rNames = target.getRemoteNames();
                    for (ISCSITargetPort.RemoteiSCSIName rName : rNames) {
                        byte client = new Integer(target.getHostModeID()).byteValue();
                        if (-1 != this.expDomainID && target.getId() != this.expDomainID || -1 != this.expCtrID && this.expCtrID != FCPort.getCtrlID((short)((ISCSITargetPort)port).getPortId(), target.getSerialNumber()) || null != this.expClientType && !this.expClientType.equals(PortandHostGroupInfo.setClientType(client)) || !rName.getName().equals(this.expHostID)) continue;
                        if (null != this.mRefInfo) {
                            this.mRefInfo.addReference(this.mIter, this.instrumentation.generateObjectPath(this.mOP, target, rName.getName()));
                            continue;
                        }
                        if (this.mIsObjectPath) {
                            this.mIter.add(this.instrumentation.generateObjectPath(this.mOP, target, rName.getName()));
                            continue;
                        }
                        CIMInstance ci = this.instrumentation.generateInstance(this.mOP, this.mPropertyList, target, rName.getName());
                        this.mIter.add(ci.filterProperties(this.mPropertyList));
                    }
                }
            }
            catch (Throwable thrown) {
                WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                this.mIter.setException(we);
                this.mIter.close();
            }
        } else {
            ret = false;
        }
        return ret;
    }
}

