/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.cache.CacheLib;
import com.hitachi.smi.cache.HitachiCacheInterface;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.FindMethodCallbackHandler;
import com.hitachi.smi.common.IteratorCallback;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ResourceRestriction;
import com.hitachi.smi.common.TierInfo;
import com.hitachi.smi.paralleltasker.Task;
import com.hitachi.smi.paralleltasker.TaskProcessor;
import com.ws.wbem.CloseableAddableIterator;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_GetTierInfo2;
import sanproject.common.Robj_interface_POOLIndex;
import sanproject.common.Robj_interface_POOLInfoDetailSx;
import sanproject.common.Robj_interface_POOLInfoDetailSx5;
import sanproject.common.Robj_interface_POOLPGKindInfo;
import sanproject.common.Robj_interface_POOLVolLDEVSx;
import sanproject.common.Robj_interface_POOLgetPoolVolInfoSx;
import sanproject.serverux.data.SANRmiException;

public class ThinPool
extends AbstractBaseCommonObject
implements Comparable<ThinPool> {
    protected static int EXCEEDED_VARIABLE_THRESHOLD = Integer.MIN_VALUE;
    protected static int EXCEEDED_FIXED_THRESHOLD = 0x40000000;
    protected static int EXCEEDED_VARIABLE_THRESHOLD_DEPLETION = 0x20000000;
    protected static int SHRINKING = 0x800000;
    protected static int BLOCKED = 65536;
    protected static short TIERALLOCATION_ON = (short)128;
    protected static short AUTOEXECUTE_ON = (short)64;
    protected static short TIERRANGECALC_ON = (short)32;
    protected static int BLOCKED_INTERNAL = 4096;
    protected static int BLOCKED_EXTERNAL = 4097;
    protected static int UTILIZATION_100 = 4098;
    protected static int UTILIZATION_0_THRESHOLD = 4101;
    protected static int UTILIZATION_100_THRESHOLD = 4102;
    protected static int EXTERNAL_MED_PERF = 2048;
    protected static int EXTERNAL_HIGH_PERF = 1024;
    protected static int EXTERNAL_LOW_PERF = 512;
    protected static final int RAID1_2D_2D_BIT = 32768;
    protected static final int RAID5_3D_1P_BIT = 2048;
    protected static final int RAID5_7D_1P_BIT = 1024;
    protected static final int RAID6_6D_2P_BIT = 128;
    protected static final int EXTERNAL_STORAGE_BIT = 8;
    protected static final String RAID1_2D_2D = "RAID1(2D+2D)";
    protected static final String RAID5_3D_1P = "RAID5(3D+1P)";
    protected static final String RAID5_7D_1P = "RAID5(7D+1P)";
    protected static final String RAID6_6D_2P = "RAID6(6D+2P)";
    protected static final String EXTERNAL_STORAGE = "External storage";
    private static final Class<ThinPool[]> clz = ThinPool[].class;
    private static final long serialVersionUID = 1L;
    private boolean mDeduplication;
    private int[] mDriveAttribute;
    private byte byPoolKind;
    private boolean mAOUPool;
    private short mPoolID;
    private final HashMap<String, PoolVolLDEVInfo> mPoolVolLDEVInfo;
    private byte mMonitorEndPeriodHour;
    private byte mMonitorEndPeriodMinute;
    private byte mMonitorStartPeriodHour;
    private byte mMonitorStartPeriodMinute;
    private byte mRelocateEndPeriodHour;
    private byte mRelocateEndPeriodMinute;
    private byte mRelocateStartPeriodHour;
    private byte mRelocateStartPeriodMinute;
    private int mEmulationType;
    private int mMaxSubscription;
    private int mPoolVolNum;
    private int mTierRelocatePolicy;
    private long mAOUUsed;
    private long mPageSize;
    private long mPoolCapa;
    private short mExternalMixCompatible;
    private short mPoolDepletionThreshold;
    private short mPoolThresholdMode;
    private long mPoolPages;
    private long mPoolStatus;
    private long mPoolUsed;
    private long mPoolUsedPages;
    private short mExecutionCycle;
    private short mPoolFixThreshold;
    private short mPoolGrainSize;
    private short mPoolThreshold;
    private short mTierControlInfo;
    private TierInfo[] mTierInfo;

    private static void addNewThinPools(List<ThinPool> tpList, String serialNum) throws WBEMException {
        HashMap<String, List<ThinPool>> tpMap = new HashMap<String, List<ThinPool>>();
        for (ThinPool tp : tpList) {
            ThinPool.addThinPoolToMap(tpMap, tp);
        }
        CacheLib.addDataToCache(tpMap, tpList, clz, serialNum);
    }

    public static ThinPool[] addThinPoolsToCache(List<Short> pList, String serialNum) throws WBEMException {
        LinkedList<ThinPool> newTPs = new LinkedList<ThinPool>();
        RMIObjectMapping mapping = RMIObjectMapping.getRMIObjectMapping(serialNum);
        RMIObjectCache rmiObj = mapping.getRMIObject();
        try {
            ThinPool tp;
            CommonClassAsList<ThinPool> callback = new CommonClassAsList<ThinPool>();
            ThinPool.getUnCachedThinPools(rmiObj, callback, (short)-1, -1L, false);
            LinkedList<ThinPool> TPs = callback.getReturnValue();
            callback = null;
            Collections.sort(pList);
            while ((tp = (ThinPool)TPs.poll()) != null) {
                int idx = Collections.binarySearch(pList, tp.getPoolID());
                if (idx < 0) continue;
                newTPs.add(tp);
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            throw new WBEMException(1, "Exception occurred trying to add ThinPool to cache" + t, null, t);
        }
        ThinPool[] ret = new ThinPool[]{};
        if (newTPs != null && newTPs.size() > 0) {
            ThinPool.addNewThinPools(newTPs, serialNum);
            ret = newTPs.toArray(new ThinPool[newTPs.size()]);
        }
        return ret;
    }

    private static void addThinPoolToMap(HashMap<String, List<ThinPool>> tpMap, ThinPool tp) {
        String key = CacheLib.getThinPoolIDString(tp.getPoolID());
        CacheLib.addToMap(tpMap, key, tp);
        key = CacheLib.getThinPoolKind(tp.mAOUPool);
        CacheLib.addToMap(tpMap, key, tp);
        Set<String> containedDNs = tp.getContainingLDEVs();
        for (String containedDN : containedDNs) {
            key = CacheLib.getThinPoolByContainedLDEVID(containedDN);
            CacheLib.addToMap(tpMap, key, tp);
        }
        if (tp.isTierAllocationFunctionON()) {
            key = CacheLib.getThinPoolTierAllocationOn();
            CacheLib.addToMap(tpMap, key, tp);
            key = CacheLib.getThinPoolTierAllocationOn(tp.getPoolID());
            CacheLib.addToMap(tpMap, key, tp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void cache(RMIObjectMapping mapping) throws WBEMException {
        try {
            RMIObjectCache rmiObj = mapping.getRMIObject();
            HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
            if (!cache.isCached(clz)) {
                Class<ThinPool> clazz = ThinPool.class;
                synchronized (ThinPool.class) {
                    if (!cache.isCached(clz)) {
                        ClosableAddableIteratorCB<ThinPool> callback = new ClosableAddableIteratorCB<ThinPool>();
                        ThinPool.getUnCachedThinPools(rmiObj, callback, (short)-1, -1L, false);
                        CloseableAddableIterator<ThinPool> cbIter = callback.getWrappedCloseableAddableIter();
                        ArrayList<ThinPool> tps = new ArrayList<ThinPool>();
                        HashMap<String, List<ThinPool>> tpMap = new HashMap<String, List<ThinPool>>();
                        while (cbIter.hasNext()) {
                            ThinPool tp = (ThinPool)cbIter.next();
                            tps.add(tp);
                            ThinPool.addThinPoolToMap(tpMap, tp);
                        }
                        CacheLib.addDataToCache(tpMap, tps, clz, mapping.getSerialNumber());
                    } else {
                        Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
                        logger.log(Level.WARNING, "ThinPool was cached for {0}", mapping.getSerialNumber());
                    }
                    // ** MonitorExit[var3_5] (shouldn't be in output)
                    return;
                }
            }
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
            logger.log(Level.WARNING, "ThinPool is already in the cache for {0}", mapping.getSerialNumber());
            return;
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, "Unexpected expection while caching ThinPool", null, th);
        }
    }

    public static ThinPool find(RMIObjectCache rmiObj, long pDevNum, ThinPoolType type) throws WBEMException {
        if (null == rmiObj) {
            throw new WBEMException(6, "Cache object must be passed to 'find' functions");
        }
        ThinPool ret = null;
        try {
            FindMethodCallbackHandler<ThinPool> callback = new FindMethodCallbackHandler<ThinPool>();
            ThinPool.getThinPools(rmiObj, callback, (short)-1, pDevNum, type);
            ret = callback.getReturnValue();
            if (type != ThinPoolType.ALL && (ret == null || type != (ret.mAOUPool ? ThinPoolType.AOU : ThinPoolType.QS))) {
                ret = null;
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable e) {
            throw new WBEMException(1, e.toString(), null, e);
        }
        return ret;
    }

    public static ThinPool find(RMIObjectCache rmiObj, short pPoolID, boolean pTierAllocationOnRequired) throws WBEMException {
        if (null == rmiObj) {
            throw new WBEMException(6, "Cache object must be passed to 'find' functions");
        }
        ThinPool ret = null;
        try {
            FindMethodCallbackHandler<ThinPool> callback = new FindMethodCallbackHandler<ThinPool>();
            ThinPool.getThinPools(rmiObj, callback, pPoolID, -1L, ThinPoolType.AOU, pTierAllocationOnRequired);
            ret = callback.getReturnValue();
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable e) {
            throw new WBEMException(1, e.toString(), null, e);
        }
        return ret;
    }

    public static ThinPool find(RMIObjectCache rmiObj, short pPoolID, ThinPoolType type) throws WBEMException {
        if (null == rmiObj) {
            throw new WBEMException(6, "Cache object must be passed to 'find' functions");
        }
        ThinPool ret = null;
        try {
            FindMethodCallbackHandler<ThinPool> callback = new FindMethodCallbackHandler<ThinPool>();
            ThinPool.getThinPools(rmiObj, callback, pPoolID, -1L, type);
            ret = callback.getReturnValue();
            if (type != ThinPoolType.ALL && (ret == null || type != (ret.mAOUPool ? ThinPoolType.AOU : ThinPoolType.QS))) {
                ret = null;
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable e) {
            throw new WBEMException(1, e.toString(), null, e);
        }
        return ret;
    }

    private static void getThinPools(IteratorCallback<ThinPool> callback, short pPoolID, long pDevNum, ThinPoolType type, boolean tierAllocationOnRequired) throws WBEMException {
        Collection<RMIObjectMapping> mappings = RMIObjectMapping.getAllRMIObjectMappings();
        for (RMIObjectMapping mapObj : mappings) {
            if (null != mapObj) {
                ThinPool.getThinPools(mapObj.getRMIObject(), callback, pPoolID, pDevNum, type, tierAllocationOnRequired);
                continue;
            }
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
            logger.severe("One of the objects returned from getAllMappings is null");
        }
    }

    public static void getThinPools(RMIObjectCache rmiObj, IteratorCallback<ThinPool> callback, short pPoolID) throws WBEMException {
        ThinPool.getThinPools(rmiObj, callback, pPoolID, -1L, ThinPoolType.ALL);
    }

    public static void getThinPools(RMIObjectCache rmiObj, IteratorCallback<ThinPool> callback, short pPoolID, boolean getThinPools) throws WBEMException {
        ThinPoolType type = getThinPools ? ThinPoolType.AOU : ThinPoolType.QS;
        ThinPool.getThinPools(rmiObj, callback, pPoolID, -1L, type);
    }

    public static void getThinPools(RMIObjectCache rmiObj, IteratorCallback<ThinPool> callback, short pPoolID, long pDevNum, boolean getThinPools) throws WBEMException {
        ThinPoolType type = getThinPools ? ThinPoolType.AOU : ThinPoolType.QS;
        ThinPool.getThinPools(rmiObj, callback, pPoolID, pDevNum, type);
    }

    public static void getThinPools(RMIObjectCache rmiObj, IteratorCallback<ThinPool> callback, short pPoolID, long pDevNum, ThinPoolType type) throws WBEMException {
        ThinPool.getThinPools(rmiObj, callback, pPoolID, pDevNum, type, false);
    }

    public static void getThinPools(RMIObjectCache rmiObj, IteratorCallback<ThinPool> callback, short pPoolID, long pDevNum, ThinPoolType type, boolean tierAllocationOnRequired) throws WBEMException {
        if (null == rmiObj) {
            ThinPool.getThinPools(callback, pPoolID, pDevNum, type, tierAllocationOnRequired);
            return;
        }
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
        try {
            HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
            if (cache.isCached(clz)) {
                AbstractBaseCommonObject[] tps = null;
                String key = null;
                if (-1 != pPoolID) {
                    key = tierAllocationOnRequired ? CacheLib.getThinPoolTierAllocationOn(pPoolID) : CacheLib.getThinPoolIDString(pPoolID);
                } else if (-1L != pDevNum) {
                    key = CacheLib.getThinPoolByContainedLDEVID(Long.toString(pDevNum));
                } else if (tierAllocationOnRequired) {
                    key = CacheLib.getThinPoolTierAllocationOn();
                } else if (type != ThinPoolType.ALL) {
                    boolean getThinPools = type == ThinPoolType.AOU;
                    key = CacheLib.getThinPoolKind(getThinPools);
                }
                tps = (ThinPool[])cache.getCachedObject(key, clz);
                if (tps != null) {
                    callback.returnItems(tps);
                } else {
                    logger.log(Level.WARNING, "No ThinPools on {0} match key: {1}", new Object[]{rmiObj.getSMISMappingContainer().getSerialNumber(), key});
                    callback.done();
                }
            } else {
                LogRecord record = new LogRecord(Level.WARNING, "{0} is not cached, this is a performance issue");
                record.setParameters(new Object[]{rmiObj.getSMISMappingContainer().getSerialNumber()});
                record.setThrown(new Exception("This is for stack trace information"));
                logger.log(record);
                ThinPool.getUnCachedThinPools(rmiObj, callback, pPoolID, pDevNum, tierAllocationOnRequired);
            }
        }
        catch (WBEMException we) {
            logger.log(Level.SEVERE, "WBEMException caught looking for ThinPool with poolID:" + pPoolID + ", Device #:" + pDevNum + ", getThinPools: " + (Object)((Object)type), we);
            callback.exceptionOccurred(we);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Exception caught looking for ThinPool with poolID:" + pPoolID + ", Device #:" + pDevNum + ", getThinPools: " + (Object)((Object)type), e);
            WBEMException we = new WBEMException(1, e.toString(), null, e);
            callback.exceptionOccurred(we);
        }
    }

    public static void getThinPools(RMIObjectCache rmiObj, IteratorCallback<ThinPool> callback, short pPoolID, ThinPoolType type) throws WBEMException {
        ThinPool.getThinPools(rmiObj, callback, pPoolID, -1L, type);
    }

    public static void getThinPoolsTierAllocationOn(RMIObjectCache rmiObj, IteratorCallback<ThinPool> callback, short pPoolID) throws WBEMException {
        ThinPool.getThinPools(rmiObj, callback, pPoolID, -1L, ThinPoolType.AOU, true);
    }

    private static void getUnCachedThinPools(RMIObjectCache rmiObj, IteratorCallback<ThinPool> callback, short pPoolID, long pDevNum, boolean pTierAllocationOnRequired) throws WBEMException {
        block6: {
            try {
                Robj_interface_POOLInfoDetailSx[] objPoolInfos = rmiObj.smisGetPoolDetails();
                if (objPoolInfos.length > 0) {
                    String serialNum = rmiObj.getSMISMappingContainer().getSerialNumber();
                    Robj_interface_POOLgetPoolVolInfoSx[] volInfs = rmiObj.smisGetPoolVolInfoSx((Robj_interface_POOLIndex[])objPoolInfos);
                    TaskProcessor task = new TaskProcessor("ThinPools - " + serialNum, objPoolInfos.length);
                    for (Robj_interface_POOLInfoDetailSx objPoolInfo : objPoolInfos) {
                        if (task.shouldStop()) {
                            callback.done();
                            break block6;
                        }
                        WorkerThread worker = new WorkerThread(serialNum, callback, objPoolInfo, task, volInfs, pPoolID, pDevNum, pTierAllocationOnRequired);
                        task.addTask(worker);
                    }
                    break block6;
                }
                callback.done();
            }
            catch (WBEMException we) {
                callback.exceptionOccurred(we);
            }
            catch (Exception e) {
                WBEMException we = new WBEMException(1, e.toString(), null, (Throwable)e);
                callback.exceptionOccurred(we);
            }
        }
    }

    private static boolean isTierAllocationFunctionON(short tierControlInfo) {
        return (tierControlInfo & TIERALLOCATION_ON) != 0;
    }

    public static short maxThinPoolID(RMIObjectCache rmiObj) throws WBEMException {
        return rmiObj.getSMIModelInfo().getMaxThinPool();
    }

    public static ThinPool[] modifyThinPoolsInCache(List<Short> pModifiedTPs, List<ThinPool> addedTPs, List<ThinPool> removedTPs, String serialNum) throws WBEMException {
        ThinPool[] ret = new ThinPool[]{};
        RMIObjectMapping mapping = RMIObjectMapping.getRMIObjectMapping(serialNum);
        RMIObjectCache rmiObj = mapping.getRMIObject();
        Logger.getLogger("com.hitachi.smis.logger.cache");
        LinkedList<ThinPool> modifiedTPs = new LinkedList<ThinPool>();
        try {
            CommonClassAsList<ThinPool> backEndCB = new CommonClassAsList<ThinPool>();
            ThinPool.getUnCachedThinPools(rmiObj, backEndCB, (short)-1, -1L, false);
            CommonClassAsList<ThinPool> cachedCallback = new CommonClassAsList<ThinPool>();
            ThinPool.getThinPools(rmiObj, cachedCallback, (short)-1, -1L, ThinPoolType.ALL);
            LinkedList<ThinPool> cachedTPs = cachedCallback.getReturnValue();
            cachedCallback = null;
            Collections.sort(cachedTPs);
            LinkedList<ThinPool> realTPs = backEndCB.getReturnValue();
            backEndCB = null;
            Collections.sort(realTPs);
            for (Short poolID : pModifiedTPs) {
                ThinPool tp = new ThinPool(serialNum, poolID);
                ThinPool cachedTP = null;
                ThinPool realTP = null;
                int cachedIndex = Collections.binarySearch(cachedTPs, tp);
                cachedTP = cachedIndex >= 0 ? (ThinPool)cachedTPs.remove(cachedIndex) : null;
                int realIndex = Collections.binarySearch(realTPs, tp);
                tp = null;
                ThinPool thinPool = realTP = realIndex >= 0 ? (ThinPool)realTPs.remove(realIndex) : null;
                if (null != cachedTP && null == realTP) {
                    if (null == removedTPs) continue;
                    removedTPs.add(cachedTP);
                    continue;
                }
                if (null == cachedTP && null != realTP) {
                    if (null == addedTPs) continue;
                    addedTPs.add(realTP);
                    continue;
                }
                if (null == cachedTP || null == realTP || cachedTP.equals(realTP)) continue;
                modifiedTPs.add(new ThinPool(cachedTP));
                if (cachedTP.isAOUPool() != realTP.isAOUPool()) {
                    if (null != removedTPs) {
                        removedTPs.add(cachedTP);
                    }
                    if (null == addedTPs) continue;
                    addedTPs.add(realTP);
                    continue;
                }
                cachedTP.copyThinPool(realTP);
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            throw new WBEMException(1, "Exception occurred trying to add ThinPool to cache " + serialNum, null, t);
        }
        if (removedTPs != null && removedTPs.size() > 0) {
            ThinPool.removeCachedThinPools(removedTPs, serialNum);
        }
        if (addedTPs != null && addedTPs.size() > 0) {
            ThinPool.addNewThinPools(addedTPs, serialNum);
        }
        if (modifiedTPs != null && modifiedTPs.size() > 0) {
            ret = modifiedTPs.toArray(new ThinPool[modifiedTPs.size()]);
        }
        return ret;
    }

    private static boolean processPoolInfo(String serialNum, IteratorCallback<ThinPool> callback, Robj_interface_POOLInfoDetailSx mTheVal, long pDevNum, Robj_interface_POOLgetPoolVolInfoSx[] mVolInfs) throws SANRmiException, RemoteException, WBEMException {
        boolean ret = true;
        boolean devMatched = false;
        ThinPool tp = new ThinPool(serialNum, mTheVal.getSPoolId());
        tp.byPoolKind = mTheVal.getByPoolKind();
        tp.mAOUPool = tp.byPoolKind == 2;
        Hashtable<Short, ArrayList<Long>> tierLdevHash = new Hashtable<Short, ArrayList<Long>>();
        for (Robj_interface_POOLgetPoolVolInfoSx volInf : mVolInfs) {
            Robj_interface_POOLVolLDEVSx[] ldevs;
            if (volInf.getSPoolId() != tp.getPoolID()) continue;
            for (Robj_interface_POOLVolLDEVSx ldev : ldevs = volInf.getObjPoolVolLDEVSx()) {
                long bdn = BaseDeviceNumber.makeUniqueDN(ldev.getSLDKC(), ldev.getSCU(), ldev.getSLDEV());
                String bdnStr = String.valueOf(bdn);
                short tier = ldev.getSBelongTier();
                ArrayList<Long> tierLdevList = (ArrayList<Long>)tierLdevHash.get(tier);
                if (null == tierLdevList) {
                    tierLdevList = new ArrayList<Long>();
                    tierLdevHash.put(tier, tierLdevList);
                }
                tierLdevList.add(bdn);
                ThinPool thinPool = tp;
                thinPool.getClass();
                PoolVolLDEVInfo ldevInf = thinPool.new PoolVolLDEVInfo(ldev.getLPoolVolPages(), ldev.getSBelongTier());
                tp.mPoolVolLDEVInfo.put(bdnStr, ldevInf);
                if (-1L == pDevNum || pDevNum != bdn) continue;
                devMatched = true;
                ret = false;
            }
        }
        if (-1L == pDevNum || devMatched) {
            tp.mMonitorEndPeriodHour = mTheVal.getByMonitorEndPeriodHour();
            tp.mMonitorEndPeriodMinute = mTheVal.getByMonitorEndPeriodMinute();
            tp.mMonitorStartPeriodHour = mTheVal.getByMonitorStartPeriodHour();
            tp.mMonitorStartPeriodMinute = mTheVal.getByMonitorStartPeriodMinute();
            tp.mRelocateEndPeriodHour = mTheVal.getByRelocateEndPeriodHour();
            tp.mRelocateEndPeriodMinute = mTheVal.getByRelocateEndPeriodMinute();
            tp.mRelocateStartPeriodHour = mTheVal.getByRelocateStartPeriodHour();
            tp.mRelocateStartPeriodMinute = mTheVal.getByRelocateStartPeriodMinute();
            tp.mEmulationType = mTheVal.getIEmulationType();
            tp.mMaxSubscription = mTheVal.getIMaxSubscription();
            tp.mPoolVolNum = mTheVal.getIPoolVolNum();
            tp.mTierRelocatePolicy = mTheVal.getITierRelocatePolicy();
            tp.mAOUUsed = mTheVal.getLAOUUsed();
            tp.mPageSize = mTheVal.getLPageSize();
            tp.mPoolCapa = mTheVal.getLPoolCapa();
            tp.mPoolPages = mTheVal.getLPoolPages();
            tp.mPoolStatus = mTheVal.getLPoolStatus();
            tp.mPoolUsed = mTheVal.getLPoolUsed();
            tp.mPoolUsedPages = mTheVal.getLPoolUsedPages();
            tp.mExecutionCycle = mTheVal.getSExecutionCycle();
            tp.mPoolFixThreshold = mTheVal.getSPoolFixThreshold();
            tp.mPoolGrainSize = mTheVal.getSPoolGrainSize();
            tp.mPoolThreshold = mTheVal.getSPoolThreshold();
            tp.mTierControlInfo = mTheVal.getSTierControlInfo();
            tp.mExternalMixCompatible = mTheVal.getSExternalMixCompatible();
            tp.mPoolDepletionThreshold = mTheVal.getSPoolDepletionThreshold();
            tp.mPoolThresholdMode = mTheVal.getSPoolThresholdMode();
            tp.mDeduplication = ((Robj_interface_POOLInfoDetailSx5)mTheVal).isBPoolDeduplication();
            if (tp.isTierAllocationFunctionON()) {
                Robj_interface_GetTierInfo2[] getTierInfo = mTheVal.getObjGetTierInfo();
                short poolID = mTheVal.getSPoolId();
                if (null != getTierInfo && getTierInfo.length > 0) {
                    TierInfo[] tierInfo = new TierInfo[getTierInfo.length];
                    tp.mDriveAttribute = new int[getTierInfo.length];
                    for (short i = 0; i < tierInfo.length; i = (short)(i + 1)) {
                        short ldevIndex = (short)(i + 1);
                        tierInfo[i] = new TierInfo(tp.getSerialNumber(), poolID, i, getTierInfo[i], (ArrayList)tierLdevHash.get(ldevIndex));
                        tp.mDriveAttribute[i] = getTierInfo[i].getIDriveAttribute();
                    }
                    tp.mTierInfo = tierInfo;
                }
            } else {
                Robj_interface_POOLPGKindInfo[] obj = mTheVal.getObjPOOLPGKindInfo();
                tp.mDriveAttribute = new int[obj.length];
                int index = 0;
                for (Robj_interface_POOLPGKindInfo poolInfo : obj) {
                    tp.mDriveAttribute[index++] = poolInfo.getIDriveAttribute();
                }
            }
            if (null == tp.mTierInfo) {
                tp.mTierInfo = new TierInfo[0];
            }
            if (ResourceRestriction.isPoolUsable(tp, tp.isAOUPool())) {
                callback.returnItem(tp);
            } else {
                cacheLogger.log(Level.FINE, "Skipping ThinPool {0}", tp.getPoolID());
            }
        }
        return ret;
    }

    private static ThinPool[] removeCachedThinPools(List<ThinPool> theList, String serialNum) throws WBEMException {
        Serializable[] ret = null;
        HashMap<String, List<ThinPool>> tpMap = new HashMap<String, List<ThinPool>>();
        for (ThinPool path : theList) {
            ThinPool.addThinPoolToMap(tpMap, path);
        }
        ret = theList.toArray(new ThinPool[theList.size()]);
        CacheLib.removeDataFromCache(tpMap, (Serializable[])ret, clz, (String)serialNum);
        return ret;
    }

    public static ThinPool[] removeThinPoolsFromCache(List<Short> pList, String serialNum) throws WBEMException {
        RMIObjectMapping mapping = RMIObjectMapping.getRMIObjectMapping(serialNum);
        RMIObjectCache rmiObj = mapping.getRMIObject();
        LinkedList<ThinPool> removedTPs = new LinkedList<ThinPool>();
        try {
            for (int index = 0; index < pList.size(); ++index) {
                short removedID = pList.get(index);
                ThinPool tp = ThinPool.find(rmiObj, removedID, ThinPoolType.ALL);
                if (tp != null) {
                    removedTPs.add(tp);
                    continue;
                }
                Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
                logger.log(Level.SEVERE, "Backend versioning indicated that ThinPool({0}) was removed, however; {1} has no such pool", new Object[]{removedID, serialNum});
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            throw new WBEMException(1, "Exception occurred trying to add ThinPool to cache " + serialNum, null, t);
        }
        ThinPool[] ret = ThinPool.removeCachedThinPools(removedTPs, serialNum);
        return ret;
    }

    private ThinPool(String serialNum, short pPoolId) {
        super(serialNum);
        this.mPoolID = pPoolId;
        this.mPoolVolLDEVInfo = new HashMap();
    }

    public ThinPool(ThinPool other) {
        this(other.getSerialNumber(), other.getPoolID());
        this.copyThinPool(other);
    }

    public boolean checkIfDNContainsPool(BaseDeviceNumber dn) {
        boolean ret = false;
        if (dn != null) {
            ret = this.checkIfDNContainsPool(dn.getDNAsString());
        }
        return ret;
    }

    public boolean checkIfDNContainsPool(String dnString) {
        boolean ret = false;
        if (this.mPoolVolLDEVInfo.containsKey(dnString)) {
            ret = true;
        }
        return ret;
    }

    @Override
    public int compareTo(ThinPool other) {
        int ret = this.getSerialNumber().compareToIgnoreCase(other.getSerialNumber());
        if (0 == ret) {
            short otherVal;
            short thisVal = this.getPoolID();
            ret = thisVal < (otherVal = other.getPoolID()) ? -1 : (thisVal == otherVal ? 0 : 1);
        }
        return ret;
    }

    private void copyThinPool(ThinPool orig) {
        this.setSerialNumber(orig.getSerialNumber());
        this.byPoolKind = orig.byPoolKind;
        this.mAOUPool = orig.isAOUPool();
        this.mAOUUsed = orig.getAOUUsed();
        this.mDeduplication = orig.mDeduplication;
        this.mDriveAttribute = new int[orig.mDriveAttribute.length];
        for (int x = 0; x < orig.mDriveAttribute.length; ++x) {
            this.mDriveAttribute[x] = orig.mDriveAttribute[x];
        }
        this.mEmulationType = orig.getEmulationType();
        this.mExecutionCycle = orig.getExecutionCycle();
        this.mExternalMixCompatible = orig.getExternalMixCompatible();
        this.mMaxSubscription = orig.getMaxSubscription();
        this.mMonitorEndPeriodHour = orig.getMonitorEndPeriodHour();
        this.mMonitorEndPeriodMinute = orig.getMonitorEndPeriodMinute();
        this.mMonitorStartPeriodHour = orig.getMonitorStartPeriodHour();
        this.mMonitorStartPeriodMinute = orig.getMonitorStartPeriodMinute();
        this.mPageSize = orig.getPageSize();
        this.mPoolCapa = orig.getPoolCapa();
        this.mPoolDepletionThreshold = orig.getPoolDepletionThreshold();
        this.mPoolFixThreshold = orig.getPoolFixThreshold();
        this.mPoolGrainSize = orig.getPoolGrainSize();
        this.mPoolID = orig.getPoolID();
        this.mPoolPages = orig.getPoolPages();
        this.mPoolStatus = orig.getPoolStatus();
        this.mPoolThreshold = orig.getPoolThreshold();
        this.mPoolThresholdMode = orig.getPoolThresholdMode();
        this.mPoolUsed = orig.getPoolUsed();
        this.mPoolUsedPages = orig.getPoolUsedPages();
        this.mPoolVolLDEVInfo.clear();
        for (String ldev : orig.getContainingLDEVs()) {
            PoolVolLDEVInfo temp = orig.getContainedLDEVInfo(ldev);
            this.mPoolVolLDEVInfo.put(new String(ldev), new PoolVolLDEVInfo(temp.getVolPages(), temp.getBelongTier()));
        }
        this.mPoolVolNum = orig.getPoolVolNum();
        this.mRelocateEndPeriodHour = orig.getRelocateEndPeriodHour();
        this.mRelocateEndPeriodMinute = orig.getRelocateEndPeriodMinute();
        this.mRelocateStartPeriodHour = orig.getRelocateStartPeriodHour();
        this.mRelocateStartPeriodMinute = orig.getRelocateStartPeriodMinute();
        this.mTierControlInfo = orig.getTierControlInfo();
        TierInfo[] origTIs = orig.getTierInfo();
        this.mTierInfo = new TierInfo[origTIs.length];
        for (int x = 0; x < origTIs.length; ++x) {
            this.mTierInfo[x] = new TierInfo(origTIs[x]);
        }
        this.mTierRelocatePolicy = orig.getTierRelocatePolicy();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThinPool other = (ThinPool)obj;
        if (!super.equals(obj)) {
            return false;
        }
        if (this.mAOUPool != other.mAOUPool) {
            return false;
        }
        if (this.mAOUUsed != other.mAOUUsed) {
            return false;
        }
        if (this.mEmulationType != other.mEmulationType) {
            return false;
        }
        if (this.mExecutionCycle != other.mExecutionCycle) {
            return false;
        }
        if (this.mMaxSubscription != other.mMaxSubscription) {
            return false;
        }
        if (this.mMonitorEndPeriodHour != other.mMonitorEndPeriodHour) {
            return false;
        }
        if (this.mMonitorEndPeriodMinute != other.mMonitorEndPeriodMinute) {
            return false;
        }
        if (this.mMonitorStartPeriodHour != other.mMonitorStartPeriodHour) {
            return false;
        }
        if (this.mMonitorStartPeriodMinute != other.mMonitorStartPeriodMinute) {
            return false;
        }
        if (this.mPageSize != other.mPageSize) {
            return false;
        }
        if (this.mPoolCapa != other.mPoolCapa) {
            return false;
        }
        if (this.mPoolFixThreshold != other.mPoolFixThreshold) {
            return false;
        }
        if (this.mPoolGrainSize != other.mPoolGrainSize) {
            return false;
        }
        if (this.mPoolID != other.mPoolID) {
            return false;
        }
        if (this.mPoolPages != other.mPoolPages) {
            return false;
        }
        if (this.mPoolStatus != other.mPoolStatus) {
            return false;
        }
        if (this.mPoolThreshold != other.mPoolThreshold) {
            return false;
        }
        if (this.mPoolUsed != other.mPoolUsed) {
            return false;
        }
        if (this.mPoolUsedPages != other.mPoolUsedPages) {
            return false;
        }
        if (this.mPoolVolLDEVInfo == null ? other.mPoolVolLDEVInfo != null : !this.mPoolVolLDEVInfo.equals(other.mPoolVolLDEVInfo)) {
            return false;
        }
        if (this.mPoolVolNum != other.mPoolVolNum) {
            return false;
        }
        if (this.mRelocateEndPeriodHour != other.mRelocateEndPeriodHour) {
            return false;
        }
        if (this.mRelocateEndPeriodMinute != other.mRelocateEndPeriodMinute) {
            return false;
        }
        if (this.mRelocateStartPeriodHour != other.mRelocateStartPeriodHour) {
            return false;
        }
        if (this.mRelocateStartPeriodMinute != other.mRelocateStartPeriodMinute) {
            return false;
        }
        if (this.mTierControlInfo != other.mTierControlInfo) {
            return false;
        }
        if (this.mTierRelocatePolicy != other.mTierRelocatePolicy) {
            return false;
        }
        if (!Arrays.equals(this.mDriveAttribute, other.mDriveAttribute)) {
            return false;
        }
        if (null != this.mTierInfo ? !Arrays.equals(this.mTierInfo, other.mTierInfo) : null != other.mTierInfo) {
            return false;
        }
        return this.mDeduplication == other.mDeduplication;
    }

    public long getAOUUsed() {
        return this.mAOUUsed;
    }

    public byte getByPoolKind() {
        return this.byPoolKind;
    }

    public int getConsistsOf() {
        int ret = -1;
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
        int[] das = this.getDriveAttribute();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "ThinPool {0} drive attributes {1}", new Object[]{this.getPoolID(), Arrays.toString(das)});
        }
        for (int da : das) {
            int val;
            if ((da & EXTERNAL_HIGH_PERF) == EXTERNAL_HIGH_PERF || (da & EXTERNAL_MED_PERF) == EXTERNAL_MED_PERF || (da & EXTERNAL_LOW_PERF) == EXTERNAL_LOW_PERF) {
                val = 2;
            } else if ((da & EXTERNAL_HIGH_PERF) != EXTERNAL_HIGH_PERF || (da & EXTERNAL_MED_PERF) != EXTERNAL_MED_PERF || (da & EXTERNAL_LOW_PERF) != EXTERNAL_LOW_PERF) {
                val = 1;
            } else {
                logger.log(Level.SEVERE, "ThinPool {0} drive attributes {1} does not contain expected perf value, ignoring", new Object[]{this.getPoolID(), da});
                continue;
            }
            switch (val) {
                case 1: {
                    if (-1 == ret) {
                        ret = val;
                        break;
                    }
                    if (2 == ret) {
                        ret = 3;
                        break;
                    }
                    if (1 == ret) break;
                    logger.log(Level.SEVERE, "\"ret\" has an unexpected value {0}", ret);
                    ret = 3 == ret ? 3 : 1;
                    break;
                }
                case 2: {
                    if (-1 == ret) {
                        ret = val;
                        break;
                    }
                    if (1 == ret) {
                        ret = 3;
                        break;
                    }
                    if (2 == ret) break;
                    logger.log(Level.SEVERE, "\"ret\" has an unexpected value {0}", ret);
                    ret = 3 == ret ? 3 : 2;
                    break;
                }
                default: {
                    logger.log(Level.SEVERE, "\"val\" has an unexpected value {0}", val);
                    ret = 3;
                }
            }
            if (3 == ret) break;
        }
        if (ret <= 0 || ret > 3) {
            logger.log(Level.SEVERE, "ConsistsOf value ({0}) is invalid, defaulting to \"Internal\"", ret);
        }
        return ret;
    }

    public UnsignedInteger16 getConsistsOfAsU16() {
        int temp = this.getConsistsOf();
        return 1 == temp ? ProviderConstants.UINT16_ONE : (2 == temp ? ProviderConstants.UINT16_TWO : ProviderConstants.UINT16_THREE);
    }

    public PoolVolLDEVInfo getContainedLDEVInfo(String dnString) {
        return this.mPoolVolLDEVInfo.get(dnString);
    }

    public Set<String> getContainingLDEVs() {
        return new HashSet<String>(this.mPoolVolLDEVInfo.keySet());
    }

    public int[] getDriveAttribute() {
        int[] ret = new int[this.mDriveAttribute.length];
        for (int x = 0; x < this.mDriveAttribute.length; ++x) {
            ret[x] = this.mDriveAttribute[x];
        }
        return ret;
    }

    public int getEmulationType() {
        return this.mEmulationType;
    }

    public short getExecutionCycle() {
        return this.mExecutionCycle;
    }

    public short getExternalMixCompatible() {
        return this.mExternalMixCompatible;
    }

    public UnsignedInteger16 getHealthState() {
        LowerPoolStatus hs = this.getPoolStatusLower();
        UnsignedInteger16 ret = hs == LowerPoolStatus.BLOCKED_INTERNAL || hs == LowerPoolStatus.BLOCKED_EXTERNAL ? new UnsignedInteger16(20) : ProviderConstants.UINT16_FIVE;
        return ret;
    }

    public int getMaxSubscription() {
        return this.mMaxSubscription;
    }

    public byte getMonitorEndPeriodHour() {
        return this.mMonitorEndPeriodHour;
    }

    public byte getMonitorEndPeriodMinute() {
        return this.mMonitorEndPeriodMinute;
    }

    public byte getMonitorStartPeriodHour() {
        return this.mMonitorStartPeriodHour;
    }

    public byte getMonitorStartPeriodMinute() {
        return this.mMonitorStartPeriodMinute;
    }

    public long getPageSize() {
        return this.mPageSize;
    }

    public long getPoolCapa() {
        return this.mPoolCapa;
    }

    public long getPoolCapaAsBytes() {
        return this.getPoolCapa() * 1024L * 1024L;
    }

    public short getPoolDepletionThreshold() {
        return this.mPoolDepletionThreshold;
    }

    public short getPoolFixThreshold() {
        return this.mPoolFixThreshold;
    }

    public short getPoolGrainSize() {
        return this.mPoolGrainSize;
    }

    public short getPoolID() {
        return this.mPoolID;
    }

    public long getPoolPages() {
        return this.mPoolPages;
    }

    public long getPoolStatus() {
        return this.mPoolStatus;
    }

    public LowerPoolStatus getPoolStatusLower() {
        LowerPoolStatus ret = LowerPoolStatus.UNKNOWN;
        int lowerPoolStatus = (int)this.mPoolStatus & 0xFFFF;
        if (lowerPoolStatus == BLOCKED_INTERNAL) {
            ret = LowerPoolStatus.BLOCKED_INTERNAL;
        }
        if (lowerPoolStatus == BLOCKED_EXTERNAL) {
            ret = LowerPoolStatus.BLOCKED_EXTERNAL;
        }
        if (lowerPoolStatus == UTILIZATION_100) {
            ret = LowerPoolStatus.UTILIZATION_100;
        }
        if (lowerPoolStatus == UTILIZATION_0_THRESHOLD) {
            ret = LowerPoolStatus.UTILIZATION_0_THRESHOLD;
        }
        if (lowerPoolStatus == UTILIZATION_100_THRESHOLD) {
            ret = LowerPoolStatus.UTILIZATION_100_THRESHOLD;
        }
        return ret;
    }

    public UpperPoolStatus getPoolStatusUpper() {
        UpperPoolStatus ret = UpperPoolStatus.UNKNOWN;
        long status = this.mPoolStatus & 0xFFFFFFFFFFFF0000L;
        if (status == (long)EXCEEDED_VARIABLE_THRESHOLD) {
            ret = UpperPoolStatus.EXCEEDED_VARIABLE_THRESHOLD;
        }
        if (status == (long)EXCEEDED_FIXED_THRESHOLD) {
            ret = UpperPoolStatus.EXCEEDED_FIXED_THRESHOLD;
        }
        if (status == (long)EXCEEDED_VARIABLE_THRESHOLD_DEPLETION) {
            ret = UpperPoolStatus.EXCEEDED_VARIABLE_THRESHOLD_DEPLETION;
        }
        if (status == (long)SHRINKING) {
            ret = UpperPoolStatus.SHRINKING;
        }
        if (status == (long)BLOCKED) {
            ret = UpperPoolStatus.BLOCKED;
        }
        return ret;
    }

    public short getPoolThreshold() {
        return this.mPoolThreshold;
    }

    public short getPoolThresholdMode() {
        return this.mPoolThresholdMode;
    }

    public long getPoolUsed() {
        return this.mPoolUsed;
    }

    public long getPoolUsedPages() {
        return this.mPoolUsedPages;
    }

    public int getPoolVolNum() {
        return this.mPoolVolNum;
    }

    public String getRAIDLevel() {
        StringBuilder retBuild = new StringBuilder();
        for (TierInfo tInfo : this.mTierInfo) {
            if (0 != retBuild.length()) {
                retBuild = retBuild.append(", ");
            }
            if (tInfo.getRaidLevel() == 32768) {
                retBuild = retBuild.append(RAID1_2D_2D);
                continue;
            }
            if (this.mTierInfo[0].getRaidLevel() == 2048) {
                retBuild = retBuild.append(RAID5_3D_1P);
                continue;
            }
            if (this.mTierInfo[0].getRaidLevel() == 1024) {
                retBuild = retBuild.append(RAID5_7D_1P);
                continue;
            }
            if (this.mTierInfo[0].getRaidLevel() == 128) {
                retBuild = retBuild.append(RAID6_6D_2P);
                continue;
            }
            if (this.mTierInfo[0].getRaidLevel() != 8) continue;
            retBuild = retBuild.append(EXTERNAL_STORAGE);
        }
        return 0 != retBuild.length() ? retBuild.toString() : "UNKNOWN";
    }

    public byte getRelocateEndPeriodHour() {
        return this.mRelocateEndPeriodHour;
    }

    public byte getRelocateEndPeriodMinute() {
        return this.mRelocateEndPeriodMinute;
    }

    public byte getRelocateStartPeriodHour() {
        return this.mRelocateStartPeriodHour;
    }

    public byte getRelocateStartPeriodMinute() {
        return this.mRelocateStartPeriodMinute;
    }

    public short getTierControlInfo() {
        return this.mTierControlInfo;
    }

    public TierInfo[] getTierInfo() {
        return this.mTierInfo;
    }

    public int getTierRelocatePolicy() {
        return this.mTierRelocatePolicy;
    }

    public UnsignedInteger16 getUsage() {
        UnsignedInteger16 usage;
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
        if (!ResourceRestriction.isPoolUsable(this, this.isAOUPool())) {
            usage = ProviderConstants.UINT16_THREE;
            logger.log(Level.FINE, "Pool {0} is restricted", this.getPoolID());
        } else if (this.isSnapShotPool()) {
            usage = ProviderConstants.UINT16_FOUR;
        } else {
            int consistsOfVal = this.getConsistsOf();
            switch (consistsOfVal) {
                case 1: {
                    usage = ProviderConstants.UINT16_TWO;
                    break;
                }
                case 2: {
                    usage = ProviderConstants.UINT16_32768;
                    break;
                }
                case 3: {
                    usage = ProviderConstants.UINT16_32769;
                    break;
                }
                default: {
                    logger.log(Level.SEVERE, "Unknown ConsistsOf value: {0}", consistsOfVal);
                    usage = null;
                }
            }
        }
        return usage;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.mAOUPool ? 1231 : 1237);
        result = 31 * result + (int)(this.mAOUUsed ^ this.mAOUUsed >>> 32);
        result = 31 * result + this.mEmulationType;
        result = 31 * result + this.mExecutionCycle;
        result = 31 * result + this.mMaxSubscription;
        result = 31 * result + this.mMonitorEndPeriodHour;
        result = 31 * result + this.mMonitorEndPeriodMinute;
        result = 31 * result + this.mMonitorStartPeriodHour;
        result = 31 * result + this.mMonitorStartPeriodMinute;
        result = 31 * result + (int)(this.mPageSize ^ this.mPageSize >>> 32);
        result = 31 * result + (int)(this.mPoolCapa ^ this.mPoolCapa >>> 32);
        result = 31 * result + this.mPoolFixThreshold;
        result = 31 * result + this.mPoolGrainSize;
        result = 31 * result + this.mPoolID;
        result = 31 * result + (int)(this.mPoolPages ^ this.mPoolPages >>> 32);
        result = 31 * result + (int)(this.mPoolStatus ^ this.mPoolStatus >>> 32);
        result = 31 * result + this.mPoolThreshold;
        result = 31 * result + (int)(this.mPoolUsed ^ this.mPoolUsed >>> 32);
        result = 31 * result + (int)(this.mPoolUsedPages ^ this.mPoolUsedPages >>> 32);
        result = 31 * result + (this.mPoolVolLDEVInfo == null ? 0 : this.mPoolVolLDEVInfo.hashCode());
        result = 31 * result + this.mPoolVolNum;
        result = 31 * result + this.mRelocateEndPeriodHour;
        result = 31 * result + this.mRelocateEndPeriodMinute;
        result = 31 * result + this.mRelocateStartPeriodHour;
        result = 31 * result + this.mRelocateStartPeriodMinute;
        result = 31 * result + this.mTierControlInfo;
        result = 31 * result + this.mTierRelocatePolicy;
        if (null != this.mTierInfo) {
            result = 31 * result + Arrays.hashCode(this.mTierInfo);
        }
        return result;
    }

    public boolean isAOUPool() {
        return this.mAOUPool;
    }

    public boolean isDeduplication() {
        return this.mDeduplication;
    }

    public boolean isOPENPool() {
        boolean ret;
        switch (this.mEmulationType) {
            case 0: {
                ret = true;
                break;
            }
            case 1: {
                ret = false;
                break;
            }
            default: {
                ret = true;
                Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
                logger.severe("Emulation type is unrecognized, defaulting to OPEN: " + this.mEmulationType);
            }
        }
        return ret;
    }

    public boolean isSnapShotPool() {
        return !this.mAOUPool;
    }

    public boolean isTierAllocationFunctionON() {
        return ThinPool.isTierAllocationFunctionON(this.mTierControlInfo);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ThinPool [serialNumber=");
        builder.append(this.getSerialNumber());
        builder.append(", mPoolID=");
        builder.append(this.mPoolID);
        builder.append(", byPoolKind=");
        builder.append(this.byPoolKind);
        builder.append(", mAOUPool=");
        builder.append(this.mAOUPool);
        builder.append(", mPoolVolLDEVInfo=");
        builder.append(this.mPoolVolLDEVInfo);
        builder.append(", mMonitorEndPeriodHour=");
        builder.append(this.mMonitorEndPeriodHour);
        builder.append(", mMonitorEndPeriodMinute=");
        builder.append(this.mMonitorEndPeriodMinute);
        builder.append(", mMonitorStartPeriodHour=");
        builder.append(this.mMonitorStartPeriodHour);
        builder.append(", mMonitorStartPeriodMinute=");
        builder.append(this.mMonitorStartPeriodMinute);
        builder.append(", mRelocateEndPeriodHour=");
        builder.append(this.mRelocateEndPeriodHour);
        builder.append(", mRelocateEndPeriodMinute=");
        builder.append(this.mRelocateEndPeriodMinute);
        builder.append(", mRelocateStartPeriodHour=");
        builder.append(this.mRelocateStartPeriodHour);
        builder.append(", mRelocateStartPeriodMinute=");
        builder.append(this.mRelocateStartPeriodMinute);
        builder.append(", mEmulationType=");
        builder.append(this.mEmulationType);
        builder.append(", mMaxSubscription=");
        builder.append(this.mMaxSubscription);
        builder.append(", mPoolVolNum=");
        builder.append(this.mPoolVolNum);
        builder.append(", mTierRelocatePolicy=");
        builder.append(this.mTierRelocatePolicy);
        builder.append(", mAOUUsed=");
        builder.append(this.mAOUUsed);
        builder.append(", mPageSize=");
        builder.append(this.mPageSize);
        builder.append(", mPoolCapa=");
        builder.append(this.mPoolCapa);
        builder.append(", mExternalMixCompatible=");
        builder.append(this.mExternalMixCompatible);
        builder.append(", mPoolDepletionThreshold=");
        builder.append(this.mPoolDepletionThreshold);
        builder.append(", mPoolThresholdMode=");
        builder.append(this.mPoolThresholdMode);
        builder.append(", mPoolPages=");
        builder.append(this.mPoolPages);
        builder.append(", mPoolStatus=");
        builder.append(this.mPoolStatus);
        builder.append(", mPoolUsed=");
        builder.append(this.mPoolUsed);
        builder.append(", mPoolUsedPages=");
        builder.append(this.mPoolUsedPages);
        builder.append(", mExecutionCycle=");
        builder.append(this.mExecutionCycle);
        builder.append(", mPoolFixThreshold=");
        builder.append(this.mPoolFixThreshold);
        builder.append(", mPoolGrainSize=");
        builder.append(this.mPoolGrainSize);
        builder.append(", mPoolThreshold=");
        builder.append(this.mPoolThreshold);
        builder.append(", mTierControlInfo=");
        builder.append(this.mTierControlInfo);
        builder.append(", mTierInfo=");
        builder.append(Arrays.toString(this.mTierInfo));
        builder.append("]");
        return builder.toString();
    }

    private static class WorkerThread
    implements Task {
        private final IteratorCallback<ThinPool> mCallback;
        private final short mSearch4PoolID;
        private final Robj_interface_POOLInfoDetailSx mTheVal;
        private final TaskProcessor mTheTask;
        private final long mDevNum;
        private final Robj_interface_POOLgetPoolVolInfoSx[] mVolInfs;
        private final boolean mTierAllocationOnRequired;
        private final String mSerialNum;

        public WorkerThread(String serialNum, IteratorCallback<ThinPool> callback, Robj_interface_POOLInfoDetailSx objPoolInfo, TaskProcessor pTheTask, Robj_interface_POOLgetPoolVolInfoSx[] volInfs, short pPoolID, long pDevNum, boolean tierAllocationOnRequired) {
            this.mSerialNum = serialNum;
            this.mCallback = callback;
            this.mTheVal = objPoolInfo;
            this.mSearch4PoolID = pPoolID;
            this.mTheTask = pTheTask;
            this.mDevNum = pDevNum;
            this.mVolInfs = volInfs;
            this.mTierAllocationOnRequired = tierAllocationOnRequired;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doTask() {
            try {
                if (!this.mTheTask.shouldStop()) {
                    boolean ret = true;
                    if (!(this.mSearch4PoolID != -1 && this.mTheVal.getSPoolId() != this.mSearch4PoolID || this.mTierAllocationOnRequired && !ThinPool.isTierAllocationFunctionON(this.mTheVal.getSTierControlInfo()))) {
                        ret = ThinPool.processPoolInfo(this.mSerialNum, this.mCallback, this.mTheVal, this.mDevNum, this.mVolInfs);
                        if (this.mSearch4PoolID != -1) {
                            ret = false;
                        }
                    }
                    if (!ret) {
                        this.mTheTask.setStop(true);
                    }
                }
            }
            catch (Throwable e) {
                WBEMException we = e.getClass().isInstance(WBEMException.class) ? (WBEMException)e : new WBEMException(1, "Exception while processing items", null, e);
                this.mCallback.exceptionOccurred(we);
                this.mTheTask.setStop(true);
            }
            finally {
                int counter = this.mTheTask.taskDone();
                if (counter < 1) {
                    this.mCallback.done();
                }
            }
        }
    }

    public static enum UpperPoolStatus {
        UNKNOWN,
        EXCEEDED_VARIABLE_THRESHOLD,
        EXCEEDED_FIXED_THRESHOLD,
        EXCEEDED_VARIABLE_THRESHOLD_DEPLETION,
        SHRINKING,
        BLOCKED;

    }

    public static enum ThinPoolType {
        AOU,
        QS,
        ALL;

    }

    public class PoolVolLDEVInfo
    implements Serializable {
        private static final long serialVersionUID = 8L;
        long volPages;
        short belongTier;

        public PoolVolLDEVInfo(long pVolPages, short pBelongTier) {
            this.volPages = pVolPages;
            this.belongTier = pBelongTier;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PoolVolLDEVInfo other = (PoolVolLDEVInfo)obj;
            if (this.belongTier != other.belongTier) {
                return false;
            }
            return this.volPages == other.volPages;
        }

        public short getBelongTier() {
            return this.belongTier;
        }

        public long getVolPages() {
            return this.volPages;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.belongTier;
            result = 31 * result + (int)(this.volPages ^ this.volPages >>> 32);
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("PoolVolInfo [volPages=");
            builder.append(this.volPages);
            builder.append(", belongTier=");
            builder.append(this.belongTier);
            builder.append("]");
            return builder.toString();
        }
    }

    public static enum LowerPoolStatus {
        UNKNOWN,
        BLOCKED_INTERNAL,
        BLOCKED_EXTERNAL,
        UTILIZATION_100,
        UTILIZATION_0_THRESHOLD,
        UTILIZATION_100_THRESHOLD;

    }
}

