/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.common.VolumeTypeEnum;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;

public final class AllocatedFromThinProvisioningPoolInstrumentation
extends BaseAssocInstrumentation {
    private static final String CCN_HITACHI_ALLOCATEDFROMTHINPROVISIONINGPOOL = "HITACHI_AllocatedFromThinProvisioningPool";
    private static final String CCN_ANTECEDENT = "HITACHI_ThinProvisioningPool";
    private static final String CCN_DEPENDENT = "HITACHI_StorageVolume";

    protected AllocatedFromThinProvisioningPoolInstrumentation() {
        super(CCN_HITACHI_ALLOCATEDFROMTHINPROVISIONINGPOOL, CCN_ANTECEDENT, "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.ThinProvisioningPoolInstrumentation"), CCN_DEPENDENT, "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageVolumeInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, boolean shouldTestInst) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && CCN_HITACHI_ALLOCATEDFROMTHINPROVISIONINGPOOL.equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference2PropertyName()))) {
                    if (!shouldTestInst || this.getReference1Instrumentation().instanceExists(objectName)) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                        CIMProperty cpPoolID = objectName.getKey("InstanceID");
                        String strPoolID = (String)cpPoolID.getValue();
                        short poolID = Short.parseShort(ProviderLibs.getEndString(strPoolID, ProviderConstants.ID_SEPERATOR_AS_CHAR));
                        this.getStorageVolumesFromThinPool(device.getRMIObject(), iter, objectName, propertyList, isObjectPath, poolID, true);
                    }
                } else if (!(!objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) || null != role && !role.equalsIgnoreCase(this.getReference2PropertyName()) || null != resultRole && !resultRole.equalsIgnoreCase(this.getReference1PropertyName()) || shouldTestInst && !this.getReference2Instrumentation().instanceExists(objectName))) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMProperty cpDevID = objectName.getKey("DeviceID");
                    String strDevID = (String)cpDevID.getValue();
                    DeviceNumber dn = DeviceNumber.find(strDevID, device.getRMIObject());
                    if (dn != null && dn.isAOUVol()) {
                        ThinPool tp = ThinPool.find(device.getRMIObject(), dn.getThinPoolID(), ThinPool.ThinPoolType.AOU);
                        if (tp != null) {
                            if (isObjectPath) {
                                CIMObjectPath retOP = this.getReference1Instrumentation().generateObjectPath(objectName, tp);
                                if (retOP != null) {
                                    iter.add(retOP);
                                }
                            } else {
                                CIMInstance ret = this.getReference1Instrumentation().generateInstance(objectName, propertyList, tp);
                                if (ret != null) {
                                    iter.add(ret);
                                }
                            }
                        } else {
                            mLogger.info("Could not find a thin pool with ID: " + dn.getThinPoolID());
                        }
                    } else {
                        mLogger.info("Could not find DeviceNumber with ID: " + strDevID);
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                CallbackHandler<ThinPool> callback = new CallbackHandler<ThinPool>(deviceIter, isObjectPath, refInfo, op, propertyList);
                ThinPool.getThinPools(device.getRMIObject(), callback, (short)-1, true);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            if (null != iter) {
                WBEMException we = new WBEMException(1, th.toString(), null, th);
                iter.setException(we);
                iter.close();
                throw we;
            }
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath opObjectName, String[] propList, Object ... o) throws Exception {
        CIMInstance ret = null;
        CIMObjectPath opAssoc = this.generateObjectPath(opObjectName, o);
        CIMObjectPath opStorageVol = (CIMObjectPath)o[1];
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opStorageVol, "SystemName");
        CIMProperty[] keys = opAssoc.getKeys();
        CIMProperty cpDeviceID = opStorageVol.getKey("DeviceID");
        if (cpDeviceID != null) {
            String deviceIDStr = (String)cpDeviceID.getValue();
            DeviceNumber dn = DeviceNumber.find(deviceIDStr, device.getRMIObject());
            if (dn != null) {
                UnsignedInteger64 spaceConsumed = new UnsignedInteger64(BigInteger.valueOf(dn.getSpaceConsumed()));
                CIMProperty[] props = new CIMProperty[]{keys[0], keys[1], new CIMProperty("SpaceConsumed", CIMDataType.UINT64_T, (Object)spaceConsumed, false)};
                ret = new CIMInstance(opAssoc, props).filterProperties(propList);
            } else {
                mLogger.severe("Could not find volume: " + opAssoc);
                ret = null;
            }
        } else {
            mLogger.severe("The AOU volume: " + opAssoc + " does not have the" + "DeviceID" + " property!");
            ret = null;
        }
        return ret;
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath opObjectName, String[] propertyList) throws WBEMException {
        block8: {
            try {
                String pnReference2 = this.getReference2PropertyName();
                CIMObjectPath opReference2 = opObjectName.getKey(pnReference2) != null ? (CIMObjectPath)opObjectName.getKey(pnReference2).getValue() : null;
                CIMInstance instReference2 = null;
                try {
                    instReference2 = this.getReference2Instrumentation().getInstance(opReference2, new String[0]);
                }
                catch (WBEMException we) {
                    // empty catch block
                }
                if (null == instReference2) break block8;
                String pnReference1 = this.getReference1PropertyName();
                CIMObjectPath opReference1 = opObjectName.getKey(pnReference1) != null ? (CIMObjectPath)opObjectName.getKey(pnReference1).getValue() : null;
                CIMInstance instReference1 = null;
                try {
                    instReference1 = this.getReference1Instrumentation().getInstance(opReference1, new String[0]);
                }
                catch (WBEMException we) {
                    // empty catch block
                }
                if (null != instReference1) {
                    opReference2 = instReference2.getObjectPath();
                    CIMInstance instReturn = this.generateInstance(opObjectName, propertyList, instReference1.getObjectPath(), instReference2.getObjectPath());
                    return instReturn.filterProperties(propertyList);
                }
            }
            catch (WBEMException we) {
                throw we;
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
        }
        throw new WBEMException(6, opObjectName.toString());
    }

    private void getStorageVolumesFromThinPool(RMIObjectCache rmiObj, CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, boolean isObjectPath, short tPoolID, boolean isAssocCall) throws Exception {
        ThinPool tp = ThinPool.find(rmiObj, tPoolID, ThinPool.ThinPoolType.AOU);
        if (tp != null) {
            CIMObjectPath antOp = this.getReference1Instrumentation().generateObjectPath(op, tp);
            CommonClassAsList<DeviceNumber> callback = new CommonClassAsList<DeviceNumber>();
            DeviceNumber.getDNs(rmiObj, callback, tPoolID, true, VolumeTypeEnum.AOUVOL);
            LinkedList<DeviceNumber> dns = callback.getReturnValue();
            callback = null;
            DeviceNumber dn = dns.poll();
            while (dn != null) {
                CIMObjectPath depOp = this.getReference2Instrumentation().generateObjectPath(op, dn);
                if (dn == null) continue;
                if (isObjectPath) {
                    CIMObjectPath retOP = !isAssocCall ? this.generateObjectPath(op, antOp, depOp) : depOp;
                    if (retOP != null) {
                        iter.add(retOP);
                    }
                } else {
                    CIMInstance ret = !isAssocCall ? this.generateInstance(op, propertyList, antOp, depOp) : this.getReference2Instrumentation().generateInstance(op, propertyList, dn);
                    if (ret != null) {
                        iter.add(ret);
                    }
                }
                dn = dns.poll();
            }
        } else {
            mLogger.info("Could not find a thin pool with ID: " + tPoolID);
        }
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && CCN_HITACHI_ALLOCATEDFROMTHINPROVISIONINGPOOL.equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                        CIMProperty cpPoolID = objectName.getKey("InstanceID");
                        String strPoolID = (String)cpPoolID.getValue();
                        short poolID = Short.parseShort(ProviderLibs.getEndString(strPoolID, ProviderConstants.ID_SEPERATOR_AS_CHAR));
                        this.getStorageVolumesFromThinPool(device.getRMIObject(), iter, objectName, propertyList, isObjectPath, poolID, false);
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMProperty cpDevID = objectName.getKey("DeviceID");
                    String strDevID = (String)cpDevID.getValue();
                    DeviceNumber dn = DeviceNumber.find(strDevID, device.getRMIObject());
                    if (dn != null) {
                        if (dn.isAOUVol()) {
                            ThinPool tp = ThinPool.find(device.getRMIObject(), dn.getThinPoolID(), ThinPool.ThinPoolType.AOU);
                            if (tp != null) {
                                CIMObjectPath depOp = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                                CIMObjectPath antOp = this.getReference1Instrumentation().generateObjectPath(objectName, tp);
                                if (isObjectPath) {
                                    CIMObjectPath retOP = this.generateObjectPath(objectName, antOp, depOp);
                                    if (retOP != null) {
                                        iter.add(retOP);
                                    }
                                } else {
                                    CIMInstance ret = this.generateInstance(objectName, propertyList, antOp, depOp);
                                    if (ret != null) {
                                        iter.add(ret);
                                    }
                                }
                            } else {
                                mLogger.info("Could not find a thin pool with ID: " + dn.getThinPoolID());
                            }
                        }
                    } else {
                        mLogger.info("Could not find a DeviceNumber with ID: " + strDevID);
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we1 = new WBEMException(1, th.toString(), null, th);
            mLogger.log(Level.SEVERE, th.getLocalizedMessage(), th);
            if (null != iter) {
                iter.setException(we1);
                iter.close();
            }
            throw we1;
        }
    }

    private class CallbackHandler<E extends ThinPool>
    extends IteratorCallbackIMPL<E> {
        private CallbackHandler(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList) {
            super(iter, isObjectPath, refInfo, op, propertyList);
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret = true;
            if (!this.mIter.isClosed()) {
                try {
                    E tp = item;
                    RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(((AbstractBaseCommonObject)tp).getSerialNumber());
                    AllocatedFromThinProvisioningPoolInstrumentation.this.getStorageVolumesFromThinPool(device.getRMIObject(), this.mIter, this.mOP, this.mPropertyList, this.mIsObjectPath, ((ThinPool)tp).getPoolID(), false);
                }
                catch (Throwable thrown) {
                    WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                    this.mIter.setException(we);
                    this.mIter.close();
                }
            } else {
                ret = false;
            }
            return ret;
        }
    }
}

