/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.LDEVStats;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.StorageVolumeCallbackHandler;
import com.hitachi.smi.common.VolumeTypeEnum;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.CloseableAddableIterator;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTimeAbsolute;
import javax.cim.CIMDateTimeInterval;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;
import sanproject.serverux.data.SANRmiException;

public class BlockStatisticalDataStorageVolumeInstrumentation
extends BaseInstrumentation {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        block20: {
            try {
                String refInstID;
                List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues, new String[]{"SystemName", "InstanceID"});
                String expInstID = null != expectedValues ? (String)expectedValues.get("InstanceID") : null;
                String string = refInstID = null != expectedValues ? (String)expectedValues.get("HITACHI_BlockStatisticalDataStorageVolume") : null;
                if (null != refInstID) {
                    int dnIdx = refInstID.lastIndexOf(".");
                    refInstID = refInstID.substring(dnIdx + 1);
                }
                String expDeviceID = null != expectedValues ? (String)expectedValues.get("DeviceID") : null;
                ChassisArrayGroup cag = null;
                if (null != expInstID) {
                    if (devices.size() == 1) {
                        Integer[] ret;
                        RMIObjectCache rmiObj = devices.get(0).getRMIObject();
                        cag = ChassisArrayGroup.find(rmiObj, null, (ret = ProviderLibs.getStoragePoolChassisAndArrayGroup(expInstID))[0], ret[1], isObjectPath);
                        if (null == cag) {
                            throw new WBEMException(1, "unable to locate required array group: " + expInstID);
                        }
                    } else {
                        throw new WBEMException("Association data passed but incorrect number of devices: " + devices.size());
                    }
                }
                for (RMIObjectMapping device : devices) {
                    RMIObjectCache rmiObj = device.getRMIObject();
                    if (null == expDeviceID) {
                        CloseableAddableIterator statIter = new CloseableAddableIterator();
                        LDEVStats.getAllStats(rmiObj, (CloseableAddableIterator<LDEVStats>)statIter);
                        while (!statIter.isClosed() && statIter.hasNext()) {
                            CIMInstance newInst = this.generateInstance(op, propertyList, statIter.next(), device.getRMIObject());
                            if (null == refInfo) {
                                iter.add(newInst);
                                continue;
                            }
                            refInfo.addReference(iter, newInst.getObjectPath());
                        }
                        continue;
                    }
                    StorageVolumeCallbackHandler<DeviceNumber> callback = new StorageVolumeCallbackHandler<DeviceNumber>(iter, isObjectPath, refInfo, op, propertyList, expDeviceID, null, null, null, VolumeTypeEnum.ALL, this);
                    DeviceNumber.getDNs(rmiObj, callback, isObjectPath, null == propertyList || propertyList.length > 0, null, true);
                }
            }
            catch (WBEMException we) {
                if (null != iter) {
                    iter.setException(we);
                    iter.close();
                }
                throw we;
            }
            catch (Throwable th) {
                if (th instanceof WBEMException) {
                    WBEMException we = (WBEMException)th;
                    break block20;
                }
                Throwable t = th;
                while (null != t.getCause()) {
                    t = t.getCause();
                }
                WBEMException we = new WBEMException(1, t.toString(), null, t);
                if (null != iter) {
                    iter.setException(we);
                    iter.close();
                }
                throw we;
            }
            finally {
                if (null != iter && !iter.isClosed()) {
                    iter.done();
                }
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propertyList, Object ... o) throws WBEMException {
        LDEVStats stats;
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        try {
            ProviderLibs.validateVARArgs(new Class[]{DeviceNumber.class}, o, "HITACHI_BlockStatisticalDataStorageVolume");
            BaseDeviceNumber devNum = (BaseDeviceNumber)o[0];
            stats = new LDEVStats(devNum);
        }
        catch (IllegalArgumentException e) {
            ProviderLibs.validateVARArgs(new Class[]{LDEVStats.class, RMIObjectCache.class}, o, "HITACHI_BlockStatisticalDataStorageVolume");
            stats = (LDEVStats)o[0];
            BaseDeviceNumber devNum = stats.getDN();
        }
        catch (RemoteException | SANRmiException e) {
            throw new WBEMException(1, "Error getting statistics from backend", null, e);
        }
        try {
            ArrayList props = new ArrayList();
            ProviderLibs.addKeysToProperties(retOP.getKeys(), props);
            props.add(new CIMProperty("ElementType", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_EIGHT, false));
            props.add(new CIMProperty("TotalIOs", CIMDataType.UINT64_T, (Object)stats.getGetTotalIOs(), false));
            UnsignedInteger64 volumeTotalIOs = new UnsignedInteger64(stats.getReadTransRateStatistic().bigIntegerValue().add(stats.getWriteTransRateStatistic().bigIntegerValue()));
            props.add(new CIMProperty("KBytesTransferred", CIMDataType.UINT64_T, (Object)volumeTotalIOs, false));
            props.add(new CIMProperty("ReadIOs", CIMDataType.UINT64_T, (Object)stats.getReadIOStatistic(), false));
            props.add(new CIMProperty("ReadHitIOs", CIMDataType.UINT64_T, (Object)stats.getReadHitStatistic(), false));
            props.add(new CIMProperty("WriteIOs", CIMDataType.UINT64_T, (Object)stats.getWriteIOStatistic(), false));
            props.add(new CIMProperty("WriteHitIOs", CIMDataType.UINT64_T, (Object)stats.getWriteHitStatistic(), false));
            BigInteger kbWrite = stats.getWriteTransRateStatistic().bigIntegerValue();
            BigInteger kbRead = stats.getReadTransRateStatistic().bigIntegerValue();
            props.add(new CIMProperty("KBytesRead", CIMDataType.UINT64_T, (Object)new UnsignedInteger64(kbRead)));
            props.add(new CIMProperty("KBytesWritten", CIMDataType.UINT64_T, (Object)new UnsignedInteger64(kbWrite)));
            BigInteger totalHitIOs = stats.getWriteHitStatistic().bigIntegerValue();
            totalHitIOs = totalHitIOs.add(stats.getReadHitStatistic().bigIntegerValue());
            props.add(new CIMProperty("TotalHitIOs", CIMDataType.UINT64_T, (Object)new UnsignedInteger64(totalHitIOs)));
            Calendar cal = Calendar.getInstance();
            cal.setTime(stats.getTargetTime());
            props.add(new CIMProperty("StatisticTime", CIMDataType.DATETIME_T, (Object)new CIMDateTimeAbsolute(cal), false));
            props.add(new CIMProperty("SampleInterval", CIMDataType.DATETIME_T, (Object)new CIMDateTimeInterval("00000000000500.000000:000"), false));
            props.add(new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)"HITACHI_BlockStatisticalDataStorageVolume", false));
            props.add(new CIMProperty("Caption", CIMDataType.STRING_T, (Object)"HITACHI_BlockStatisticalDataStorageVolume", false));
            props.add(new CIMProperty("Description", CIMDataType.STRING_T, (Object)"HITACHI_BlockStatisticalDataStorageVolume", false));
            props.add(new CIMProperty("ReadIOTimeCounter", CIMDataType.UINT64_T, (Object)stats.getReadIOTime(), false));
            props.add(new CIMProperty("WriteIOTimeCounter", CIMDataType.UINT64_T, (Object)stats.getWriteIOTime(), false));
            return new CIMInstance(retOP, props.toArray(new CIMProperty[props.size()])).filterProperties(propertyList);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws WBEMException {
        RMIObjectCache rmiObj;
        BaseDeviceNumber dn;
        try {
            ProviderLibs.validateVARArgs(new Class[]{DeviceNumber.class}, o, "HITACHI_BlockStatisticalDataStorageVolume");
            dn = (BaseDeviceNumber)o[0];
            rmiObj = RMIObjectMapping.getRMIObjectMapping(dn.getSerialNumber()).getRMIObject();
        }
        catch (IllegalArgumentException e) {
            ProviderLibs.validateVARArgs(new Class[]{LDEVStats.class, RMIObjectCache.class}, o, "HITACHI_BlockStatisticalDataStorageVolume");
            LDEVStats stat = (LDEVStats)o[0];
            rmiObj = (RMIObjectCache)o[1];
            dn = stat.getDN();
        }
        CIMObjectPath ret = null;
        if (null != op && null != dn) {
            String systemName;
            try {
                systemName = rmiObj.getSMISMappingContainer().getStorageSystemName();
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
            String name = systemName + "." + dn.getDNAsString();
            CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)name, true)};
            ret = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_BlockStatisticalDataStorageVolume", keys, op.getXmlSchemaName());
        }
        return ret;
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            RMIObjectMapping device;
            RMIObjectCache rmiObj;
            String deviceIDKeyVal;
            String string = deviceIDKeyVal = null != op.getKey("InstanceID") ? (String)op.getKey("InstanceID").getValue() : null;
            if (null == deviceIDKeyVal) {
                throw new WBEMException(6, op.toString());
            }
            DeviceNumber dn = DeviceNumber.find(deviceIDKeyVal = ProviderLibs.getEndString(deviceIDKeyVal, ProviderConstants.ID_SEPERATOR_AS_CHAR), true, rmiObj = (device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID")).getRMIObject());
            if (dn != null) {
                CIMInstance ci = this.generateInstance(op, propertyList, dn);
                return ci;
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }
}

