/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.instrumentation.StorageClientSettingDataInstrumentation;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class ElementStorageClientSettingDataStorageHardwareIDInstrumentation
extends BaseAssocInstrumentation {
    private static final String IDSBYWWNS_SER = "idsbywwns.ser";
    private static final String IDSBYCLIENT_SER = "idsbyclient.ser";
    private static String[] mAssocDataFiles = new String[]{ProviderConstants.getDatDirectory() + "idsbyclient.ser", ProviderConstants.getDatDirectory() + "idsbywwns.ser"};
    private Hashtable<String, UnsignedInteger16> mAssociatedIDsByWWN = null;
    private Hashtable<UnsignedInteger16, ArrayList<String>> mAssociatedIDsByClient = null;

    protected ElementStorageClientSettingDataStorageHardwareIDInstrumentation() {
        super("HITACHI_ElementStorageClientSettingDataStorageHardwareID", "HITACHI_StorageHardwareID", "ManagedElement", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageHardwareIDInstrumentation"), "HITACHI_StorageClientSettingData", "SettingData", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageClientSettingDataInstrumentation"));
        this.restoreAssociationData();
        if (this.mAssociatedIDsByClient == null || this.mAssociatedIDsByWWN == null) {
            this.mAssociatedIDsByWWN = new Hashtable();
            this.mAssociatedIDsByClient = new Hashtable();
        }
    }

    protected void addAssociatedHardwareID(RMIObjectCache rmiObj, String pHostWWN, String pClientSettingInstID) {
        if (pHostWWN != null && pClientSettingInstID != null) {
            String clientVal = ProviderLibs.getEndString(pClientSettingInstID);
            this.getReference2Instrumentation();
            int hostVal = StorageClientSettingDataInstrumentation.getHostModeFromClientType(rmiObj, Integer.parseInt(clientVal));
            if (0 != hostVal) {
                try {
                    UnsignedInteger16 hostType = new UnsignedInteger16(hostVal);
                    this.mAssociatedIDsByWWN.put(pHostWWN, hostType);
                    ArrayList<String> vals = this.mAssociatedIDsByClient.get(hostType);
                    if (null == vals) {
                        vals = new ArrayList();
                    }
                    vals.add(pHostWWN);
                    this.mAssociatedIDsByClient.put(hostType, vals);
                    this.persistAssociationData();
                }
                catch (NumberFormatException nfe) {
                    mLogger.log(Level.SEVERE, "Could not convert " + clientVal + " to an integer", nfe);
                }
            }
        }
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_ElementStorageClientSettingDataStorageHardwareID".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference2PropertyName()))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        Hashtable<String, Object> hostType = this.getReference2SearchProperties(objectName);
                        this.getReference2Instrumentation().enumerate(iter, objectName, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, hostType, null);
                        needToCloseIter = false;
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    Hashtable<String, Object> expectValues = this.getReference1SearchProperties(objectName);
                    this.getReference1Instrumentation().enumerate(iter, objectName, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, expectValues, null);
                    needToCloseIter = false;
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            for (RMIObjectMapping device : devices) {
                CustomCloseableIterator iterStorageHardwareID = new CustomCloseableIterator();
                CIMObjectPath opStorageHardwareID = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), this.getReference1ClassName(), new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)device.getStorageSystemName())});
                this.getReference1Instrumentation().enumerate(iterStorageHardwareID, opStorageHardwareID, null, filterQueryLanguage, filterQuery, continueOnError, true, null, null);
                CIMObjectPath opStorageClientSettingData = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), this.getReference2ClassName(), null);
                while (iterStorageHardwareID.hasNext()) {
                    opStorageHardwareID = (CIMObjectPath)iterStorageHardwareID.next();
                    Hashtable<String, Object> hostType = this.getReference2SearchProperties(opStorageHardwareID);
                    CustomCloseableIterator iterStorageClientSettingData = new CustomCloseableIterator();
                    this.getReference2Instrumentation().enumerate(iterStorageClientSettingData, opStorageClientSettingData, null, filterQueryLanguage, filterQuery, continueOnError, false, hostType, null);
                    while (iterStorageClientSettingData.hasNext()) {
                        CIMInstance instStorageClientSettingData = (CIMInstance)iterStorageClientSettingData.next();
                        if (isObjectPath) {
                            iter.add(this.generateObjectPath(op, opStorageHardwareID, instStorageClientSettingData.getObjectPath()));
                            continue;
                        }
                        iter.add(this.generateInstance(op, propertyList, opStorageHardwareID, instStorageClientSettingData));
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{CIMObjectPath.class, CIMInstance.class}, o, "HITACHI_ElementStorageClientSettingDataStorageHardwareID");
        CIMObjectPath opStorageHardwareIDInstrumentation = (CIMObjectPath)o[0];
        CIMInstance instStorageClientSettingData = (CIMInstance)o[1];
        CIMObjectPath opAssoc = this.generateObjectPath(op, opStorageHardwareIDInstrumentation, instStorageClientSettingData.getObjectPath());
        CIMProperty key1 = opAssoc.getKey(this.getReference1PropertyName());
        CIMProperty key2 = opAssoc.getKey(this.getReference2PropertyName());
        UnsignedInteger16[] clientTypes = null != instStorageClientSettingData.getPropertyValue("ClientTypes") ? (UnsignedInteger16[])instStorageClientSettingData.getPropertyValue("ClientTypes") : null;
        int isDefault = ProviderLibs.valueExist(clientTypes, 2) ? 1 : 2;
        CIMProperty[] props = new CIMProperty[]{key1, key2, new CIMProperty("IsDefault", CIMDataType.UINT16_T, (Object)(isDefault == 1 ? ProviderConstants.UINT16_ONE : ProviderConstants.UINT16_TWO), false), new CIMProperty("IsCurrent", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ONE, false)};
        return new CIMInstance(opAssoc, props).filterProperties(propList);
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath opStorageClientSettingData;
            String cpnStorageHardwareID = this.getReference1PropertyName();
            CIMObjectPath opStorageHardwareID = op.getKey(cpnStorageHardwareID) != null ? (CIMObjectPath)op.getKey(cpnStorageHardwareID).getValue() : null;
            String cpnStorageClientSettingData = this.getReference2PropertyName();
            CIMObjectPath cIMObjectPath = opStorageClientSettingData = op.getKey(cpnStorageClientSettingData) != null ? (CIMObjectPath)op.getKey(cpnStorageClientSettingData).getValue() : null;
            if (null != opStorageHardwareID && null != opStorageClientSettingData) {
                try {
                    CIMInstance instStorageHardwareID = this.getReference1Instrumentation().getInstance(opStorageHardwareID, null);
                    CIMInstance instStorageClientSettingData = this.getReference2Instrumentation().getInstance(opStorageClientSettingData, null);
                    return this.generateInstance(op, propertyList, instStorageHardwareID.getObjectPath(), instStorageClientSettingData);
                }
                catch (WBEMException we) {}
            }
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public Hashtable<String, Object> getReference1SearchProperties(CIMObjectPath opClientSettingData) {
        String instID;
        CIMProperty cvInstID;
        Hashtable<String, Object> ret = new Hashtable<String, Object>();
        if (opClientSettingData != null && (cvInstID = opClientSettingData.getKey("InstanceID")) != null && (instID = (String)cvInstID.getValue()) != null) {
            RMIObjectCache rmiObj;
            ret.put("SystemName", instID);
            String clientType = ProviderLibs.getEndString(instID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
            String serial = ProviderLibs.getSerialFromString(instID);
            RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(serial);
            try {
                rmiObj = device.getRMIObject();
            }
            catch (WBEMException we) {
                throw new RuntimeException(device + " has no associated rmi object", we);
            }
            this.getReference2Instrumentation();
            int hostVal = StorageClientSettingDataInstrumentation.getHostModeFromClientType(rmiObj, Integer.parseInt(clientType));
            if (0 != hostVal) {
                ArrayList<String> hostWWNs = this.mAssociatedIDsByClient.get(new UnsignedInteger16(hostVal));
                if (hostWWNs != null) {
                    ret.put("Included", hostWWNs);
                } else {
                    hostWWNs = new ArrayList(0);
                    ret.put("Included", hostWWNs);
                }
            } else {
                ArrayList<String> excluded = new ArrayList<String>(this.mAssociatedIDsByWWN.keySet());
                ret.put("Excluded", excluded);
            }
        }
        return ret;
    }

    @Override
    public StorageClientSettingDataInstrumentation getReference2Instrumentation() {
        return (StorageClientSettingDataInstrumentation)super.getReference2Instrumentation();
    }

    @Override
    public Hashtable<String, Object> getReference2SearchProperties(CIMObjectPath opStorageHardwareID) {
        String instID;
        CIMProperty cvInstID;
        Hashtable<String, Object> ret = new Hashtable<String, Object>();
        if (opStorageHardwareID != null && (cvInstID = opStorageHardwareID.getKey("InstanceID")) != null && (instID = (String)cvInstID.getValue()) != null) {
            ret.put("ElementName", instID);
            String hostWWN = ProviderLibs.getEndString(instID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
            UnsignedInteger16 value = this.mAssociatedIDsByWWN.get(hostWWN);
            if (value == null) {
                value = ProviderConstants.UINT16_ZED;
            }
            ret.put("HostMode", value);
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void persistAssociationData() {
        mLogger.info("Persisting ClientSettingDataStorageHardwareID data");
        if (!this.mAssociatedIDsByClient.isEmpty()) {
            String fileName = null;
            try {
                for (int x = 0; x < mAssocDataFiles.length; ++x) {
                    fileName = mAssocDataFiles[x];
                    try (FileOutputStream fos = new FileOutputStream(fileName);
                         ObjectOutputStream out = new ObjectOutputStream(fos);){
                        if (0 == x) {
                            out.writeObject(this.mAssociatedIDsByClient);
                            mLogger.info("Wrote data for IDs by Client");
                            continue;
                        }
                        if (1 == x) {
                            out.writeObject(this.mAssociatedIDsByWWN);
                            mLogger.info("Wrote data for IDs by WWNs");
                            continue;
                        }
                        mLogger.severe("Don't know how to save data for file # " + x + " with name: " + fileName);
                        continue;
                    }
                }
            }
            catch (IOException ex) {
                mLogger.log(Level.SEVERE, "Error trying to persist Association data", ex);
            }
        }
        mLogger.info("Persisting ClientSettingDataStorageHardwareID done");
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_ElementStorageClientSettingDataStorageHardwareID".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    CIMInstance instStorageHardwareID = null;
                    try {
                        instStorageHardwareID = this.getReference1Instrumentation().getInstance(objectName, null);
                    }
                    catch (WBEMException we) {
                        // empty catch block
                    }
                    if (null != instStorageHardwareID) {
                        CIMObjectPath opStorageClientSettingData = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.getReference2ClassName(), null);
                        Hashtable<String, Object> hostType = this.getReference2SearchProperties(objectName);
                        CustomCloseableIterator iterStorageClientSettingData = new CustomCloseableIterator();
                        this.getReference2Instrumentation().enumerate(iterStorageClientSettingData, opStorageClientSettingData, null, null, null, continueOnError, false, hostType, null);
                        while (iterStorageClientSettingData.hasNext()) {
                            CIMInstance instStorageClientSettingData = (CIMInstance)iterStorageClientSettingData.next();
                            if (null == instStorageClientSettingData) continue;
                            if (isObjectPath) {
                                iter.add(this.generateObjectPath(objectName, instStorageHardwareID.getObjectPath(), instStorageClientSettingData.getObjectPath()));
                                continue;
                            }
                            iter.add(this.generateInstance(objectName, propertyList, instStorageHardwareID.getObjectPath(), instStorageClientSettingData));
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName()))) {
                    CIMInstance instStorageClientSettingData = null;
                    try {
                        instStorageClientSettingData = this.getReference2Instrumentation().getInstance(objectName, null);
                    }
                    catch (WBEMException we) {
                        // empty catch block
                    }
                    if (null != instStorageClientSettingData) {
                        CIMObjectPath opStorageHardwareID = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.getReference1ClassName(), null);
                        Hashtable<String, Object> expectValues = this.getReference1SearchProperties(objectName);
                        CustomCloseableIterator iterStorageHardwareID = new CustomCloseableIterator();
                        this.getReference1Instrumentation().enumerate(iterStorageHardwareID, opStorageHardwareID, null, null, null, continueOnError, false, expectValues, null);
                        while (iterStorageHardwareID.hasNext()) {
                            CIMInstance instStorageHardwareID = (CIMInstance)iterStorageHardwareID.next();
                            if (null == instStorageHardwareID) continue;
                            if (isObjectPath) {
                                iter.add(this.generateObjectPath(objectName, instStorageHardwareID.getObjectPath(), instStorageClientSettingData.getObjectPath()));
                                continue;
                            }
                            iter.add(this.generateInstance(objectName, propertyList, instStorageHardwareID.getObjectPath(), instStorageClientSettingData));
                        }
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    protected boolean removeAssociatedHardwareID(String pID) {
        boolean ret = false;
        if (pID != null) {
            if (this.mAssociatedIDsByWWN.remove(pID) != null) {
                ret = true;
            }
            Enumeration<UnsignedInteger16> keys = this.mAssociatedIDsByClient.keys();
            while (keys.hasMoreElements()) {
                UnsignedInteger16 key = keys.nextElement();
                ArrayList<String> ids = this.mAssociatedIDsByClient.get(key);
                if (ids == null || !ids.remove(pID)) continue;
                ret = true;
                this.persistAssociationData();
                break;
            }
        }
        return ret;
    }

    private void restoreAssociationData() {
        mLogger.info("Restoring ClientSettingDataStorageHardwareID data");
        String fileName = null;
        try {
            boolean errOccurred = false;
            for (int x = 0; x < mAssocDataFiles.length && !errOccurred; ++x) {
                fileName = mAssocDataFiles[x];
                File test = new File(fileName);
                if (test.exists()) {
                    try (FileInputStream fin = new FileInputStream(test);
                         ObjectInputStream in = new ObjectInputStream(fin);){
                        try {
                            if (0 == x) {
                                this.mAssociatedIDsByClient = (Hashtable)in.readObject();
                                mLogger.info("Read data for IDs by Client");
                                continue;
                            }
                            if (1 == x) {
                                this.mAssociatedIDsByWWN = (Hashtable)in.readObject();
                                mLogger.info("Read data for IDs by WWNs");
                                continue;
                            }
                            mLogger.severe("Don't know how to restore file # " + x + " with name: " + fileName);
                        }
                        catch (EOFException eof) {
                        }
                        catch (ClassNotFoundException cnfe) {
                            mLogger.log(Level.SEVERE, "Exception attempting to read " + fileName + " for Association data", cnfe);
                            this.mAssociatedIDsByClient = null;
                            this.mAssociatedIDsByWWN = null;
                            errOccurred = true;
                        }
                        continue;
                    }
                }
                mLogger.finest(fileName + " doesn't exist, no stored Association data restored");
            }
        }
        catch (IOException ex) {
            mLogger.log(Level.SEVERE, "Error trying to restore " + fileName, ex);
            this.mAssociatedIDsByClient = null;
            this.mAssociatedIDsByWWN = null;
        }
        mLogger.info("Restoring ClientSettingDataStorageHardwareID done");
    }
}

